"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Servicer*

:details: DeviceServicer:
    Used to acquire general device status and individual stirrer position status of the bioREACTOR48.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 12.02.2020
           
:file:    DeviceServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:48.762671
:date: (last modification) 2020-04-16T10:18:48.762671

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceServicer_pb2 as DeviceServicer_pb2
from .gRPC import DeviceServicer_pb2_grpc as DeviceServicer_pb2_grpc

# import simulation and real implementation
from .DeviceServicer_simulation import DeviceServicerSimulation
from .DeviceServicer_real import DeviceServicerReal


class DeviceServicer(DeviceServicer_pb2_grpc.DeviceServicerServicer):
    """
    This is a BioREACTOR48 Service
    """
    implementation: Union[DeviceServicerSimulation, DeviceServicerReal]
    simulation_mode: bool

    def __init__(self, ser, lock, status, start_time, simulation_mode: bool = True):
        """
        Class initializer.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.start_time = start_time
        self.lock = lock
        self.ser = ser
        self.status = status
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceServicerSimulation(self.status, self.start_time))
        else:
            self._inject_implementation(DeviceServicerReal(self.ser,self.status))

    def _inject_implementation(self,
                               implementation: Union[DeviceServicerSimulation,
                                                     DeviceServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the BioREACTOR48ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceServicerSimulation(self.status, self.start_time))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceServicerReal(self.ser, self.status))

    def GetLog(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Executes the observable command "Get Log"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A command confirmation object with the following information:
            commandId: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution: The (maximum) lifetime of this command call.
        """
    
        logging.debug(
            "GetLog called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.GetLog(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
    def GetLog_Info(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Returns execution information regarding the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: An ExecutionInfo response stream for the command with the following fields:
            commandStatus: Status of the command (enumeration)
            progressInfo: Information on the progress of the command (0 to 1)
            estimatedRemainingTime: Estimate of the remaining time required to run the command
            updatedLifetimeOfExecution: An update on the execution lifetime
        """
    
        logging.debug(
            "GetLog_Info called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.GetLog_Info(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
    def GetLog_Result(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Returns the final result of the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLogLevel (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogTimestamp (Current Log Timestamp): The current log timestamp of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogMessage (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
        """
    
        logging.debug(
            "GetLog_Result called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.GetLog_Result(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
    def GetDeviceStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetDeviceStatus_Responses:
        """
        Executes the unobservable command "Get Device Status"
            Get the current status of the device, software version, control mode, bar number and unit address.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): The overall device status. ER or OK.
            request.Version (Software Version): Software version number
            request.Mode (Mode): Operation mode. REM (remote) or MAN (manual) or OFF (offline).
            request.BarConnection (Bar Connection): Bar number connected or not connected. (1 = connected, 0 = not connected)
            request.Address (Address): UnitAddress
        """
    
        logging.debug(
            "GetDeviceStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetDeviceStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
    def GetReactorStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetReactorStatus_Responses:
        """
        Executes the unobservable command "Get Reactor Status"
            Get the current status of all 48 reactors. Check if stirrer is still running. 1 = stirring, 0 = not stirring
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ReactorStatus (Reactor Status): Get the current status of all 48 reactors. Check if stirrer is still running. 1 = stirring, 0 = not stirring
        """
    
        logging.debug(
            "GetReactorStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetReactorStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def Subscribe_CurrentStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """
        Requests the observable property Current Status
            Get the current status of the device from the internal state machine of the SiLA server.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response stream with the following fields:
            request.CurrentStatus (Current Status): Get the current status of the device from the internal state machine of the SiLA server.
        """
    
        logging.debug(
            "Property CurrentStatus requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.Subscribe_CurrentStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
    def Get_BarNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_BarNumber_Responses:
        """
        Requests the unobservable property Bar Number
            Number of stirrer bars available. Default = 6.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.BarNumber (Bar Number): Number of stirrer bars available. Default = 6.
        """
    
        logging.debug(
            "Property BarNumber requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.Get_BarNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def Get_BarReactors(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_BarReactors_Responses:
        """
        Requests the unobservable property BarReactorsr
            Number of reactors per bar. Default = 8.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.BarReactors (BarReactorsr): Number of reactors per bar. Default = 8.
        """
    
        logging.debug(
            "Property BarReactors requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.Get_BarReactors(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def Get_TotalReactors(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_TotalReactors_Responses:
        """
        Requests the unobservable property Total Reactors
            Number of total reactors. Default = 6*8 = 48.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.TotalReactors (Total Reactors): Number of total reactors. Default = 6*8 = 48.
        """
    
        logging.debug(
            "Property TotalReactors requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            self.lock.acquire()
            return self.implementation.Get_TotalReactors(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
