# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
import grpc

from . import DeviceServicer_pb2 as DeviceServicer__pb2
import sila2lib.framework.SiLAFramework_pb2 as SiLAFramework__pb2


class DeviceServicerStub(object):
  """Feature: Device Servicer

  Used to acquire general device status and individual stirrer position status of the bioREACTOR48.
  By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 12.02.2020

  """

  def __init__(self, channel):
    """Constructor.

    Args:
      channel: A grpc.Channel.
    """
    self.GetLog = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/GetLog',
        request_serializer=DeviceServicer__pb2.GetLog_Parameters.SerializeToString,
        response_deserializer=SiLAFramework__pb2.CommandConfirmation.FromString,
        )
    self.GetLog_Info = channel.unary_stream(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/GetLog_Info',
        request_serializer=SiLAFramework__pb2.CommandExecutionUUID.SerializeToString,
        response_deserializer=SiLAFramework__pb2.ExecutionInfo.FromString,
        )
    self.GetLog_Result = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/GetLog_Result',
        request_serializer=SiLAFramework__pb2.CommandExecutionUUID.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetLog_Responses.FromString,
        )
    self.GetDeviceStatus = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/GetDeviceStatus',
        request_serializer=DeviceServicer__pb2.GetDeviceStatus_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetDeviceStatus_Responses.FromString,
        )
    self.GetReactorStatus = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/GetReactorStatus',
        request_serializer=DeviceServicer__pb2.GetReactorStatus_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.GetReactorStatus_Responses.FromString,
        )
    self.Subscribe_CurrentStatus = channel.unary_stream(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/Subscribe_CurrentStatus',
        request_serializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Responses.FromString,
        )
    self.Get_BarNumber = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/Get_BarNumber',
        request_serializer=DeviceServicer__pb2.Get_BarNumber_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.Get_BarNumber_Responses.FromString,
        )
    self.Get_BarReactors = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/Get_BarReactors',
        request_serializer=DeviceServicer__pb2.Get_BarReactors_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.Get_BarReactors_Responses.FromString,
        )
    self.Get_TotalReactors = channel.unary_unary(
        '/sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer/Get_TotalReactors',
        request_serializer=DeviceServicer__pb2.Get_TotalReactors_Parameters.SerializeToString,
        response_deserializer=DeviceServicer__pb2.Get_TotalReactors_Responses.FromString,
        )


class DeviceServicerServicer(object):
  """Feature: Device Servicer

  Used to acquire general device status and individual stirrer position status of the bioREACTOR48.
  By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 12.02.2020

  """

  def GetLog(self, request, context):
    """Get Log
    Get the current status of the device from the state machine of the SiLA server.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetLog_Info(self, request, context):
    # missing associated documentation comment in .proto file
    pass
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetLog_Result(self, request, context):
    # missing associated documentation comment in .proto file
    pass
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetDeviceStatus(self, request, context):
    """Get Device Status
    Get the current status of the device, software version, control mode, bar number and unit address.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def GetReactorStatus(self, request, context):
    """Get Reactor Status
    Get the current status of all 48 reactors. Check if stirrer is still running. 1 = stirring, 0 = not stirring
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Subscribe_CurrentStatus(self, request, context):
    """Current Status
    Get the current status of the device from the internal state machine of the SiLA server.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Get_BarNumber(self, request, context):
    """Bar Number
    Number of stirrer bars available. Default = 6.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Get_BarReactors(self, request, context):
    """BarReactorsr
    Number of reactors per bar. Default = 8.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')

  def Get_TotalReactors(self, request, context):
    """Total Reactors
    Number of total reactors. Default = 6*8 = 48.
    """
    context.set_code(grpc.StatusCode.UNIMPLEMENTED)
    context.set_details('Method not implemented!')
    raise NotImplementedError('Method not implemented!')


def add_DeviceServicerServicer_to_server(servicer, server):
  rpc_method_handlers = {
      'GetLog': grpc.unary_unary_rpc_method_handler(
          servicer.GetLog,
          request_deserializer=DeviceServicer__pb2.GetLog_Parameters.FromString,
          response_serializer=SiLAFramework__pb2.CommandConfirmation.SerializeToString,
      ),
      'GetLog_Info': grpc.unary_stream_rpc_method_handler(
          servicer.GetLog_Info,
          request_deserializer=SiLAFramework__pb2.CommandExecutionUUID.FromString,
          response_serializer=SiLAFramework__pb2.ExecutionInfo.SerializeToString,
      ),
      'GetLog_Result': grpc.unary_unary_rpc_method_handler(
          servicer.GetLog_Result,
          request_deserializer=SiLAFramework__pb2.CommandExecutionUUID.FromString,
          response_serializer=DeviceServicer__pb2.GetLog_Responses.SerializeToString,
      ),
      'GetDeviceStatus': grpc.unary_unary_rpc_method_handler(
          servicer.GetDeviceStatus,
          request_deserializer=DeviceServicer__pb2.GetDeviceStatus_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetDeviceStatus_Responses.SerializeToString,
      ),
      'GetReactorStatus': grpc.unary_unary_rpc_method_handler(
          servicer.GetReactorStatus,
          request_deserializer=DeviceServicer__pb2.GetReactorStatus_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.GetReactorStatus_Responses.SerializeToString,
      ),
      'Subscribe_CurrentStatus': grpc.unary_stream_rpc_method_handler(
          servicer.Subscribe_CurrentStatus,
          request_deserializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.Subscribe_CurrentStatus_Responses.SerializeToString,
      ),
      'Get_BarNumber': grpc.unary_unary_rpc_method_handler(
          servicer.Get_BarNumber,
          request_deserializer=DeviceServicer__pb2.Get_BarNumber_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.Get_BarNumber_Responses.SerializeToString,
      ),
      'Get_BarReactors': grpc.unary_unary_rpc_method_handler(
          servicer.Get_BarReactors,
          request_deserializer=DeviceServicer__pb2.Get_BarReactors_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.Get_BarReactors_Responses.SerializeToString,
      ),
      'Get_TotalReactors': grpc.unary_unary_rpc_method_handler(
          servicer.Get_TotalReactors,
          request_deserializer=DeviceServicer__pb2.Get_TotalReactors_Parameters.FromString,
          response_serializer=DeviceServicer__pb2.Get_TotalReactors_Responses.SerializeToString,
      ),
  }
  generic_handler = grpc.method_handlers_generic_handler(
      'sila2.biovt.mw.tum.de.examples.deviceservicer.v1.DeviceServicer', rpc_method_handlers)
  server.add_generic_rpc_handlers((generic_handler,))
