"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Motor Servicer*

:details: MotorServicer:
    Allows full control of the stirrer speed and power. Starts and stops the stirrer of the bioREACTOR48.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 12.02.2020

:file:    MotorServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:48.817127
:date: (last modification) 2020-04-16T10:18:48.817127

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import inspect      # used for status determination
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import MotorServicer_pb2 as MotorServicer_pb2
# from .gRPC import MotorServicer_pb2_grpc as MotorServicer_pb2_grpc

# import default arguments
from .MotorServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class MotorServicerReal:
    """
    Implementation of the *Motor Servicer* in *Real* mode
        This is a BioREACTOR48 Service
    """

    def __init__(self, ser, status):
        """Class initializer"""
        self.ser = ser
        self.status = status
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )
    def _get_function_name(self):
        return inspect.stack()[1][3]

    def StartStirrer(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.StartStirrer_Responses:
        """
        Executes the unobservable command "Start Stirrer"
            Start the magnetic stirrer.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current start status response.
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.status}')

        command = 'Start\r\n'
        for i in range(0, 3, 1):
            try:
                self.ser.write(str.encode(command))
                read = str(bytes.decode(self.ser.read_until(str.encode('\r'))))
                par_dict = {'CurrentStatus': silaFW_pb2.String(value=read)}
                return_value = MotorServicer_pb2.StartStirrer_Responses(**par_dict)
                logging.debug('Executed command StartStirrer in mode: {mode} with response: {response}'
                              .format(mode='Real', response=read))
                break
            except (ValueError, IndexError):
                logging.exception('Parsing of the following command response failed: {command}, {response}'
                                  .format(command=command, response=read))
                logging.warning(f'Resending the command (#{i+1} try)')
                if i == 2:
                    return_value = None
                continue
            except ConnectionError:
                logging.exception(f'Communication failed executing the command: {command}')
                return_value = None

        # fallback to default
        if return_value is None:
            return_value = MotorServicer_pb2.StartStirrer_Responses(
                **default_dict['StartStirrer_Responses']
            )
    
        return return_value

    def StopStirrer(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.StopStirrer_Responses:
        """
        Executes the unobservable command "Stop Stirrer"
            Stop the magnetic stirrer.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current stop status response.
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.status}')

        command = 'Stop\r\n'
        for i in range(0, 3, 1):
            try:
                self.ser.write(str.encode(command))
                read = str(bytes.decode(self.ser.read_until(str.encode('\r'))))
                par_dict = {'CurrentStatus': silaFW_pb2.String(value=read)}
                return_value = MotorServicer_pb2.StopStirrer_Responses(**par_dict)
                logging.debug('Executed command StopStirrer in mode: {mode} with response: {response}'
                              .format(mode='Real', response=read))
                break
            except (ValueError, IndexError):
                logging.exception('Parsing of the following command response failed: {command}, {response}'
                                  .format(command=command, response=read))
                logging.warning(f'Resending the command (#{i + 1} try)')
                if i == 2:
                    return_value = None
                continue
            except ConnectionError:
                logging.exception(f'Communication failed executing the command: {command}')
                return_value = None
        # fallback to default
        if return_value is None:
            return_value = MotorServicer_pb2.StopStirrer_Responses(
                **default_dict['StopStirrer_Responses']
            )

        return return_value

    def SetRPM(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.SetRPM_Responses:
        """
        Executes the unobservable command "Set RPM"
            Set the stirrer rpm.
    
        :param request: gRPC request containing the parameters passed:
            request.RPM (RPM):
            The stirrer rpm to be set.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current status of the rpm set operation.
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.status}')

        command = ''
        if request.RPM.value <= 4000:
            command = 'SetRpm_%s\r\n' % str(request.RPM.value).zfill(4)
            for i in range(0, 3, 1):
                try:
                    self.ser.write(str.encode(command))
                    read = str(bytes.decode(self.ser.read_until(str.encode('\r'))))
                    par_dict = {'CurrentStatus': silaFW_pb2.String(value=read)}
                    return_value = MotorServicer_pb2.SetRPM_Responses(**par_dict)
                    logging.debug('Executed command SetRPM in mode: {mode} with response: {response}'
                                  .format(mode='Real', response=read))
                    break
                except (ValueError, IndexError):
                    logging.exception('Parsing of the following command response failed: {command}, {response}'
                                      .format(command=command, response=read))
                    logging.warning(f'Resending the command (#{i + 1} try)')
                    if i == 2:
                        return_value = None
                    continue
                except ConnectionError:
                    logging.exception(f'Communication failed executing the command: {command}')
                    return_value = None
        else:
            logging.error('RPM set point must be between 0 and 4000. Input value is: {value}'
                          .format(value=request.RPM.value))
        # fallback to default
        if return_value is None:
            return_value = MotorServicer_pb2.SetRPM_Responses(
                **default_dict['SetRPM_Responses']
            )
    
        return return_value

    def GetRPM(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.GetRPM_Responses:
        """
        Executes the unobservable command "Get RPM"
            Get the current rpm of the stirrer.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRPM (Current rpm): The current rpm of the stirrer.
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.status}')

        command = 'SendRpm\r\n'
        for i in range(0, 3, 1):
            try:
                self.ser.write(str.encode(command))
                read = str(bytes.decode(self.ser.read_until(str.encode('\r'))))
                logging.debug('Executed command GetRPM in mode: {mode} with response: {response}'
                              .format(mode='Real', response=read))
                try:
                    status, rpm = read.split('_')[0], read.split('_')[1]
                    rpm = int(''.join(filter(lambda x: x.isdigit(), rpm)))
                    par_dict = {'CurrentRPM': silaFW_pb2.Integer(value=rpm)}
                    return_value = MotorServicer_pb2.GetRPM_Responses(**par_dict)
                    logging.debug('Parsing command GetRPM in mode: {mode} with response: {response}'
                                  .format(mode='Real', response=status))
                    break
                except (ValueError, IndexError):
                    logging.exception('Parsing of the following command response failed: {command}, {response}'
                                      .format(command=command, response=read))
                    logging.warning(f'Resending the command (#{i + 1} try)')
                    if i == 2:
                        return_value = None
                    continue
            except ConnectionError:
                logging.exception(f'Communication failed executing the command: {command}')
                return_value = None

        # fallback to default
        if return_value is None:
            return_value = MotorServicer_pb2.GetRPM_Responses(
                **default_dict['GetRPM_Responses']
            )
    
        return return_value

    def SetPower(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.SetPower_Responses:
        """
        Executes the unobservable command "Set Power"
            Set the stirrer power in %.
    
        :param request: gRPC request containing the parameters passed:
            request.Power (Power):
            The power input to the stirrer motor in %.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (CurrentStatus): The current status of the power set operation
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.status}')

        allowed = range(0, 101, 25)
        if request.Power.value in allowed:
            command = 'SetPower_%s\r\n' % str(request.Power.value)
            for i in range(0, 3, 1):
                try:
                    self.ser.write(str.encode(command))
                    read = str(bytes.decode(self.ser.read_until(str.encode('\r'))))
                    par_dict = {'CurrentStatus': silaFW_pb2.String(value=read)}
                    return_value = MotorServicer_pb2.SetPower_Responses(**par_dict)
                    logging.debug('Executed command SetPower in mode: {mode} with response: {response}'
                                  .format(mode='Real', response=read))
                    break
                except (ValueError, IndexError):
                    logging.exception('Parsing of the following command response failed: {command}, {response}'
                                      .format(command=command, response=read))
                    logging.warning(f'Resending the command (#{i + 1} try)')
                    if i == 2:
                        return_value = None
                    continue
                except ConnectionError:
                    logging.exception(f'Communication failed executing the command: {command}')
                    return_value = None

        else:
            logging.error('RPM set point must be between 0 and 4000. Input value is: {value}'
                          .format(value=request.Power.value))
        # fallback to default
        if return_value is None:
            return_value = MotorServicer_pb2.SetPower_Responses(
                **default_dict['SetPower_Responses']
            )
        return return_value

    def GetPower(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.GetPower_Responses:
        """
        Executes the unobservable command "Get Power"
            Get the current power input of the stirrer in %.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPower (Current Power): The current power input in %.
        """
    
        # initialise the return value
        return_value = None
        read = None
        self.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.status}')

        command = 'SendPower\r\n'
        for i in range(0, 3, 1):
            try:
                self.ser.write(str.encode(command))
                read = str(bytes.decode(self.ser.read_until(str.encode('\r'))))
                logging.debug('Executed command GetPower in mode: {mode} with response: {response}'
                              .format(mode='Real', response=read))
                try:
                    status, rpm = read.split('_')[0], read.split('_')[1]
                    rpm = int(rpm.split('POWER')[1])
                    par_dict = {'CurrentPower': silaFW_pb2.Integer(value=rpm)}
                    return_value = MotorServicer_pb2.GetPower_Responses(**par_dict)
                    logging.debug('Parsing command GetPower in mode: {mode} with response: {response}'
                                  .format(mode='Real', response=status))
                    break
                except (ValueError, IndexError):
                    logging.exception('Parsing of the following command response failed: {command}, {response}'
                                      .format(command=command, response=read))
                    logging.warning(f'Resending the command (#{i + 1} try)')
                    if i == 2:
                        return_value = None
                    continue
            except ConnectionError:
                logging.exception(f'Communication failed executing the command: {command}')
                return_value = None
        # fallback to default
        if return_value is None:
            return_value = MotorServicer_pb2.GetPower_Responses(
                **default_dict['GetPower_Responses']
            )
        return return_value
