"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Motor Servicer*

:details: MotorServicer:
    Allows full control of the stirrer speed and power. Starts and stops the stirrer of the bioREACTOR48.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 12.02.2020
           
:file:    MotorServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:48.797174
:date: (last modification) 2020-04-16T10:18:48.797174

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import MotorServicer_pb2 as MotorServicer_pb2
from .gRPC import MotorServicer_pb2_grpc as MotorServicer_pb2_grpc

# import simulation and real implementation
from .MotorServicer_simulation import MotorServicerSimulation
from .MotorServicer_real import MotorServicerReal


class MotorServicer(MotorServicer_pb2_grpc.MotorServicerServicer):
    """
    This is a BioREACTOR48 Service
    """
    implementation: Union[MotorServicerSimulation, MotorServicerReal]
    simulation_mode: bool

    def __init__(self, ser, lock, status, simulation_mode: bool = True):
        """
        Class initializer.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.lock = lock
        self.ser = ser
        self.status = status
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(MotorServicerSimulation(self.status))
        else:
            self._inject_implementation(MotorServicerReal(self.ser, self.status))

    def _inject_implementation(self,
                               implementation: Union[MotorServicerSimulation,
                                                     MotorServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the BioREACTOR48ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(MotorServicerSimulation(self.status))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(MotorServicerReal(self.ser, self.status))

    def StartStirrer(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.StartStirrer_Responses:
        """
        Executes the unobservable command "Start Stirrer"
            Start the magnetic stirrer.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current start status response.
        """
    
        logging.debug(
            "StartStirrer called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            self.status = "BioREACTOR executing StartStirrer"
            return self.implementation.StartStirrer(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def StopStirrer(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.StopStirrer_Responses:
        """
        Executes the unobservable command "Stop Stirrer"
            Stop the magnetic stirrer.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current stop status response.
        """
    
        logging.debug(
            "StopStirrer called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.StopStirrer(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetRPM(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.SetRPM_Responses:
        """
        Executes the unobservable command "Set RPM"
            Set the stirrer rpm.
    
        :param request: gRPC request containing the parameters passed:
            request.RPM (RPM):
            The stirrer rpm to be set.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (Current Status): The current status of the rpm set operation.
        """
    
        logging.debug(
            "SetRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.SetRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
    
    def GetRPM(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.GetRPM_Responses:
        """
        Executes the unobservable command "Get RPM"
            Get the current rpm of the stirrer.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRPM (Current rpm): The current rpm of the stirrer.
        """
    
        logging.debug(
            "GetRPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetRPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetPower(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.SetPower_Responses:
        """
        Executes the unobservable command "Set Power"
            Set the stirrer power in %.
    
        :param request: gRPC request containing the parameters passed:
            request.Power (Power):
            The power input to the stirrer motor in %.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStatus (CurrentStatus): The current status of the power set operation
        """
    
        logging.debug(
            "SetPower called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.SetPower(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetPower(self, request, context: grpc.ServicerContext) \
            -> MotorServicer_pb2.GetPower_Responses:
        """
        Executes the unobservable command "Get Power"
            Get the current power input of the stirrer in %.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPower (Current Power): The current power input in %.
        """
    
        logging.debug(
            "GetPower called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            self.lock.acquire()
            return self.implementation.GetPower(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
