#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*BlueVaryService client*

:details: BlueVaryService:
    This is a BlueVary Off-Gas Analytics Service

:file:    BlueVaryService_client.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:59.344858
:date: (last modification) 2020-04-16T10:18:59.344858

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from .DeviceServicer.gRPC import DeviceServicer_pb2
from .DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from .DeviceServicer.DeviceServicer_default_arguments import default_dict as DeviceServicer_default_dict
from .SensorServicer.gRPC import SensorServicer_pb2
from .SensorServicer.gRPC import SensorServicer_pb2_grpc
# import default arguments for this feature
from .SensorServicer.SensorServicer_default_arguments import default_dict as SensorServicer_default_dict
from .CalibrationServicer.gRPC import CalibrationServicer_pb2
from .CalibrationServicer.gRPC import CalibrationServicer_pb2_grpc
# import default arguments for this feature
from .CalibrationServicer.CalibrationServicer_default_arguments import default_dict as CalibrationServicer_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class BlueVaryServiceClient(SiLA2Client):
    """
        This is a BlueVary Off-Gas Analytics Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "BlueVaryServiceClient", description: str = "This is a BlueVary Off-Gas Analytics Service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service BlueVaryService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.SensorServicer_stub = \
            SensorServicer_pb2_grpc.SensorServicerStub(self.channel)
        self.CalibrationServicer_stub = \
            CalibrationServicer_pb2_grpc.CalibrationServicerStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(
                        value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def DeviceServicer_GetLog(self,
                      parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Info(self,
                           uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Result(self,
                             uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetSensorID(self,
                      parameter: DeviceServicer_pb2.GetSensorID_Parameters = None) \
            -> DeviceServicer_pb2.GetSensorID_Responses:
        """
        Wrapper to call the unobservable command GetSensorID on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorID:")
        try:
            parameter = None
            if parameter is None:
                parameter = DeviceServicer_pb2.GetSensorID_Parameters(
                    **DeviceServicer_default_dict['GetSensorID_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetSensorID(parameter)
    
            logging.debug('GetSensorID response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetSensorInfo(self,
                      parameter: DeviceServicer_pb2.GetSensorInfo_Parameters = None) \
            -> DeviceServicer_pb2.GetSensorInfo_Responses:
        """
        Wrapper to call the unobservable command GetSensorInfo on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorInfo:")
        try:
            parameter = None
            if parameter is None:
                parameter = DeviceServicer_pb2.GetSensorInfo_Parameters(
                    **DeviceServicer_default_dict['GetSensorInfo_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetSensorInfo(parameter)
    
            logging.debug('GetSensorInfo response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SensorServicer_GetResults(self,
                      parameter: SensorServicer_pb2.GetResults_Parameters = None) \
            -> SensorServicer_pb2.GetResults_Responses:
        """
        Wrapper to call the unobservable command GetResults on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetResults:")
        try:
            parameter = None
            if parameter is None:
                parameter = SensorServicer_pb2.GetResults_Parameters(
                    **SensorServicer_default_dict['GetResults_Parameters']
                )
    
            response = self.SensorServicer_stub.GetResults(parameter)
    
            logging.debug('GetResults response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SensorServicer_GetHumidity(self,
                      parameter: SensorServicer_pb2.GetHumidity_Parameters = None) \
            -> SensorServicer_pb2.GetHumidity_Responses:
        """
        Wrapper to call the unobservable command GetHumidity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetHumidity:")
        try:
            parameter = None
            if parameter is None:
                parameter = SensorServicer_pb2.GetHumidity_Parameters(
                    **SensorServicer_default_dict['GetHumidity_Parameters']
                )
    
            response = self.SensorServicer_stub.GetHumidity(parameter)
    
            logging.debug('GetHumidity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def CalibrationServicer_StartCalibration(self,
                      parameter: CalibrationServicer_pb2.StartCalibration_Parameters = None) \
            -> CalibrationServicer_pb2.StartCalibration_Responses:
        """
        Wrapper to call the unobservable command StartCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartCalibration:")
        try:
            parameter = None
            if parameter is None:
                parameter = CalibrationServicer_pb2.StartCalibration_Parameters(
                    **CalibrationServicer_default_dict['StartCalibration_Parameters']
                )
    
            response = self.CalibrationServicer_stub.StartCalibration(parameter)
    
            logging.debug('StartCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def Subscribe_DeviceServicer_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceServicer_stub.Subscribe_CurrentStatus(
                DeviceServicer_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: BlueVaryService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = BlueVaryServiceClient(server_ip='127.0.0.1', server_port=50001)
    sila_client.run()

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
