"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Servicer*

:details: CalibrationServicer:
    Used to initiate device 1-pt calibration of the off-gas sensors.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    CalibrationServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:59.323922
:date: (last modification) 2020-04-16T10:18:59.323922

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import CalibrationServicer_pb2 as CalibrationServicer_pb2
from .gRPC import CalibrationServicer_pb2_grpc as CalibrationServicer_pb2_grpc

# import simulation and real implementation
from .CalibrationServicer_simulation import CalibrationServicerSimulation
from .CalibrationServicer_real import CalibrationServicerReal


class CalibrationServicer(CalibrationServicer_pb2_grpc.CalibrationServicerServicer):
    """
    This is a BlueVary Off-Gas Analytics Service
    """
    implementation: Union[CalibrationServicerSimulation, CalibrationServicerReal]
    simulation_mode: bool

    def __init__(self, ser, lock, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.lock = lock
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(CalibrationServicerSimulation())
        else:
            self._inject_implementation(CalibrationServicerReal(ser = self.ser, lock = self.lock))

    def _inject_implementation(self,
                               implementation: Union[CalibrationServicerSimulation,
                                                     CalibrationServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the BlueVaryServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(CalibrationServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(CalibrationServicerReal(ser = self.ser, lock = self.lock))

    def StartCalibration(self, request, context: grpc.ServicerContext) \
            -> CalibrationServicer_pb2.StartCalibration_Responses:
        """
        Executes the unobservable command "Start Calibration"
            Start the 1-pt calibration of the sensors
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CalibrationStatus (Calibration Status): Calibration command recieved. Calibration status response.
        """
    
        logging.debug(
            "StartCalibration called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartCalibration(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
