"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Sensor Servicer*

:details: SensorServicer:
    Read out the off-gas analytics sensor data for gas1 and gas2.Gas concentrations [vol.-%], pressure [mbar], humidity
    [%], temperature[C] and absolute humidity [vol.-%] are provided.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    SensorServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:59.314970
:date: (last modification) 2020-04-16T10:18:59.314970

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import SensorServicer_pb2 as SensorServicer_pb2
# from .gRPC import SensorServicer_pb2_grpc as SensorServicer_pb2_grpc

# import default arguments
from .SensorServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class SensorServicerSimulation:
    """
    Implementation of the *Sensor Servicer* in *Simulation* mode
        This is a BlueVary Off-Gas Analytics Service
    """

    def __init__(self):
        """Class initialiser"""

        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetResults(self, request, context: grpc.ServicerContext) \
            -> SensorServicer_pb2.GetResults_Responses:
        """
        Executes the unobservable command "Get Sensor Results"
            Get the current gas concentrations for CO2 and O2 in [vol.-%] and the pressure readings in [mbar].
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CO2 (Current CO2 Concentration): Get the current CO2 concentration
            request.O2 (Current O2 Concentration): Get the current O2 concentration
            request.Pressure (Current Air Pressure): Get the current air pressure reading
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetResults here and write the resulting response
        #   in return_value
        par_dict = {
            'CO2': silaFW_pb2.Real(value=0.04),
            'O2': silaFW_pb2.Real(value=21.1),
            'Pressure': silaFW_pb2.Real(value=1.01)
        }
        return_value = SensorServicer_pb2.GetResults_Responses(**par_dict)
        # fallback to default
        if return_value is None:
            return_value = SensorServicer_pb2.GetResults_Responses(
                **default_dict['GetResults_Responses']
            )
    
        return return_value
    
    
    def GetHumidity(self, request, context: grpc.ServicerContext) \
            -> SensorServicer_pb2.GetHumidity_Responses:
        """
        Executes the unobservable command "Get Humidity Results"
            Get the current humidity [%], temperature [C] and absolute humidity [vol.-%].
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Humidity (Current Humidity): Get the current humidity in [%]
            request.Temperature (Current Temperature): Get the current temperature in [C]
            request.AbsoluteHumidity (Current Absolute Humidity): Get the current absolute humidity in [vol.-%]
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetHumidity here and write the resulting response
        #   in return_value
        par_dict = {
            'Humidity': silaFW_pb2.Real(value=25),
            'Temperature': silaFW_pb2.Real(value=21),
            'AbsoluteHumidity': silaFW_pb2.Real(value=0.23)
        }

        return_value = SensorServicer_pb2.GetHumidity_Responses(**par_dict)
        # fallback to default
        if return_value is None:
            return_value = SensorServicer_pb2.GetHumidity_Responses(
                **default_dict['GetHumidity_Responses']
            )
    
        return return_value
    

    
