#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*DASGIP_Service client*

:details: DASGIP_Service:
    This is a DASGIP Service

:file:    DASGIP_Service_client.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:15.719813
:date: (last modification) 2020-04-16T10:19:15.719813

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "0.0.1"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer.gRPC import AgitationServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer.gRPC import AgitationServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer.AgitationServicer_default_arguments import default_dict as AgitationServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer.gRPC import DeviceServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer.DeviceServicer_default_arguments import default_dict as DeviceServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.DOServicer.gRPC import DOServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.DOServicer.gRPC import DOServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.DOServicer.DOServicer_default_arguments import default_dict as DOServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.GassingServicer.gRPC import GassingServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.GassingServicer.gRPC import GassingServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.GassingServicer.GassingServicer_default_arguments import default_dict as GassingServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer.gRPC import IlluminationServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer.gRPC import IlluminationServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer.IlluminationServicer_default_arguments import default_dict as IlluminationServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.LevelServicer.gRPC import LevelServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.LevelServicer.gRPC import LevelServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.LevelServicer.LevelServicer_default_arguments import default_dict as LevelServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer.gRPC import OffgasServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer.gRPC import OffgasServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer.OffgasServicer_default_arguments import default_dict as OffgasServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer.gRPC import OverlayServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer.gRPC import OverlayServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer.OverlayServicer_default_arguments import default_dict as OverlayServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.PHServicer.gRPC import PHServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.PHServicer.gRPC import PHServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.PHServicer.PHServicer_default_arguments import default_dict as PHServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.PressureServicer.gRPC import PressureServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.PressureServicer.gRPC import PressureServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.PressureServicer.PressureServicer_default_arguments import default_dict as PressureServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer.gRPC import PumpAServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer.gRPC import PumpAServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer.PumpAServicer_default_arguments import default_dict as PumpAServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer.gRPC import PumpBServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer.gRPC import PumpBServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer.PumpBServicer_default_arguments import default_dict as PumpBServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer.gRPC import PumpCServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer.gRPC import PumpCServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer.PumpCServicer_default_arguments import default_dict as PumpCServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer.gRPC import PumpDServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer.gRPC import PumpDServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer.PumpDServicer_default_arguments import default_dict as PumpDServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer.gRPC import ReactorServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer.gRPC import ReactorServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer.ReactorServicer_default_arguments import default_dict as ReactorServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer.gRPC import RedoxServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer.gRPC import RedoxServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer.RedoxServicer_default_arguments import default_dict as RedoxServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer.gRPC import TemperatureServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer.gRPC import TemperatureServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer.TemperatureServicer_default_arguments import default_dict as TemperatureServicer_default_dict
from sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer.gRPC import TurbidityServicer_pb2
from sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer.gRPC import TurbidityServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer.TurbidityServicer_default_arguments import default_dict as TurbidityServicer_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class DASGIP_ServiceClient(SiLA2Client):
    """
        This is a DASGIP Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "DASGIP_ServiceClient", description: str = "This is a DASGIP Service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "lukas.bromig@tum.de",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50004,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service DASGIP_Service with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.AgitationServicer_stub = \
            AgitationServicer_pb2_grpc.AgitationServicerStub(self.channel)
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.DOServicer_stub = \
            DOServicer_pb2_grpc.DOServicerStub(self.channel)
        self.GassingServicer_stub = \
            GassingServicer_pb2_grpc.GassingServicerStub(self.channel)
        self.IlluminationServicer_stub = \
            IlluminationServicer_pb2_grpc.IlluminationServicerStub(self.channel)
        self.LevelServicer_stub = \
            LevelServicer_pb2_grpc.LevelServicerStub(self.channel)
        self.OffgasServicer_stub = \
            OffgasServicer_pb2_grpc.OffgasServicerStub(self.channel)
        self.OverlayServicer_stub = \
            OverlayServicer_pb2_grpc.OverlayServicerStub(self.channel)
        self.PHServicer_stub = \
            PHServicer_pb2_grpc.PHServicerStub(self.channel)
        self.PressureServicer_stub = \
            PressureServicer_pb2_grpc.PressureServicerStub(self.channel)
        self.PumpAServicer_stub = \
            PumpAServicer_pb2_grpc.PumpAServicerStub(self.channel)
        self.PumpBServicer_stub = \
            PumpBServicer_pb2_grpc.PumpBServicerStub(self.channel)
        self.PumpCServicer_stub = \
            PumpCServicer_pb2_grpc.PumpCServicerStub(self.channel)
        self.PumpDServicer_stub = \
            PumpDServicer_pb2_grpc.PumpDServicerStub(self.channel)
        self.ReactorServicer_stub = \
            ReactorServicer_pb2_grpc.ReactorServicerStub(self.channel)
        self.RedoxServicer_stub = \
            RedoxServicer_pb2_grpc.RedoxServicerStub(self.channel)
        self.TemperatureServicer_stub = \
            TemperatureServicer_pb2_grpc.TemperatureServicerStub(self.channel)
        self.TurbidityServicer_stub = \
            TurbidityServicer_pb2_grpc.TurbidityServicerStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
            return response
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def AgitationServicer_GetPV(self, UnitID):
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetPV_Parameters(**par_dict)    
            response = self.AgitationServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
        return response

    def AgitationServicer_SetSPM(self, UnitID, value):
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
        }
        try:
            parameter = AgitationServicer_pb2.SetSPM_Parameters(**par_dict) 
            response = self.AgitationServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
        return response

    def AgitationServicer_SetSPE(self, UnitID, value) \
            -> AgitationServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = AgitationServicer_pb2.SetSPE_Parameters(**par_dict) 
            response = self.AgitationServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetSP(self, UnitID) \
            -> AgitationServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetSP_Parameters(**par_dict) 
            response = self.AgitationServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetSPA(self, UnitID) \
            -> AgitationServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetSPA_Parameters(**par_dict) 
            response = self.AgitationServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetSPM(self, UnitID) \
            -> AgitationServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetSPM_Parameters(**par_dict) 
            response = self.AgitationServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetSPE(self, UnitID) \
            -> AgitationServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetSPE_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetSPR(self, UnitID) \
            -> AgitationServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetSPR_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def AgitationServicer_GetAccess(self, UnitID) \
            -> AgitationServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_SetCmd(self, UnitID, value) \
            -> AgitationServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = AgitationServicer_pb2.SetCmd_Parameters(**par_dict)    
            response = self.AgitationServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetCmd(self, UnitID) \
            -> AgitationServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetCmd_Parameters(**par_dict)    
            response = self.AgitationServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def AgitationServicer_GetMode(self, UnitID) \
            -> AgitationServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetMode_Parameters(**par_dict)   
            response = self.AgitationServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_SetSetpointSelect(self, UnitID, value) \
            -> AgitationServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = AgitationServicer_pb2.SetSetpointSelect_Parameters(**par_dict)  
            response = self.AgitationServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetSetpointSelect(self, UnitID) \
            -> AgitationServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetSetpointSelect_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetState(self, UnitID) \
            -> AgitationServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetState_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetType(self, UnitID) \
            -> AgitationServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetType_Parameters(**par_dict)    
            response = self.AgitationServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetAvailable(self, UnitID) \
            -> AgitationServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetAvailable_Parameters(**par_dict)  
            response = self.AgitationServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetName(self, UnitID) \
            -> AgitationServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetName_Parameters(**par_dict)  
            response = self.AgitationServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetVersion(self, UnitID) \
            -> AgitationServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetVersion_Parameters(**par_dict)  
            response = self.AgitationServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetActuatorDirPV(self, UnitID) \
            -> AgitationServicer_pb2.GetActuatorDirPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorDirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorDirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetActuatorDirPV_Parameters(**par_dict)  
            response = self.AgitationServicer_stub.GetActuatorDirPV(parameter)
    
            logging.debug('GetActuatorDirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetActuatorPwrPV(self, UnitID) \
            -> AgitationServicer_pb2.GetActuatorPwrPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorPwrPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorPwrPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetActuatorPwrPV_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetActuatorPwrPV(parameter)
    
            logging.debug('GetActuatorPwrPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def AgitationServicer_GetActuatorTStirPV(self, UnitID) \
            -> AgitationServicer_pb2.GetActuatorTStirPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorTStirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorTStirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = AgitationServicer_pb2.GetActuatorTStirPV_Parameters(**par_dict)
            response = self.AgitationServicer_stub.GetActuatorTStirPV(parameter)
    
            logging.debug('GetActuatorTStirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog(self,
                      parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Info(self,
                           uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Result(self,
                             uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetRuntimeClock(self, UnitID) \
            -> DeviceServicer_pb2.GetRuntimeClock_Responses:
        """
        Wrapper to call the unobservable command GetRuntimeClock on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRuntimeClock:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetRuntimeClock_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetRuntimeClock(parameter)
    
            logging.debug('GetRuntimeClock response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetStartedUTC(self, UnitID) \
            -> DeviceServicer_pb2.GetStartedUTC_Responses:
        """
        Wrapper to call the unobservable command GetStartedUTC on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetStartedUTC:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetStartedUTC_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetStartedUTC(parameter)
    
            logging.debug('GetStartedUTC response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetStarted(self, UnitID) \
            -> DeviceServicer_pb2.GetStarted_Responses:
        """
        Wrapper to call the unobservable command GetStarted on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetStarted:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetStarted_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetStarted(parameter)
    
            logging.debug('GetStarted response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetStoppedUTC(self, UnitID) \
            -> DeviceServicer_pb2.GetStoppedUTC_Responses:
        """
        Wrapper to call the unobservable command GetStoppedUTC on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetStoppedUTC:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetStoppedUTC_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetStoppedUTC(parameter)
    
            logging.debug('GetStoppedUTC response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetStopped(self, UnitID) \
            -> DeviceServicer_pb2.GetStopped_Responses:
        """
        Wrapper to call the unobservable command GetStopped on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetStopped:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetStopped_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetStopped(parameter)
    
            logging.debug('GetStopped response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetUserId(self, UnitID) \
            -> DeviceServicer_pb2.GetUserId_Responses:
        """
        Wrapper to call the unobservable command GetUserId on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetUserId:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetUserId_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetUserId(parameter)
    
            logging.debug('GetUserId response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetBatchId(self, UnitID) \
            -> DeviceServicer_pb2.GetBatchId_Responses:
        """
        Wrapper to call the unobservable command GetBatchId on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetBatchId:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetBatchId_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetBatchId(parameter)
    
            logging.debug('GetBatchId response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetInoculatedUTC(self, UnitID) \
            -> DeviceServicer_pb2.GetInoculatedUTC_Responses:
        """
        Wrapper to call the unobservable command GetInoculatedUTC on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetInoculatedUTC:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetInoculatedUTC_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetInoculatedUTC(parameter)
    
            logging.debug('GetInoculatedUTC response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetInoculated(self, UnitID) \
            -> DeviceServicer_pb2.GetInoculated_Responses:
        """
        Wrapper to call the unobservable command GetInoculated on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetInoculated:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetInoculated_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetInoculated(parameter)
    
            logging.debug('GetInoculated response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetAvailable(self, UnitID) \
            -> DeviceServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetName(self, UnitID) \
            -> DeviceServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetName_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetVersion(self, UnitID) \
            -> DeviceServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling Getversion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DeviceServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.DeviceServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetPV(self, UnitID) \
            -> DOServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")

        #parameter = DOServicer_pb2.GetPV_Parameters(
        #    UnitID=silaFW_pb2.Integer(value=unit)
        #parameter = DOServicer_pb2.GetPV_Parameters(UnitID=silaFW_pb2.Integer(value=parameter))

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.DOServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetSPM(self, UnitID, value) \
            -> DOServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = DOServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.DOServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetSPE(self, UnitID, value) \
            -> DOServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = DOServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.DOServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSP(self, UnitID) \
            -> DOServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.DOServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSPA(self, UnitID) \
            -> DOServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.DOServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSPM(self, UnitID) \
            -> DOServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetSPM_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSPE(self, UnitID) \
            -> DOServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetSPE_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSPR(self, UnitID) \
            -> DOServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetSPR_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAccess(self, UnitID) \
            -> DOServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetAccess_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetCmd(self, UnitID, value) \
            -> DOServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = DOServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.DOServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetCmd(self, UnitID) \
            -> DOServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.DOServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetMode(self,UnitID, value) \
            -> DOServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = DOServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.DOServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetMode(self, UnitID) \
            -> DOServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = DOServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.DOServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetSetpointSelect(self, UnitID, value) \
            -> DOServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.DOServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def DOServicer_GetSetpointSelect(self, UnitID) \
            -> DOServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetSetpointSelect_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetState(self, UnitID) \
            -> DOServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetState_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetType(self, UnitID) \
            -> DOServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetType_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAvailable(self, UnitID) \
            -> DOServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAvailable_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetName(self, UnitID) \
            -> DOServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetName_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetVersion(self, UnitID) \
            -> DOServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetVersion_Parameters(**par_dict)    
            response = self.DOServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetSensorOffset(self, UnitID, value) \
            -> DOServicer_pb2.SetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command SetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorOffset': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetSensorOffset_Parameters(**par_dict)    
            response = self.DOServicer_stub.SetSensorOffset(parameter)
    
            logging.debug('SetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSensorOffset(self, UnitID) \
            -> DOServicer_pb2.GetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command GetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetSensorOffset_Parameters(**par_dict)
            response = self.DOServicer_stub.GetSensorOffset(parameter)
    
            logging.debug('GetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSensorPVRaw(self, UnitID) \
            -> DOServicer_pb2.GetSensorPVRaw_Responses:
        """
        Wrapper to call the unobservable command GetSensorPVRaw on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorPVRaw:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetSensorPVRaw_Parameters(**par_dict)
            response = self.DOServicer_stub.GetSensorPVRaw(parameter)
    
            logging.debug('GetSensorPVRaw response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetSensorSlope(self, UnitID, value) \
            -> DOServicer_pb2.SetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command SetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorSlope:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorSlope': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetSensorSlope_Parameters(**par_dict)
            response = self.DOServicer_stub.SetSensorSlope(parameter)
    
            logging.debug('SetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSensorSlope(self, UnitID) \
            -> DOServicer_pb2.GetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command GetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorSlope:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetSensorSlope_Parameters(**par_dict)
            response = self.DOServicer_stub.GetSensorSlope(parameter)
    
            logging.debug('GetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetSensorCompensation(self, UnitID, value) \
            -> DOServicer_pb2.SetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command SetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorCompensation': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetSensorCompensation_Parameters(**par_dict)
            response = self.DOServicer_stub.SetSensorCompensation(parameter)
    
            logging.debug('SetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetSensorCompensation(self, UnitID) \
            -> DOServicer_pb2.GetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command GetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetSensorCompensation_Parameters(**par_dict)
            response = self.DOServicer_stub.GetSensorCompensation(parameter)
    
            logging.debug('GetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetControllerDB(self, UnitID, value) \
            -> DOServicer_pb2.SetControllerDB_Responses:
        """
        Wrapper to call the unobservable command SetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerDB': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetControllerDB_Parameters(**par_dict)
            response = self.DOServicer_stub.SetControllerDB(parameter)
    
            logging.debug('SetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerDB(self, UnitID) \
            -> DOServicer_pb2.GetControllerDB_Responses:
        """
        Wrapper to call the unobservable command GetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerDB_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerDB(parameter)
    
            logging.debug('GetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerOut(self, UnitID) \
            -> DOServicer_pb2.GetControllerOut_Responses:
        """
        Wrapper to call the unobservable command GetControllerOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerOut:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerOut_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerOut(parameter)
    
            logging.debug('GetControllerOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetControllerP(self, UnitID, value) \
            -> DOServicer_pb2.SetControllerP_Responses:
        """
        Wrapper to call the unobservable command SetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerP': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetControllerP_Parameters(**par_dict)
            response = self.DOServicer_stub.SetControllerP(parameter)
    
            logging.debug('SetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerP(self, UnitID) \
            -> DOServicer_pb2.GetControllerP_Responses:
        """
        Wrapper to call the unobservable command GetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerP_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerP(parameter)
    
            logging.debug('GetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetControllerTd(self, UnitID, value) \
            -> DOServicer_pb2.SetControllerTd_Responses:
        """
        Wrapper to call the unobservable command SetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTd': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetControllerTd_Parameters(**par_dict)
            response = self.DOServicer_stub.SetControllerTd(parameter)
    
            logging.debug('SetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerTd(self, UnitID) \
            -> DOServicer_pb2.GetControllerTd_Responses:
        """
        Wrapper to call the unobservable command GetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerTd_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerTd(parameter)
    
            logging.debug('GetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetControllerTi(self, UnitID, value) \
            -> DOServicer_pb2.SetControllerTi_Responses:
        """
        Wrapper to call the unobservable command SetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTi': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetControllerTi_Parameters(**par_dict)
            response = self.DOServicer_stub.SetControllerTi(parameter)
    
            logging.debug('SetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerTi(self,UnitID) \
            -> DOServicer_pb2.GetControllerTi_Responses:
        """
        Wrapper to call the unobservable command GetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerTi_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerTi(parameter)
    
            logging.debug('GetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetControllerMin(self, UnitID, value) \
            -> DOServicer_pb2.SetControllerMin_Responses:
        """
        Wrapper to call the unobservable command SetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMin': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetControllerMin_Parameters(**par_dict)
            response = self.DOServicer_stub.SetControllerMin(parameter)
    
            logging.debug('SetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerMin(self, UnitID) \
            -> DOServicer_pb2.GetControllerMin_Responses:
        """
        Wrapper to call the unobservable command GetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerMin_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerMin(parameter)
    
            logging.debug('GetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetControllerMax(self, UnitID, value) \
            -> DOServicer_pb2.SetControllerMax_Responses:
        """
        Wrapper to call the unobservable command SetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMax': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetControllerMax_Parameters(**par_dict)
            response = self.DOServicer_stub.SetControllerMax(parameter)
    
            logging.debug('SetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetControllerMax(self, UnitID) \
            -> DOServicer_pb2.GetControllerMax_Responses:
        """
        Wrapper to call the unobservable command GetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetControllerMax_Parameters(**par_dict)
            response = self.DOServicer_stub.GetControllerMax(parameter)
    
            logging.debug('GetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmEnabled(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command SetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmEnabled': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmEnabled_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmEnabled(parameter)
    
            logging.debug('SetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmEnabled(self, UnitID) \
            -> DOServicer_pb2.GetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command GetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmEnabled:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmEnabled_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmEnabled(parameter)
    
            logging.debug('GetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmAlarmHigh(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmAlarmHigh(parameter)
    
            logging.debug('SetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmAlarmHigh(self, UnitID) \
            -> DOServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmAlarmHigh(parameter)
    
            logging.debug('GetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmAlarmLow(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmAlarmLow_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmAlarmLow(parameter)
    
            logging.debug('SetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmAlarmLow(self, UnitID) \
            -> DOServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmAlarmLow_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmAlarmLow(parameter)
    
            logging.debug('GetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmMode(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmMode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmMode_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmMode(parameter)
    
            logging.debug('SetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmMode(self, UnitID) \
            -> DOServicer_pb2.GetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmMode_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmMode(parameter)
    
            logging.debug('GetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmState(self, UnitID) \
            -> DOServicer_pb2.GetAlarmState_Responses:
        """
        Wrapper to call the unobservable command GetAlarmState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmState_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmState(parameter)
    
            logging.debug('GetAlarmState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmDelay(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command SetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmDelay': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmDelay_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmDelay(parameter)
    
            logging.debug('SetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmDelay(self, UnitID) \
            -> DOServicer_pb2.GetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command GetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmDelay_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmDelay(parameter)
    
            logging.debug('GetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmWarnHigh(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmWarnHigh_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmWarnHigh(parameter)
    
            logging.debug('SetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmWarnHigh(self, UnitID) \
            -> DOServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmWarnHigh_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmWarnHigh(parameter)
    
            logging.debug('GetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_SetAlarmWarnLow(self, UnitID, value) \
            -> DOServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = DOServicer_pb2.SetAlarmWarnLow_Parameters(**par_dict)
            response = self.DOServicer_stub.SetAlarmWarnLow(parameter)
    
            logging.debug('SetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DOServicer_GetAlarmWarnLow(self, UnitID) \
            -> DOServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = DOServicer_pb2.GetAlarmWarnLow_Parameters(**par_dict)
            response = self.DOServicer_stub.GetAlarmWarnLow(parameter)
    
            logging.debug('GetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetPV(self, UnitID) \
            -> GassingServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetSP(self, UnitID) \
            -> GassingServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFPV(self, UnitID) \
            -> GassingServicer_pb2.GetFPV_Responses:
        """
        Wrapper to call the unobservable command GetFPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFPV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFPV(parameter)
    
            logging.debug('GetFPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetVPV(self, UnitID) \
            -> GassingServicer_pb2.GetVPV_Responses:
        """
        Wrapper to call the unobservable command GetVPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetVPV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetVPV(parameter)
    
            logging.debug('GetVPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFSP(self, UnitID) \
            -> GassingServicer_pb2.GetFSP_Responses:
        """
        Wrapper to call the unobservable command GetFSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFSP(parameter)
    
            logging.debug('GetFSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFSPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetFSPM_Responses:
        """
        Wrapper to call the unobservable command SetFSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FSPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFSPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFSPM(parameter)
    
            logging.debug('SetFSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFSPM(self, UnitID) \
            -> GassingServicer_pb2.GetFSPM_Responses:
        """
        Wrapper to call the unobservable command GetFSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetFSPM(parameter)
    
            logging.debug('GetFSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFSPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetFSPE_Responses:
        """
        Wrapper to call the unobservable command SetFSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FSPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFSPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFSPE(parameter)
    
            logging.debug('SetFSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFSPE(self, UnitID) \
            -> GassingServicer_pb2.GetFSPE_Responses:
        """
        Wrapper to call the unobservable command GetFSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFSPE(parameter)
    
            logging.debug('GetFSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFSPA(self, UnitID) \
            -> GassingServicer_pb2.GetFSPA_Responses:
        """
        Wrapper to call the unobservable command GetFSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFSPA(parameter)
    
            logging.debug('GetFSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFSPR(self, UnitID) \
            -> GassingServicer_pb2.GetFSPR_Responses:
        """
        Wrapper to call the unobservable command GetFSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFSPR(parameter)
    
            logging.debug('GetFSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def GassingServicer_GetFSPL(self, UnitID) \
            -> GassingServicer_pb2.GetFSPL_Responses:
        """
        Wrapper to call the unobservable command GetFSPL on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPL:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSPL_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFSPL(parameter)
    
            logging.debug('GetFSPL response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFMode(self, UnitID, value) \
            -> GassingServicer_pb2.SetFMode_Responses:
        """
        Wrapper to call the unobservable command SetFMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FMode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFMode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFMode(parameter)
    
            logging.debug('SetFMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFMode(self, UnitID) \
            -> GassingServicer_pb2.GetFMode_Responses:
        """
        Wrapper to call the unobservable command GetFMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFMode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFMode(parameter)
    
            logging.debug('GetFMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFSetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetFSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FSetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFSetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFSetpointSelect(parameter)
    
            logging.debug('SetFSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFSetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetFSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFSetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFSetpointSelect(parameter)
    
            logging.debug('GetFSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2PV(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetXCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2PV(parameter)
    
            logging.debug('GetXCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SP(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SP_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2SP(parameter)
    
            logging.debug('GetXCO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXCO2SPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetXCO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetXCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXCO2SPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXCO2SPM(parameter)
    
            logging.debug('SetXCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SPM(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetXCO2SPM(parameter)
    
            logging.debug('GetXCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXCO2SPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetXCO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetXCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXCO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXCO2SPE(parameter)
    
            logging.debug('SetXCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SPE(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2SPE(parameter)
    
            logging.debug('GetXCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SPA(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2SPA(parameter)
    
            logging.debug('GetXCO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SPR(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2SPR(parameter)
    
            logging.debug('GetXCO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SPL(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SPL_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPL on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPL:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SPL_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2SPL(parameter)

            logging.debug('GetXCO2SPL response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXCO2Mode(self, UnitID, value) \
            -> GassingServicer_pb2.SetXCO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetXCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXCO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXCO2Mode(parameter)
    
            logging.debug('SetXCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2Mode(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetXCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2Mode(parameter)
    
            logging.debug('GetXCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXCO2SetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetXCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetXCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXCO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXCO2SetpointSelect(parameter)
    
            logging.debug('SetXCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXCO2SetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetXCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXCO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXCO2SetpointSelect(parameter)
    
            logging.debug('GetXCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2PV(self, UnitID) \
            -> GassingServicer_pb2.GetXO2PV_Responses:
        """
        Wrapper to call the unobservable command GetXO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2PV(parameter)
    
            logging.debug('GetXO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SP(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SP_Responses:
        """
        Wrapper to call the unobservable command GetXO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2SP(parameter)
    
            logging.debug('GetXO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXO2SPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetXO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetXO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXO2SPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXO2SPM(parameter)
    
            logging.debug('SetXO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SPM(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetXO2SPM(parameter)
    
            logging.debug('GetXO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXO2SPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetXO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetXO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXO2SPE(parameter)
    
            logging.debug('SetXO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SPE(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2SPE(parameter)
    
            logging.debug('GetXO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SPA(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2SPA(parameter)
    
            logging.debug('GetXO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SPR(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2SPR(parameter)
    
            logging.debug('GetXO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SPL(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SPL_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPL on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPL:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SPL_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2SPL(parameter)
            
            logging.debug('SetXO2SPL response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXO2Mode(self, UnitID, value) \
            -> GassingServicer_pb2.SetXO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetXO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXO2Mode(parameter)
    
            logging.debug('SetXO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2Mode(self, UnitID) \
            -> GassingServicer_pb2.GetXO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetXO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2Mode(parameter)
    
            logging.debug('GetXO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetXO2SetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetXO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetXO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetXO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetXO2SetpointSelect(parameter)
    
            logging.debug('SetXO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetXO2SetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetXO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetXO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetXO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetXO2SetpointSelect(parameter)
    
            logging.debug('GetXO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirPV(self, UnitID) \
            -> GassingServicer_pb2.GetFAirPV_Responses:
        """
        Wrapper to call the unobservable command GetFAirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirPV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirPV(parameter)
    
            logging.debug('GetFAirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GassingServicer_GetVAirPV(self, UnitID) \
            -> GassingServicer_pb2.GetVAirPV_Responses:
        """
        Wrapper to call the unobservable command GetVAirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVAirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetVAirPV_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetVAirPV(parameter)
    
            logging.debug('GetVAirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirSP(self, UnitID) \
            -> GassingServicer_pb2.GetFAirSP_Responses:
        """
        Wrapper to call the unobservable command GetFAirSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirSP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirSP(parameter)
    
            logging.debug('GetFAirSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFAirSPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetFAirSPM_Responses:
        """
        Wrapper to call the unobservable command SetFAirSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirSPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFAirSPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFAirSPM(parameter)
    
            logging.debug('SetFAirSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirSPM(self, UnitID) \
            -> GassingServicer_pb2.GetFAirSPM_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirSPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetFAirSPM(parameter)
    
            logging.debug('GetFAirSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFAirSPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetFAirSPE_Responses:
        """
        Wrapper to call the unobservable command SetFAirSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirSPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFAirSPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFAirSPE(parameter)
    
            logging.debug('SetFAirSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirSPE(self, UnitID) \
            -> GassingServicer_pb2.GetFAirSPE_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirSPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirSPE(parameter)
    
            logging.debug('GetFAirSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirSPA(self, UnitID) \
            -> GassingServicer_pb2.GetFAirSPA_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirSPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirSPA(parameter)
    
            logging.debug('GetFAirSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirSPR(self, UnitID) \
            -> GassingServicer_pb2.GetFAirSPR_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirSPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirSPR(parameter)
    
            logging.debug('GetFAirSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFAirMode(self, UnitID, value) \
            -> GassingServicer_pb2.SetFAirMode_Responses:
        """
        Wrapper to call the unobservable command SetFAirMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirMode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFAirMode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFAirMode(parameter)
    
            logging.debug('SetFAirMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirMode(self, UnitID) \
            -> GassingServicer_pb2.GetFAirMode_Responses:
        """
        Wrapper to call the unobservable command GetFAirMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirMode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirMode(parameter)
    
            logging.debug('GetFAirMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFAirSetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetFAirSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFAirSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirSetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFAirSetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFAirSetpointSelect(parameter)
    
            logging.debug('SetFAirSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFAirSetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetFAirSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFAirSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFAirSetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFAirSetpointSelect(parameter)
    
            logging.debug('GetFAirSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2PV(self, UnitID) \
            -> GassingServicer_pb2.GetFO2PV_Responses:
        """
        Wrapper to call the unobservable command GetFO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2PV(parameter)
    
            logging.debug('GetFO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GassingServicer_GetVO2PV(self, UnitID) \
            -> GassingServicer_pb2.GetVO2PV_Responses:
        """
        Wrapper to call the unobservable command GetVO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetVO2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetVO2PV(parameter)
    
            logging.debug('GetVO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2SP(self, UnitID) \
            -> GassingServicer_pb2.GetFO2SP_Responses:
        """
        Wrapper to call the unobservable command GetFO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2SP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2SP(parameter)
    
            logging.debug('GetFO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFO2SPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetFO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetFO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFO2SPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFO2SPM(parameter)
    
            logging.debug('SetFO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2SPM(self, UnitID) \
            -> GassingServicer_pb2.GetFO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2SPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetFO2SPM(parameter)
    
            logging.debug('GetFO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFO2SPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetFO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetFO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFO2SPE(parameter)
    
            logging.debug('SetFO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2SPE(self, UnitID) \
            -> GassingServicer_pb2.GetFO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2SPE(parameter)
    
            logging.debug('GetFO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2SPA(self, UnitID) \
            -> GassingServicer_pb2.GetFO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2SPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2SPA(parameter)
    
            logging.debug('GetFO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2SPR(self, UnitID) \
            -> GassingServicer_pb2.GetFO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2SPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2SPR(parameter)
    
            logging.debug('GetFO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFO2Mode(self, UnitID, value) \
            -> GassingServicer_pb2.SetFO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetFO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFO2Mode(parameter)
    
            logging.debug('SetFO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2Mode(self, UnitID) \
            -> GassingServicer_pb2.GetFO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetFO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2Mode(parameter)
    
            logging.debug('GetFO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFO2SetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetFO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFO2SetpointSelect(parameter)
    
            logging.debug('SetFO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFO2SetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetFO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFO2SetpointSelect(parameter)
    
            logging.debug('GetFO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2PV(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetFCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2PV(parameter)
    
            logging.debug('GetFCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetVCO2PV(self, UnitID) \
            -> GassingServicer_pb2.GetVCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetVCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetVCO2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetVCO2PV(parameter)
    
            logging.debug('GetVCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2SP(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2SP_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2SP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2SP(parameter)
    
            logging.debug('GetFCO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFCO2SPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetFCO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetFCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFCO2SPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFCO2SPM(parameter)
    
            logging.debug('SetFCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2SPM(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2SPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetFCO2SPM(parameter)
    
            logging.debug('GetFCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFCO2SPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetFCO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetFCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFCO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFCO2SPE(parameter)
    
            logging.debug('SetFCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2SPE(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2SPE(parameter)
    
            logging.debug('GetFCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2SPA(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2SPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2SPA(parameter)
    
            logging.debug('GetFCO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2SPR(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2SPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2SPR(parameter)
    
            logging.debug('GetFCO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFCO2Mode(self, UnitID, value) \
            -> GassingServicer_pb2.SetFCO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetFCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFCO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFCO2Mode(parameter)
    
            logging.debug('SetFCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2Mode(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetFCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2Mode(parameter)
    
            logging.debug('GetFCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFCO2SetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetFCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFCO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFCO2SetpointSelect(parameter)
    
            logging.debug('SetFCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFCO2SetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetFCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFCO2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFCO2SetpointSelect(parameter)
    
            logging.debug('GetFCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2PV(self, UnitID) \
            -> GassingServicer_pb2.GetFN2PV_Responses:
        """
        Wrapper to call the unobservable command GetFN2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2PV(parameter)
    
            logging.debug('GetFN2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GassingServicer_GetVN2PV(self, UnitID) \
            -> GassingServicer_pb2.GetVN2PV_Responses:
        """
        Wrapper to call the unobservable command GetVN2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVN2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetVN2PV_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetVN2PV(parameter)
    
            logging.debug('GetVN2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GassingServicer_GetFN2SP(self, UnitID) \
            -> GassingServicer_pb2.GetFN2SP_Responses:
        """
        Wrapper to call the unobservable command GetFN2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2SP_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2SP(parameter)
    
            logging.debug('GetFN2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFN2SPM(self, UnitID, value) \
            -> GassingServicer_pb2.SetFN2SPM_Responses:
        """
        Wrapper to call the unobservable command SetFN2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFN2SPM_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFN2SPM(parameter)
    
            logging.debug('SetFN2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2SPM(self, UnitID) \
            -> GassingServicer_pb2.GetFN2SPM_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2SPM_Parameters(**par_dict)    
            response = self.GassingServicer_stub.GetFN2SPM(parameter)
    
            logging.debug('GetFN2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFN2SPE(self, UnitID, value) \
            -> GassingServicer_pb2.SetFN2SPE_Responses:
        """
        Wrapper to call the unobservable command SetFN2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFN2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFN2SPE(parameter)
    
            logging.debug('SetFN2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2SPE(self, UnitID) \
            -> GassingServicer_pb2.GetFN2SPE_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2SPE_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2SPE(parameter)
    
            logging.debug('GetFN2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2SPA(self, UnitID) \
            -> GassingServicer_pb2.GetFN2SPA_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2SPA_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2SPA(parameter)
    
            logging.debug('GetFN2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2SPR(self, UnitID) \
            -> GassingServicer_pb2.GetFN2SPR_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2SPR_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2SPR(parameter)
    
            logging.debug('GetFN2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFN2Mode(self, UnitID, value) \
            -> GassingServicer_pb2.SetFN2Mode_Responses:
        """
        Wrapper to call the unobservable command SetFN2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFN2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFN2Mode(parameter)
    
            logging.debug('SetFN2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2Mode(self, UnitID) \
            -> GassingServicer_pb2.GetFN2Mode_Responses:
        """
        Wrapper to call the unobservable command GetFN2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2Mode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2Mode(parameter)
    
            logging.debug('GetFN2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetFN2SetpointSelect(self, UnitID, value) \
            -> GassingServicer_pb2.SetFN2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFN2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetFN2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetFN2SetpointSelect(parameter)
    
            logging.debug('SetFN2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetFN2SetpointSelect(self, UnitID) \
            -> GassingServicer_pb2.GetFN2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFN2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetFN2SetpointSelect_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetFN2SetpointSelect(parameter)
    
            logging.debug('GetFN2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetAccess(self, UnitID) \
            -> GassingServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_SetCmd(self, UnitID, value) \
            -> GassingServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = GassingServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.GassingServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetCmd(self, UnitID) \
            -> GassingServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetGassingMode(self, UnitID) \
            -> GassingServicer_pb2.GetGassingMode_Responses:
        """
        Wrapper to call the unobservable command GetGassingMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetGassingMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetGassingMode_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetGassingMode(parameter)
    
            logging.debug('GetGassingMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetState(self, UnitID) \
            -> GassingServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetState_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetType(self, UnitID) \
            -> GassingServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetType_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetAvailable(self, UnitID) \
            -> GassingServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetName(self, UnitID) \
            -> GassingServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetName_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GassingServicer_GetVersion(self, UnitID) \
            -> GassingServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = GassingServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.GassingServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetAccess(self, UnitID) \
            -> IlluminationServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetCmd(self, UnitID, value) \
            -> IlluminationServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = IlluminationServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetCmd(self, UnitID) \
            -> IlluminationServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetMode(self, UnitID, value) \
            -> IlluminationServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = IlluminationServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetMode(self, UnitID) \
            -> IlluminationServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetState(self, UnitID) \
            -> IlluminationServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetState_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetType(self, UnitID) \
            -> IlluminationServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetType_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetAvailable(self, UnitID) \
            -> IlluminationServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetName(self, UnitID) \
            -> IlluminationServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetName_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetVersion(self, UnitID) \
            -> IlluminationServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorAPV(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorAPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorAPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorAPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorAPV_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorAPV(parameter)
    
            logging.debug('GetActuatorAPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorAPVInt(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorAPVInt_Responses:
        """
        Wrapper to call the unobservable command GetActuatorAPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorAPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorAPVInt_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorAPVInt(parameter)
    
            logging.debug('GetActuatorAPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASource(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASource_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASource on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASource:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASource_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASource(parameter)
    
            logging.debug('GetActuatorASource response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorASPM(self, UnitID, value) \
            -> IlluminationServicer_pb2.SetActuatorASPM_Responses:
        """
        Wrapper to call the unobservable command SetActuatorASPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorASPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorASPM': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = IlluminationServicer_pb2.SetActuatorASPM_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.SetActuatorASPM(parameter)
    
            logging.debug('SetActuatorASPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorASPE(self, UnitID, value) \
            -> IlluminationServicer_pb2.SetActuatorASPE_Responses:
        """
        Wrapper to call the unobservable command SetActuatorASPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorASPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorASPE': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = IlluminationServicer_pb2.SetActuatorASPE_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.SetActuatorASPE(parameter)
    
            logging.debug('SetActuatorASPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASP(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASP_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASP_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASP(parameter)
    
            logging.debug('GetActuatorASP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASPA(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASPA_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASPA_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASPA(parameter)
    
            logging.debug('GetActuatorASPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASPM(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASPM_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASPM_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASPM(parameter)
    
            logging.debug('GetActuatorASPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASPE(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASPE_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASPE_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASPE(parameter)
    
            logging.debug('GetActuatorASPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASPR(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASPR_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASPR_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASPR(parameter)
    
            logging.debug('GetActuatorASPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorAMode(self, UnitID, value) \
            -> IlluminationServicer_pb2.SetActuatorAMode_Responses:
        """
        Wrapper to call the unobservable command SetActuatorAMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorAMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorAMode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = IlluminationServicer_pb2.SetActuatorAMode_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.SetActuatorAMode(parameter)
    
            logging.debug('SetActuatorAMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorAMode(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorAMode_Responses:
        """
        Wrapper to call the unobservable command GetActuatorAMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorAMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorAMode_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorAMode(parameter)
    
            logging.debug('GetActuatorAMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorASetpointSelect(self, UnitID, value) \
            -> IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetActuatorASetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorASetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorASetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = IlluminationServicer_pb2.SetActuatorASetpointSelect_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.SetActuatorASetpointSelect(parameter)
    
            logging.debug('SetActuatorASetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorASetpointSelect(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetActuatorASetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorASetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorASetpointSelect_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorASetpointSelect(parameter)
    
            logging.debug('GetActuatorASetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorAAvailable(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorAAvailable_Responses:
        """
        Wrapper to call the unobservable command GetActuatorAAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorAAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorAAvailable_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorAAvailable(parameter)
    
            logging.debug('GetActuatorAAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorAName(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorAName_Responses:
        """
        Wrapper to call the unobservable command GetActuatorAName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorAName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorAName_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorAName(parameter)
    
            logging.debug('GetActuatorAName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBPV(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorBPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorBPV_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorBPV(parameter)
    
            logging.debug('GetActuatorBPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBPVInt(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorBPVInt_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorBPVInt_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorBPVInt(parameter)
    
            logging.debug('GetActuatorBPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSource(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorBSource_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSource on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSource:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorBSource_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorBSource(parameter)
    
            logging.debug('GetActuatorBSource response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorBSPM(self,
                      parameter: IlluminationServicer_pb2.SetActuatorBSPM_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorBSPM_Responses:
        """
        Wrapper to call the unobservable command SetActuatorBSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorBSPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorBSPM_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorBSPM_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorBSPM(parameter)
    
            logging.debug('SetActuatorBSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorBSPE(self,
                      parameter: IlluminationServicer_pb2.SetActuatorBSPE_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorBSPE_Responses:
        """
        Wrapper to call the unobservable command SetActuatorBSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorBSPE:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorBSPE_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorBSPE_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorBSPE(parameter)
    
            logging.debug('SetActuatorBSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSP(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBSP_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBSP_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSP:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBSP_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBSP_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBSP(parameter)
    
            logging.debug('GetActuatorBSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSPA(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBSPA_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBSPA_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSPA:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBSPA_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBSPA_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBSPA(parameter)
    
            logging.debug('GetActuatorBSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSPM(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBSPM_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBSPM_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBSPM_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBSPM_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBSPM(parameter)
    
            logging.debug('GetActuatorBSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSPE(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBSPE_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBSPE_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSPE:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBSPE_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBSPE_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBSPE(parameter)
    
            logging.debug('GetActuatorBSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSPR(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBSPR_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBSPR_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSPR:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBSPR_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBSPR_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBSPR(parameter)
    
            logging.debug('GetActuatorBSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorBMode(self,
                      parameter: IlluminationServicer_pb2.SetActuatorBMode_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorBMode_Responses:
        """
        Wrapper to call the unobservable command SetActuatorBMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorBMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorBMode_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorBMode_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorBMode(parameter)
    
            logging.debug('SetActuatorBMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBMode(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBMode_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBMode_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBMode_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBMode_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBMode(parameter)
    
            logging.debug('GetActuatorBMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorBSetpointSelect(self,
                      parameter: IlluminationServicer_pb2.SetActuatorBSetpointSelect_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetActuatorBSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorBSetpointSelect:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorBSetpointSelect_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorBSetpointSelect_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorBSetpointSelect(parameter)
    
            logging.debug('SetActuatorBSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBSetpointSelect(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBSetpointSelect_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBSetpointSelect:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBSetpointSelect_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBSetpointSelect_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBSetpointSelect(parameter)
    
            logging.debug('GetActuatorBSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBAvailable(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBAvailable_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBAvailable_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBAvailable:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBAvailable_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBAvailable_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBAvailable(parameter)
    
            logging.debug('GetActuatorBAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorBName(self,
                      parameter: IlluminationServicer_pb2.GetActuatorBName_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorBName_Responses:
        """
        Wrapper to call the unobservable command GetActuatorBName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorBName:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorBName_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorBName_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorBName(parameter)
    
            logging.debug('GetActuatorBName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCPV(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorCPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorCPV_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorCPV(parameter)
    
            logging.debug('GetActuatorCPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCPVInt(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorCPVInt_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorCPVInt_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorCPVInt(parameter)
    
            logging.debug('GetActuatorCPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSource(self, UnitID) \
            -> IlluminationServicer_pb2.GetActuatorCSource_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSource on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSource:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = IlluminationServicer_pb2.GetActuatorCSource_Parameters(**par_dict)
            response = self.IlluminationServicer_stub.GetActuatorCSource(parameter)
    
            logging.debug('GetActuatorCSource response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorCSPM(self,
                      parameter: IlluminationServicer_pb2.SetActuatorCSPM_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorCSPM_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCSPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorCSPM_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorCSPM_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorCSPM(parameter)
    
            logging.debug('SetActuatorCSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorCSPE(self,
                      parameter: IlluminationServicer_pb2.SetActuatorCSPE_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorCSPE_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCSPE:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorCSPE_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorCSPE_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorCSPE(parameter)
    
            logging.debug('SetActuatorCSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSP(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCSP_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCSP_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSP:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCSP_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCSP_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCSP(parameter)
    
            logging.debug('GetActuatorCSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSPA(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCSPA_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCSPA_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSPA:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCSPA_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCSPA_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCSPA(parameter)
    
            logging.debug('GetActuatorCSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSPM(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCSPM_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCSPM_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCSPM_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCSPM_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCSPM(parameter)
    
            logging.debug('GetActuatorCSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSPE(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCSPE_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCSPE_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSPE:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCSPE_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCSPE_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCSPE(parameter)
    
            logging.debug('GetActuatorCSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSPR(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCSPR_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCSPR_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSPR:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCSPR_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCSPR_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCSPR(parameter)
    
            logging.debug('GetActuatorCSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorCMode(self,
                      parameter: IlluminationServicer_pb2.SetActuatorCMode_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorCMode_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorCMode_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorCMode_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorCMode(parameter)
    
            logging.debug('SetActuatorCMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCMode(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCMode_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCMode_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCMode_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCMode_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCMode(parameter)
    
            logging.debug('GetActuatorCMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_SetActuatorCSetpointSelect(self,
                      parameter: IlluminationServicer_pb2.SetActuatorCSetpointSelect_Parameters = None) \
            -> IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCSetpointSelect:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.SetActuatorCSetpointSelect_Parameters(
                    **IlluminationServicer_default_dict['SetActuatorCSetpointSelect_Parameters']
                )
    
            response = self.IlluminationServicer_stub.SetActuatorCSetpointSelect(parameter)
    
            logging.debug('SetActuatorCSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCSetpointSelect(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCSetpointSelect_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCSetpointSelect:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCSetpointSelect_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCSetpointSelect_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCSetpointSelect(parameter)
    
            logging.debug('GetActuatorCSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCAvailable(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCAvailable_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCAvailable_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCAvailable:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCAvailable_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCAvailable_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCAvailable(parameter)
    
            logging.debug('GetActuatorCAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def IlluminationServicer_GetActuatorCName(self,
                      parameter: IlluminationServicer_pb2.GetActuatorCName_Parameters = None) \
            -> IlluminationServicer_pb2.GetActuatorCName_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCName:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = IlluminationServicer_pb2.GetActuatorCName_Parameters(
                    **IlluminationServicer_default_dict['GetActuatorCName_Parameters']
                )
    
            response = self.IlluminationServicer_stub.GetActuatorCName(parameter)
    
            logging.debug('GetActuatorCName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetPV(self, UnitID) \
            -> LevelServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = LevelServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetType(self, UnitID) \
            -> LevelServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetType_Parameters(**par_dict)  
            response = self.LevelServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAvailable(self, UnitID) \
            -> LevelServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetName(self, UnitID) \
            -> LevelServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetName_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetVersion(self, UnitID) \
            -> LevelServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetSensorPVRaw(self, UnitID) \
            -> LevelServicer_pb2.GetSensorPVRaw_Responses:
        """
        Wrapper to call the unobservable command GetSensorPVRaw on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorPVRaw:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetSensorPVRaw_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetSensorPVRaw(parameter)
    
            logging.debug('GetSensorPVRaw response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetSensorSlope(self, UnitID) \
            -> LevelServicer_pb2.GetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command GetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorSlope:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetSensorSlope_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetSensorSlope(parameter)
    
            logging.debug('GetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmEnabled(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command SetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmEnabled:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmEnabled': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmEnabled_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmEnabled(parameter)
    
            logging.debug('SetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmEnabled(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command GetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmEnabled:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmEnabled_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmEnabled(parameter)
    
            logging.debug('GetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmAlarmHigh(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmHigh:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmAlarmHigh(parameter)
    
            logging.debug('SetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmAlarmHigh(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmHigh:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmAlarmHigh(parameter)
    
            logging.debug('GetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmAlarmLow(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmLow:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmAlarmLow_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmAlarmLow(parameter)
    
            logging.debug('SetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmAlarmLow(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmLow:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmAlarmLow_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmAlarmLow(parameter)
    
            logging.debug('GetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmMode(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmMode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmMode_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmMode(parameter)
    
            logging.debug('SetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmMode(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmMode_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmMode(parameter)
    
            logging.debug('GetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmState(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmState_Responses:
        """
        Wrapper to call the unobservable command GetAlarmState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmState_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmState(parameter)
    
            logging.debug('GetAlarmState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmDelay(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command SetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmDelay:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmDelay': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmDelay_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmDelay(parameter)
    
            logging.debug('SetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmDelay(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command GetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmDelay:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmDelay_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmDelay(parameter)
    
            logging.debug('GetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmWarnHigh(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnHigh:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmWarnHigh_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmWarnHigh(parameter)
    
            logging.debug('SetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmWarnHigh(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnHigh:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmWarnHigh_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmWarnHigh(parameter)
    
            logging.debug('GetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_SetAlarmWarnLow(self, UnitID, value) \
            -> LevelServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnLow:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = LevelServicer_pb2.SetAlarmWarnLow_Parameters(**par_dict)
            response = self.LevelServicer_stub.SetAlarmWarnLow(parameter)
    
            logging.debug('SetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def LevelServicer_GetAlarmWarnLow(self, UnitID) \
            -> LevelServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnLow:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = LevelServicer_pb2.GetAlarmWarnLow_Parameters(**par_dict)
            response = self.LevelServicer_stub.GetAlarmWarnLow(parameter)
    
            logging.debug('GetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetCTRPV(self, UnitID) \
            -> OffgasServicer_pb2.GetCTRPV_Responses:
        """
        Wrapper to call the unobservable command GetCTRPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCTRPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetCTRPV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetCTRPV(parameter)
    
            logging.debug('GetCTRPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetFPV(self, UnitID) \
            -> OffgasServicer_pb2.GetFPV_Responses:
        """
        Wrapper to call the unobservable command GetFPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetFPV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetFPV(parameter)
    
            logging.debug('GetFPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetOTRPV(self, UnitID) \
            -> OffgasServicer_pb2.GetOTRPV_Responses:
        """
        Wrapper to call the unobservable command GetOTRPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetOTRPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetOTRPV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetOTRPV(parameter)
    
            logging.debug('GetOTRPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetRQPV(self, UnitID) \
            -> OffgasServicer_pb2.GetRQPV_Responses:
        """
        Wrapper to call the unobservable command GetRQPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetRQPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetRQPV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetRQPV(parameter)
    
            logging.debug('GetRQPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetXCO2PV(self, UnitID) \
            -> OffgasServicer_pb2.GetXCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetXCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetXCO2PV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetXCO2PV(parameter)
    
            logging.debug('GetXCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetVCTPV(self, UnitID) \
            -> OffgasServicer_pb2.GetVCTPV_Responses:
        """
        Wrapper to call the unobservable command GetVCTPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVCTPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetVCTPV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetVCTPV(parameter)
    
            logging.debug('GetVCTPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetVOTPV(self, UnitID) \
            -> OffgasServicer_pb2.GetVOTPV_Responses:
        """
        Wrapper to call the unobservable command GetVOTPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVOTPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetVOTPV_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetVOTPV(parameter)
    
            logging.debug('GetVOTPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetState(self, UnitID) \
            -> OffgasServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetState_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetType(self, UnitID) \
            -> OffgasServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetType_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetAvailable(self, UnitID) \
            -> OffgasServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetName(self, UnitID) \
            -> OffgasServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetName_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OffgasServicer_GetVersion(self, UnitID) \
            -> OffgasServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = OffgasServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.OffgasServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetPV(self, UnitID) \
            -> OverlayServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetSP(self, UnitID) \
            -> OverlayServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFPV(self, UnitID) \
            -> OverlayServicer_pb2.GetFPV_Responses:
        """
        Wrapper to call the unobservable command GetFPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFPV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFPV(parameter)
    
            logging.debug('GetFPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetVPV(self, UnitID) \
            -> OverlayServicer_pb2.GetVPV_Responses:
        """
        Wrapper to call the unobservable command GetVPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetVPV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetVPV(parameter)
    
            logging.debug('GetVPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSP(self, UnitID) \
            -> OverlayServicer_pb2.GetFSP_Responses:
        """
        Wrapper to call the unobservable command GetFSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFSP(parameter)
    
            logging.debug('GetFSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFSPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFSPM_Responses:
        """
        Wrapper to call the unobservable command SetFSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FSPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFSPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFSPM(parameter)
    
            logging.debug('SetFSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSPM(self, UnitID) \
            -> OverlayServicer_pb2.GetFSPM_Responses:
        """
        Wrapper to call the unobservable command GetFSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetFSPM(parameter)
    
            logging.debug('GetFSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFSPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFSPE_Responses:
        """
        Wrapper to call the unobservable command SetFSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FSPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFSPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFSPE(parameter)
    
            logging.debug('SetFSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSPE(self, UnitID) \
            -> OverlayServicer_pb2.GetFSPE_Responses:
        """
        Wrapper to call the unobservable command GetFSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFSPE(parameter)
    
            logging.debug('GetFSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSPA(self, UnitID) \
            -> OverlayServicer_pb2.GetFSPA_Responses:
        """
        Wrapper to call the unobservable command GetFSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFSPA(parameter)
    
            logging.debug('GetFSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSPR(self, UnitID) \
            -> OverlayServicer_pb2.GetFSPR_Responses:
        """
        Wrapper to call the unobservable command GetFSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFSPR(parameter)
    
            logging.debug('GetFSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSPL(self, UnitID) \
            -> OverlayServicer_pb2.GetFSPL_Responses:
        """
        Wrapper to call the unobservable command GetFSPL on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSPL:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSPL_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFSPL(parameter)
    
            logging.debug('GetFSPL response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFMode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFMode_Responses:
        """
        Wrapper to call the unobservable command SetFMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FMode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFMode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFMode(parameter)
    
            logging.debug('SetFMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFMode(self, UnitID) \
            -> OverlayServicer_pb2.GetFMode_Responses:
        """
        Wrapper to call the unobservable command GetFMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFMode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFMode(parameter)
    
            logging.debug('GetFMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFSetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FSetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFSetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFSetpointSelect(parameter)
    
            logging.debug('SetFSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFSetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetFSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFSetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFSetpointSelect(parameter)
    
            logging.debug('GetFSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetXCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2PV(parameter)
    
            logging.debug('GetXCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2SP(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SP_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2SP(parameter)
    
            logging.debug('GetXCO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXCO2SPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXCO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetXCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXCO2SPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXCO2SPM(parameter)
    
            logging.debug('SetXCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2SPM(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetXCO2SPM(parameter)
    
            logging.debug('GetXCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXCO2SPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXCO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetXCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXCO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXCO2SPE(parameter)
    
            logging.debug('SetXCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2SPE(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2SPE(parameter)
    
            logging.debug('GetXCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2SPA(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2SPA(parameter)
    
            logging.debug('GetXCO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def OverlayServicer_GetXCO2SPR(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2SPR(parameter)
    
            logging.debug('GetXCO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2SPL(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SPL_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SPL on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SPL:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SPL_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2SPL(parameter)

            logging.debug('GetXCO2SPL response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXCO2Mode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXCO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetXCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXCO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXCO2Mode(parameter)
    
            logging.debug('SetXCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2Mode(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetXCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2Mode(parameter)
    
            logging.debug('GetXCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXCO2SetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetXCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XCO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXCO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXCO2SetpointSelect(parameter)
    
            logging.debug('SetXCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXCO2SetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetXCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetXCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXCO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXCO2SetpointSelect(parameter)
    
            logging.debug('GetXCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2PV_Responses:
        """
        Wrapper to call the unobservable command GetXO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2PV(parameter)
    
            logging.debug('GetXO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SP(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SP_Responses:
        """
        Wrapper to call the unobservable command GetXO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2SP(parameter)
    
            logging.debug('GetXO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXO2SPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetXO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXO2SPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXO2SPM(parameter)
    
            logging.debug('SetXO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SPM(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetXO2SPM(parameter)
    
            logging.debug('GetXO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXO2SPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetXO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXO2SPE(parameter)
    
            logging.debug('SetXO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SPE(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2SPE(parameter)
    
            logging.debug('GetXO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SPA(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2SPA(parameter)
    
            logging.debug('GetXO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SPR(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2SPR(parameter)
    
            logging.debug('GetXO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SPL(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SPL_Responses:
        """
        Wrapper to call the unobservable command GetXO2SPL on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SPL:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SPL_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2SPL(parameter)
    
            logging.debug('GetXO2SPL response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXO2Mode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetXO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXO2Mode(parameter)
    
            logging.debug('SetXO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2Mode(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetXO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2Mode(parameter)
    
            logging.debug('GetXO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetXO2SetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetXO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetXO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetXO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'XO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetXO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetXO2SetpointSelect(parameter)
    
            logging.debug('SetXO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetXO2SetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetXO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetXO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetXO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetXO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetXO2SetpointSelect(parameter)
    
            logging.debug('GetXO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirPV(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirPV_Responses:
        """
        Wrapper to call the unobservable command GetFAirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirPV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirPV(parameter)
    
            logging.debug('GetFAirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def OverlayServicer_GetVAirPV(self, UnitID) \
            -> OverlayServicer_pb2.GetVAirPV_Responses:
        """
        Wrapper to call the unobservable command GetVAirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVAirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetVAirPV_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetVAirPV(parameter)
    
            logging.debug('GetVAirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirSP(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirSP_Responses:
        """
        Wrapper to call the unobservable command GetFAirSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirSP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirSP(parameter)
    
            logging.debug('GetFAirSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFAirSPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFAirSPM_Responses:
        """
        Wrapper to call the unobservable command SetFAirSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirSPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFAirSPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFAirSPM(parameter)
    
            logging.debug('SetFAirSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirSPM(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirSPM_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirSPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetFAirSPM(parameter)
    
            logging.debug('GetFAirSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFAirSPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFAirSPE_Responses:
        """
        Wrapper to call the unobservable command SetFAirSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirSPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFAirSPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFAirSPE(parameter)
    
            logging.debug('SetFAirSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirSPE(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirSPE_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirSPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirSPE(parameter)
    
            logging.debug('GetFAirSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def OverlayServicer_GetFAirSPA(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirSPA_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirSPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirSPA(parameter)
    
            logging.debug('GetFAirSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirSPR(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirSPR_Responses:
        """
        Wrapper to call the unobservable command GetFAirSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirSPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirSPR(parameter)
    
            logging.debug('GetFAirSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFAirMode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFAirMode_Responses:
        """
        Wrapper to call the unobservable command SetFAirMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirMode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFAirMode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFAirMode(parameter)
    
            logging.debug('SetFAirMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirMode(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirMode_Responses:
        """
        Wrapper to call the unobservable command GetFAirMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirMode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirMode(parameter)
    
            logging.debug('GetFAirMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFAirSetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFAirSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFAirSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFAirSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FAirSetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFAirSetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFAirSetpointSelect(parameter)
    
            logging.debug('SetFAirSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFAirSetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetFAirSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFAirSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFAirSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFAirSetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFAirSetpointSelect(parameter)
    
            logging.debug('GetFAirSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2PV_Responses:
        """
        Wrapper to call the unobservable command GetFO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2PV(parameter)
    
            logging.debug('GetFO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def OverlayServicer_GetVO2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetVO2PV_Responses:
        """
        Wrapper to call the unobservable command GetVO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetVO2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetVO2PV(parameter)
    
            logging.debug('GetVO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def OverlayServicer_GetFO2SP(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2SP_Responses:
        """
        Wrapper to call the unobservable command GetFO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2SP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2SP(parameter)
    
            logging.debug('GetFO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFO2SPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetFO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFO2SPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFO2SPM(parameter)
    
            logging.debug('SetFO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2SPM(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2SPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetFO2SPM(parameter)
    
            logging.debug('GetFO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFO2SPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetFO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFO2SPE(parameter)
    
            logging.debug('SetFO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2SPE(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2SPE(parameter)
    
            logging.debug('GetFO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2SPA(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2SPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2SPA(parameter)
    
            logging.debug('GetFO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2SPR(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetFO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2SPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2SPR(parameter)
    
            logging.debug('GetFO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFO2Mode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetFO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFO2Mode(parameter)
    
            logging.debug('SetFO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2Mode(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetFO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2Mode(parameter)
    
            logging.debug('GetFO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFO2SetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFO2SetpointSelect(parameter)
    
            logging.debug('SetFO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFO2SetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetFO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFO2SetpointSelect(parameter)
    
            logging.debug('GetFO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetFCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2PV(parameter)
    
            logging.debug('GetFCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetVCO2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetVCO2PV_Responses:
        """
        Wrapper to call the unobservable command GetVCO2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVCO2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetVCO2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetVCO2PV(parameter)
    
            logging.debug('GetVCO2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2SP(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2SP_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2SP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2SP(parameter)
    
            logging.debug('GetFCO2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFCO2SPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFCO2SPM_Responses:
        """
        Wrapper to call the unobservable command SetFCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFCO2SPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFCO2SPM(parameter)
    
            logging.debug('SetFCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2SPM(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2SPM_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2SPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetFCO2SPM(parameter)
    
            logging.debug('GetFCO2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFCO2SPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFCO2SPE_Responses:
        """
        Wrapper to call the unobservable command SetFCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFCO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFCO2SPE(parameter)
    
            logging.debug('SetFCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2SPE(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2SPE_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2SPE(parameter)
    
            logging.debug('GetFCO2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2SPA(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2SPA_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2SPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2SPA(parameter)
    
            logging.debug('GetFCO2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2SPR(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2SPR_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2SPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2SPR(parameter)
    
            logging.debug('GetFCO2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFCO2Mode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFCO2Mode_Responses:
        """
        Wrapper to call the unobservable command SetFCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFCO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFCO2Mode(parameter)
    
            logging.debug('SetFCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2Mode(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2Mode_Responses:
        """
        Wrapper to call the unobservable command GetFCO2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2Mode(parameter)
    
            logging.debug('GetFCO2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFCO2SetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FCO2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFCO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFCO2SetpointSelect(parameter)
    
            logging.debug('SetFCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFCO2SetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetFCO2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFCO2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFCO2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFCO2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFCO2SetpointSelect(parameter)
    
            logging.debug('GetFCO2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2PV_Responses:
        """
        Wrapper to call the unobservable command GetFN2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2PV(parameter)
    
            logging.debug('GetFN2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def OverlayServicer_GetVN2PV(self, UnitID) \
            -> OverlayServicer_pb2.GetVN2PV_Responses:
        """
        Wrapper to call the unobservable command GetVN2PV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVN2PV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetVN2PV_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetVN2PV(parameter)
    
            logging.debug('GetVN2PV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2SP(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2SP_Responses:
        """
        Wrapper to call the unobservable command GetFN2SP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2SP_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2SP(parameter)
    
            logging.debug('GetFN2SP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFN2SPM(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFN2SPM_Responses:
        """
        Wrapper to call the unobservable command SetFN2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFN2SPM_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFN2SPM(parameter)
    
            logging.debug('SetFN2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2SPM(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2SPM_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2SPM_Parameters(**par_dict)    
            response = self.OverlayServicer_stub.GetFN2SPM(parameter)
    
            logging.debug('GetFN2SPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFN2SPE(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFN2SPE_Responses:
        """
        Wrapper to call the unobservable command SetFN2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFN2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFN2SPE(parameter)
    
            logging.debug('SetFN2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2SPE(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2SPE_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2SPE_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2SPE(parameter)
    
            logging.debug('GetFN2SPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2SPA(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2SPA_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2SPA_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2SPA(parameter)
    
            logging.debug('GetFN2SPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2SPR(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2SPR_Responses:
        """
        Wrapper to call the unobservable command GetFN2SPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2SPR_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2SPR(parameter)
    
            logging.debug('GetFN2SPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFN2Mode(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFN2Mode_Responses:
        """
        Wrapper to call the unobservable command SetFN2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFN2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFN2Mode(parameter)
    
            logging.debug('SetFN2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2Mode(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2Mode_Responses:
        """
        Wrapper to call the unobservable command GetFN2Mode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2Mode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2Mode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2Mode(parameter)
    
            logging.debug('GetFN2Mode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetFN2SetpointSelect(self, UnitID, value) \
            -> OverlayServicer_pb2.SetFN2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetFN2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFN2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'FN2SetpointSelect': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetFN2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetFN2SetpointSelect(parameter)
    
            logging.debug('SetFN2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetFN2SetpointSelect(self, UnitID) \
            -> OverlayServicer_pb2.GetFN2SetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetFN2SetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFN2SetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetFN2SetpointSelect_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetFN2SetpointSelect(parameter)
    
            logging.debug('GetFN2SetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetAccess(self, UnitID) \
            -> OverlayServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_SetCmd(self, UnitID, value) \
            -> OverlayServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = OverlayServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.OverlayServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetCmd(self, UnitID) \
            -> OverlayServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetGassingMode(self, UnitID) \
            -> OverlayServicer_pb2.GetGassingMode_Responses:
        """
        Wrapper to call the unobservable command GetGassingMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetGassingMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetGassingMode_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetGassingMode(parameter)
    
            logging.debug('GetGassingMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetState(self, UnitID) \
            -> OverlayServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetState_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetType(self, UnitID) \
            -> OverlayServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetType_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetAvailable(self, UnitID) \
            -> OverlayServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetName(self, UnitID) \
            -> OverlayServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetName_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def OverlayServicer_GetVersion(self, UnitID) \
            -> OverlayServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = OverlayServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.OverlayServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetPV(self, UnitID) \
            -> PHServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")

        #parameter = PHServicer_pb2.GetPV_Parameters(
        #    UnitID=silaFW_pb2.Integer(value=unit)
        #parameter = PHServicer_pb2.GetPV_Parameters(UnitID=silaFW_pb2.Integer(value=parameter))

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.PHServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetSPM(self, UnitID, value) \
            -> PHServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = PHServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.PHServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetSPE(self, UnitID, value) \
            -> PHServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = PHServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.PHServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSP(self, UnitID) \
            -> PHServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.PHServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSPA(self, UnitID) \
            -> PHServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.PHServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSPM(self, UnitID) \
            -> PHServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetSPM_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSPE(self, UnitID) \
            -> PHServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetSPE_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSPR(self, UnitID) \
            -> PHServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetSPR_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAccess(self, UnitID) \
            -> PHServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetAccess_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetCmd(self, UnitID, value) \
            -> PHServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = PHServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.PHServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetCmd(self, UnitID) \
            -> PHServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.PHServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetMode(self,UnitID, value) \
            -> PHServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = PHServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.PHServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetMode(self, UnitID) \
            -> PHServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PHServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.PHServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetSetpointSelect(self, UnitID, value) \
            -> PHServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.PHServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def PHServicer_GetSetpointSelect(self, UnitID) \
            -> PHServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetSetpointSelect_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetState(self, UnitID) \
            -> PHServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetState_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetType(self, UnitID) \
            -> PHServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetType_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAvailable(self, UnitID) \
            -> PHServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAvailable_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetName(self, UnitID) \
            -> PHServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetName_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetVersion(self, UnitID) \
            -> PHServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetVersion_Parameters(**par_dict)    
            response = self.PHServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetSensorOffset(self, UnitID, value) \
            -> PHServicer_pb2.SetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command SetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorOffset': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetSensorOffset_Parameters(**par_dict)    
            response = self.PHServicer_stub.SetSensorOffset(parameter)
    
            logging.debug('SetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSensorOffset(self, UnitID) \
            -> PHServicer_pb2.GetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command GetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetSensorOffset_Parameters(**par_dict)
            response = self.PHServicer_stub.GetSensorOffset(parameter)
    
            logging.debug('GetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSensorPVRaw(self, UnitID) \
            -> PHServicer_pb2.GetSensorPVRaw_Responses:
        """
        Wrapper to call the unobservable command GetSensorPVRaw on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorPVRaw:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetSensorPVRaw_Parameters(**par_dict)
            response = self.PHServicer_stub.GetSensorPVRaw(parameter)
    
            logging.debug('GetSensorPVRaw response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetSensorSlope(self, UnitID, value) \
            -> PHServicer_pb2.SetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command SetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorSlope:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorSlope': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetSensorSlope_Parameters(**par_dict)
            response = self.PHServicer_stub.SetSensorSlope(parameter)
    
            logging.debug('SetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSensorSlope(self, UnitID) \
            -> PHServicer_pb2.GetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command GetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorSlope:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetSensorSlope_Parameters(**par_dict)
            response = self.PHServicer_stub.GetSensorSlope(parameter)
    
            logging.debug('GetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetSensorCompensation(self, UnitID, value) \
            -> PHServicer_pb2.SetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command SetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorCompensation': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetSensorCompensation_Parameters(**par_dict)
            response = self.PHServicer_stub.SetSensorCompensation(parameter)
    
            logging.debug('SetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetSensorCompensation(self, UnitID) \
            -> PHServicer_pb2.GetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command GetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetSensorCompensation_Parameters(**par_dict)
            response = self.PHServicer_stub.GetSensorCompensation(parameter)
    
            logging.debug('GetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetControllerDB(self, UnitID, value) \
            -> PHServicer_pb2.SetControllerDB_Responses:
        """
        Wrapper to call the unobservable command SetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerDB': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetControllerDB_Parameters(**par_dict)
            response = self.PHServicer_stub.SetControllerDB(parameter)
    
            logging.debug('SetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerDB(self, UnitID) \
            -> PHServicer_pb2.GetControllerDB_Responses:
        """
        Wrapper to call the unobservable command GetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerDB_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerDB(parameter)
    
            logging.debug('GetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerOut(self, UnitID) \
            -> PHServicer_pb2.GetControllerOut_Responses:
        """
        Wrapper to call the unobservable command GetControllerOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerOut:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerOut_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerOut(parameter)
    
            logging.debug('GetControllerOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetControllerP(self, UnitID, value) \
            -> PHServicer_pb2.SetControllerP_Responses:
        """
        Wrapper to call the unobservable command SetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerP': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetControllerP_Parameters(**par_dict)
            response = self.PHServicer_stub.SetControllerP(parameter)
    
            logging.debug('SetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerP(self, UnitID) \
            -> PHServicer_pb2.GetControllerP_Responses:
        """
        Wrapper to call the unobservable command GetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerP_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerP(parameter)
    
            logging.debug('GetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetControllerTd(self, UnitID, value) \
            -> PHServicer_pb2.SetControllerTd_Responses:
        """
        Wrapper to call the unobservable command SetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTd': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetControllerTd_Parameters(**par_dict)
            response = self.PHServicer_stub.SetControllerTd(parameter)
    
            logging.debug('SetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerTd(self, UnitID) \
            -> PHServicer_pb2.GetControllerTd_Responses:
        """
        Wrapper to call the unobservable command GetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerTd_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerTd(parameter)
    
            logging.debug('GetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetControllerTi(self, UnitID, value) \
            -> PHServicer_pb2.SetControllerTi_Responses:
        """
        Wrapper to call the unobservable command SetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTi': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetControllerTi_Parameters(**par_dict)
            response = self.PHServicer_stub.SetControllerTi(parameter)
    
            logging.debug('SetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerTi(self,UnitID) \
            -> PHServicer_pb2.GetControllerTi_Responses:
        """
        Wrapper to call the unobservable command GetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerTi_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerTi(parameter)
    
            logging.debug('GetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetControllerMin(self, UnitID, value) \
            -> PHServicer_pb2.SetControllerMin_Responses:
        """
        Wrapper to call the unobservable command SetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMin': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetControllerMin_Parameters(**par_dict)
            response = self.PHServicer_stub.SetControllerMin(parameter)
    
            logging.debug('SetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerMin(self, UnitID) \
            -> PHServicer_pb2.GetControllerMin_Responses:
        """
        Wrapper to call the unobservable command GetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerMin_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerMin(parameter)
    
            logging.debug('GetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetControllerMax(self, UnitID, value) \
            -> PHServicer_pb2.SetControllerMax_Responses:
        """
        Wrapper to call the unobservable command SetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMax': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetControllerMax_Parameters(**par_dict)
            response = self.PHServicer_stub.SetControllerMax(parameter)
    
            logging.debug('SetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetControllerMax(self, UnitID) \
            -> PHServicer_pb2.GetControllerMax_Responses:
        """
        Wrapper to call the unobservable command GetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetControllerMax_Parameters(**par_dict)
            response = self.PHServicer_stub.GetControllerMax(parameter)
    
            logging.debug('GetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmEnabled(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command SetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmEnabled': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmEnabled_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmEnabled(parameter)
    
            logging.debug('SetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmEnabled(self, UnitID) \
            -> PHServicer_pb2.GetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command GetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmEnabled_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmEnabled(parameter)
    
            logging.debug('GetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmAlarmHigh(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmAlarmHigh(parameter)
    
            logging.debug('SetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmAlarmHigh(self, UnitID) \
            -> PHServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmAlarmHigh(parameter)
    
            logging.debug('GetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmAlarmLow(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmAlarmLow_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmAlarmLow(parameter)
    
            logging.debug('SetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmAlarmLow(self, UnitID) \
            -> PHServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmAlarmLow_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmAlarmLow(parameter)
    
            logging.debug('GetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmMode(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmMode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmMode_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmMode(parameter)
    
            logging.debug('SetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmMode(self, UnitID) \
            -> PHServicer_pb2.GetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmMode_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmMode(parameter)
    
            logging.debug('GetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmState(self, UnitID) \
            -> PHServicer_pb2.GetAlarmState_Responses:
        """
        Wrapper to call the unobservable command GetAlarmState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmState_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmState(parameter)
    
            logging.debug('GetAlarmState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmDelay(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command SetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmDelay': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmDelay_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmDelay(parameter)
    
            logging.debug('SetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmDelay(self, UnitID) \
            -> PHServicer_pb2.GetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command GetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmDelay_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmDelay(parameter)
    
            logging.debug('GetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmWarnHigh(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmWarnHigh_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmWarnHigh(parameter)
    
            logging.debug('SetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmWarnHigh(self, UnitID) \
            -> PHServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmWarnHigh_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmWarnHigh(parameter)
    
            logging.debug('GetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_SetAlarmWarnLow(self, UnitID, value) \
            -> PHServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PHServicer_pb2.SetAlarmWarnLow_Parameters(**par_dict)
            response = self.PHServicer_stub.SetAlarmWarnLow(parameter)
    
            logging.debug('SetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PHServicer_GetAlarmWarnLow(self, UnitID) \
            -> PHServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PHServicer_pb2.GetAlarmWarnLow_Parameters(**par_dict)
            response = self.PHServicer_stub.GetAlarmWarnLow(parameter)
    
            logging.debug('GetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def PressureServicer_GetPV(self, UnitID) \
            -> PressureServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")

        #parameter = PressureServicer_pb2.GetPV_Parameters(
        #    UnitID=silaFW_pb2.Integer(value=unit)
        #parameter = PressureServicer_pb2.GetPV_Parameters(UnitID=silaFW_pb2.Integer(value=parameter))

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetSPM(self, UnitID, value) \
            -> PressureServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = PressureServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetSPE(self, UnitID, value) \
            -> PressureServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = PressureServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSP(self, UnitID) \
            -> PressureServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSPA(self, UnitID) \
            -> PressureServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSPM(self, UnitID) \
            -> PressureServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetSPM_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSPE(self, UnitID) \
            -> PressureServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetSPE_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSPR(self, UnitID) \
            -> PressureServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetSPR_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
   
    def PressureServicer_GetAccess(self, UnitID) \
            -> PressureServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetAccess_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetCmd(self, UnitID, value) \
            -> PressureServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = PressureServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetCmd(self, UnitID) \
            -> PressureServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetMode(self,UnitID, value) \
            -> PressureServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = PressureServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetMode(self, UnitID) \
            -> PressureServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = PressureServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetSetpointSelect(self, UnitID, value) \
            -> PressureServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def PressureServicer_GetSetpointSelect(self, UnitID) \
            -> PressureServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetSetpointSelect_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetState(self, UnitID) \
            -> PressureServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetState_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetType(self, UnitID) \
            -> PressureServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetType_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetAvailable(self, UnitID) \
            -> PressureServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetAvailable_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetName(self, UnitID) \
            -> PressureServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetName_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetVersion(self, UnitID) \
            -> PressureServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetVersion_Parameters(**par_dict)    
            response = self.PressureServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetSensorOffset(self, UnitID, value) \
            -> PressureServicer_pb2.SetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command SetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorOffset': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetSensorOffset_Parameters(**par_dict)    
            response = self.PressureServicer_stub.SetSensorOffset(parameter)
    
            logging.debug('SetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSensorOffset(self, UnitID) \
            -> PressureServicer_pb2.GetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command GetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetSensorOffset_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetSensorOffset(parameter)
    
            logging.debug('GetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSensorPVRaw(self, UnitID) \
            -> PressureServicer_pb2.GetSensorPVRaw_Responses:
        """
        Wrapper to call the unobservable command GetSensorPVRaw on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorPVRaw:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetSensorPVRaw_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetSensorPVRaw(parameter)
    
            logging.debug('GetSensorPVRaw response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetSensorCompensation(self, UnitID, value) \
            -> PressureServicer_pb2.SetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command SetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorCompensation': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetSensorCompensation_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetSensorCompensation(parameter)
    
            logging.debug('SetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetSensorCompensation(self, UnitID) \
            -> PressureServicer_pb2.GetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command GetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetSensorCompensation_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetSensorCompensation(parameter)
    
            logging.debug('GetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetControllerDB(self, UnitID, value) \
            -> PressureServicer_pb2.SetControllerDB_Responses:
        """
        Wrapper to call the unobservable command SetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerDB': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetControllerDB_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetControllerDB(parameter)
    
            logging.debug('SetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerDB(self, UnitID) \
            -> PressureServicer_pb2.GetControllerDB_Responses:
        """
        Wrapper to call the unobservable command GetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerDB_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerDB(parameter)
    
            logging.debug('GetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerOut(self, UnitID) \
            -> PressureServicer_pb2.GetControllerOut_Responses:
        """
        Wrapper to call the unobservable command GetControllerOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerOut:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerOut_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerOut(parameter)
    
            logging.debug('GetControllerOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetControllerP(self, UnitID, value) \
            -> PressureServicer_pb2.SetControllerP_Responses:
        """
        Wrapper to call the unobservable command SetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerP': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetControllerP_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetControllerP(parameter)
    
            logging.debug('SetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerP(self, UnitID) \
            -> PressureServicer_pb2.GetControllerP_Responses:
        """
        Wrapper to call the unobservable command GetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerP_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerP(parameter)
    
            logging.debug('GetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetControllerTd(self, UnitID, value) \
            -> PressureServicer_pb2.SetControllerTd_Responses:
        """
        Wrapper to call the unobservable command SetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTd': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetControllerTd_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetControllerTd(parameter)
    
            logging.debug('SetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerTd(self, UnitID) \
            -> PressureServicer_pb2.GetControllerTd_Responses:
        """
        Wrapper to call the unobservable command GetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerTd_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerTd(parameter)
    
            logging.debug('GetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetControllerTi(self, UnitID, value) \
            -> PressureServicer_pb2.SetControllerTi_Responses:
        """
        Wrapper to call the unobservable command SetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTi': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetControllerTi_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetControllerTi(parameter)
    
            logging.debug('SetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerTi(self,UnitID) \
            -> PressureServicer_pb2.GetControllerTi_Responses:
        """
        Wrapper to call the unobservable command GetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerTi_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerTi(parameter)
    
            logging.debug('GetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetControllerMin(self, UnitID, value) \
            -> PressureServicer_pb2.SetControllerMin_Responses:
        """
        Wrapper to call the unobservable command SetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMin': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetControllerMin_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetControllerMin(parameter)
    
            logging.debug('SetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerMin(self, UnitID) \
            -> PressureServicer_pb2.GetControllerMin_Responses:
        """
        Wrapper to call the unobservable command GetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerMin_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerMin(parameter)
    
            logging.debug('GetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_SetControllerMax(self, UnitID, value) \
            -> PressureServicer_pb2.SetControllerMax_Responses:
        """
        Wrapper to call the unobservable command SetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMax': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PressureServicer_pb2.SetControllerMax_Parameters(**par_dict)
            response = self.PressureServicer_stub.SetControllerMax(parameter)
    
            logging.debug('SetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PressureServicer_GetControllerMax(self, UnitID) \
            -> PressureServicer_pb2.GetControllerMax_Responses:
        """
        Wrapper to call the unobservable command GetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PressureServicer_pb2.GetControllerMax_Parameters(**par_dict)
            response = self.PressureServicer_stub.GetControllerMax(parameter)
    
            logging.debug('GetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetPVInt(self, UnitID) \
            -> PumpAServicer_pb2.GetPVInt_Responses:
        """
        Wrapper to call the unobservable command GetPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetPVInt_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetPVInt(parameter)
    
            logging.debug('GetPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetPV(self, UnitID) \
            -> PumpAServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def PumpAServicer_SetSPM(self, UnitID, value) \
            -> PumpAServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpAServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.PumpAServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_SetSPE(self, UnitID, value) \
            -> PumpAServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpAServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.PumpAServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetSP(self, UnitID) \
            -> PumpAServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetSPA(self, UnitID) \
            -> PumpAServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetSPM(self, UnitID) \
            -> PumpAServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetSPM_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetSPE(self, UnitID) \
            -> PumpAServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetSPE_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetSPR(self, UnitID) \
            -> PumpAServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetSPR_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetAccess(self, UnitID) \
            -> PumpAServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_SetCmd(self, UnitID, value) \
            -> PumpAServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpAServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.PumpAServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetCmd(self, UnitID) \
            -> PumpAServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_SetMode(self, UnitID, value) \
            -> PumpAServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpAServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.PumpAServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetMode(self, UnitID) \
            -> PumpAServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_SetSetpointSelect(self, UnitID, value) \
            -> PumpAServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpAServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.PumpAServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetSetpointSelect(self, UnitID) \
            -> PumpAServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetSetpointSelect_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetState(self, UnitID) \
            -> PumpAServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetState_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetType(self, UnitID) \
            -> PumpAServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetType_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetAvailable(self, UnitID) \
            -> PumpAServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetName(self, UnitID) \
            -> PumpAServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetName_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetVersion(self, UnitID) \
            -> PumpAServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_SetActuatorCalibration(self, UnitID, value) \
            -> PumpAServicer_pb2.SetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorCalibration': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpAServicer_pb2.SetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpAServicer_stub.SetActuatorCalibration(parameter)
    
            logging.debug('SetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetActuatorCalibration(self, UnitID) \
            -> PumpAServicer_pb2.GetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetActuatorCalibration(parameter)
    
            logging.debug('GetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpAServicer_GetActuatorDirPV(self, UnitID) \
            -> PumpAServicer_pb2.GetActuatorDirPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorDirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorDirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpAServicer_pb2.GetActuatorDirPV_Parameters(**par_dict)
            response = self.PumpAServicer_stub.GetActuatorDirPV(parameter)
    
            logging.debug('GetActuatorDirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetPVInt(self, UnitID) \
            -> PumpBServicer_pb2.GetPVInt_Responses:
        """
        Wrapper to call the unobservable command GetPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetPVInt_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetPVInt(parameter)
    
            logging.debug('GetPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetPV(self, UnitID) \
            -> PumpBServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_SetSPM(self, UnitID, value) \
            -> PumpBServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpBServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.PumpBServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_SetSPE(self, UnitID, value) \
            -> PumpBServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpBServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.PumpBServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetSP(self, UnitID) \
            -> PumpBServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetSPA(self, UnitID) \
            -> PumpBServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetSPM(self, UnitID) \
            -> PumpBServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetSPM_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetSPE(self, UnitID) \
            -> PumpBServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetSPE_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetSPR(self, UnitID) \
            -> PumpBServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetSPR_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetAccess(self, UnitID) \
            -> PumpBServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_SetCmd(self, UnitID, value) \
            -> PumpBServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpBServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.PumpBServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetCmd(self, UnitID) \
            -> PumpBServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_SetMode(self, UnitID, value) \
            -> PumpBServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpBServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.PumpBServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetMode(self, UnitID) \
            -> PumpBServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_SetSetpointSelect(self, UnitID, value) \
            -> PumpBServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpBServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.PumpBServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetSetpointSelect(self, UnitID) \
            -> PumpBServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetSetpointSelect_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetState(self, UnitID) \
            -> PumpBServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetState_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetType(self, UnitID) \
            -> PumpBServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetType_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetAvailable(self, UnitID) \
            -> PumpBServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetName(self, UnitID) \
            -> PumpBServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetName_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetVersion(self, UnitID) \
            -> PumpBServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_SetActuatorCalibration(self, UnitID, value) \
            -> PumpBServicer_pb2.SetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorCalibration': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpBServicer_pb2.SetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpBServicer_stub.SetActuatorCalibration(parameter)
    
            logging.debug('SetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetActuatorCalibration(self, UnitID) \
            -> PumpBServicer_pb2.GetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetActuatorCalibration(parameter)
    
            logging.debug('GetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpBServicer_GetActuatorDirPV(self, UnitID) \
            -> PumpBServicer_pb2.GetActuatorDirPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorDirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorDirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpBServicer_pb2.GetActuatorDirPV_Parameters(**par_dict)
            response = self.PumpBServicer_stub.GetActuatorDirPV(parameter)
    
            logging.debug('GetActuatorDirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetPVInt(self, UnitID) \
            -> PumpCServicer_pb2.GetPVInt_Responses:
        """
        Wrapper to call the unobservable command GetPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetPVInt_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetPVInt(parameter)
    
            logging.debug('GetPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetPV(self, UnitID) \
            -> PumpCServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_SetSPM(self, UnitID, value) \
            -> PumpCServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpCServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.PumpCServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_SetSPE(self, UnitID, value) \
            -> PumpCServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpCServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.PumpCServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetSP(self, UnitID) \
            -> PumpCServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetSPA(self, UnitID) \
            -> PumpCServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetSPM(self, UnitID) \
            -> PumpCServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetSPM_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetSPE(self, UnitID) \
            -> PumpCServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetSPE_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetSPR(self, UnitID) \
            -> PumpCServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetSPR_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetAccess(self, UnitID) \
            -> PumpCServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_SetCmd(self, UnitID, value) \
            -> PumpCServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpCServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.PumpCServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetCmd(self, UnitID) \
            -> PumpCServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_SetMode(self, UnitID, value) \
            -> PumpCServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpCServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.PumpCServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetMode(self, UnitID) \
            -> PumpCServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_SetSetpointSelect(self, UnitID, value) \
            -> PumpCServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpCServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.PumpCServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetSetpointSelect(self, UnitID) \
            -> PumpCServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetSetpointSelect_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetState(self, UnitID) \
            -> PumpCServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetState_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetType(self, UnitID) \
            -> PumpCServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetType_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetAvailable(self, UnitID) \
            -> PumpCServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetName(self, UnitID) \
            -> PumpCServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetName_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetVersion(self, UnitID) \
            -> PumpCServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_SetActuatorCalibration(self, UnitID, value) \
            -> PumpCServicer_pb2.SetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorCalibration': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpCServicer_pb2.SetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpCServicer_stub.SetActuatorCalibration(parameter)
    
            logging.debug('SetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetActuatorCalibration(self, UnitID) \
            -> PumpCServicer_pb2.GetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetActuatorCalibration(parameter)
    
            logging.debug('GetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpCServicer_GetActuatorDirPV(self, UnitID) \
            -> PumpCServicer_pb2.GetActuatorDirPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorDirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorDirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpCServicer_pb2.GetActuatorDirPV_Parameters(**par_dict)
            response = self.PumpCServicer_stub.GetActuatorDirPV(parameter)
    
            logging.debug('GetActuatorDirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetPVInt(self, UnitID) \
            -> PumpDServicer_pb2.GetPVInt_Responses:
        """
        Wrapper to call the unobservable command GetPVInt on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPVInt:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetPVInt_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetPVInt(parameter)
    
            logging.debug('GetPVInt response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetPV(self, UnitID) \
            -> PumpDServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_SetSPM(self, UnitID, value) \
            -> PumpDServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpDServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.PumpDServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_SetSPE(self, UnitID, value) \
            -> PumpDServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpDServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.PumpDServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetSP(self, UnitID) \
            -> PumpDServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetSPA(self, UnitID) \
            -> PumpDServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetSPM(self, UnitID) \
            -> PumpDServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetSPM_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetSPE(self, UnitID) \
            -> PumpDServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetSPE_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetSPR(self, UnitID) \
            -> PumpDServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetSPR_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetAccess(self, UnitID) \
            -> PumpDServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetAccess_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_SetCmd(self, UnitID, value) \
            -> PumpDServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpDServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.PumpDServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetCmd(self, UnitID) \
            -> PumpDServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_SetMode(self, UnitID, value) \
            -> PumpDServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpDServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.PumpDServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetMode(self, UnitID) \
            -> PumpDServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_SetSetpointSelect(self, UnitID, value) \
            -> PumpDServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = PumpDServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.PumpDServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetSetpointSelect(self, UnitID) \
            -> PumpDServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetSetpointSelect_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetState(self, UnitID) \
            -> PumpDServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetState_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetType(self, UnitID) \
            -> PumpDServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetType_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetAvailable(self, UnitID) \
            -> PumpDServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetName(self, UnitID) \
            -> PumpDServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetName_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetVersion(self, UnitID) \
            -> PumpDServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_SetActuatorCalibration(self, UnitID, value) \
            -> PumpDServicer_pb2.SetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command SetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ActuatorCalibration': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = PumpDServicer_pb2.SetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpDServicer_stub.SetActuatorCalibration(parameter)
    
            logging.debug('SetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetActuatorCalibration(self, UnitID) \
            -> PumpDServicer_pb2.GetActuatorCalibration_Responses:
        """
        Wrapper to call the unobservable command GetActuatorCalibration on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorCalibration:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetActuatorCalibration_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetActuatorCalibration(parameter)
    
            logging.debug('GetActuatorCalibration response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PumpDServicer_GetActuatorDirPV(self, UnitID) \
            -> PumpDServicer_pb2.GetActuatorDirPV_Responses:
        """
        Wrapper to call the unobservable command GetActuatorDirPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetActuatorDirPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = PumpDServicer_pb2.GetActuatorDirPV_Parameters(**par_dict)
            response = self.PumpDServicer_stub.GetActuatorDirPV(parameter)
    
            logging.debug('GetActuatorDirPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ReactorServicer_GetVInitial(self, UnitID) \
            -> ReactorServicer_pb2.GetVInitial_Responses:
        """
        Wrapper to call the unobservable command GetVInitial on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVInitial:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = ReactorServicer_pb2.GetVInitial_Parameters(**par_dict)
            response = self.ReactorServicer_stub.GetVInitial(parameter)
    
            logging.debug('GetVInitial response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ReactorServicer_GetVLiquid(self, UnitID) \
            -> ReactorServicer_pb2.GetVLiquid_Responses:
        """
        Wrapper to call the unobservable command GetVLiquid on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVLiquid:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = ReactorServicer_pb2.GetVLiquid_Parameters(**par_dict)
            response = self.ReactorServicer_stub.GetVLiquid(parameter)
    
            logging.debug('GetVLiquid response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ReactorServicer_GetVMax(self, UnitID) \
            -> ReactorServicer_pb2.GetVMax_Responses:
        """
        Wrapper to call the unobservable command GetVMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVMax:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = ReactorServicer_pb2.GetVMax_Parameters(**par_dict)
            response = self.ReactorServicer_stub.GetVMax(parameter)
    
            logging.debug('GetVMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ReactorServicer_GetVMin(self, UnitID) \
            -> ReactorServicer_pb2.GetVMin_Responses:
        """
        Wrapper to call the unobservable command GetVMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVMin:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = ReactorServicer_pb2.GetVMin_Parameters(**par_dict)
            response = self.ReactorServicer_stub.GetVMin(parameter)
    
            logging.debug('GetVMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ReactorServicer_GetVTotal(self, UnitID) \
            -> ReactorServicer_pb2.GetVTotal_Responses:
        """
        Wrapper to call the unobservable command GetVTotal on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVTotal:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = ReactorServicer_pb2.GetVTotal_Parameters(**par_dict)
            response = self.ReactorServicer_stub.GetVTotal(parameter)
    
            logging.debug('GetVTotal response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetPV(self, UnitID) \
            -> RedoxServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Calling GetPV:")

        #parameter = RedoxServicer_pb2.GetPV_Parameters(
        #    UnitID=silaFW_pb2.Integer(value=unit)
        #parameter = RedoxServicer_pb2.GetPV_Parameters(UnitID=silaFW_pb2.Integer(value=parameter))

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetSPM(self, UnitID, value) \
            -> RedoxServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = RedoxServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetSPE(self, UnitID, value) \
            -> RedoxServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = RedoxServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSP(self, UnitID) \
            -> RedoxServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSPA(self, UnitID) \
            -> RedoxServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSPM(self, UnitID) \
            -> RedoxServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetSPM_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSPE(self, UnitID) \
            -> RedoxServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetSPE_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSPR(self, UnitID) \
            -> RedoxServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetSPR_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAccess(self, UnitID) \
            -> RedoxServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetAccess_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetCmd(self, UnitID, value) \
            -> RedoxServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = RedoxServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetCmd(self, UnitID) \
            -> RedoxServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetMode(self,UnitID, value) \
            -> RedoxServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = RedoxServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetMode(self, UnitID) \
            -> RedoxServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = RedoxServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetSetpointSelect(self, UnitID, value) \
            -> RedoxServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def RedoxServicer_GetSetpointSelect(self, UnitID) \
            -> RedoxServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetSetpointSelect_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetState(self, UnitID) \
            -> RedoxServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetState_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetType(self, UnitID) \
            -> RedoxServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetType_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAvailable(self, UnitID) \
            -> RedoxServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAvailable_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetName(self, UnitID) \
            -> RedoxServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetName_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetVersion(self, UnitID) \
            -> RedoxServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetVersion_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetSensorOffset(self, UnitID, value) \
            -> RedoxServicer_pb2.SetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command SetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorOffset': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetSensorOffset_Parameters(**par_dict)    
            response = self.RedoxServicer_stub.SetSensorOffset(parameter)
    
            logging.debug('SetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSensorOffset(self, UnitID) \
            -> RedoxServicer_pb2.GetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command GetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetSensorOffset_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetSensorOffset(parameter)
    
            logging.debug('GetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSensorPVRaw(self, UnitID) \
            -> RedoxServicer_pb2.GetSensorPVRaw_Responses:
        """
        Wrapper to call the unobservable command GetSensorPVRaw on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorPVRaw:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetSensorPVRaw_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetSensorPVRaw(parameter)
    
            logging.debug('GetSensorPVRaw response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetSensorCompensation(self, UnitID, value) \
            -> RedoxServicer_pb2.SetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command SetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorCompensation': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetSensorCompensation_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetSensorCompensation(parameter)
    
            logging.debug('SetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetSensorCompensation(self, UnitID) \
            -> RedoxServicer_pb2.GetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command GetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetSensorCompensation_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetSensorCompensation(parameter)
    
            logging.debug('GetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetControllerDB(self, UnitID, value) \
            -> RedoxServicer_pb2.SetControllerDB_Responses:
        """
        Wrapper to call the unobservable command SetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerDB': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetControllerDB_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetControllerDB(parameter)
    
            logging.debug('SetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerDB(self, UnitID) \
            -> RedoxServicer_pb2.GetControllerDB_Responses:
        """
        Wrapper to call the unobservable command GetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerDB_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerDB(parameter)
    
            logging.debug('GetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerOut(self, UnitID) \
            -> RedoxServicer_pb2.GetControllerOut_Responses:
        """
        Wrapper to call the unobservable command GetControllerOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerOut:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerOut_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerOut(parameter)
    
            logging.debug('GetControllerOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetControllerP(self, UnitID, value) \
            -> RedoxServicer_pb2.SetControllerP_Responses:
        """
        Wrapper to call the unobservable command SetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerP': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetControllerP_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetControllerP(parameter)
    
            logging.debug('SetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerP(self, UnitID) \
            -> RedoxServicer_pb2.GetControllerP_Responses:
        """
        Wrapper to call the unobservable command GetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerP_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerP(parameter)
    
            logging.debug('GetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetControllerTd(self, UnitID, value) \
            -> RedoxServicer_pb2.SetControllerTd_Responses:
        """
        Wrapper to call the unobservable command SetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTd': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetControllerTd_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetControllerTd(parameter)
    
            logging.debug('SetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerTd(self, UnitID) \
            -> RedoxServicer_pb2.GetControllerTd_Responses:
        """
        Wrapper to call the unobservable command GetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerTd_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerTd(parameter)
    
            logging.debug('GetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetControllerTi(self, UnitID, value) \
            -> RedoxServicer_pb2.SetControllerTi_Responses:
        """
        Wrapper to call the unobservable command SetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTi': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetControllerTi_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetControllerTi(parameter)
    
            logging.debug('SetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerTi(self,UnitID) \
            -> RedoxServicer_pb2.GetControllerTi_Responses:
        """
        Wrapper to call the unobservable command GetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerTi_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerTi(parameter)
    
            logging.debug('GetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetControllerMin(self, UnitID, value) \
            -> RedoxServicer_pb2.SetControllerMin_Responses:
        """
        Wrapper to call the unobservable command SetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMin': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetControllerMin_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetControllerMin(parameter)
    
            logging.debug('SetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerMin(self, UnitID) \
            -> RedoxServicer_pb2.GetControllerMin_Responses:
        """
        Wrapper to call the unobservable command GetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerMin_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerMin(parameter)
    
            logging.debug('GetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetControllerMax(self, UnitID, value) \
            -> RedoxServicer_pb2.SetControllerMax_Responses:
        """
        Wrapper to call the unobservable command SetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMax': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetControllerMax_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetControllerMax(parameter)
    
            logging.debug('SetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetControllerMax(self, UnitID) \
            -> RedoxServicer_pb2.GetControllerMax_Responses:
        """
        Wrapper to call the unobservable command GetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetControllerMax_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetControllerMax(parameter)
    
            logging.debug('GetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmEnabled(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command SetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmEnabled': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmEnabled_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmEnabled(parameter)
    
            logging.debug('SetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmEnabled(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command GetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmEnabled_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmEnabled(parameter)
    
            logging.debug('GetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmAlarmHigh(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmAlarmHigh(parameter)
    
            logging.debug('SetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmAlarmHigh(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmAlarmHigh(parameter)
    
            logging.debug('GetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmAlarmLow(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmAlarmLow_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmAlarmLow(parameter)
    
            logging.debug('SetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmAlarmLow(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmAlarmLow_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmAlarmLow(parameter)
    
            logging.debug('GetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmMode(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmMode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmMode_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmMode(parameter)
    
            logging.debug('SetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmMode(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmMode_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmMode(parameter)
    
            logging.debug('GetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmState(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmState_Responses:
        """
        Wrapper to call the unobservable command GetAlarmState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmState_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmState(parameter)
    
            logging.debug('GetAlarmState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmDelay(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command SetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmDelay': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmDelay_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmDelay(parameter)
    
            logging.debug('SetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmDelay(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command GetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmDelay_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmDelay(parameter)
    
            logging.debug('GetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmWarnHigh(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmWarnHigh_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmWarnHigh(parameter)
    
            logging.debug('SetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmWarnHigh(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmWarnHigh_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmWarnHigh(parameter)
    
            logging.debug('GetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_SetAlarmWarnLow(self, UnitID, value) \
            -> RedoxServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = RedoxServicer_pb2.SetAlarmWarnLow_Parameters(**par_dict)
            response = self.RedoxServicer_stub.SetAlarmWarnLow(parameter)
    
            logging.debug('SetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def RedoxServicer_GetAlarmWarnLow(self, UnitID) \
            -> RedoxServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = RedoxServicer_pb2.GetAlarmWarnLow_Parameters(**par_dict)
            response = self.RedoxServicer_stub.GetAlarmWarnLow(parameter)
    
            logging.debug('GetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetPV(self, UnitID) \
            -> TemperatureServicer_pb2.GetPV_Responses:
        """
        Wrapper to call the unobservable command GetPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPV:")

        #parameter = TemperatureServicer_pb2.GetPV_Parameters(
        #    UnitID=silaFW_pb2.Integer(value=unit)
        #parameter = TemperatureServicer_pb2.GetPV_Parameters(UnitID=silaFW_pb2.Integer(value=parameter))

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetPV_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetPV(parameter)
    
            logging.debug('GetPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetSPM(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetSPM_Responses:
        """
        Wrapper to call the unobservable command SetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPM': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = TemperatureServicer_pb2.SetSPM_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetSPM(parameter)
    
            logging.debug('SetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetSPE(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetSPE_Responses:
        """
        Wrapper to call the unobservable command SetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SPE': silaFW_pb2.Real(value=value)
        } 
        try:
            parameter = TemperatureServicer_pb2.SetSPE_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetSPE(parameter)
    
            logging.debug('SetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSP(self, UnitID) \
            -> TemperatureServicer_pb2.GetSP_Responses:
        """
        Wrapper to call the unobservable command GetSP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetSP_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetSP(parameter)
    
            logging.debug('GetSP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSPA(self, UnitID) \
            -> TemperatureServicer_pb2.GetSPA_Responses:
        """
        Wrapper to call the unobservable command GetSPA on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPA:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetSPA_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetSPA(parameter)
    
            logging.debug('GetSPA response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSPM(self, UnitID) \
            -> TemperatureServicer_pb2.GetSPM_Responses:
        """
        Wrapper to call the unobservable command GetSPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPM:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetSPM_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetSPM(parameter)
    
            logging.debug('GetSPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSPE(self, UnitID) \
            -> TemperatureServicer_pb2.GetSPE_Responses:
        """
        Wrapper to call the unobservable command GetSPE on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPE:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetSPE_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetSPE(parameter)
    
            logging.debug('GetSPE response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSPR(self, UnitID) \
            -> TemperatureServicer_pb2.GetSPR_Responses:
        """
        Wrapper to call the unobservable command GetSPR on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSPR:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetSPR_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetSPR(parameter)
    
            logging.debug('GetSPR response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAccess(self, UnitID) \
            -> TemperatureServicer_pb2.GetAccess_Responses:
        """
        Wrapper to call the unobservable command GetAccess on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAccess:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetAccess_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetAccess(parameter)
    
            logging.debug('GetAccess response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetCmd(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetCmd_Responses:
        """
        Wrapper to call the unobservable command SetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Cmd': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = TemperatureServicer_pb2.SetCmd_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetCmd(parameter)
    
            logging.debug('SetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetCmd(self, UnitID) \
            -> TemperatureServicer_pb2.GetCmd_Responses:
        """
        Wrapper to call the unobservable command GetCmd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCmd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetCmd_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetCmd(parameter)
    
            logging.debug('GetCmd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetMode(self,UnitID, value) \
            -> TemperatureServicer_pb2.SetMode_Responses:
        """
        Wrapper to call the unobservable command SetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'Mode': silaFW_pb2.Integer(value=value)
        } 
        try:
            parameter = TemperatureServicer_pb2.SetMode_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetMode(parameter)
    
            logging.debug('SetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetMode(self, UnitID) \
            -> TemperatureServicer_pb2.GetMode_Responses:
        """
        Wrapper to call the unobservable command GetMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
        } 
        try:
            parameter = TemperatureServicer_pb2.GetMode_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetMode(parameter)
    
            logging.debug('GetMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetSetpointSelect(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command SetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SetpointSelect': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetSetpointSelect_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetSetpointSelect(parameter)
    
            logging.debug('SetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def TemperatureServicer_GetSetpointSelect(self, UnitID) \
            -> TemperatureServicer_pb2.GetSetpointSelect_Responses:
        """
        Wrapper to call the unobservable command GetSetpointSelect on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointSelect:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetSetpointSelect_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetSetpointSelect(parameter)
    
            logging.debug('GetSetpointSelect response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetState(self, UnitID) \
            -> TemperatureServicer_pb2.GetState_Responses:
        """
        Wrapper to call the unobservable command GetState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetState_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetState(parameter)
    
            logging.debug('GetState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetType(self, UnitID) \
            -> TemperatureServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetType_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAvailable(self, UnitID) \
            -> TemperatureServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAvailable_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetName(self, UnitID) \
            -> TemperatureServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetName_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetVersion(self, UnitID) \
            -> TemperatureServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetVersion_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetSensorOffset(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command SetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorOffset': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetSensorOffset_Parameters(**par_dict)    
            response = self.TemperatureServicer_stub.SetSensorOffset(parameter)
    
            logging.debug('SetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSensorOffset(self, UnitID) \
            -> TemperatureServicer_pb2.GetSensorOffset_Responses:
        """
        Wrapper to call the unobservable command GetSensorOffset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorOffset:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetSensorOffset_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetSensorOffset(parameter)
    
            logging.debug('GetSensorOffset response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSensorPVRaw(self, UnitID) \
            -> TemperatureServicer_pb2.GetSensorPVRaw_Responses:
        """
        Wrapper to call the unobservable command GetSensorPVRaw on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorPVRaw:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetSensorPVRaw_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetSensorPVRaw(parameter)
    
            logging.debug('GetSensorPVRaw response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetSensorSlope(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command SetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorSlope:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorSlope': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetSensorSlope_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetSensorSlope(parameter)
    
            logging.debug('SetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSensorSlope(self, UnitID) \
            -> TemperatureServicer_pb2.GetSensorSlope_Responses:
        """
        Wrapper to call the unobservable command GetSensorSlope on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorSlope:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetSensorSlope_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetSensorSlope(parameter)
    
            logging.debug('GetSensorSlope response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetSensorCompensation(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command SetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'SensorCompensation': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetSensorCompensation_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetSensorCompensation(parameter)
    
            logging.debug('SetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetSensorCompensation(self, UnitID) \
            -> TemperatureServicer_pb2.GetSensorCompensation_Responses:
        """
        Wrapper to call the unobservable command GetSensorCompensation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorCompensation:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetSensorCompensation_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetSensorCompensation(parameter)
    
            logging.debug('GetSensorCompensation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetControllerDB(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetControllerDB_Responses:
        """
        Wrapper to call the unobservable command SetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerDB': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetControllerDB_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetControllerDB(parameter)
    
            logging.debug('SetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerDB(self, UnitID) \
            -> TemperatureServicer_pb2.GetControllerDB_Responses:
        """
        Wrapper to call the unobservable command GetControllerDB on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerDB:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerDB_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerDB(parameter)
    
            logging.debug('GetControllerDB response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerOut(self, UnitID) \
            -> TemperatureServicer_pb2.GetControllerOut_Responses:
        """
        Wrapper to call the unobservable command GetControllerOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerOut:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerOut_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerOut(parameter)
    
            logging.debug('GetControllerOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetControllerP(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetControllerP_Responses:
        """
        Wrapper to call the unobservable command SetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerP': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetControllerP_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetControllerP(parameter)
    
            logging.debug('SetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerP(self, UnitID) \
            -> TemperatureServicer_pb2.GetControllerP_Responses:
        """
        Wrapper to call the unobservable command GetControllerP on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerP:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerP_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerP(parameter)
    
            logging.debug('GetControllerP response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetControllerTd(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetControllerTd_Responses:
        """
        Wrapper to call the unobservable command SetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTd': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetControllerTd_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetControllerTd(parameter)
    
            logging.debug('SetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerTd(self, UnitID) \
            -> TemperatureServicer_pb2.GetControllerTd_Responses:
        """
        Wrapper to call the unobservable command GetControllerTd on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTd:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerTd_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerTd(parameter)
    
            logging.debug('GetControllerTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetControllerTi(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetControllerTi_Responses:
        """
        Wrapper to call the unobservable command SetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerTi': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetControllerTi_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetControllerTi(parameter)
    
            logging.debug('SetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerTi(self,UnitID) \
            -> TemperatureServicer_pb2.GetControllerTi_Responses:
        """
        Wrapper to call the unobservable command GetControllerTi on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerTi:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerTi_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerTi(parameter)
    
            logging.debug('GetControllerTi response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetControllerMin(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetControllerMin_Responses:
        """
        Wrapper to call the unobservable command SetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMin': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetControllerMin_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetControllerMin(parameter)
    
            logging.debug('SetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerMin(self, UnitID) \
            -> TemperatureServicer_pb2.GetControllerMin_Responses:
        """
        Wrapper to call the unobservable command GetControllerMin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMin:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerMin_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerMin(parameter)
    
            logging.debug('GetControllerMin response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetControllerMax(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetControllerMax_Responses:
        """
        Wrapper to call the unobservable command SetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'ControllerMax': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetControllerMax_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetControllerMax(parameter)
    
            logging.debug('SetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetControllerMax(self, UnitID) \
            -> TemperatureServicer_pb2.GetControllerMax_Responses:
        """
        Wrapper to call the unobservable command GetControllerMax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControllerMax:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetControllerMax_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetControllerMax(parameter)
    
            logging.debug('GetControllerMax response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmEnabled(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command SetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmEnabled': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmEnabled_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmEnabled(parameter)
    
            logging.debug('SetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmEnabled(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmEnabled_Responses:
        """
        Wrapper to call the unobservable command GetAlarmEnabled on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmEnabled:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmEnabled_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmEnabled(parameter)
    
            logging.debug('GetAlarmEnabled response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmAlarmHigh(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmAlarmHigh(parameter)
    
            logging.debug('SetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmAlarmHigh(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmAlarmHigh_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmAlarmHigh(parameter)
    
            logging.debug('GetAlarmAlarmHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmAlarmLow(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmAlarmLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmAlarmLow_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmAlarmLow(parameter)
    
            logging.debug('SetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmAlarmLow(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmAlarmLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmAlarmLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmAlarmLow_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmAlarmLow(parameter)
    
            logging.debug('GetAlarmAlarmLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmMode(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmMode': silaFW_pb2.Integer(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmMode_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmMode(parameter)
    
            logging.debug('SetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmMode(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmMode:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmMode_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmMode(parameter)
    
            logging.debug('GetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmState(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmState_Responses:
        """
        Wrapper to call the unobservable command GetAlarmState on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmState:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmState_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmState(parameter)
    
            logging.debug('GetAlarmState response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmDelay(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command SetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmDelay': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmDelay_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmDelay(parameter)
    
            logging.debug('SetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmDelay(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmDelay_Responses:
        """
        Wrapper to call the unobservable command GetAlarmDelay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmDelay:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmDelay_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmDelay(parameter)
    
            logging.debug('GetAlarmDelay response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmWarnHigh(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnHigh': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmWarnHigh_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmWarnHigh(parameter)
    
            logging.debug('SetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmWarnHigh(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnHigh:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmWarnHigh_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmWarnHigh(parameter)
    
            logging.debug('GetAlarmWarnHigh response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_SetAlarmWarnLow(self, UnitID, value) \
            -> TemperatureServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command SetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID),
            'AlarmWarnLow': silaFW_pb2.Real(value=value)
            } 

        try:
            parameter = TemperatureServicer_pb2.SetAlarmWarnLow_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.SetAlarmWarnLow(parameter)
    
            logging.debug('SetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureServicer_GetAlarmWarnLow(self, UnitID) \
            -> TemperatureServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Wrapper to call the unobservable command GetAlarmWarnLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmWarnLow:")

        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TemperatureServicer_pb2.GetAlarmWarnLow_Parameters(**par_dict)
            response = self.TemperatureServicer_stub.GetAlarmWarnLow(parameter)
    
            logging.debug('GetAlarmWarnLow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TurbidityServicer_GetAUPV(self, UnitID) \
            -> TurbidityServicer_pb2.GetAUPV_Responses:
        """
        Wrapper to call the unobservable command GetAUPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAUPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TurbidityServicer_pb2.GetAUPV_Parameters(**par_dict)
            response = self.TurbidityServicer_stub.GetAUPV(parameter)
    
            logging.debug('GetAUPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TurbidityServicer_GetCXPV(self, UnitID) \
            -> TurbidityServicer_pb2.GetCXPV_Responses:
        """
        Wrapper to call the unobservable command GetCXPV on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCXPV:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TurbidityServicer_pb2.GetCXPV_Parameters(**par_dict)
            response = self.TurbidityServicer_stub.GetCXPV(parameter)
    
            logging.debug('GetCXPV response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TurbidityServicer_GetType(self, UnitID) \
            -> TurbidityServicer_pb2.GetType_Responses:
        """
        Wrapper to call the unobservable command GetType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetType:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TurbidityServicer_pb2.GetType_Parameters(**par_dict)
            response = self.TurbidityServicer_stub.GetType(parameter)
    
            logging.debug('GetType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TurbidityServicer_GetAvailable(self, UnitID) \
            -> TurbidityServicer_pb2.GetAvailable_Responses:
        """
        Wrapper to call the unobservable command GetAvailable on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAvailable:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TurbidityServicer_pb2.GetAvailable_Parameters(**par_dict)
            response = self.TurbidityServicer_stub.GetAvailable(parameter)
    
            logging.debug('GetAvailable response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TurbidityServicer_GetName(self, UnitID) \
            -> TurbidityServicer_pb2.GetName_Responses:
        """
        Wrapper to call the unobservable command GetName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetName:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TurbidityServicer_pb2.GetName_Parameters(**par_dict)
            response = self.TurbidityServicer_stub.GetName(parameter)
    
            logging.debug('GetName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TurbidityServicer_GetVersion(self, UnitID) \
            -> TurbidityServicer_pb2.GetVersion_Responses:
        """
        Wrapper to call the unobservable command GetVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVersion:")
        par_dict = {
            'UnitID': silaFW_pb2.Integer(value=UnitID)
            } 

        try:
            parameter = TurbidityServicer_pb2.GetVersion_Parameters(**par_dict)
            response = self.TurbidityServicer_stub.GetVersion(parameter)
    
            logging.debug('GetVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    def Subscribe_DeviceServicer_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceServicer_stub.Subscribe_CurrentStatus(
                DeviceServicer_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call):
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: DASGIP_Service")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = DASGIP_ServiceClient(server_ip='127.0.0.1', server_port=50005)
    sila_client.run()
    sila_client.TurbidityServicer_GetVersion(UnitID=1)
    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
