#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*DASGIP_Service*

:details: DASGIP_Service:
    This is a DASGIP Service
           
:file:    DASGIP_Service_server.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:15.324232
:date: (last modification) 2020-04-16T10:19:15.324232

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "0.0.1"

import os
import sys
import logging
import argparse

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer.gRPC import AgitationServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.DOServicer.gRPC import DOServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.GassingServicer.gRPC import GassingServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer.gRPC import IlluminationServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.LevelServicer.gRPC import LevelServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer.gRPC import OffgasServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer.gRPC import OverlayServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.PHServicer.gRPC import PHServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.PressureServicer.gRPC import PressureServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer.gRPC import PumpAServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer.gRPC import PumpBServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer.gRPC import PumpCServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer.gRPC import PumpDServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer.gRPC import ReactorServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer.gRPC import RedoxServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer.gRPC import TemperatureServicer_pb2_grpc
from sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer.gRPC import TurbidityServicer_pb2_grpc

# Import the servicer modules for each feature
from sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer.AgitationServicer_servicer import AgitationServicer
from sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer.DeviceServicer_servicer import DeviceServicer
from sila2lib_implementations.DASGIP.DASGIPService.DOServicer.DOServicer_servicer import DOServicer
from sila2lib_implementations.DASGIP.DASGIPService.GassingServicer.GassingServicer_servicer import GassingServicer
from sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer.IlluminationServicer_servicer import IlluminationServicer
from sila2lib_implementations.DASGIP.DASGIPService.LevelServicer.LevelServicer_servicer import LevelServicer
from sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer.OffgasServicer_servicer import OffgasServicer
from sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer.OverlayServicer_servicer import OverlayServicer
from sila2lib_implementations.DASGIP.DASGIPService.PHServicer.PHServicer_servicer import PHServicer
from sila2lib_implementations.DASGIP.DASGIPService.PressureServicer.PressureServicer_servicer import PressureServicer
from sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer.PumpAServicer_servicer import PumpAServicer
from sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer.PumpBServicer_servicer import PumpBServicer
from sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer.PumpCServicer_servicer import PumpCServicer
from sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer.PumpDServicer_servicer import PumpDServicer
from sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer.ReactorServicer_servicer import ReactorServicer
from sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer.RedoxServicer_servicer import RedoxServicer
from sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer.TemperatureServicer_servicer import TemperatureServicer
from sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer.TurbidityServicer_servicer import TurbidityServicer

# Insert this command into the respective implementation of the SiLA server at ....Servicer_Real.py
from sila2lib_implementations.DASGIP.DASGIPService.OpcuaClient import client_DASGIP_UA as opc_client


class DASGIP_ServiceServer(SiLA2Server):
    """
    This is a DASGIP Service
    """
    def __init__(self, cmd_args, ip: str = '127.0.0.1', port: int = 50004, simulation_mode: bool = False):
        """Class initializer"""
        super().__init__(
            name=cmd_args.server_name, description=cmd_args.description,
            server_type=cmd_args.server_type, server_uuid=None,
            version=__version__,
            vendor_url="L.Bromig@lrz.tum.de",
            ip=ip, port=port,
            key_file=cmd_args.encryption_key, cert_file=cmd_args.encryption_cert,
            simulation_mode=simulation_mode
            # key_file=None, cert_file=None
        )

        logging.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=cmd_args.server_name
            )
        )
        self.simulation_mode = simulation_mode
        self.number_units = 4
        self.reactors = []

        for i in range(1, self.number_units+1, 1):
            vars()["unit_ID%s" % i] = i
            print("Initializing: Unit%s..."%vars()["unit_ID%s" % i])
            vars(self)["reactor_%s" % i] = opc_client.clientDASGIP(unit_ID = vars()["unit_ID%s" % i])
            print(vars(self)["reactor_%s" % i],"Initialized")
            self.reactors.append(vars(self)["reactor_%s" % i])

        def connectUnits(self): 
            for i, reactor in enumerate(self.reactors):
                print("___________________________Starting Unit%s___________________________" % (i+1))
                reactor.run()
                print("___________________________Started Unit%s___________________________" % (i+1))

        def disconnectUnits(self):
            for i, reactor in enumerate(self.reactors):
                print("___________________________Disconnecting Unit%s___________________________" % (i+1))
                reactor.close()
                print("___________________________Disconnected Unit%s___________________________" % (i+1))

        if not self.simulation_mode:
            connectUnits(self)

        """ Class initialiser """


        # registering features
        #  Register AgitationServicer
        self.AgitationServicer_servicer = AgitationServicer(self.reactors, simulation_mode=simulation_mode)
        AgitationServicer_pb2_grpc.add_AgitationServicerServicer_to_server(
            self.AgitationServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='AgitationServicer',
                         servicer=self.AgitationServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )

        #  Register DeviceServicer
        self.DeviceServicer_servicer = DeviceServicer(self.reactors, simulation_mode=simulation_mode)
        DeviceServicer_pb2_grpc.add_DeviceServicerServicer_to_server(
            self.DeviceServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceServicer',
                         servicer=self.DeviceServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register DOServicer
        self.DOServicer_servicer = DOServicer(self.reactors, simulation_mode=simulation_mode)
        DOServicer_pb2_grpc.add_DOServicerServicer_to_server(
            self.DOServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DOServicer',
                         servicer=self.DOServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register GassingServicer
        self.GassingServicer_servicer = GassingServicer(self.reactors, simulation_mode=simulation_mode)
        GassingServicer_pb2_grpc.add_GassingServicerServicer_to_server(
            self.GassingServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='GassingServicer',
                         servicer=self.GassingServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register IlluminationServicer
        self.IlluminationServicer_servicer = IlluminationServicer(self.reactors, simulation_mode=simulation_mode)
        IlluminationServicer_pb2_grpc.add_IlluminationServicerServicer_to_server(
            self.IlluminationServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='IlluminationServicer',
                         servicer=self.IlluminationServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register LevelServicer
        self.LevelServicer_servicer = LevelServicer(self.reactors, simulation_mode=simulation_mode)
        LevelServicer_pb2_grpc.add_LevelServicerServicer_to_server(
            self.LevelServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='LevelServicer',
                         servicer=self.LevelServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register OffgasServicer
        self.OffgasServicer_servicer = OffgasServicer(self.reactors, simulation_mode=simulation_mode)
        OffgasServicer_pb2_grpc.add_OffgasServicerServicer_to_server(
            self.OffgasServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='OffgasServicer',
                         servicer=self.OffgasServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register OverlayServicer
        self.OverlayServicer_servicer = OverlayServicer(self.reactors, simulation_mode=simulation_mode)
        OverlayServicer_pb2_grpc.add_OverlayServicerServicer_to_server(
            self.OverlayServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='OverlayServicer',
                         servicer=self.OverlayServicer_servicer,
                         data_path='meta')
        #  Register PHServicer
        self.PHServicer_servicer = PHServicer(self.reactors, simulation_mode=simulation_mode)
        PHServicer_pb2_grpc.add_PHServicerServicer_to_server(
            self.PHServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='PHServicer',
                         servicer=self.PHServicer_servicer,
                         data_path='meta')
        #  Register PressureServicer
        self.PressureServicer_servicer = PressureServicer(self.reactors, simulation_mode=simulation_mode)
        PressureServicer_pb2_grpc.add_PressureServicerServicer_to_server(
            self.PressureServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='PressureServicer',
                         servicer=self.PressureServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register PumpAServicer
        self.PumpAServicer_servicer = PumpAServicer(self.reactors, simulation_mode=simulation_mode)
        PumpAServicer_pb2_grpc.add_PumpAServicerServicer_to_server(
            self.PumpAServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='PumpAServicer',
                         servicer=self.PumpAServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register PumpBServicer
        self.PumpBServicer_servicer = PumpBServicer(self.reactors, simulation_mode=simulation_mode)
        PumpBServicer_pb2_grpc.add_PumpBServicerServicer_to_server(
            self.PumpBServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='PumpBServicer',
                         servicer=self.PumpBServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register PumpCServicer
        self.PumpCServicer_servicer = PumpCServicer(self.reactors, simulation_mode=simulation_mode)
        PumpCServicer_pb2_grpc.add_PumpCServicerServicer_to_server(
            self.PumpCServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='PumpCServicer',
                         servicer=self.PumpCServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register PumpDServicer
        self.PumpDServicer_servicer = PumpDServicer(self.reactors, simulation_mode=simulation_mode)
        PumpDServicer_pb2_grpc.add_PumpDServicerServicer_to_server(
            self.PumpDServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='PumpDServicer',
                         servicer=self.PumpDServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register ReactorServicer
        self.ReactorServicer_servicer = ReactorServicer(self.reactors, simulation_mode=simulation_mode)
        ReactorServicer_pb2_grpc.add_ReactorServicerServicer_to_server(
            self.ReactorServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='ReactorServicer',
                         servicer=self.ReactorServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register RedoxServicer
        self.RedoxServicer_servicer = RedoxServicer(self.reactors, simulation_mode=simulation_mode)
        RedoxServicer_pb2_grpc.add_RedoxServicerServicer_to_server(
            self.RedoxServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='RedoxServicer',
                         servicer=self.RedoxServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register TemperatureServicer
        self.TemperatureServicer_servicer = TemperatureServicer(self.reactors, simulation_mode=simulation_mode)
        TemperatureServicer_pb2_grpc.add_TemperatureServicerServicer_to_server(
            self.TemperatureServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='TemperatureServicer',
                         servicer=self.TemperatureServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register TurbidityServicer
        self.TurbidityServicer_servicer = TurbidityServicer(self.reactors, simulation_mode=simulation_mode)
        TurbidityServicer_pb2_grpc.add_TurbidityServicerServicer_to_server(
            self.TurbidityServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='TurbidityServicer',
                         servicer=self.TurbidityServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )

        self.simulation_mode = simulation_mode

        # starting and running the gRPC/SiLA2 server
        self.run()
        if not self.simulation_mode:
            disconnectUnits(self)
        
    def switchToSimMode(self):
        """Switch to simulation mode of the server"""

        # perform implementation specific switch operations
        self.AgitationServicer_servicer.switch_to_simulation_mode()
        self.DeviceServicer_servicer.switch_to_simulation_mode()
        self.DOServicer_servicer.switch_to_simulation_mode()
        self.GassingServicer_servicer.switch_to_simulation_mode()
        self.IlluminationServicer_servicer.switch_to_simulation_mode()
        self.LevelServicer_servicer.switch_to_simulation_mode()
        self.OffgasServicer_servicer.switch_to_simulation_mode()
        self.OverlayServicer_servicer.switch_to_simulation_mode()
        self.PHServicer_servicer.switch_to_simulation_mode()
        self.PressureServicer_servicer.switch_to_simulation_mode()
        self.PumpAServicer_servicer.switch_to_simulation_mode()
        self.PumpBServicer_servicer.switch_to_simulation_mode()
        self.PumpCServicer_servicer.switch_to_simulation_mode()
        self.PumpDServicer_servicer.switch_to_simulation_mode()
        self.ReactorServicer_servicer.switch_to_simulation_mode()
        self.RedoxServicer_servicer.switch_to_simulation_mode()
        self.TemperatureServicer_servicer.switch_to_simulation_mode()
        self.TurbidityServicer_servicer.switch_to_simulation_mode()

        self.simulation_mode = True

    def switchToRealMode(self):
        """Switch to real mode"""

        # perform implementation specific switch operations
        self.AgitationServicer_servicer.switch_to_real_mode()
        self.DeviceServicer_servicer.switch_to_real_mode()
        self.DOServicer_servicer.switch_to_real_mode()
        self.GassingServicer_servicer.switch_to_real_mode()
        self.IlluminationServicer_servicer.switch_to_real_mode()
        self.LevelServicer_servicer.switch_to_real_mode()
        self.OffgasServicer_servicer.switch_to_real_mode()
        self.OverlayServicer_servicer.switch_to_real_mode()
        self.PHServicer_servicer.switch_to_real_mode()
        self.PressureServicer_servicer.switch_to_real_mode()
        self.PumpAServicer_servicer.switch_to_real_mode()
        self.PumpBServicer_servicer.switch_to_real_mode()
        self.PumpCServicer_servicer.switch_to_real_mode()
        self.PumpDServicer_servicer.switch_to_real_mode()
        self.ReactorServicer_servicer.switch_to_real_mode()
        self.RedoxServicer_servicer.switch_to_real_mode()
        self.TemperatureServicer_servicer.switch_to_real_mode()
        self.TurbidityServicer_servicer.switch_to_real_mode()

        self.simulation_mode = False


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: DASGIP_Service")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="DASGIP_Service", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a DASGIP Service", help='SiLA server description')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args
    

def init():
    if __name__ == '__main__':
        # or use logging.ERROR for less output
        logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

        args = parse_command_line()

        # generate SiLA2Server
        sila_server = DASGIP_ServiceServer(cmd_args=args, ip='127.0.0.1', port=50004, simulation_mode=True)
        sys.exit(sila_server.run())


init()
