"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Gassing Servicer*

:details: GassingServicer:
    Control a DASGIP gassing module. Enables read and write operations for various parameters.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    GassingServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:13.853361
:date: (last modification) 2020-04-16T10:19:13.853361

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import GassingServicer_pb2 as GassingServicer_pb2
# from .gRPC import GassingServicer_pb2_grpc as GassingServicer_pb2_grpc

# import default arguments
from .GassingServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class GassingServicerSimulation:
    """
    Implementation of the *Gassing Servicer* in *Simulation* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetPV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetPV_Responses:
        """
        Executes the unobservable command "Get PV"
            Get present value. Gassing total flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPV (Current PV): Current present value. Gassing total flow process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentPV = 0.0
        return_value = GassingServicer_pb2.GetPV_Responses(CurrentPV=silaFW_pb2.Real(value=CurrentPV))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetPV_Responses(
                **default_dict['GetPV_Responses']
            )
    
        return return_value
    
    
    def GetSP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetSP_Responses:
        """
        Executes the unobservable command "Get SP"
            Get setpoint value. Gassing total flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSP (Current SP): Current setpoint value. Gassing total flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentSP = 0.0
        return_value = GassingServicer_pb2.GetSP_Responses(CurrentSP=silaFW_pb2.Real(value=CurrentSP))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetSP_Responses(
                **default_dict['GetSP_Responses']
            )
    
        return return_value
    
    
    def GetFPV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFPV_Responses:
        """
        Executes the unobservable command "Get F PV"
            Get present value. Gassing total flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFPV (Current F PV): Current present value. Gassing total flow process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentFPV = 0.0
        return_value = GassingServicer_pb2.GetFPV_Responses(CurrentFPV=silaFW_pb2.Real(value=CurrentFPV))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFPV_Responses(
                **default_dict['GetFPV_Responses']
            )
    
        return return_value
    
    
    def GetVPV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetVPV_Responses:
        """
        Executes the unobservable command "Get V PV"
            Get present value. Gassing total volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVPV (Current V PV): Current present value. Gassing total volume process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentVPV = 0.0
        return_value = GassingServicer_pb2.GetVPV_Responses(CurrentVPV=silaFW_pb2.Real(value=CurrentVPV))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetVPV_Responses(
                **default_dict['GetVPV_Responses']
            )
    
        return return_value
    
    
    def GetFSP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSP_Responses:
        """
        Executes the unobservable command "Get Flow SP"
            Get gassing total flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSP (Current Flow SP): Current gassing total flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFSP = 0.0
        return_value = GassingServicer_pb2.GetFSP_Responses(CurrentFSP=silaFW_pb2.Real(value=CurrentFSP))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSP_Responses(
                **default_dict['GetFSP_Responses']
            )
    
        return return_value
    
    
    def SetFSPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFSPM_Responses:
        """
        Executes the unobservable command "Set Flow SPM"
            Set gassing total flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FSPM (Flow Setpoint Manual):
            The gassing total flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FSPMSet (Flow Setpoint Manual Set): The set manual gassing total flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FSPMSet = 0.0
        return_value = GassingServicer_pb2.SetFSPM_Responses(FSPMSet=silaFW_pb2.Real(value=FSPMSet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFSPM_Responses(
                **default_dict['SetFSPM_Responses']
            )
    
        return return_value
    
    
    def GetFSPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSPM_Responses:
        """
        Executes the unobservable command "Get Flow SP Manual"
            Get gassing total flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPM (Current Flow SP Manual): Current gassing total flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFSPM = 0.0
        return_value = GassingServicer_pb2.GetFSPM_Responses(CurrentFSPM=silaFW_pb2.Real(value=CurrentFSPM))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSPM_Responses(
                **default_dict['GetFSPM_Responses']
            )
    
        return return_value
    
    
    def SetFSPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFSPE_Responses:
        """
        Executes the unobservable command "Set Flow SPE"
            Set gassing total flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FSPE (Flow Setpoint External):
            The gassing total flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FSPESet (Flow Setpoint External Set): The set external gassing total flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FSPESet = 0.0
        return_value = GassingServicer_pb2.SetFSPE_Responses(FSPESet=silaFW_pb2.Real(value=FSPESet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFSPE_Responses(
                **default_dict['SetFSPE_Responses']
            )
    
        return return_value
    
    
    def GetFSPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSPE_Responses:
        """
        Executes the unobservable command "Get Flow SP External"
            Get gassing total flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPE (Current Flow SP External): Current gassing total flow external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFSPE = 0.0
        return_value = GassingServicer_pb2.GetFSPE_Responses(CurrentFSPE=silaFW_pb2.Real(value=CurrentFSPE))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSPE_Responses(
                **default_dict['GetFSPE_Responses']
            )
    
        return return_value
    
    
    def GetFSPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSPA_Responses:
        """
        Executes the unobservable command "Get Flow SP Automatic"
            Get gassing total flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPA (Current Flow SP Automatic): Current gassing total flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFSPA = 0.0
        return_value = GassingServicer_pb2.GetFSPA_Responses(CurrentFSPA=silaFW_pb2.Real(value=CurrentFSPA))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSPA_Responses(
                **default_dict['GetFSPA_Responses']
            )
    
        return return_value
    
    
    def GetFSPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSPR_Responses:
        """
        Executes the unobservable command "Get Flow SP Remote"
            Get gassing total flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPR (Current Flow SP Remote): Current gassing total flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFSPR = 0.0
        return_value = GassingServicer_pb2.GetFSPR_Responses(CurrentFSPR=silaFW_pb2.Real(value=CurrentFSPR))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSPR_Responses(
                **default_dict['GetFSPR_Responses']
            )
    
        return return_value
    
    
    def GetFSPL(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSPL_Responses:
        """
        Executes the unobservable command "Get Flow SP Local"
            Get gassing total flow local setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPL (Current Flow SP Local): Current gassing total flow local setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFSPL = 0.0
        return_value = GassingServicer_pb2.GetFSPL_Responses(CurrentFSPL=silaFW_pb2.Real(value=CurrentFSPL))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSPL_Responses(
                **default_dict['GetFSPL_Responses']
            )
    
        return return_value
    
    
    def SetFMode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFMode_Responses:
        """
        Executes the unobservable command "Set Flow Mode"
            Set gas total flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FMode (Flow Mode):
            Set gas total flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FModeSet (Flow Mode Set): The set gas total flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        FModeSet = 1
        return_value = GassingServicer_pb2.SetFMode_Responses(FModeSet=silaFW_pb2.Integer(value=FModeSet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFMode_Responses(
                **default_dict['SetFMode_Responses']
            )
    
        return return_value
    
    
    def GetFMode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFMode_Responses:
        """
        Executes the unobservable command "Get Flow Mode"
            Get gas total flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFMode (Current Flow Mode): Current gas total flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentFMode = 1
        return_value = GassingServicer_pb2.GetFMode_Responses(CurrentFMode=silaFW_pb2.Integer(value=CurrentFMode))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFMode_Responses(
                **default_dict['GetFMode_Responses']
            )
    
        return return_value
    
    
    def SetFSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFSetpointSelect_Responses:
        """
        Executes the unobservable command "Set Flow SetpointSelect"
            Set gas total flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FSetpointSelect (Flow SetpointSelect):
            Set gas total flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FSetpointSelectSet (Flow SetpointSelect Set): The set gas total flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        FSetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetFSetpointSelect_Responses(FSetpointSelectSet=silaFW_pb2.Integer(value=FSetpointSelectSet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFSetpointSelect_Responses(
                **default_dict['SetFSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFSetpointSelect_Responses:
        """
        Executes the unobservable command "Get Flow SetpointSelect"
            Get gas total flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSetpointSelect (Current Flow SetpointSelect): Current gas total flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentFSetpointSelect = 2
        return_value = GassingServicer_pb2.GetFSetpointSelect_Responses(CurrentFSetpointSelect=silaFW_pb2.Integer(value=CurrentFSetpointSelect))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFSetpointSelect_Responses(
                **default_dict['GetFSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetXCO2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2PV_Responses:
        """
        Executes the unobservable command "Get XCO2 PV"
            Get present value. Gassing XCO2 concentration process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2PV (Current XCO2 PV): Current present value. Gassing XCO2 concentration process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2PV = 0.0
        return_value = GassingServicer_pb2.GetXCO2PV_Responses(CurrentXCO2PV=silaFW_pb2.Real(value=CurrentXCO2PV))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2PV_Responses(
                **default_dict['GetXCO2PV_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SP_Responses:
        """
        Executes the unobservable command "Get XCO2 SP"
            Get gassing XCO2 concentration setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SP (Current XCO2 SP): Current gassing XCO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SP = 0.0
        return_value = GassingServicer_pb2.GetXCO2SP_Responses(CurrentXCO2SP=silaFW_pb2.Real(value=CurrentXCO2SP))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SP_Responses(
                **default_dict['GetXCO2SP_Responses']
            )
    
        return return_value
    
    
    def SetXCO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXCO2SPM_Responses:
        """
        Executes the unobservable command "Set XCO2 SPM"
            Set gassing XCO2 concentration setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XCO2SPM (XCO2 Setpoint Manual):
            The gassing XCO2 concentration setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2SPMSet (XCO2 Setpoint Manual Set): The set manual gassing XCO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None

        XCO2SPMSet = 0.0
        return_value = GassingServicer_pb2.SetXCO2SPM_Responses(XCO2SPMSet=silaFW_pb2.Real(value=XCO2SPMSet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXCO2SPM_Responses(
                **default_dict['SetXCO2SPM_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SPM_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Manual"
            Get gassing XCO2 concentration manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPM (Current XCO2 SP Manual): Current gassing XCO2 concentration manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SPM = 0.0
        return_value = GassingServicer_pb2.GetXCO2SPM_Responses(CurrentXCO2SPM=silaFW_pb2.Real(value=CurrentXCO2SPM))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SPM_Responses(
                **default_dict['GetXCO2SPM_Responses']
            )
    
        return return_value
    
    
    def SetXCO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXCO2SPE_Responses:
        """
        Executes the unobservable command "Set XCO2 SPE"
            Set gassing XCO2 concentration setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XCO2SPE (XCO2 Setpoint External):
            The gassing XCO2 concentration setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2SPESet (XCO2 Setpoint External Set): The set external gassing XCO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None

        XCO2SPESet = 0.0
        return_value = GassingServicer_pb2.SetXCO2SPE_Responses(XCO2SPESet=silaFW_pb2.Real(value=XCO2SPESet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXCO2SPE_Responses(
                **default_dict['SetXCO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SPE_Responses:
        """
        Executes the unobservable command "Get XCO2 SP External"
            Get gassing XCO2 concentration external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPE (Current XCO2 SP External): Current gassing XCO2 concentration external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SPE = 0.0
        return_value = GassingServicer_pb2.GetXCO2SPE_Responses(CurrentXCO2SPE=silaFW_pb2.Real(value=CurrentXCO2SPE))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SPE_Responses(
                **default_dict['GetXCO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SPA_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Automatic"
            Get gassing XCO2 concentration automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPA (Current XCO2 SP Automatic): Current gassing XCO2 concentration automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SPA = 0.0
        return_value = GassingServicer_pb2.GetXCO2SPA_Responses(CurrentXCO2SPA=silaFW_pb2.Real(value=CurrentXCO2SPA))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SPA_Responses(
                **default_dict['GetXCO2SPA_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SPR_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Remote"
            Get gassing XCO2 concentration remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPR (Current XCO2 SP Remote): Current gassing XCO2 concentration remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SPR = 0.0
        return_value = GassingServicer_pb2.GetXCO2SPR_Responses(CurrentXCO2SPR=silaFW_pb2.Real(value=CurrentXCO2SPR))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SPR_Responses(
                **default_dict['GetXCO2SPR_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SPL(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SPL_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Local"
            Get gassing XCO2 concentration local setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPL (Current XCO2 SP Local): Current gassing XCO2 concentration local setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SPL = 0.0
        return_value = GassingServicer_pb2.GetXCO2SPL_Responses(CurrentXCO2SPL=silaFW_pb2.Real(value=CurrentXCO2SPL))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SPL_Responses(
                **default_dict['GetXCO2SPL_Responses']
            )
    
        return return_value
    
    
    def SetXCO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXCO2Mode_Responses:
        """
        Executes the unobservable command "Set XCO2 Mode"
            Set gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XCO2Mode (XCO2 Mode):
            Set gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2ModeSet (XCO2 Mode Set): The set gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        XCO2ModeSet = 1
        return_value = GassingServicer_pb2.SetXCO2Mode_Responses(XCO2ModeSet=silaFW_pb2.Integer(value=XCO2ModeSet))
    
        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXCO2Mode_Responses(
                **default_dict['SetXCO2Mode_Responses']
            )
    
        return return_value
    
    
    def GetXCO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2Mode_Responses:
        """
        Executes the unobservable command "Get XCO2 Mode"
            Get gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2Mode (Current XCO2 Mode): Current gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2Mode = 1
        return_value = GassingServicer_pb2.GetXCO2Mode_Responses(CurrentXCO2Mode=silaFW_pb2.Integer(value=CurrentXCO2Mode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2Mode_Responses(
                **default_dict['GetXCO2Mode_Responses']
            )
    
        return return_value
    
    
    def SetXCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set XCO2 SetpointSelect"
            Set gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XCO2SetpointSelect (XCO2 SetpointSelect):
            Set gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2SetpointSelectSet (XCO2 SetpointSelect Set): The set gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        XCO2SetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetXCO2SetpointSelect_Responses(XCO2SetpointSelectSet=silaFW_pb2.Integer(value=XCO2SetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXCO2SetpointSelect_Responses(
                **default_dict['SetXCO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetXCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get XCO2 SetpointSelect"
            Get gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SetpointSelect (Current XCO2 SetpointSelect): Current gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentXCO2SetpointSelect = 2
        return_value = GassingServicer_pb2.GetXCO2SetpointSelect_Responses(CurrentXCO2SetpointSelect=silaFW_pb2.Integer(value=CurrentXCO2SetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXCO2SetpointSelect_Responses(
                **default_dict['GetXCO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetXO2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2PV_Responses:
        """
        Executes the unobservable command "Get XO2 PV"
            Get present value. Gassing XO2 concentration process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2PV (Current XO2 PV): Current present value. Gassing XO2 concentration process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2PV = 0.0
        return_value = GassingServicer_pb2.GetXO2PV_Responses(CurrentXO2PV=silaFW_pb2.Real(value=CurrentXO2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2PV_Responses(
                **default_dict['GetXO2PV_Responses']
            )
    
        return return_value
    
    
    def GetXO2SP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SP_Responses:
        """
        Executes the unobservable command "Get XO2 SP"
            Get gassing XO2 concentration setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SP (Current XO2 SP): Current gassing XO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SP = 0.0
        return_value = GassingServicer_pb2.GetXO2SP_Responses(CurrentXO2SP=silaFW_pb2.Real(value=CurrentXO2SP))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SP_Responses(
                **default_dict['GetXO2SP_Responses']
            )
    
        return return_value
    
    
    def SetXO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXO2SPM_Responses:
        """
        Executes the unobservable command "Set XO2 SPM"
            Set gassing XO2 concentration setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XO2SPM (XO2 Setpoint Manual):
            The gassing XO2 concentration setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2SPMSet (XO2 Setpoint Manual Set): The set manual gassing XO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None

        XO2SPMSet = 0.0
        return_value = GassingServicer_pb2.SetXO2SPM_Responses(XO2SPMSet=silaFW_pb2.Real(value=XO2SPMSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXO2SPM_Responses(
                **default_dict['SetXO2SPM_Responses']
            )
    
        return return_value
    
    
    def GetXO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SPM_Responses:
        """
        Executes the unobservable command "Get XO2 SP Manual"
            Get gassing XO2 concentration manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPM (Current XO2 SP Manual): Current gassing XO2 concentration manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SPM = 0.0
        return_value = GassingServicer_pb2.GetXO2SPM_Responses(CurrentXO2SPM=silaFW_pb2.Real(value=CurrentXO2SPM))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SPM_Responses(
                **default_dict['GetXO2SPM_Responses']
            )
    
        return return_value
    
    
    def SetXO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXO2SPE_Responses:
        """
        Executes the unobservable command "Set XO2 SPE"
            Set gassing XO2 concentration setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XO2SPE (XO2 Setpoint External):
            The gassing XO2 concentration setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2SPESet (XO2 Setpoint External Set): The set external gassing XO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None

        XO2SPESet = 0.0
        return_value = GassingServicer_pb2.SetXO2SPE_Responses(XO2SPESet=silaFW_pb2.Real(value=XO2SPESet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXO2SPE_Responses(
                **default_dict['SetXO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetXO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SPE_Responses:
        """
        Executes the unobservable command "Get XO2 SP External"
            Get gassing XO2 concentration external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPE (Current XO2 SP External): Current gassing XO2 concentration external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SPE = 0.0
        return_value = GassingServicer_pb2.GetXO2SPE_Responses(CurrentXO2SPE=silaFW_pb2.Real(value=CurrentXO2SPE))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SPE_Responses(
                **default_dict['GetXO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetXO2SPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SPA_Responses:
        """
        Executes the unobservable command "Get XO2 SP Automatic"
            Get gassing XO2 concentration automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPA (Current XO2 SP Automatic): Current gassing XO2 concentration automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SPA = 0.0
        return_value = GassingServicer_pb2.GetXO2SPA_Responses(CurrentXO2SPA=silaFW_pb2.Real(value=CurrentXO2SPA))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SPA_Responses(
                **default_dict['GetXO2SPA_Responses']
            )
    
        return return_value
    
    
    def GetXO2SPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SPR_Responses:
        """
        Executes the unobservable command "Get XO2 SP Remote"
            Get gassing XO2 concentration remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPR (Current XO2 SP Remote): Current gassing XO2 concentration remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SPR = 0.0
        return_value = GassingServicer_pb2.GetXO2SPR_Responses(CurrentXO2SPR=silaFW_pb2.Real(value=CurrentXO2SPR))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SPR_Responses(
                **default_dict['GetXO2SPR_Responses']
            )
    
        return return_value
    
    
    def GetXO2SPL(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SPL_Responses:
        """
        Executes the unobservable command "Get XO2 SP Local"
            Get gassing XO2 concentration local setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPL (Current XO2 SP Local): Current gassing XO2 concentration local setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SPL = 0.0
        return_value = GassingServicer_pb2.GetXO2SPL_Responses(CurrentXO2SPL=silaFW_pb2.Real(value=CurrentXO2SPL))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SPL_Responses(
                **default_dict['GetXO2SPL_Responses']
            )
    
        return return_value
    
    
    def SetXO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXO2Mode_Responses:
        """
        Executes the unobservable command "Set XO2 Mode"
            Set gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XO2Mode (XO2 Mode):
            Set gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2ModeSet (XO2 Mode Set): The set gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        XO2ModeSet = 1
        return_value = GassingServicer_pb2.SetXO2Mode_Responses(XO2ModeSet=silaFW_pb2.Integer(value=XO2ModeSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXO2Mode_Responses(
                **default_dict['SetXO2Mode_Responses']
            )
    
        return return_value
    
    
    def GetXO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2Mode_Responses:
        """
        Executes the unobservable command "Get XO2 Mode"
            Get gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2Mode (Current XO2 Mode): Current gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2Mode = 1
        return_value = GassingServicer_pb2.GetXO2Mode_Responses(CurrentXO2Mode=silaFW_pb2.Integer(value=CurrentXO2Mode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2Mode_Responses(
                **default_dict['GetXO2Mode_Responses']
            )
    
        return return_value
    
    
    def SetXO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetXO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set XO2 SetpointSelect"
            Set gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XO2SetpointSelect (XO2 SetpointSelect):
            Set gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2SetpointSelectSet (XO2 SetpointSelect Set): The set gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        XO2SetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetXO2SetpointSelect_Responses(XO2SetpointSelectSet=silaFW_pb2.Integer(value=XO2SetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetXO2SetpointSelect_Responses(
                **default_dict['SetXO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetXO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetXO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get XO2 SetpointSelect"
            Get gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SetpointSelect (Current XO2 SetpointSelect): Current gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentXO2SetpointSelect = 2
        return_value = GassingServicer_pb2.GetXO2SetpointSelect_Responses(CurrentXO2SetpointSelect=silaFW_pb2.Integer(value=CurrentXO2SetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetXO2SetpointSelect_Responses(
                **default_dict['GetXO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFAirPV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirPV_Responses:
        """
        Executes the unobservable command "Get FAir PV"
            Get present value. Gassing air flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirPV (Current FAir PV): Current present value. Gassing air flow process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirPV = 0.0
        return_value = GassingServicer_pb2.GetFAirPV_Responses(CurrentFAirPV=silaFW_pb2.Real(value=CurrentFAirPV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirPV_Responses(
                **default_dict['GetFAirPV_Responses']
            )
    
        return return_value
    
    
    def GetVAirPV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetVAirPV_Responses:
        """
        Executes the unobservable command "Get V Air PV"
            Get present value. Gassing air flow volume value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVAirPV (Current V Air PV): Current present value. Gassing air flow volume value
        """
    
        # initialise the return value
        return_value = None

        CurrentVAirPV = 0.0
        return_value = GassingServicer_pb2.GetVAirPV_Responses(CurrentVAirPV=silaFW_pb2.Real(value=CurrentVAirPV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetVAirPV_Responses(
                **default_dict['GetVAirPV_Responses']
            )
    
        return return_value
    
    
    def GetFAirSP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirSP_Responses:
        """
        Executes the unobservable command "Get FAir SP"
            Get gassing air flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSP (Current FAir SP): Current gassing air flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirSP = 0.0
        return_value = GassingServicer_pb2.GetFAirSP_Responses(CurrentFAirSP=silaFW_pb2.Real(value=CurrentFAirSP))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirSP_Responses(
                **default_dict['GetFAirSP_Responses']
            )
    
        return return_value
    
    
    def SetFAirSPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFAirSPM_Responses:
        """
        Executes the unobservable command "Set FAir SPM"
            Set gassing air flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FAirSPM (FAir Setpoint Manual):
            The gassing air flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirSPMSet (FAir Setpoint Manual Set): The set manual gassing air flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FAirSPMSet = 0.0
        return_value = GassingServicer_pb2.SetFAirSPM_Responses(FAirSPMSet=silaFW_pb2.Real(value=FAirSPMSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFAirSPM_Responses(
                **default_dict['SetFAirSPM_Responses']
            )
    
        return return_value
    
    
    def GetFAirSPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirSPM_Responses:
        """
        Executes the unobservable command "Get FAir SP Manual"
            Get gassing air flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPM (Current FAir SP Manual): Current gassing air flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirSPM = 0.0
        return_value = GassingServicer_pb2.GetFAirSPM_Responses(CurrentFAirSPM=silaFW_pb2.Real(value=CurrentFAirSPM))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirSPM_Responses(
                **default_dict['GetFAirSPM_Responses']
            )
    
        return return_value
    
    
    def SetFAirSPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFAirSPE_Responses:
        """
        Executes the unobservable command "Set FAir SPE"
            Set gassing air flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FAirSPE (FAir Setpoint External):
            The gassing air flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirSPESet (FAir Setpoint External Set): The set external gassing air flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FAirSPESet = 0.0
        return_value = GassingServicer_pb2.SetFAirSPE_Responses(FAirSPESet=silaFW_pb2.Real(value=FAirSPESet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFAirSPE_Responses(
                **default_dict['SetFAirSPE_Responses']
            )
    
        return return_value
    
    
    def GetFAirSPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirSPE_Responses:
        """
        Executes the unobservable command "Get FAir SP External"
            Get gassing air flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPE (Current FAir SP External): Current gassing air flow external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirSPE = 0.0
        return_value = GassingServicer_pb2.GetFAirSPE_Responses(CurrentFAirSPE=silaFW_pb2.Real(value=CurrentFAirSPE))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirSPE_Responses(
                **default_dict['GetFAirSPE_Responses']
            )
    
        return return_value
    
    
    def GetFAirSPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirSPA_Responses:
        """
        Executes the unobservable command "Get FAir SP Automatic"
            Get gassing air flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPA (Current FAir SP Automatic): Current gassing air flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirSPA = 0.0
        return_value = GassingServicer_pb2.GetFAirSPA_Responses(CurrentFAirSPA=silaFW_pb2.Real(value=CurrentFAirSPA))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirSPA_Responses(
                **default_dict['GetFAirSPA_Responses']
            )
    
        return return_value
    
    
    def GetFAirSPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirSPR_Responses:
        """
        Executes the unobservable command "Get FAir SP Remote"
            Get gassing air flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPR (Current FAir SP Remote): Current gassing air flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirSPR = 0.0
        return_value = GassingServicer_pb2.GetFAirSPR_Responses(CurrentFAirSPR=silaFW_pb2.Real(value=CurrentFAirSPR))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirSPR_Responses(
                **default_dict['GetFAirSPR_Responses']
            )
    
        return return_value
    
    
    def SetFAirMode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFAirMode_Responses:
        """
        Executes the unobservable command "Set FAir Mode"
            Set gas air flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FAirMode (FAir Mode):
            Set gas air flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirModeSet (FAir Mode Set): The set gas air flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        FAirModeSet = 1
        return_value = GassingServicer_pb2.SetFAirMode_Responses(FAirModeSet=silaFW_pb2.Integer(value=FAirModeSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFAirMode_Responses(
                **default_dict['SetFAirMode_Responses']
            )
    
        return return_value
    
    
    def GetFAirMode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirMode_Responses:
        """
        Executes the unobservable command "Get FAir Mode"
            Get gas air flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirMode (Current FAir Mode): Current gas air flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirMode = 1
        return_value = GassingServicer_pb2.GetFAirMode_Responses(CurrentFAirMode=silaFW_pb2.Integer(value=CurrentFAirMode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirMode_Responses(
                **default_dict['GetFAirMode_Responses']
            )
    
        return return_value
    
    
    def SetFAirSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFAirSetpointSelect_Responses:
        """
        Executes the unobservable command "Set FAir SetpointSelect"
            Set gas air flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FAirSetpointSelect (FAir SetpointSelect):
            Set gas air flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirSetpointSelectSet (FAir SetpointSelect Set): The set gas air flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        FAirSetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetFAirSetpointSelect_Responses(FAirSetpointSelectSet=silaFW_pb2.Integer(value=FAirSetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFAirSetpointSelect_Responses(
                **default_dict['SetFAirSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFAirSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFAirSetpointSelect_Responses:
        """
        Executes the unobservable command "Get FAir SetpointSelect"
            Get gas air flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSetpointSelect (Current FAir SetpointSelect): Current gas air flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentFAirSetpointSelect = 2
        return_value = GassingServicer_pb2.GetFAirSetpointSelect_Responses(CurrentFAirSetpointSelect=silaFW_pb2.Integer(value=CurrentFAirSetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFAirSetpointSelect_Responses(
                **default_dict['GetFAirSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFO2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2PV_Responses:
        """
        Executes the unobservable command "Get FO2 PV"
            Get present value. Gassing O2 flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2PV (Current FO2 PV): Current present value. Gassing O2 flow process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2PV = 0.0
        return_value = GassingServicer_pb2.GetFO2PV_Responses(CurrentFO2PV=silaFW_pb2.Real(value=CurrentFO2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2PV_Responses(
                **default_dict['GetFO2PV_Responses']
            )
    
        return return_value
    
    
    def GetVO2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetVO2PV_Responses:
        """
        Executes the unobservable command "Get V O2 PV"
            Get present value. Gassing O2 volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVO2PV (Current V O2 PV): Current present value. Gassing O2 volume process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentVO2PV = 0.0
        return_value = GassingServicer_pb2.GetVO2PV_Responses(CurrentVO2PV=silaFW_pb2.Real(value=CurrentVO2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetVO2PV_Responses(
                **default_dict['GetVO2PV_Responses']
            )
    
        return return_value
    
    
    def GetFO2SP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2SP_Responses:
        """
        Executes the unobservable command "Get FO2 SP"
            Get gassing O2 flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SP (Current FO2 SP): Current gassing O2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2SP = 0.0
        return_value = GassingServicer_pb2.GetFO2SP_Responses(CurrentFO2SP=silaFW_pb2.Real(value=CurrentFO2SP))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2SP_Responses(
                **default_dict['GetFO2SP_Responses']
            )
    
        return return_value
    
    
    def SetFO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFO2SPM_Responses:
        """
        Executes the unobservable command "Set FO2 SPM"
            Set gassing O2 flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FO2SPM (FO2 Setpoint Manual):
            The gassing O2 flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2SPMSet (FO2 Setpoint Manual Set): The set manual gassing O2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FO2SPMSet = 0.0
        return_value = GassingServicer_pb2.SetFO2SPM_Responses(FO2SPMSet=silaFW_pb2.Real(value=FO2SPMSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFO2SPM_Responses(
                **default_dict['SetFO2SPM_Responses']
            )
    
        return return_value
    
    
    def GetFO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2SPM_Responses:
        """
        Executes the unobservable command "Get FO2 SP Manual"
            Get gassing O2 flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPM (Current FO2 SP Manual): Current gassing O2 flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2SPM = 0.0
        return_value = GassingServicer_pb2.GetFO2SPM_Responses(CurrentFO2SPM=silaFW_pb2.Real(value=CurrentFO2SPM))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2SPM_Responses(
                **default_dict['GetFO2SPM_Responses']
            )
    
        return return_value
    
    
    def SetFO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFO2SPE_Responses:
        """
        Executes the unobservable command "Set FO2 SPE"
            Set gassing O2 flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FO2SPE (FO2 Setpoint External):
            The gassing O2 flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2SPESet (FO2 Setpoint External Set): The set external gassing O2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FO2SPESet = 0.0
        return_value = GassingServicer_pb2.SetFO2SPE_Responses(FO2SPESet=silaFW_pb2.Real(value=FO2SPESet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFO2SPE_Responses(
                **default_dict['SetFO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetFO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2SPE_Responses:
        """
        Executes the unobservable command "Get FO2 SP External"
            Get gassing O2 flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPE (Current FO2 SP External): Current gassing O2 flow external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2SPE = 0.0
        return_value = GassingServicer_pb2.GetFO2SPE_Responses(CurrentFO2SPE=silaFW_pb2.Real(value=CurrentFO2SPE))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2SPE_Responses(
                **default_dict['GetFO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetFO2SPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2SPA_Responses:
        """
        Executes the unobservable command "Get FO2 SP Automatic"
            Get gassing O2 flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPA (Current FO2 SP Automatic): Current gassing O2 flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2SPA = 0.0
        return_value = GassingServicer_pb2.GetFO2SPA_Responses(CurrentFO2SPA=silaFW_pb2.Real(value=CurrentFO2SPA))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2SPA_Responses(
                **default_dict['GetFO2SPA_Responses']
            )
    
        return return_value
    
    
    def GetFO2SPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2SPR_Responses:
        """
        Executes the unobservable command "Get FO2 SP Remote"
            Get gassing O2 flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPR (Current FO2 SP Remote): Current gassing O2 flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2SPR = 0.0
        return_value = GassingServicer_pb2.GetFO2SPR_Responses(CurrentFO2SPR=silaFW_pb2.Real(value=CurrentFO2SPR))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2SPR_Responses(
                **default_dict['GetFO2SPR_Responses']
            )
    
        return return_value
    
    
    def SetFO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFO2Mode_Responses:
        """
        Executes the unobservable command "Set FO2 Mode"
            Set gas O2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FO2Mode (FO2 Mode):
            Set gas O2 flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2ModeSet (FO2 Mode Set): The set gas O2 flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        FO2ModeSet = 1
        return_value = GassingServicer_pb2.SetFO2Mode_Responses(FO2ModeSet=silaFW_pb2.Integer(value=FO2ModeSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFO2Mode_Responses(
                **default_dict['SetFO2Mode_Responses']
            )
    
        return return_value
    
    
    def GetFO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2Mode_Responses:
        """
        Executes the unobservable command "Get FO2 Mode"
            Get gas O2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2Mode (Current FO2 Mode): Current gas O2 flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2Mode = 1
        return_value = GassingServicer_pb2.GetFO2Mode_Responses(CurrentFO2Mode=silaFW_pb2.Integer(value=CurrentFO2Mode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2Mode_Responses(
                **default_dict['GetFO2Mode_Responses']
            )
    
        return return_value
    
    
    def SetFO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set FO2 SetpointSelect"
            Set gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FO2SetpointSelect (FO2 SetpointSelect):
            Set gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2SetpointSelectSet (FO2 SetpointSelect Set): The set gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        FO2SetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetFO2SetpointSelect_Responses(FO2SetpointSelectSet=silaFW_pb2.Integer(value=FO2SetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFO2SetpointSelect_Responses(
                **default_dict['SetFO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get FO2 SetpointSelect"
            Get gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SetpointSelect (Current FO2 SetpointSelect): Current gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentFO2SetpointSelect = 2
        return_value = GassingServicer_pb2.GetFO2SetpointSelect_Responses(CurrentFO2SetpointSelect=silaFW_pb2.Integer(value=CurrentFO2SetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFO2SetpointSelect_Responses(
                **default_dict['GetFO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFCO2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2PV_Responses:
        """
        Executes the unobservable command "Get FCO2 PV"
            Get present value. Gassing CO2  flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2PV (Current FCO2 PV): Current present value. Gassing CO2  flow process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2PV = 0.0
        return_value = GassingServicer_pb2.GetFCO2PV_Responses(CurrentFCO2PV=silaFW_pb2.Real(value=CurrentFCO2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2PV_Responses(
                **default_dict['GetFCO2PV_Responses']
            )
    
        return return_value
    
    
    def GetVCO2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetVCO2PV_Responses:
        """
        Executes the unobservable command "Get V CO2 PV"
            Get present value. Gassing CO2 volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVCO2PV (Current V CO2 PV): Current present value. Gassing CO2 volume process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentVCO2PV = 0.0
        return_value = GassingServicer_pb2.GetVCO2PV_Responses(CurrentVCO2PV=silaFW_pb2.Real(value=CurrentVCO2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetVCO2PV_Responses(
                **default_dict['GetVCO2PV_Responses']
            )
    
        return return_value
    
    
    def GetFCO2SP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2SP_Responses:
        """
        Executes the unobservable command "Get FCO2 SP"
            Get gassing CO2  flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SP (Current FCO2 SP): Current gassing CO2  flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2SP = 0.0
        return_value = GassingServicer_pb2.GetFCO2SP_Responses(CurrentFCO2SP=silaFW_pb2.Real(value=CurrentFCO2SP))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2SP_Responses(
                **default_dict['GetFCO2SP_Responses']
            )
    
        return return_value
    
    
    def SetFCO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFCO2SPM_Responses:
        """
        Executes the unobservable command "Set FCO2 SPM"
            Set gassing CO2  flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FCO2SPM (FCO2 Setpoint Manual):
            The gassing CO2  flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2SPMSet (FCO2 Setpoint Manual Set): The set manual gassing CO2  flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FCO2SPMSet = 0.0
        return_value = GassingServicer_pb2.SetFCO2SPM_Responses(FCO2SPMSet=silaFW_pb2.Real(value=FCO2SPMSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFCO2SPM_Responses(
                **default_dict['SetFCO2SPM_Responses']
            )
    
        return return_value
    
    
    def GetFCO2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2SPM_Responses:
        """
        Executes the unobservable command "Get FCO2 SP Manual"
            Get gassing CO2  flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPM (Current FCO2 SP Manual): Current gassing CO2  flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2SPM = 0.0
        return_value = GassingServicer_pb2.GetFCO2SPM_Responses(CurrentFCO2SPM=silaFW_pb2.Real(value=CurrentFCO2SPM))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2SPM_Responses(
                **default_dict['GetFCO2SPM_Responses']
            )
    
        return return_value
    
    
    def SetFCO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFCO2SPE_Responses:
        """
        Executes the unobservable command "Set FCO2 SPE"
            Set gassing CO2  flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FCO2SPE (FCO2 Setpoint External):
            The gassing CO2  flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2SPESet (FCO2 Setpoint External Set): The set external gassing CO2  flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FCO2SPESet = 0.0
        return_value = GassingServicer_pb2.SetFCO2SPE_Responses(FCO2SPESet=silaFW_pb2.Real(value=FCO2SPESet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFCO2SPE_Responses(
                **default_dict['SetFCO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetFCO2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2SPE_Responses:
        """
        Executes the unobservable command "Get FCO2 SP External"
            Get gassing CO2  flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPE (Current FCO2 SP External): Current gassing CO2  flow external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2SPE = 0.0
        return_value = GassingServicer_pb2.GetFCO2SPE_Responses(CurrentFCO2SPE=silaFW_pb2.Real(value=CurrentFCO2SPE))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2SPE_Responses(
                **default_dict['GetFCO2SPE_Responses']
            )
    
        return return_value
    
    
    def GetFCO2SPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2SPA_Responses:
        """
        Executes the unobservable command "Get FCO2 SP Automatic"
            Get gassing CO2  flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPA (Current FCO2 SP Automatic): Current gassing CO2  flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2SPA = 0.0
        return_value = GassingServicer_pb2.GetFCO2SPA_Responses(CurrentFCO2SPA=silaFW_pb2.Real(value=CurrentFCO2SPA))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2SPA_Responses(
                **default_dict['GetFCO2SPA_Responses']
            )
    
        return return_value
    
    
    def GetFCO2SPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2SPR_Responses:
        """
        Executes the unobservable command "Get FCO2 SP Remote"
            Get gassing CO2  flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPR (Current FCO2 SP Remote): Current gassing CO2  flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2SPR = 0.0
        return_value = GassingServicer_pb2.GetFCO2SPR_Responses(CurrentFCO2SPR=silaFW_pb2.Real(value=CurrentFCO2SPR))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2SPR_Responses(
                **default_dict['GetFCO2SPR_Responses']
            )
    
        return return_value
    
    
    def SetFCO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFCO2Mode_Responses:
        """
        Executes the unobservable command "Set FCO2 Mode"
            Set gas CO2  flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FCO2Mode (FCO2 Mode):
            Set gas CO2  flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2ModeSet (FCO2 Mode Set): The set gas CO2  flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        FCO2ModeSet = 1
        return_value = GassingServicer_pb2.SetFCO2Mode_Responses(FCO2ModeSet=silaFW_pb2.Integer(value=FCO2ModeSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFCO2Mode_Responses(
                **default_dict['SetFCO2Mode_Responses']
            )
    
        return return_value
    
    
    def GetFCO2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2Mode_Responses:
        """
        Executes the unobservable command "Get FCO2 Mode"
            Get gas CO2  flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2Mode (Current FCO2 Mode): Current gas CO2  flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2Mode = 1
        return_value = GassingServicer_pb2.GetFCO2Mode_Responses(CurrentFCO2Mode=silaFW_pb2.Integer(value=CurrentFCO2Mode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2Mode_Responses(
                **default_dict['GetFCO2Mode_Responses']
            )
    
        return return_value
    
    
    def SetFCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set FCO2 SetpointSelect"
            Set gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FCO2SetpointSelect (FCO2 SetpointSelect):
            Set gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2SetpointSelectSet (FCO2 SetpointSelect Set): The set gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        FCO2SetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetFCO2SetpointSelect_Responses(FCO2SetpointSelectSet=silaFW_pb2.Integer(value=FCO2SetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFCO2SetpointSelect_Responses(
                **default_dict['SetFCO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get FCO2 SetpointSelect"
            Get gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SetpointSelect (Current FCO2 SetpointSelect): Current gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentFCO2SetpointSelect = 2
        return_value = GassingServicer_pb2.GetFCO2SetpointSelect_Responses(CurrentFCO2SetpointSelect=silaFW_pb2.Integer(value=CurrentFCO2SetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFCO2SetpointSelect_Responses(
                **default_dict['GetFCO2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFN2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2PV_Responses:
        """
        Executes the unobservable command "Get FN2 PV"
            Get present value. Gassing N2 flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2PV (Current FN2 PV): Current present value. Gassing N2 flow process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2PV = 0.0
        return_value = GassingServicer_pb2.GetFN2PV_Responses(CurrentFN2PV=silaFW_pb2.Real(value=CurrentFN2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2PV_Responses(
                **default_dict['GetFN2PV_Responses']
            )
    
        return return_value
    
    
    def GetVN2PV(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetVN2PV_Responses:
        """
        Executes the unobservable command "Get V N2 PV"
            Get present value. Gassing N2 volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVN2PV (Current V N2 PV): Current present value. Gassing N2 volume process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentVN2PV = 0.0
        return_value = GassingServicer_pb2.GetVN2PV_Responses(CurrentVN2PV=silaFW_pb2.Real(value=CurrentVN2PV))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetVN2PV_Responses(
                **default_dict['GetVN2PV_Responses']
            )
    
        return return_value
    
    
    def GetFN2SP(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2SP_Responses:
        """
        Executes the unobservable command "Get FN2 SP"
            Get gassing N2 flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SP (Current FN2 SP): Current gassing N2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2SP = 0.0
        return_value = GassingServicer_pb2.GetFN2SP_Responses(CurrentFN2SP=silaFW_pb2.Real(value=CurrentFN2SP))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2SP_Responses(
                **default_dict['GetFN2SP_Responses']
            )
    
        return return_value
    
    
    def SetFN2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFN2SPM_Responses:
        """
        Executes the unobservable command "Set FN2 SPM"
            Set gassing N2 flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FN2SPM (FN2 Setpoint Manual):
            The gassing N2 flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2SPMSet (FN2 Setpoint Manual Set): The set manual gassing N2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FN2SPMSet = 0.0
        return_value = GassingServicer_pb2.SetFN2SPM_Responses(FN2SPMSet=silaFW_pb2.Real(value=FN2SPMSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFN2SPM_Responses(
                **default_dict['SetFN2SPM_Responses']
            )
    
        return return_value
    
    
    def GetFN2SPM(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2SPM_Responses:
        """
        Executes the unobservable command "Get FN2 SP Manual"
            Get gassing N2 flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPM (Current FN2 SP Manual): Current gassing N2 flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2SPM = 0.0
        return_value = GassingServicer_pb2.GetFN2SPM_Responses(CurrentFN2SPM=silaFW_pb2.Real(value=CurrentFN2SPM))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2SPM_Responses(
                **default_dict['GetFN2SPM_Responses']
            )
    
        return return_value
    
    
    def SetFN2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFN2SPE_Responses:
        """
        Executes the unobservable command "Set FN2 SPE"
            Set gassing N2 flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FN2SPE (FN2 Setpoint External):
            The gassing N2 flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2SPESet (FN2 Setpoint External Set): The set external gassing N2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        FN2SPESet = 0.0
        return_value = GassingServicer_pb2.SetFN2SPE_Responses(FN2SPESet=silaFW_pb2.Real(value=FN2SPESet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFN2SPE_Responses(
                **default_dict['SetFN2SPE_Responses']
            )
    
        return return_value
    
    
    def GetFN2SPE(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2SPE_Responses:
        """
        Executes the unobservable command "Get FN2 SP External"
            Get gassing N2 flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPE (Current FN2 SP External): Current gassing N2 flow external setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2SPE = 0.0
        return_value = GassingServicer_pb2.GetFN2SPE_Responses(CurrentFN2SPE=silaFW_pb2.Real(value=CurrentFN2SPE))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2SPE_Responses(
                **default_dict['GetFN2SPE_Responses']
            )
    
        return return_value
    
    
    def GetFN2SPA(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2SPA_Responses:
        """
        Executes the unobservable command "Get FN2 SP Automatic"
            Get gassing N2 flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPA (Current FN2 SP Automatic): Current gassing N2 flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2SPA = 0.0
        return_value = GassingServicer_pb2.GetFN2SPA_Responses(CurrentFN2SPA=silaFW_pb2.Real(value=CurrentFN2SPA))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2SPA_Responses(
                **default_dict['GetFN2SPA_Responses']
            )
    
        return return_value
    
    
    def GetFN2SPR(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2SPR_Responses:
        """
        Executes the unobservable command "Get FN2 SP Remote"
            Get gassing N2 flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPR (Current FN2 SP Remote): Current gassing N2 flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2SPR = 0.0
        return_value = GassingServicer_pb2.GetFN2SPR_Responses(CurrentFN2SPR=silaFW_pb2.Real(value=CurrentFN2SPR))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2SPR_Responses(
                **default_dict['GetFN2SPR_Responses']
            )
    
        return return_value
    
    
    def SetFN2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFN2Mode_Responses:
        """
        Executes the unobservable command "Set FN2 Mode"
            Set gas N2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FN2Mode (FN2 Mode):
            Set gas N2 flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2ModeSet (FN2 Mode Set): The set gas N2 flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        FN2ModeSet = 1
        return_value = GassingServicer_pb2.SetFN2Mode_Responses(FN2ModeSet=silaFW_pb2.Integer(value=FN2ModeSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFN2Mode_Responses(
                **default_dict['SetFN2Mode_Responses']
            )
    
        return return_value
    
    
    def GetFN2Mode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2Mode_Responses:
        """
        Executes the unobservable command "Get FN2 Mode"
            Get gas N2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2Mode (Current FN2 Mode): Current gas N2 flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2Mode = 1
        return_value = GassingServicer_pb2.GetFN2Mode_Responses(CurrentFN2Mode=silaFW_pb2.Integer(value=CurrentFN2Mode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2Mode_Responses(
                **default_dict['GetFN2Mode_Responses']
            )
    
        return return_value
    
    
    def SetFN2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetFN2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set FN2 SetpointSelect"
            Set gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FN2SetpointSelect (FN2 SetpointSelect):
            Set gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2SetpointSelectSet (FN2 SetpointSelect Set): The set gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        FN2SetpointSelectSet = 2
        return_value = GassingServicer_pb2.SetFN2SetpointSelect_Responses(FN2SetpointSelectSet=silaFW_pb2.Integer(value=FN2SetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetFN2SetpointSelect_Responses(
                **default_dict['SetFN2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetFN2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetFN2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get FN2 SetpointSelect"
            Get gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SetpointSelect (Current FN2 SetpointSelect): Current gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None

        CurrentFN2SetpointSelect = 2
        return_value = GassingServicer_pb2.GetFN2SetpointSelect_Responses(CurrentFN2SetpointSelect=silaFW_pb2.Integer(value=CurrentFN2SetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetFN2SetpointSelect_Responses(
                **default_dict['GetFN2SetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None

        CurrentAccess = 1
        return_value = GassingServicer_pb2.GetAccess_Responses(CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetAccess_Responses(
                **default_dict['GetAccess_Responses']
            )
    
        return return_value
    
    
    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller command of the gassing module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None

        CmdSet = 0
        return_value = GassingServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetCmd_Responses(
                **default_dict['SetCmd_Responses']
            )
    
        return return_value
    
    
    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the gassing module. Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None

        CurrentCmd = 0
        return_value = GassingServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetCmd_Responses(
                **default_dict['GetCmd_Responses']
            )
    
        return return_value
    
    
    def SetGassingMode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.SetGassingMode_Responses:
        """
        Executes the unobservable command "Set Gassing Mode"
            Gassing mode (Unknown, Mix, Flow).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.GassingMode (Gassing Mode):
            Gassing mode (Unknown, Mix, Flow).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.GassingModeSet (Gassing Mode Set): The set gassing mode.
        """
    
        # initialise the return value
        return_value = None

        GassingModeSet = 1
        return_value = GassingServicer_pb2.SetGassingMode_Responses(GassingModeSet=silaFW_pb2.Integer(value=GassingModeSet))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.SetGassingMode_Responses(
                **default_dict['SetGassingMode_Responses']
            )
    
        return return_value
    
    
    def GetGassingMode(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetGassingMode_Responses:
        """
        Executes the unobservable command "Get Gassing Mode"
            Get the gassing mode. Gassing mode (Unknown, Mix, Flow).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentGassingMode (Current Gassing Mode): Current gassing mode value of the gassing module. Gassing mode (Unknown, Mix, Flow).
        """
    
        # initialise the return value
        return_value = None

        CurrentGassingMode = 0
        return_value = GassingServicer_pb2.GetGassingMode_Responses(CurrentGassingMode=silaFW_pb2.Integer(value=CurrentGassingMode))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetGassingMode_Responses(
                **default_dict['GetGassingMode_Responses']
            )
    
        return return_value
    
    
    def GetState(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the gassing module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None

        CurrentState = 0
        return_value = GassingServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetState_Responses(
                **default_dict['GetState_Responses']
            )
    
        return return_value
    
    
    def GetType(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the gassing module.
        """
    
        # initialise the return value
        return_value = None

        CurrentType = 'SimGassingType'
        return_value = GassingServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetType_Responses(
                **default_dict['GetType_Responses']
            )
    
        return return_value
    
    
    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the gassing module.
        """
    
        # initialise the return value
        return_value = None

        CurrentAvailable = 0
        return_value = GassingServicer_pb2.GetAvailable_Responses(CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetAvailable_Responses(
                **default_dict['GetAvailable_Responses']
            )
    
        return return_value
    
    
    def GetName(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the gassing module.
        """
    
        # initialise the return value
        return_value = None

        CurrentName = 'SimGassing'
        return_value = GassingServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetName_Responses(
                **default_dict['GetName_Responses']
            )
    
        return return_value
    
    
    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> GassingServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the gassing module.
        """
    
        # initialise the return value
        return_value = None

        CurrentVersion = 'SimGassingVersion_1.0'
        return_value = GassingServicer_pb2.GetVersion_Responses(CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        # fallback to default
        if return_value is None:
            return_value = GassingServicer_pb2.GetVersion_Responses(
                **default_dict['GetVersion_Responses']
            )
    
        return return_value
