"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Illumination Servicer*

:details: IlluminationServicer:
    Control a DASGIP illumination module. Enables read and write operations for various parameters, including the
    illumination actuators.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    IlluminationServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.116047
:date: (last modification) 2020-04-16T10:19:14.116047

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import IlluminationServicer_pb2 as IlluminationServicer_pb2
# from .gRPC import IlluminationServicer_pb2_grpc as IlluminationServicer_pb2_grpc

# import default arguments
from .IlluminationServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class IlluminationServicerReal:
    """
    Implementation of the *Illumination Servicer* in *Real* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.status.Access
        CurrentAccess = node.get_value()
        return_value = IlluminationServicer_pb2.GetAccess_Responses(
            CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        return return_value
    
    
    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller commandillumination module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.status.Cmd = request.Cmd.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.status.Cmd
        CmdSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        return return_value
    
    
    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the illumination 
            module. Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.status.Cmd
        CurrentCmd = node.get_value()
        return_value = IlluminationServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        return return_value
    
    
    def SetMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller modeillumination module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.status.Mode = request.Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.status.Mode
        ModeSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetMode_Responses(ModeSet=silaFW_pb2.Integer(value=ModeSet))

        return return_value
    
    
    def GetMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the illumination module. 
            Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.status.Mode
        CurrentMode = node.get_value()
        return_value = IlluminationServicer_pb2.GetMode_Responses(CurrentMode=silaFW_pb2.Integer(value=CurrentMode))

        return return_value
    
    
    def GetState(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the illumination module. 
            Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.status.State
        CurrentState = node.get_value()
        return_value = IlluminationServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        return return_value
    
    
    def GetType(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.sysinfo.Type
        CurrentType = node.get_value()
        return_value = IlluminationServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        return return_value
    
    
    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.sysinfo.Available
        CurrentAvailable = node.get_value()
        return_value = IlluminationServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        return return_value
    
    
    def GetName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function nameillumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.sysinfo.Name
        CurrentName = node.get_value()
        return_value = IlluminationServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        return return_value
    
    
    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version numberillumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.sysinfo.Version
        CurrentVersion = node.get_value()
        return_value = IlluminationServicer_pb2.GetVersion_Responses(
            CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        return return_value
    
    
    def GetActuatorAPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAPV_Responses:
        """
        Executes the unobservable command "Get ActuatorA PV"
            Get ActuatorA controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAPV (Current ActuatorA PV): Current ActuatorA controller process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.PV
        CurrentActuatorAPV = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorAPV_Responses(
            CurrentActuatorAPV=silaFW_pb2.Real(value=CurrentActuatorAPV))

        return return_value
    
    
    def GetActuatorAPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorA PV Int"
            Get ActuatorA accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAPVInt (Current ActuatorA PV Int): Current ActuatorA accumulated process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.PVInt
        CurrentActuatorAPVInt = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorAPVInt_Responses(
            CurrentActuatorAPVInt=silaFW_pb2.Integer(value=CurrentActuatorAPVInt))

        return return_value
    
    
    def GetActuatorASource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASource_Responses:
        """
        Executes the unobservable command "Get ActuatorA Source"
            Get ActuatorA source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASource (Current ActuatorA Source): Current ActuatorA Source.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.Source
        CurrentActuatorASource = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASource_Responses(
            CurrentActuatorASource=silaFW_pb2.String(value=CurrentActuatorASource))

        return return_value
    
    
    def SetActuatorASPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASPM_Responses:
        """
        Executes the unobservable command "Set ActuatorA Manual Setpoint"
            Set the manual ActuatorA setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASPM (ActuatorA Manual Setpoint):
            The manual setpoint of the ActuatorA module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASPMSet (ActuatorA Manual Setpoint Set): The set ActuatorA manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPM = request.ActuatorASPM.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPM
        ActuatorASPMSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorASPM_Responses(
            ActuatorASPMSet=silaFW_pb2.Real(value=ActuatorASPMSet))

        return return_value
    
    
    def SetActuatorASPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASPE_Responses:
        """
        Executes the unobservable command "Set ActuatorA External Setpoint"
            Set the external ActuatorA setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASPE (ActuatorA External Setpoint):
            The external setpoint of the ActuatorA module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASPESet (ActuatorA External Setpoint Set): The set ActuatorA external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPE = request.ActuatorASPE.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPE
        ActuatorASPESet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorASPE_Responses(
            ActuatorASPESet=silaFW_pb2.Real(value=ActuatorASPESet))

        return return_value
    
    
    def GetActuatorASP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASP_Responses:
        """
        Executes the unobservable command "Get ActuatorA SP"
            Get ActuatorA setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASP (Current ActuatorA SP): Current ActuatorA setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SP
        CurrentActuatorASP = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASP_Responses(
            CurrentActuatorASP=silaFW_pb2.Real(value=CurrentActuatorASP))

        return return_value
    
    
    def GetActuatorASPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPA_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPA"
            Get ActuatorA automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPA (Current ActuatorA SPA): Current ActuatorA automatic setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPA
        CurrentActuatorASPA = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASPA_Responses(
            CurrentActuatorASPA=silaFW_pb2.Real(value=CurrentActuatorASPA))

        return return_value
    
    
    def GetActuatorASPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPM_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPM"
            Get ActuatorA manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPM (Current ActuatorA SPM): Current ActuatorA manual setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPM
        CurrentActuatorASPM = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASPM_Responses(
            CurrentActuatorASPM=silaFW_pb2.Real(value=CurrentActuatorASPM))

        return return_value
    
    
    def GetActuatorASPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPE_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPE"
            Get ActuatorA external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPE (Current ActuatorA SPE): Current ActuatorA external setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPE
        CurrentActuatorASPE = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASPE_Responses(
            CurrentActuatorASPE=silaFW_pb2.Real(value=CurrentActuatorASPE))

        return return_value
    
    
    def GetActuatorASPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPR_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPR"
            Get ActuatorA remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPR (Current ActuatorA SPR): Current ActuatorA remote setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SPR
        CurrentActuatorASPR = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASPR_Responses(
            CurrentActuatorASPR=silaFW_pb2.Real(value=CurrentActuatorASPR))

        return return_value
    
    
    def SetActuatorAMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorAMode_Responses:
        """
        Executes the unobservable command "Set ActuatorA Controller Mode"
            Set the ActuatorA controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorAMode (ActuatorA Controller Mode):
            The controller mode of the ActuatorA module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorAModeSet (ActuatorA Controller Mode Set): The set ActuatorA controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatora.Mode = request.ActuatorAMode.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.Mode
        ActuatorAModeSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorAMode_Responses(
            ActuatorAModeSet=silaFW_pb2.Integer(value=ActuatorAModeSet))

        return return_value
    
    
    def GetActuatorAMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAMode_Responses:
        """
        Executes the unobservable command "Get ActuatorA Controller Mode"
            Get the ActuatorA controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAMode (Current ActuatorA Controller Mode): Current controller mode value of the 
            ActuatorA module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.Mode
        CurrentActuatorAMode = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorAMode_Responses(
            CurrentActuatorAMode=silaFW_pb2.Integer(value=CurrentActuatorAMode))

        return return_value
    
    
    def SetActuatorASetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorA SetpointSelect"
            Set the selected ActuatorA setpoint that should be used. Setpoint selection (Local, Manual, Internal, 
            Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASetpointSelect (Set ActuatorA SetpointSelect):
            The selected setpoint of the ActuatorA module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASetpointSelectSet (ActuatorA Setpoint selection Set): The set ActuatorA setpoint selection.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatora.SetpointSelect \
            = request.ActuatorASetpointSelect.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SetpointSelect
        ActuatorASetpointSelectSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses(
            ActuatorASetpointSelectSet=silaFW_pb2.Integer(value=ActuatorASetpointSelectSet))
    
        return return_value
    
    
    def GetActuatorASetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorA SetpointSelect"
            Get the ActuatorA setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASetpointSelect (Current ActuatorA Setpoint Selection): Current ActuatorA setpoint 
            selection value. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.SetpointSelect
        CurrentActuatorASetpointSelect = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses(
            CurrentActuatorASetpointSelect=silaFW_pb2.Integer(value=CurrentActuatorASetpointSelect))

        return return_value
    
    
    def GetActuatorAAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorA Function Availability"
            Get ActuatorA function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAAvailable (Current ActuatorA Function Availability): Current ActuatorA function 
            availability value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.Available
        CurrentActuatorAAvailable = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorAAvailable_Responses(
            CurrentActuatorAAvailable=silaFW_pb2.Integer(value=CurrentActuatorAAvailable))

        return return_value
    
    
    def GetActuatorAName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAName_Responses:
        """
        Executes the unobservable command "Get ActuatorA Function Name"
            Get ActuatorA function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAName (Current ActuatorA Function Name): Current ActuatorA function name of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatora.Name
        CurrentActuatorAName = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorAName_Responses(
            CurrentActuatorAName=silaFW_pb2.String(value=CurrentActuatorAName))

        return return_value
    
    
    def GetActuatorBPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBPV_Responses:
        """
        Executes the unobservable command "Get ActuatorB PV"
            Get ActuatorB controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBPV (Current ActuatorB PV): Current ActuatorB controller process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.PV
        CurrentActuatorBPV = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBPV_Responses(
            CurrentActuatorBPV=silaFW_pb2.Real(value=CurrentActuatorBPV))

        return return_value
    
    
    def GetActuatorBPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorB PV Int"
            Get ActuatorB accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBPVInt (Current ActuatorB PV Int): Current ActuatorB accumulated process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.PVInt
        CurrentActuatorBPVInt = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBPVInt_Responses(
            CurrentActuatorBPVInt=silaFW_pb2.Integer(value=CurrentActuatorBPVInt))

        return return_value
    
    
    def GetActuatorBSource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSource_Responses:
        """
        Executes the unobservable command "Get ActuatorB Source"
            Get ActuatorB source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSource (Current ActuatorB Source): Current ActuatorB Source.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.Source
        CurrentActuatorBSource = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSource_Responses(
            CurrentActuatorBSource=silaFW_pb2.String(value=CurrentActuatorBSource))

        return return_value
    
    
    def SetActuatorBSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSPM_Responses:
        """
        Executes the unobservable command "Set ActuatorB Manual Setpoint"
            Set the manual ActuatorB setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSPM (ActuatorB Manual Setpoint):
            The manual setpoint of the ActuatorB module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSPMSet (ActuatorB Manual Setpoint Set): The set ActuatorB manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPM = request.ActuatorBSPM.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPM
        ActuatorBSPMSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorBSPM_Responses(
            ActuatorBSPMSet=silaFW_pb2.Real(value=ActuatorBSPMSet))

        return return_value
    
    
    def SetActuatorBSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSPE_Responses:
        """
        Executes the unobservable command "Set ActuatorB External Setpoint"
            Set the external ActuatorB setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSPE (ActuatorB External Setpoint):
            The external setpoint of the ActuatorB module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSPESet (ActuatorB External Setpoint Set): The set ActuatorB external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPE = request.ActuatorBSPE.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPE
        ActuatorBSPESet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorBSPE_Responses(
            ActuatorBSPESet=silaFW_pb2.Real(value=ActuatorBSPESet))

        return return_value
    
    
    def GetActuatorBSP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSP_Responses:
        """
        Executes the unobservable command "Get ActuatorB SP"
            Get ActuatorB setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSP (Current ActuatorB SP): Current ActuatorB setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SP
        CurrentActuatorBSP = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSP_Responses(
            CurrentActuatorBSP=silaFW_pb2.Real(value=CurrentActuatorBSP))

        return return_value
    
    
    def GetActuatorBSPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPA_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPA"
            Get ActuatorB automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPA (Current ActuatorB SPA): Current ActuatorB automatic setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPA
        CurrentActuatorBSPA = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSPA_Responses(
            CurrentActuatorBSPA=silaFW_pb2.Real(value=CurrentActuatorBSPA))

        return return_value
    
    
    def GetActuatorBSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPM_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPM"
            Get ActuatorB manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPM (Current ActuatorB SPM): Current ActuatorB manual setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPM
        CurrentActuatorBSPM = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSPM_Responses(
            CurrentActuatorBSPM=silaFW_pb2.Real(value=CurrentActuatorBSPM))

        return return_value
    
    
    def GetActuatorBSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPE_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPE"
            Get ActuatorB external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPE (Current ActuatorB SPE): Current ActuatorB external setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPE
        CurrentActuatorBSPE = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSPE_Responses(
            CurrentActuatorBSPE=silaFW_pb2.Real(value=CurrentActuatorBSPE))

        return return_value
    
    
    def GetActuatorBSPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPR_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPR"
            Get ActuatorB remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPR (Current ActuatorB SPR): Current ActuatorB remote setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SPR
        CurrentActuatorBSPR = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSPR_Responses(
            CurrentActuatorBSPR=silaFW_pb2.Real(value=CurrentActuatorBSPR))

        return return_value
    
    
    def SetActuatorBMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBMode_Responses:
        """
        Executes the unobservable command "Set ActuatorB Controller Mode"
            Set the ActuatorB controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBMode (ActuatorB Controller Mode):
            The controller mode of the ActuatorB module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBModeSet (ActuatorB Controller Mode Set): The set ActuatorB controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorb.Mode = request.ActuatorBMode.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.Mode
        ActuatorBModeSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorBMode_Responses(
            ActuatorBModeSet=silaFW_pb2.Integer(value=ActuatorBModeSet))

        return return_value
    
    
    def GetActuatorBMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBMode_Responses:
        """
        Executes the unobservable command "Get ActuatorB Controller Mode"
            Get the ActuatorB controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBMode (Current ActuatorB Controller Mode): Current controller mode value of the 
            ActuatorB module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.Mode
        CurrentActuatorBMode = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBMode_Responses(
            CurrentActuatorBMode=silaFW_pb2.Integer(value=CurrentActuatorBMode))

        return return_value
    
    
    def SetActuatorBSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorB SetpointSelect"
            Set the selected ActuatorB setpoint that should be used. Setpoint selection (Local, Manual, Internal, 
            Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSetpointSelect (Set ActuatorB SetpointSelect):
            The selected setpoint of the ActuatorB module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSetpointSelectSet (ActuatorB Setpoint selection Set): The set ActuatorB setpoint selection.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SetpointSelect \
            = request.ActuatorBSetpointSelect.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SetpointSelect
        ActuatorBSetpointSelectSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses(
            ActuatorBSetpointSelectSet=silaFW_pb2.Integer(value=ActuatorBSetpointSelectSet))

        return return_value
    
    
    def GetActuatorBSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorB SetpointSelect"
            Get the ActuatorB setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSetpointSelect (Current ActuatorB Setpoint Selection): Current ActuatorB setpoint 
            selection value of the illumination module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.SetpointSelect
        CurrentActuatorBSetpointSelect = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses(
            CurrentActuatorBSetpointSelect=silaFW_pb2.Integer(value=CurrentActuatorBSetpointSelect))

        return return_value
    
    
    def GetActuatorBAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorB Function Availability"
            Get ActuatorB function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBAvailable (Current ActuatorB Function Availability): Current ActuatorB function 
            availability value of the illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.Available
        CurrentActuatorBAvailable = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBAvailable_Responses(
            CurrentActuatorBAvailable=silaFW_pb2.Integer(value=CurrentActuatorBAvailable))

        return return_value
    
    
    def GetActuatorBName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBName_Responses:
        """
        Executes the unobservable command "Get ActuatorB Function Name"
            Get ActuatorB function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBName (Current ActuatorB Function Name): Current ActuatorB function name of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorb.Name
        CurrentActuatorBName = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorBName_Responses(
            CurrentActuatorBName=silaFW_pb2.String(value=CurrentActuatorBName))

        return return_value
    
    
    def GetActuatorCPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCPV_Responses:
        """
        Executes the unobservable command "Get ActuatorC PV"
            Get ActuatorC controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCPV (Current ActuatorC PV): Current ActuatorC controller process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.PV
        CurrentActuatorCPV = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCPV_Responses(
            CurrentActuatorCPV=silaFW_pb2.Real(value=CurrentActuatorCPV))

        return return_value
    
    
    def GetActuatorCPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorC PV Int"
            Get ActuatorC accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCPVInt (Current ActuatorC PV Int): Current ActuatorC accumulated process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.PVInt
        CurrentActuatorCPVInt = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCPVInt_Responses(
            CurrentActuatorCPVInt=silaFW_pb2.Integer(value=CurrentActuatorCPVInt))

        return return_value
    
    
    def GetActuatorCSource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSource_Responses:
        """
        Executes the unobservable command "Get ActuatorC Source"
            Get ActuatorC source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSource (Current ActuatorC Source): Current ActuatorC Source.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.Source
        CurrentActuatorCSource = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSource_Responses(
            CurrentActuatorCSource=silaFW_pb2.String(value=CurrentActuatorCSource))

        return return_value
    
    
    def SetActuatorCSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSPM_Responses:
        """
        Executes the unobservable command "Set ActuatorC Manual Setpoint"
            Set the manual ActuatorC setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSPM (ActuatorC Manual Setpoint):
            The manual setpoint of the ActuatorC module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSPMSet (ActuatorC Manual Setpoint Set): The set ActuatorC manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPM = request.ActuatorCSPM.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPM
        ActuatorCSPMSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorCSPM_Responses(
            ActuatorCSPMSet=silaFW_pb2.Real(value=ActuatorCSPMSet))

        return return_value
    
    
    def SetActuatorCSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSPE_Responses:
        """
        Executes the unobservable command "Set ActuatorC External Setpoint"
            Set the external ActuatorC setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSPE (ActuatorC External Setpoint):
            The external setpoint of the ActuatorC module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSPESet (ActuatorC External Setpoint Set): The set ActuatorC external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPE = request.ActuatorCSPE.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPE
        ActuatorCSPESet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorCSPE_Responses(
            ActuatorCSPESet=silaFW_pb2.Real(value=ActuatorCSPESet))

        return return_value
    
    
    def GetActuatorCSP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSP_Responses:
        """
        Executes the unobservable command "Get ActuatorC SP"
            Get ActuatorC setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSP (Current ActuatorC SP): Current ActuatorC setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SP
        CurrentActuatorCSP = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSP_Responses(
            CurrentActuatorCSP=silaFW_pb2.Real(value=CurrentActuatorCSP))

        return return_value
    
    
    def GetActuatorCSPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPA_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPA"
            Get ActuatorC automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPA (Current ActuatorC SPA): Current ActuatorC automatic setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPA
        CurrentActuatorCSPA = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSPA_Responses(
            CurrentActuatorCSPA=silaFW_pb2.Real(value=CurrentActuatorCSPA))

        return return_value
    
    
    def GetActuatorCSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPM_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPM"
            Get ActuatorC manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPM (Current ActuatorC SPM): Current ActuatorC manual setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPM
        CurrentActuatorCSPM = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSPM_Responses(
            CurrentActuatorCSPM=silaFW_pb2.Real(value=CurrentActuatorCSPM))

        return return_value
    
    
    def GetActuatorCSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPE_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPE"
            Get ActuatorC external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPE (Current ActuatorC SPE): Current ActuatorC external setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPE
        CurrentActuatorCSPE = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSPE_Responses(
            CurrentActuatorCSPE=silaFW_pb2.Real(value=CurrentActuatorCSPE))

        return return_value
    
    
    def GetActuatorCSPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPR_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPR"
            Get ActuatorC remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPR (Current ActuatorC SPR): Current ActuatorC remote setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SPR
        CurrentActuatorCSPR = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSPR_Responses(
            CurrentActuatorCSPR=silaFW_pb2.Real(value=CurrentActuatorCSPR))

        return return_value
    
    
    def SetActuatorCMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCMode_Responses:
        """
        Executes the unobservable command "Set ActuatorC Controller Mode"
            Set the ActuatorC controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCMode (ActuatorC Controller Mode):
            The controller mode of the ActuatorC module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCModeSet (ActuatorC Controller Mode Set): The set ActuatorC controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorc.Mode = request.ActuatorCMode.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.Mode
        ActuatorCModeSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorCMode_Responses(
            ActuatorCModeSet=silaFW_pb2.Integer(value=ActuatorCModeSet))

        return return_value
    
    
    def GetActuatorCMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCMode_Responses:
        """
        Executes the unobservable command "Get ActuatorC Controller Mode"
            Get the ActuatorC controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCMode (Current ActuatorC Controller Mode): Current controller mode value of the 
            ActuatorC module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.Mode
        CurrentActuatorCMode = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCMode_Responses(
            CurrentActuatorCMode=silaFW_pb2.Integer(value=CurrentActuatorCMode))

        return return_value
    
    
    def SetActuatorCSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorC SetpointSelect"
            Set the selected ActuatorC setpoint that should be used. Setpoint selection (Local, Manual, Internal, 
            Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSetpointSelect (Set ActuatorC SetpointSelect):
            The selected setpoint of the ActuatorC module. Setpoint selection (Local, Manual, Internal, Script, 
            External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSetpointSelectSet (ActuatorC Setpoint selection Set): The set ActuatorC setpoint selection.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SetpointSelect \
            = request.ActuatorCSetpointSelect.value
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SetpointSelect
        ActuatorCSetpointSelectSet = node.get_value()
        return_value = IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses(
            ActuatorCSetpointSelectSet=silaFW_pb2.Integer(value=ActuatorCSetpointSelectSet))

        return return_value
    
    
    def GetActuatorCSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorC SetpointSelect"
            Get the ActuatorC setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSetpointSelect (Current ActuatorC Setpoint Selection): Current ActuatorC setpoint selection value of the illumination module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.SetpointSelect
        CurrentActuatorCSetpointSelect = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses(
            CurrentActuatorCSetpointSelect=silaFW_pb2.Integer(value=CurrentActuatorCSetpointSelect))

        return return_value
    
    
    def GetActuatorCAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorC Function Availability"
            Get ActuatorC function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCAvailable (Current ActuatorC Function Availability): Current ActuatorC function availability value of the illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.Available
        CurrentActuatorCAvailable = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCAvailable_Responses(
            CurrentActuatorCAvailable=silaFW_pb2.Integer(value=CurrentActuatorCAvailable))

        return return_value
    
    
    def GetActuatorCName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCName_Responses:
        """
        Executes the unobservable command "Get ActuatorC Function Name"
            Get ActuatorC function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCName (Current ActuatorC Function Name): Current ActuatorC function name of the illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Illumination.actuatorc.Name
        CurrentActuatorCName = node.get_value()
        return_value = IlluminationServicer_pb2.GetActuatorCName_Responses(
            CurrentActuatorCName=silaFW_pb2.String(value=CurrentActuatorCName))

        return return_value
