"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Illumination Servicer*

:details: IlluminationServicer:
    Control a DASGIP illumination module. Enables read and write operations for various parameters, including the
    illumination actuators.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    IlluminationServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.021953
:date: (last modification) 2020-04-16T10:19:14.021953

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import IlluminationServicer_pb2 as IlluminationServicer_pb2
from .gRPC import IlluminationServicer_pb2_grpc as IlluminationServicer_pb2_grpc

# import simulation and real implementation
from .IlluminationServicer_simulation import IlluminationServicerSimulation
from .IlluminationServicer_real import IlluminationServicerReal


class IlluminationServicer(IlluminationServicer_pb2_grpc.IlluminationServicerServicer):
    """
    This is a DASGIP Service
    """
    implementation: Union[IlluminationServicerSimulation, IlluminationServicerReal]
    simulation_mode: bool

    def __init__(self, reactors, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.reactors = reactors
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(IlluminationServicerSimulation(self.reactors))
        else:
            self._inject_implementation(IlluminationServicerReal(self.reactors))

    def _inject_implementation(self,
                               implementation: Union[IlluminationServicerSimulation,
                                                     IlluminationServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the DASGIP_ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(IlluminationServicerSimulation(self.reactors))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(IlluminationServicerReal(self.reactors))

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        logging.debug(
            "GetAccess called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetAccess(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller commandillumination module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        logging.debug(
            "SetCmd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCmd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the illumination module. Controller command (Nothing, Stop, Start)
        """
    
        logging.debug(
            "GetCmd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCmd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller modeillumination module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        logging.debug(
            "SetMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the illumination module. Controller mode (Manual, Automatic).
        """
    
        logging.debug(
            "GetMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetState(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the illumination module. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetState called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetState(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetType(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the illumination module.
        """
    
        logging.debug(
            "GetType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the illumination module.
        """
    
        logging.debug(
            "GetAvailable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetAvailable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function nameillumination module.
        """
    
        logging.debug(
            "GetName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version numberillumination module.
        """
    
        logging.debug(
            "GetVersion called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorAPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAPV_Responses:
        """
        Executes the unobservable command "Get ActuatorA PV"
            Get ActuatorA controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAPV (Current ActuatorA PV): Current ActuatorA controller process value.
        """
    
        logging.debug(
            "GetActuatorAPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorAPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorAPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorA PV Int"
            Get ActuatorA accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAPVInt (Current ActuatorA PV Int): Current ActuatorA accumulated process value.
        """
    
        logging.debug(
            "GetActuatorAPVInt called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorAPVInt(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASource_Responses:
        """
        Executes the unobservable command "Get ActuatorA Source"
            Get ActuatorA source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASource (Current ActuatorA Source): Current ActuatorA Source.
        """
    
        logging.debug(
            "GetActuatorASource called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASource(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorASPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASPM_Responses:
        """
        Executes the unobservable command "Set ActuatorA Manual Setpoint"
            Set the manual ActuatorA setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASPM (ActuatorA Manual Setpoint):
            The manual setpoint of the ActuatorA module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASPMSet (ActuatorA Manual Setpoint Set): The set ActuatorA manual setpoint.
        """
    
        logging.debug(
            "SetActuatorASPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorASPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorASPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASPE_Responses:
        """
        Executes the unobservable command "Set ActuatorA External Setpoint"
            Set the external ActuatorA setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASPE (ActuatorA External Setpoint):
            The external setpoint of the ActuatorA module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASPESet (ActuatorA External Setpoint Set): The set ActuatorA external setpoint.
        """
    
        logging.debug(
            "SetActuatorASPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorASPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASP_Responses:
        """
        Executes the unobservable command "Get ActuatorA SP"
            Get ActuatorA setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASP (Current ActuatorA SP): Current ActuatorA setpoint value
        """
    
        logging.debug(
            "GetActuatorASP called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASP(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPA_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPA"
            Get ActuatorA automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPA (Current ActuatorA SPA): Current ActuatorA automatic setpoint value
        """
    
        logging.debug(
            "GetActuatorASPA called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASPA(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPM_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPM"
            Get ActuatorA manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPM (Current ActuatorA SPM): Current ActuatorA manual setpoint value
        """
    
        logging.debug(
            "GetActuatorASPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPE_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPE"
            Get ActuatorA external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPE (Current ActuatorA SPE): Current ActuatorA external setpoint value
        """
    
        logging.debug(
            "GetActuatorASPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPR_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPR"
            Get ActuatorA remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPR (Current ActuatorA SPR): Current ActuatorA remote setpoint value
        """
    
        logging.debug(
            "GetActuatorASPR called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASPR(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorAMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorAMode_Responses:
        """
        Executes the unobservable command "Set ActuatorA Controller Mode"
            Set the ActuatorA controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorAMode (ActuatorA Controller Mode):
            The controller mode of the ActuatorA module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorAModeSet (ActuatorA Controller Mode Set): The set ActuatorA controller mode.
        """
    
        logging.debug(
            "SetActuatorAMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorAMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorAMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAMode_Responses:
        """
        Executes the unobservable command "Get ActuatorA Controller Mode"
            Get the ActuatorA controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAMode (Current ActuatorA Controller Mode): Current controller mode value of the ActuatorA module. Controller mode (Manual, Automatic).
        """
    
        logging.debug(
            "GetActuatorAMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorAMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorASetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorA SetpointSelect"
            Set the selected ActuatorA setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASetpointSelect (Set ActuatorA SetpointSelect):
            The selected setpoint of the ActuatorA module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASetpointSelectSet (ActuatorA Setpoint selection Set): The set ActuatorA setpoint selection.
        """
    
        logging.debug(
            "SetActuatorASetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorASetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorASetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorA SetpointSelect"
            Get the ActuatorA setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASetpointSelect (Current ActuatorA Setpoint Selection): Current ActuatorA setpoint selection value. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetActuatorASetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorASetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorAAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorA Function Availability"
            Get ActuatorA function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAAvailable (Current ActuatorA Function Availability): Current ActuatorA function availability value.
        """
    
        logging.debug(
            "GetActuatorAAvailable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorAAvailable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorAName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAName_Responses:
        """
        Executes the unobservable command "Get ActuatorA Function Name"
            Get ActuatorA function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAName (Current ActuatorA Function Name): Current ActuatorA function name of the illumination module.
        """
    
        logging.debug(
            "GetActuatorAName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorAName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBPV_Responses:
        """
        Executes the unobservable command "Get ActuatorB PV"
            Get ActuatorB controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBPV (Current ActuatorB PV): Current ActuatorB controller process value.
        """
    
        logging.debug(
            "GetActuatorBPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorB PV Int"
            Get ActuatorB accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBPVInt (Current ActuatorB PV Int): Current ActuatorB accumulated process value.
        """
    
        logging.debug(
            "GetActuatorBPVInt called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBPVInt(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSource_Responses:
        """
        Executes the unobservable command "Get ActuatorB Source"
            Get ActuatorB source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSource (Current ActuatorB Source): Current ActuatorB Source.
        """
    
        logging.debug(
            "GetActuatorBSource called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSource(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorBSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSPM_Responses:
        """
        Executes the unobservable command "Set ActuatorB Manual Setpoint"
            Set the manual ActuatorB setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSPM (ActuatorB Manual Setpoint):
            The manual setpoint of the ActuatorB module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSPMSet (ActuatorB Manual Setpoint Set): The set ActuatorB manual setpoint.
        """
    
        logging.debug(
            "SetActuatorBSPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorBSPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorBSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSPE_Responses:
        """
        Executes the unobservable command "Set ActuatorB External Setpoint"
            Set the external ActuatorB setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSPE (ActuatorB External Setpoint):
            The external setpoint of the ActuatorB module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSPESet (ActuatorB External Setpoint Set): The set ActuatorB external setpoint.
        """
    
        logging.debug(
            "SetActuatorBSPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorBSPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSP_Responses:
        """
        Executes the unobservable command "Get ActuatorB SP"
            Get ActuatorB setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSP (Current ActuatorB SP): Current ActuatorB setpoint value
        """
    
        logging.debug(
            "GetActuatorBSP called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSP(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPA_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPA"
            Get ActuatorB automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPA (Current ActuatorB SPA): Current ActuatorB automatic setpoint value
        """
    
        logging.debug(
            "GetActuatorBSPA called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSPA(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPM_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPM"
            Get ActuatorB manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPM (Current ActuatorB SPM): Current ActuatorB manual setpoint value
        """
    
        logging.debug(
            "GetActuatorBSPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPE_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPE"
            Get ActuatorB external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPE (Current ActuatorB SPE): Current ActuatorB external setpoint value
        """
    
        logging.debug(
            "GetActuatorBSPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPR_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPR"
            Get ActuatorB remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPR (Current ActuatorB SPR): Current ActuatorB remote setpoint value
        """
    
        logging.debug(
            "GetActuatorBSPR called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSPR(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorBMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBMode_Responses:
        """
        Executes the unobservable command "Set ActuatorB Controller Mode"
            Set the ActuatorB controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBMode (ActuatorB Controller Mode):
            The controller mode of the ActuatorB module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBModeSet (ActuatorB Controller Mode Set): The set ActuatorB controller mode.
        """
    
        logging.debug(
            "SetActuatorBMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorBMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBMode_Responses:
        """
        Executes the unobservable command "Get ActuatorB Controller Mode"
            Get the ActuatorB controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBMode (Current ActuatorB Controller Mode): Current controller mode value of the ActuatorB module. Controller mode (Manual, Automatic).
        """
    
        logging.debug(
            "GetActuatorBMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorBSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorB SetpointSelect"
            Set the selected ActuatorB setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSetpointSelect (Set ActuatorB SetpointSelect):
            The selected setpoint of the ActuatorB module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSetpointSelectSet (ActuatorB Setpoint selection Set): The set ActuatorB setpoint selection.
        """
    
        logging.debug(
            "SetActuatorBSetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorBSetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorB SetpointSelect"
            Get the ActuatorB setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSetpointSelect (Current ActuatorB Setpoint Selection): Current ActuatorB setpoint selection value of the illumination module. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetActuatorBSetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBSetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorB Function Availability"
            Get ActuatorB function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBAvailable (Current ActuatorB Function Availability): Current ActuatorB function availability value of the illumination module.
        """
    
        logging.debug(
            "GetActuatorBAvailable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBAvailable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorBName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBName_Responses:
        """
        Executes the unobservable command "Get ActuatorB Function Name"
            Get ActuatorB function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBName (Current ActuatorB Function Name): Current ActuatorB function name of the illumination module.
        """
    
        logging.debug(
            "GetActuatorBName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorBName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCPV_Responses:
        """
        Executes the unobservable command "Get ActuatorC PV"
            Get ActuatorC controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCPV (Current ActuatorC PV): Current ActuatorC controller process value.
        """
    
        logging.debug(
            "GetActuatorCPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorC PV Int"
            Get ActuatorC accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCPVInt (Current ActuatorC PV Int): Current ActuatorC accumulated process value.
        """
    
        logging.debug(
            "GetActuatorCPVInt called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCPVInt(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSource_Responses:
        """
        Executes the unobservable command "Get ActuatorC Source"
            Get ActuatorC source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSource (Current ActuatorC Source): Current ActuatorC Source.
        """
    
        logging.debug(
            "GetActuatorCSource called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSource(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorCSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSPM_Responses:
        """
        Executes the unobservable command "Set ActuatorC Manual Setpoint"
            Set the manual ActuatorC setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSPM (ActuatorC Manual Setpoint):
            The manual setpoint of the ActuatorC module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSPMSet (ActuatorC Manual Setpoint Set): The set ActuatorC manual setpoint.
        """
    
        logging.debug(
            "SetActuatorCSPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorCSPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorCSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSPE_Responses:
        """
        Executes the unobservable command "Set ActuatorC External Setpoint"
            Set the external ActuatorC setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSPE (ActuatorC External Setpoint):
            The external setpoint of the ActuatorC module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSPESet (ActuatorC External Setpoint Set): The set ActuatorC external setpoint.
        """
    
        logging.debug(
            "SetActuatorCSPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorCSPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSP_Responses:
        """
        Executes the unobservable command "Get ActuatorC SP"
            Get ActuatorC setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSP (Current ActuatorC SP): Current ActuatorC setpoint value
        """
    
        logging.debug(
            "GetActuatorCSP called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSP(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPA_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPA"
            Get ActuatorC automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPA (Current ActuatorC SPA): Current ActuatorC automatic setpoint value
        """
    
        logging.debug(
            "GetActuatorCSPA called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSPA(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPM_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPM"
            Get ActuatorC manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPM (Current ActuatorC SPM): Current ActuatorC manual setpoint value
        """
    
        logging.debug(
            "GetActuatorCSPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPE_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPE"
            Get ActuatorC external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPE (Current ActuatorC SPE): Current ActuatorC external setpoint value
        """
    
        logging.debug(
            "GetActuatorCSPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPR_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPR"
            Get ActuatorC remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPR (Current ActuatorC SPR): Current ActuatorC remote setpoint value
        """
    
        logging.debug(
            "GetActuatorCSPR called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSPR(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorCMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCMode_Responses:
        """
        Executes the unobservable command "Set ActuatorC Controller Mode"
            Set the ActuatorC controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCMode (ActuatorC Controller Mode):
            The controller mode of the ActuatorC module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCModeSet (ActuatorC Controller Mode Set): The set ActuatorC controller mode.
        """
    
        logging.debug(
            "SetActuatorCMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorCMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCMode_Responses:
        """
        Executes the unobservable command "Get ActuatorC Controller Mode"
            Get the ActuatorC controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCMode (Current ActuatorC Controller Mode): Current controller mode value of the ActuatorC module. Controller mode (Manual, Automatic).
        """
    
        logging.debug(
            "GetActuatorCMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetActuatorCSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorC SetpointSelect"
            Set the selected ActuatorC setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSetpointSelect (Set ActuatorC SetpointSelect):
            The selected setpoint of the ActuatorC module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSetpointSelectSet (ActuatorC Setpoint selection Set): The set ActuatorC setpoint selection.
        """
    
        logging.debug(
            "SetActuatorCSetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetActuatorCSetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorC SetpointSelect"
            Get the ActuatorC setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSetpointSelect (Current ActuatorC Setpoint Selection): Current ActuatorC setpoint selection value of the illumination module. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetActuatorCSetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCSetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorC Function Availability"
            Get ActuatorC function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCAvailable (Current ActuatorC Function Availability): Current ActuatorC function availability value of the illumination module.
        """
    
        logging.debug(
            "GetActuatorCAvailable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCAvailable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetActuatorCName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCName_Responses:
        """
        Executes the unobservable command "Get ActuatorC Function Name"
            Get ActuatorC function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCName (Current ActuatorC Function Name): Current ActuatorC function name of the illumination module.
        """
    
        logging.debug(
            "GetActuatorCName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetActuatorCName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
