"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Illumination Servicer*

:details: IlluminationServicer:
    Control a DASGIP illumination module. Enables read and write operations for various parameters, including the
    illumination actuators.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    IlluminationServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.068828
:date: (last modification) 2020-04-16T10:19:14.068828

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import IlluminationServicer_pb2 as IlluminationServicer_pb2
# from .gRPC import IlluminationServicer_pb2_grpc as IlluminationServicer_pb2_grpc

# import default arguments
from .IlluminationServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class IlluminationServicerSimulation:
    """
    Implementation of the *Illumination Servicer* in *Simulation* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None
    
        CurrentAccess = 1
        return_value = IlluminationServicer_pb2.GetAccess_Responses(
            CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetAccess_Responses(
                **default_dict['GetAccess_Responses']
            )
    
        return return_value
    
    
    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller commandillumination module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None
    
        CmdSet = 0
        return_value = IlluminationServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetCmd_Responses(
                **default_dict['SetCmd_Responses']
            )
    
        return return_value
    
    
    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the illumination 
            module. Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None
    
        CurrentCmd = 0
        return_value = IlluminationServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetCmd_Responses(
                **default_dict['GetCmd_Responses']
            )
    
        return return_value
    
    
    def SetMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller modeillumination module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        ModeSet = 1
        return_value = IlluminationServicer_pb2.SetMode_Responses(ModeSet=silaFW_pb2.Integer(value=ModeSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetMode_Responses(
                **default_dict['SetMode_Responses']
            )
    
        return return_value
    
    
    def GetMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the illumination module. 
            Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        CurrentMode = 1
        return_value = IlluminationServicer_pb2.GetMode_Responses(CurrentMode=silaFW_pb2.Integer(value=CurrentMode))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetMode_Responses(
                **default_dict['GetMode_Responses']
            )
    
        return return_value
    
    
    def GetState(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the illumination module. 
            Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        CurrentState = 0
        return_value = IlluminationServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetState_Responses(
                **default_dict['GetState_Responses']
            )
    
        return return_value
    
    
    def GetType(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentType = 'SimIlluminationType'
        return_value = IlluminationServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetType_Responses(
                **default_dict['GetType_Responses']
            )
    
        return return_value
    
    
    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentAvailable = 0
        return_value = IlluminationServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetAvailable_Responses(
                **default_dict['GetAvailable_Responses']
            )
    
        return return_value
    
    
    def GetName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function nameillumination module.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentName = 'SimIllumination'
        return_value = IlluminationServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetName_Responses(
                **default_dict['GetName_Responses']
            )
    
        return return_value
    
    
    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version numberillumination module.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentVersion = 'SimIlluminationVersion_1.0'
        return_value = IlluminationServicer_pb2.GetVersion_Responses(
            CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetVersion_Responses(
                **default_dict['GetVersion_Responses']
            )
    
        return return_value
    
    
    def GetActuatorAPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAPV_Responses:
        """
        Executes the unobservable command "Get ActuatorA PV"
            Get ActuatorA controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAPV (Current ActuatorA PV): Current ActuatorA controller process value.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorAPV = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorAPV_Responses(
            CurrentActuatorAPV=silaFW_pb2.Real(value=CurrentActuatorAPV))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorAPV_Responses(
                **default_dict['GetActuatorAPV_Responses']
            )
    
        return return_value
    
    
    def GetActuatorAPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorA PV Int"
            Get ActuatorA accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAPVInt (Current ActuatorA PV Int): Current ActuatorA accumulated process value.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorAPVInt = 0
        return_value = IlluminationServicer_pb2.GetActuatorAPVInt_Responses(
            CurrentActuatorAPVInt=silaFW_pb2.Integer(value=CurrentActuatorAPVInt))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorAPVInt_Responses(
                **default_dict['GetActuatorAPVInt_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASource_Responses:
        """
        Executes the unobservable command "Get ActuatorA Source"
            Get ActuatorA source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASource (Current ActuatorA Source): Current ActuatorA Source.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorASource = 'SimActuatorASource'
        return_value = IlluminationServicer_pb2.GetActuatorASource_Responses(
            CurrentActuatorASource=silaFW_pb2.String(value=CurrentActuatorASource))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASource_Responses(
                **default_dict['GetActuatorASource_Responses']
            )
    
        return return_value
    
    
    def SetActuatorASPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASPM_Responses:
        """
        Executes the unobservable command "Set ActuatorA Manual Setpoint"
            Set the manual ActuatorA setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASPM (ActuatorA Manual Setpoint):
            The manual setpoint of the ActuatorA module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASPMSet (ActuatorA Manual Setpoint Set): The set ActuatorA manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        ActuatorASPMSet = 0.0
        return_value = IlluminationServicer_pb2.SetActuatorASPM_Responses(
            ActuatorASPMSet=silaFW_pb2.Real(value=ActuatorASPMSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorASPM_Responses(
                **default_dict['SetActuatorASPM_Responses']
            )
    
        return return_value
    
    
    def SetActuatorASPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASPE_Responses:
        """
        Executes the unobservable command "Set ActuatorA External Setpoint"
            Set the external ActuatorA setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASPE (ActuatorA External Setpoint):
            The external setpoint of the ActuatorA module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASPESet (ActuatorA External Setpoint Set): The set ActuatorA external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        ActuatorASPESet = 0.0
        return_value = IlluminationServicer_pb2.SetActuatorASPE_Responses(
            ActuatorASPESet=silaFW_pb2.Real(value=ActuatorASPESet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorASPE_Responses(
                **default_dict['SetActuatorASPE_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASP_Responses:
        """
        Executes the unobservable command "Get ActuatorA SP"
            Get ActuatorA setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASP (Current ActuatorA SP): Current ActuatorA setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorASP = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorASP_Responses(
            CurrentActuatorASP=silaFW_pb2.Real(value=CurrentActuatorASP))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASP_Responses(
                **default_dict['GetActuatorASP_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPA_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPA"
            Get ActuatorA automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPA (Current ActuatorA SPA): Current ActuatorA automatic setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorASPA = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorASPA_Responses(
            CurrentActuatorASPA=silaFW_pb2.Real(value=CurrentActuatorASPA))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASPA_Responses(
                **default_dict['GetActuatorASPA_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPM_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPM"
            Get ActuatorA manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPM (Current ActuatorA SPM): Current ActuatorA manual setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorASPM = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorASPM_Responses(
            CurrentActuatorASPM=silaFW_pb2.Real(value=CurrentActuatorASPM))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASPM_Responses(
                **default_dict['GetActuatorASPM_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPE_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPE"
            Get ActuatorA external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPE (Current ActuatorA SPE): Current ActuatorA external setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorASPE = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorASPE_Responses(
            CurrentActuatorASPE=silaFW_pb2.Real(value=CurrentActuatorASPE))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASPE_Responses(
                **default_dict['GetActuatorASPE_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASPR_Responses:
        """
        Executes the unobservable command "Get ActuatorA SPR"
            Get ActuatorA remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASPR (Current ActuatorA SPR): Current ActuatorA remote setpoint value
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorASPR = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorASPR_Responses(
            CurrentActuatorASPR=silaFW_pb2.Real(value=CurrentActuatorASPR))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASPR_Responses(
                **default_dict['GetActuatorASPR_Responses']
            )
    
        return return_value
    
    
    def SetActuatorAMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorAMode_Responses:
        """
        Executes the unobservable command "Set ActuatorA Controller Mode"
            Set the ActuatorA controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorAMode (ActuatorA Controller Mode):
            The controller mode of the ActuatorA module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorAModeSet (ActuatorA Controller Mode Set): The set ActuatorA controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        ActuatorAModeSet = 1
        return_value = IlluminationServicer_pb2.SetActuatorAMode_Responses(
            ActuatorAModeSet=silaFW_pb2.Integer(value=ActuatorAModeSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorAMode_Responses(
                **default_dict['SetActuatorAMode_Responses']
            )
    
        return return_value
    
    
    def GetActuatorAMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAMode_Responses:
        """
        Executes the unobservable command "Get ActuatorA Controller Mode"
            Get the ActuatorA controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAMode (Current ActuatorA Controller Mode): Current controller mode value of the 
            ActuatorA module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorAMode = 1
        return_value = IlluminationServicer_pb2.GetActuatorAMode_Responses(
            CurrentActuatorAMode=silaFW_pb2.Integer(value=CurrentActuatorAMode))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorAMode_Responses(
                **default_dict['GetActuatorAMode_Responses']
            )
    
        return return_value
    
    
    def SetActuatorASetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorA SetpointSelect"
            Set the selected ActuatorA setpoint that should be used. Setpoint selection (Local, Manual, Internal, 
            Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorASetpointSelect (Set ActuatorA SetpointSelect):
            The selected setpoint of the ActuatorA module. Setpoint selection (Local, Manual, Internal, Script, 
            External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorASetpointSelectSet (ActuatorA Setpoint selection Set): The set ActuatorA setpoint selection.
        """
    
        # initialise the return value
        return_value = None

        ActuatorASetpointSelectSet = 2
        return_value = IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses(
            ActuatorASetpointSelectSet=silaFW_pb2.Integer(value=ActuatorASetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorASetpointSelect_Responses(
                **default_dict['SetActuatorASetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetActuatorASetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorA SetpointSelect"
            Get the ActuatorA setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorASetpointSelect (Current ActuatorA Setpoint Selection): Current ActuatorA setpoint 
            selection value. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorASetpointSelect = 2
        return_value = IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses(
            CurrentActuatorASetpointSelect=silaFW_pb2.Integer(value=CurrentActuatorASetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorASetpointSelect_Responses(
                **default_dict['GetActuatorASetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetActuatorAAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorA Function Availability"
            Get ActuatorA function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAAvailable (Current ActuatorA Function Availability): Current ActuatorA function 
            availability value.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorAAvailable = 0
        return_value = IlluminationServicer_pb2.GetActuatorAAvailable_Responses(
            CurrentActuatorAAvailable=silaFW_pb2.Integer(value=CurrentActuatorAAvailable))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorAAvailable_Responses(
                **default_dict['GetActuatorAAvailable_Responses']
            )
    
        return return_value
    
    
    def GetActuatorAName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorAName_Responses:
        """
        Executes the unobservable command "Get ActuatorA Function Name"
            Get ActuatorA function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorAName (Current ActuatorA Function Name): Current ActuatorA function name of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorAName = 'SimActuatorA'
        return_value = IlluminationServicer_pb2.GetActuatorAName_Responses(
            CurrentActuatorAName=silaFW_pb2.String(value=CurrentActuatorAName))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorAName_Responses(
                **default_dict['GetActuatorAName_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBPV_Responses:
        """
        Executes the unobservable command "Get ActuatorB PV"
            Get ActuatorB controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBPV (Current ActuatorB PV): Current ActuatorB controller process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBPV = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorBPV_Responses(
            CurrentActuatorBPV=silaFW_pb2.Real(value=CurrentActuatorBPV))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBPV_Responses(
                **default_dict['GetActuatorBPV_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorB PV Int"
            Get ActuatorB accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBPVInt (Current ActuatorB PV Int): Current ActuatorB accumulated process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBPVInt = 0
        return_value = IlluminationServicer_pb2.GetActuatorBPVInt_Responses(
            CurrentActuatorBPVInt=silaFW_pb2.Integer(value=CurrentActuatorBPVInt))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBPVInt_Responses(
                **default_dict['GetActuatorBPVInt_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSource_Responses:
        """
        Executes the unobservable command "Get ActuatorB Source"
            Get ActuatorB source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSource (Current ActuatorB Source): Current ActuatorB Source.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorBSource = 'SimActuatorBSource'
        return_value = IlluminationServicer_pb2.GetActuatorBSource_Responses(
            CurrentActuatorBSource=silaFW_pb2.String(value=CurrentActuatorBSource))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSource_Responses(
                **default_dict['GetActuatorBSource_Responses']
            )
    
        return return_value
    
    
    def SetActuatorBSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSPM_Responses:
        """
        Executes the unobservable command "Set ActuatorB Manual Setpoint"
            Set the manual ActuatorB setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSPM (ActuatorB Manual Setpoint):
            The manual setpoint of the ActuatorB module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSPMSet (ActuatorB Manual Setpoint Set): The set ActuatorB manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        ActuatorBSPMSet = 0.0
        return_value = IlluminationServicer_pb2.SetActuatorBSPM_Responses(
            ActuatorBSPMSet=silaFW_pb2.Real(value=ActuatorBSPMSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorBSPM_Responses(
                **default_dict['SetActuatorBSPM_Responses']
            )
    
        return return_value
    
    
    def SetActuatorBSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSPE_Responses:
        """
        Executes the unobservable command "Set ActuatorB External Setpoint"
            Set the external ActuatorB setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSPE (ActuatorB External Setpoint):
            The external setpoint of the ActuatorB module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSPESet (ActuatorB External Setpoint Set): The set ActuatorB external setpoint.
        """
    
        # initialise the return value
        return_value = None

        ActuatorBSPESet = 0.0
        return_value = IlluminationServicer_pb2.SetActuatorBSPE_Responses(
            ActuatorBSPESet=silaFW_pb2.Real(value=ActuatorBSPESet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorBSPE_Responses(
                **default_dict['SetActuatorBSPE_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSP_Responses:
        """
        Executes the unobservable command "Get ActuatorB SP"
            Get ActuatorB setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSP (Current ActuatorB SP): Current ActuatorB setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBSP = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorBSP_Responses(
            CurrentActuatorBSP=silaFW_pb2.Real(value=CurrentActuatorBSP))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSP_Responses(
                **default_dict['GetActuatorBSP_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPA_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPA"
            Get ActuatorB automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPA (Current ActuatorB SPA): Current ActuatorB automatic setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBSPA = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorBSPA_Responses(
            CurrentActuatorBSPA=silaFW_pb2.Real(value=CurrentActuatorBSPA))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSPA_Responses(
                **default_dict['GetActuatorBSPA_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPM_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPM"
            Get ActuatorB manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPM (Current ActuatorB SPM): Current ActuatorB manual setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBSPM = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorBSPM_Responses(
            CurrentActuatorBSPM=silaFW_pb2.Real(value=CurrentActuatorBSPM))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSPM_Responses(
                **default_dict['GetActuatorBSPM_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPE_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPE"
            Get ActuatorB external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPE (Current ActuatorB SPE): Current ActuatorB external setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBSPE = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorBSPE_Responses(
            CurrentActuatorBSPE=silaFW_pb2.Real(value=CurrentActuatorBSPE))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSPE_Responses(
                **default_dict['GetActuatorBSPE_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSPR_Responses:
        """
        Executes the unobservable command "Get ActuatorB SPR"
            Get ActuatorB remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSPR (Current ActuatorB SPR): Current ActuatorB remote setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBSPR = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorBSPR_Responses(
            CurrentActuatorBSPR=silaFW_pb2.Real(value=CurrentActuatorBSPR))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSPR_Responses(
                **default_dict['GetActuatorBSPR_Responses']
            )
    
        return return_value
    
    
    def SetActuatorBMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBMode_Responses:
        """
        Executes the unobservable command "Set ActuatorB Controller Mode"
            Set the ActuatorB controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBMode (ActuatorB Controller Mode):
            The controller mode of the ActuatorB module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBModeSet (ActuatorB Controller Mode Set): The set ActuatorB controller mode.
        """
    
        # initialise the return value
        return_value = None

        ActuatorBModeSet = 1
        return_value = IlluminationServicer_pb2.SetActuatorBMode_Responses(
            ActuatorBModeSet=silaFW_pb2.Integer(value=ActuatorBModeSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorBMode_Responses(
                **default_dict['SetActuatorBMode_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBMode_Responses:
        """
        Executes the unobservable command "Get ActuatorB Controller Mode"
            Get the ActuatorB controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBMode (Current ActuatorB Controller Mode): Current controller mode value of the 
            ActuatorB module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBMode = 1
        return_value = IlluminationServicer_pb2.GetActuatorBMode_Responses(
            CurrentActuatorBMode=silaFW_pb2.Integer(value=CurrentActuatorBMode))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBMode_Responses(
                **default_dict['GetActuatorBMode_Responses']
            )
    
        return return_value
    
    
    def SetActuatorBSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorB SetpointSelect"
            Set the selected ActuatorB setpoint that should be used. Setpoint selection (Local, Manual, Internal, 
            Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorBSetpointSelect (Set ActuatorB SetpointSelect):
            The selected setpoint of the ActuatorB module. Setpoint selection (Local, Manual, Internal, Script, 
            External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorBSetpointSelectSet (ActuatorB Setpoint selection Set): The set ActuatorB setpoint selection.
        """
    
        # initialise the return value
        return_value = None

        ActuatorBSetpointSelectSet = 2
        return_value = IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses(
            ActuatorBSetpointSelectSet=silaFW_pb2.Integer(value=ActuatorBSetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorBSetpointSelect_Responses(
                **default_dict['SetActuatorBSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorB SetpointSelect"
            Get the ActuatorB setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBSetpointSelect (Current ActuatorB Setpoint Selection): Current ActuatorB setpoint 
            selection value of the illumination module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBSetpointSelect = 2
        return_value = IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses(
            CurrentActuatorBSetpointSelect=silaFW_pb2.Integer(value=CurrentActuatorBSetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBSetpointSelect_Responses(
                **default_dict['GetActuatorBSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorB Function Availability"
            Get ActuatorB function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBAvailable (Current ActuatorB Function Availability): Current ActuatorB function 
            availability value of the illumination module.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBAvailable = 0
        return_value = IlluminationServicer_pb2.GetActuatorBAvailable_Responses(
            CurrentActuatorBAvailable=silaFW_pb2.Integer(value=CurrentActuatorBAvailable))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBAvailable_Responses(
                **default_dict['GetActuatorBAvailable_Responses']
            )
    
        return return_value
    
    
    def GetActuatorBName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorBName_Responses:
        """
        Executes the unobservable command "Get ActuatorB Function Name"
            Get ActuatorB function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorBName (Current ActuatorB Function Name): Current ActuatorB function name of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorBName = 'SimActuatorB'
        return_value = IlluminationServicer_pb2.GetActuatorBName_Responses(
            CurrentActuatorBName=silaFW_pb2.String(value=CurrentActuatorBName))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorBName_Responses(
                **default_dict['GetActuatorBName_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCPV(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCPV_Responses:
        """
        Executes the unobservable command "Get ActuatorC PV"
            Get ActuatorC controller process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCPV (Current ActuatorC PV): Current ActuatorC controller process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCPV = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorCPV_Responses(
            CurrentActuatorCPV=silaFW_pb2.Real(value=CurrentActuatorCPV))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCPV_Responses(
                **default_dict['GetActuatorCPV_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCPVInt(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCPVInt_Responses:
        """
        Executes the unobservable command "Get ActuatorC PV Int"
            Get ActuatorC accumulated process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCPVInt (Current ActuatorC PV Int): Current ActuatorC accumulated process value.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCPVInt = 0
        return_value = IlluminationServicer_pb2.GetActuatorCPVInt_Responses(
            CurrentActuatorCPVInt=silaFW_pb2.Integer(value=CurrentActuatorCPVInt))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCPVInt_Responses(
                **default_dict['GetActuatorCPVInt_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSource(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSource_Responses:
        """
        Executes the unobservable command "Get ActuatorC Source"
            Get ActuatorC source.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSource (Current ActuatorC Source): Current ActuatorC Source.
        """
    
        # initialise the return value
        return_value = None
    
        CurrentActuatorCSource = 'SimActuatorCSource'
        return_value = IlluminationServicer_pb2.GetActuatorCSource_Responses(
            CurrentActuatorCSource=silaFW_pb2.String(value=CurrentActuatorCSource))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSource_Responses(
                **default_dict['GetActuatorCSource_Responses']
            )
    
        return return_value
    
    
    def SetActuatorCSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSPM_Responses:
        """
        Executes the unobservable command "Set ActuatorC Manual Setpoint"
            Set the manual ActuatorC setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSPM (ActuatorC Manual Setpoint):
            The manual setpoint of the ActuatorC module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSPMSet (ActuatorC Manual Setpoint Set): The set ActuatorC manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        ActuatorCSPMSet = 0.0
        return_value = IlluminationServicer_pb2.SetActuatorCSPM_Responses(
            ActuatorCSPMSet=silaFW_pb2.Real(value=ActuatorCSPMSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorCSPM_Responses(
                **default_dict['SetActuatorCSPM_Responses']
            )
    
        return return_value
    
    
    def SetActuatorCSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSPE_Responses:
        """
        Executes the unobservable command "Set ActuatorC External Setpoint"
            Set the external ActuatorC setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSPE (ActuatorC External Setpoint):
            The external setpoint of the ActuatorC module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSPESet (ActuatorC External Setpoint Set): The set ActuatorC external setpoint.
        """
    
        # initialise the return value
        return_value = None

        ActuatorCSPESet = 0.0
        return_value = IlluminationServicer_pb2.SetActuatorCSPE_Responses(
            ActuatorCSPESet=silaFW_pb2.Real(value=ActuatorCSPESet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorCSPE_Responses(
                **default_dict['SetActuatorCSPE_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSP(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSP_Responses:
        """
        Executes the unobservable command "Get ActuatorC SP"
            Get ActuatorC setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSP (Current ActuatorC SP): Current ActuatorC setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCSP = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorCSP_Responses(
            CurrentActuatorCSP=silaFW_pb2.Real(value=CurrentActuatorCSP))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSP_Responses(
                **default_dict['GetActuatorCSP_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSPA(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPA_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPA"
            Get ActuatorC automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPA (Current ActuatorC SPA): Current ActuatorC automatic setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCSPA = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorCSPA_Responses(
            CurrentActuatorCSPA=silaFW_pb2.Real(value=CurrentActuatorCSPA))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSPA_Responses(
                **default_dict['GetActuatorCSPA_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSPM(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPM_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPM"
            Get ActuatorC manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPM (Current ActuatorC SPM): Current ActuatorC manual setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCSPM = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorCSPM_Responses(
            CurrentActuatorCSPM=silaFW_pb2.Real(value=CurrentActuatorCSPM))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSPM_Responses(
                **default_dict['GetActuatorCSPM_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSPE(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPE_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPE"
            Get ActuatorC external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPE (Current ActuatorC SPE): Current ActuatorC external setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCSPE = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorCSPE_Responses(
            CurrentActuatorCSPE=silaFW_pb2.Real(value=CurrentActuatorCSPE))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSPE_Responses(
                **default_dict['GetActuatorCSPE_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSPR(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSPR_Responses:
        """
        Executes the unobservable command "Get ActuatorC SPR"
            Get ActuatorC remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSPR (Current ActuatorC SPR): Current ActuatorC remote setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCSPR = 0.0
        return_value = IlluminationServicer_pb2.GetActuatorCSPR_Responses(
            CurrentActuatorCSPR=silaFW_pb2.Real(value=CurrentActuatorCSPR))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSPR_Responses(
                **default_dict['GetActuatorCSPR_Responses']
            )
    
        return return_value
    
    
    def SetActuatorCMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCMode_Responses:
        """
        Executes the unobservable command "Set ActuatorC Controller Mode"
            Set the ActuatorC controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCMode (ActuatorC Controller Mode):
            The controller mode of the ActuatorC module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCModeSet (ActuatorC Controller Mode Set): The set ActuatorC controller mode.
        """
    
        # initialise the return value
        return_value = None

        ActuatorCModeSet = 1
        return_value = IlluminationServicer_pb2.SetActuatorCMode_Responses(
            ActuatorCModeSet=silaFW_pb2.Integer(value=ActuatorCModeSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorCMode_Responses(
                **default_dict['SetActuatorCMode_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCMode(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCMode_Responses:
        """
        Executes the unobservable command "Get ActuatorC Controller Mode"
            Get the ActuatorC controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCMode (Current ActuatorC Controller Mode): Current controller mode value of the 
            ActuatorC module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCMode = 1
        return_value = IlluminationServicer_pb2.GetActuatorCMode_Responses(
            CurrentActuatorCMode=silaFW_pb2.Integer(value=CurrentActuatorCMode))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCMode_Responses(
                **default_dict['GetActuatorCMode_Responses']
            )
    
        return return_value
    
    
    def SetActuatorCSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses:
        """
        Executes the unobservable command "Set ActuatorC SetpointSelect"
            Set the selected ActuatorC setpoint that should be used. Setpoint selection (Local, Manual, Internal, 
            Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ActuatorCSetpointSelect (Set ActuatorC SetpointSelect):
            The selected setpoint of the ActuatorC module. Setpoint selection (Local, Manual, Internal, Script, 
            External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ActuatorCSetpointSelectSet (ActuatorC Setpoint selection Set): The set ActuatorC setpoint selection.
        """
    
        # initialise the return value
        return_value = None

        ActuatorCSetpointSelectSet = 2
        return_value = IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses(
            ActuatorCSetpointSelectSet=silaFW_pb2.Integer(value=ActuatorCSetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.SetActuatorCSetpointSelect_Responses(
                **default_dict['SetActuatorCSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses:
        """
        Executes the unobservable command "Get ActuatorC SetpointSelect"
            Get the ActuatorC setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCSetpointSelect (Current ActuatorC Setpoint Selection): Current ActuatorC setpoint 
            selection value of the illumination module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCSetpointSelect = 2
        return_value = IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses(
            CurrentActuatorCSetpointSelect=silaFW_pb2.Integer(value=CurrentActuatorCSetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCSetpointSelect_Responses(
                **default_dict['GetActuatorCSetpointSelect_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCAvailable(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCAvailable_Responses:
        """
        Executes the unobservable command "Get ActuatorC Function Availability"
            Get ActuatorC function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCAvailable (Current ActuatorC Function Availability): Current ActuatorC function 
            availability value of the illumination module.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCAvailable = 0
        return_value = IlluminationServicer_pb2.GetActuatorCAvailable_Responses(
            CurrentActuatorCAvailable=silaFW_pb2.Integer(value=CurrentActuatorCAvailable))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCAvailable_Responses(
                **default_dict['GetActuatorCAvailable_Responses']
            )
    
        return return_value
    
    
    def GetActuatorCName(self, request, context: grpc.ServicerContext) \
            -> IlluminationServicer_pb2.GetActuatorCName_Responses:
        """
        Executes the unobservable command "Get ActuatorC Function Name"
            Get ActuatorC function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentActuatorCName (Current ActuatorC Function Name): Current ActuatorC function name of the 
            illumination module.
        """
    
        # initialise the return value
        return_value = None

        CurrentActuatorCName = 'SimActuatorC'
        return_value = IlluminationServicer_pb2.GetActuatorCName_Responses(
            CurrentActuatorCName=silaFW_pb2.String(value=CurrentActuatorCName))

        # fallback to default
        if return_value is None:
            return_value = IlluminationServicer_pb2.GetActuatorCName_Responses(
                **default_dict['GetActuatorCName_Responses']
            )
    
        return return_value
