"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Offgas Servicer*

:details: OffgasServicer:
    Control a DASGIP offgas module. Enables read and write operations for various parameters.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    OffgasServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.208513
:date: (last modification) 2020-04-16T10:19:14.208513

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import OffgasServicer_pb2 as OffgasServicer_pb2
# from .gRPC import OffgasServicer_pb2_grpc as OffgasServicer_pb2_grpc

# import default arguments
from .OffgasServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class OffgasServicerReal:
    """
    Implementation of the *Offgas Servicer* in *Real* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetCTRPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetCTRPV_Responses:
        """
        Executes the unobservable command "Get CTR PV"
            Get offgas carbondioxide transfer rate process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCTRPV (Current CTR PV): Current offgas carbondioxide transfer rate process value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.CTR_PV
        CurrentCTRPV = node.get_value()
        return_value = OffgasServicer_pb2.GetCTRPV_Responses(CurrentCTRPV=silaFW_pb2.Real(value=CurrentCTRPV))

        return return_value

    def GetFPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetFPV_Responses:
        """
        Executes the unobservable command "Get F PV"
            Get offgas total flow process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFPV (Current F PV): Current offgas total flow process value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.F_PV
        CurrentFPV = node.get_value()
        return_value = OffgasServicer_pb2.GetFPV_Responses(CurrentFPV=silaFW_pb2.Real(value=CurrentFPV))

        return return_value

    def GetOTRPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetOTRPV_Responses:
        """
        Executes the unobservable command "Get OTR PV"
            Get offgas oxygen transfer rate process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentOTRPV (Current OTR PV): Current offgas oxygen transfer rate process value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.OTR_PV
        CurrentOTRPV = node.get_value()
        return_value = OffgasServicer_pb2.GetOTRPV_Responses(CurrentOTRPV=silaFW_pb2.Real(value=CurrentOTRPV))

        return return_value

    def GetRQPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetRQPV_Responses:
        """
        Executes the unobservable command "Get RQ PV"
            Get offgas RQ process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRQPV (Current RQ PV): Current offgas RQ process value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.RQ_PV
        CurrentRQPV = node.get_value()
        return_value = OffgasServicer_pb2.GetRQPV_Responses(CurrentRQPV=silaFW_pb2.Real(value=CurrentRQPV))

        return return_value

    def GetXCO2PV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetXCO2PV_Responses:
        """
        Executes the unobservable command "Get XCO2 PV"
            Get offgas CO2 concentration process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2PV (Current XCO2 PV): Current offgas CO2 concentration process value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.XCO2_PV
        CurrentXCO2PV = node.get_value()
        return_value = OffgasServicer_pb2.GetXCO2PV_Responses(CurrentXCO2PV=silaFW_pb2.Real(value=CurrentXCO2PV))

        return return_value

    def GetVCTPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetVCTPV_Responses:
        """
        Executes the unobservable command "Get VCT PV"
            Get offgas cumulated CO2 transfer rate
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVCTPV (Current VCT PV): Current offgas cumulated CO2 transfer rate
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.VCT_PV
        CurrentVCTPV = node.get_value()
        return_value = OffgasServicer_pb2.GetVCTPV_Responses(CurrentVCTPV=silaFW_pb2.Real(value=CurrentVCTPV))

        return return_value

    def GetVOTPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetVOTPV_Responses:
        """
        Executes the unobservable command "Get VOT PV"
            Get offgas cumulated O2 transfer rate
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVOTPV (Current VOT PV): Current offgas cumulated O2 transfer rate
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.VOT_PV
        CurrentVOTPV = node.get_value()
        return_value = OffgasServicer_pb2.GetVOTPV_Responses(CurrentVOTPV=silaFW_pb2.Real(value=CurrentVOTPV))

        return return_value

    def GetState(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the offgas module.
            Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.status.State
        CurrentState = node.get_value()
        return_value = OffgasServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        return return_value

    def GetType(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the offgas module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.sysinfo.Type
        CurrentType = node.get_value()
        return_value = OffgasServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        return return_value

    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the offgas module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.sysinfo.Available
        CurrentAvailable = node.get_value()
        return_value = OffgasServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        return return_value

    def GetName(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the offgas module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.sysinfo.Name
        CurrentName = node.get_value()
        return_value = OffgasServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        return return_value

    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the offgas
            module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Offgas.sysinfo.Version
        CurrentVersion = node.get_value()
        return_value = OffgasServicer_pb2.GetVersion_Responses(CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        return return_value
