"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Offgas Servicer*

:details: OffgasServicer:
    Control a DASGIP offgas module. Enables read and write operations for various parameters.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    OffgasServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.187870
:date: (last modification) 2020-04-16T10:19:14.187870

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import OffgasServicer_pb2 as OffgasServicer_pb2
from .gRPC import OffgasServicer_pb2_grpc as OffgasServicer_pb2_grpc

# import simulation and real implementation
from .OffgasServicer_simulation import OffgasServicerSimulation
from .OffgasServicer_real import OffgasServicerReal


class OffgasServicer(OffgasServicer_pb2_grpc.OffgasServicerServicer):
    """
    This is a DASGIP Service
    """
    implementation: Union[OffgasServicerSimulation, OffgasServicerReal]
    simulation_mode: bool

    def __init__(self, reactors, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.reactors = reactors
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(OffgasServicerSimulation(self.reactors))
        else:
            self._inject_implementation(OffgasServicerReal(self.reactors))

    def _inject_implementation(self,
                               implementation: Union[OffgasServicerSimulation,
                                                     OffgasServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the DASGIP_ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(OffgasServicerSimulation(self.reactors))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(OffgasServicerReal(self.reactors))

    def GetCTRPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetCTRPV_Responses:
        """
        Executes the unobservable command "Get CTR PV"
            Get offgas carbondioxide transfer rate process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCTRPV (Current CTR PV): Current offgas carbondioxide transfer rate process value
        """
    
        logging.debug(
            "GetCTRPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCTRPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetFPV_Responses:
        """
        Executes the unobservable command "Get F PV"
            Get offgas total flow process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFPV (Current F PV): Current offgas total flow process value
        """
    
        logging.debug(
            "GetFPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetOTRPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetOTRPV_Responses:
        """
        Executes the unobservable command "Get OTR PV"
            Get offgas oxygen transfer rate process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentOTRPV (Current OTR PV): Current offgas oxygen transfer rate process value
        """
    
        logging.debug(
            "GetOTRPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetOTRPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetRQPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetRQPV_Responses:
        """
        Executes the unobservable command "Get RQ PV"
            Get offgas RQ process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentRQPV (Current RQ PV): Current offgas RQ process value
        """
    
        logging.debug(
            "GetRQPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetRQPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetXCO2PV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetXCO2PV_Responses:
        """
        Executes the unobservable command "Get XCO2 PV"
            Get offgas CO2 concentration process value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2PV (Current XCO2 PV): Current offgas CO2 concentration process value
        """
    
        logging.debug(
            "GetXCO2PV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetXCO2PV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVCTPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetVCTPV_Responses:
        """
        Executes the unobservable command "Get VCT PV"
            Get offgas cumulated CO2 transfer rate
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVCTPV (Current VCT PV): Current offgas cumulated CO2 transfer rate
        """
    
        logging.debug(
            "GetVCTPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVCTPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVOTPV(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetVOTPV_Responses:
        """
        Executes the unobservable command "Get VOT PV"
            Get offgas cumulated O2 transfer rate
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVOTPV (Current VOT PV): Current offgas cumulated O2 transfer rate
        """
    
        logging.debug(
            "GetVOTPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVOTPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetState(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the offgas module. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetState called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetState(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetType(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the offgas module.
        """
    
        logging.debug(
            "GetType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the offgas module.
        """
    
        logging.debug(
            "GetAvailable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetAvailable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetName(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the offgas module.
        """
    
        logging.debug(
            "GetName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> OffgasServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the offgas module.
        """
    
        logging.debug(
            "GetVersion called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
