"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Overlay Servicer*

:details: OverlayServicer:
    Control a DASGIP Overlay module. Enables read and write operations for various parameters.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    OverlayServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.468433
:date: (last modification) 2020-04-16T10:19:14.468433

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import OverlayServicer_pb2 as OverlayServicer_pb2
# from .gRPC import OverlayServicer_pb2_grpc as OverlayServicer_pb2_grpc

# import default arguments
from .OverlayServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class OverlayServicerReal:
    """
    Implementation of the *Overlay Servicer* in *Real* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetPV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetPV_Responses:
        """
        Executes the unobservable command "Get PV"
            Get present value. Overlay total flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPV (Current PV): Current present value. Overlay total flow process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.PV
        CurrentPV = node.get_value()
        return_value = OverlayServicer_pb2.GetPV_Responses(CurrentPV=silaFW_pb2.Real(value=CurrentPV))

        return return_value

    def GetSP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetSP_Responses:
        """
        Executes the unobservable command "Get SP"
            Get setpoint value. Overlay total flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSP (Current SP): Current setpoint value. Overlay total flow setpoint.
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.SP
        CurrentSP = node.get_value()
        return_value = OverlayServicer_pb2.GetSP_Responses(CurrentSP=silaFW_pb2.Real(value=CurrentSP))

        return return_value

    def GetFPV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFPV_Responses:
        """
        Executes the unobservable command "Get F PV"
            Get present value. Overlay total flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFPV (Current F PV): Current present value. Overlay total flow process value.
        """
    
        # initialise the return value
        return_value = None
    

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_PV
        CurrentFPV = node.get_value()
        return_value = OverlayServicer_pb2.GetFPV_Responses(CurrentFPV=silaFW_pb2.Real(value=CurrentFPV))

        return return_value

    def GetVPV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetVPV_Responses:
        """
        Executes the unobservable command "Get V PV"
            Get present value. Overlay total volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVPV (Current V PV): Current present value. Overlay total volume process value.
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.V_PV
        CurrentVPV = node.get_value()
        return_value = OverlayServicer_pb2.GetVPV_Responses(CurrentVPV=silaFW_pb2.Real(value=CurrentVPV))

        return return_value

    def GetFSP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSP_Responses:
        """
        Executes the unobservable command "Get Flow SP"
            Get overlay total flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSP (Current Flow SP): Current overlay total flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SP
        CurrentFSP = node.get_value()
        return_value = OverlayServicer_pb2.GetFSP_Responses(CurrentFSP=silaFW_pb2.Real(value=CurrentFSP))

        return return_value

    def SetFSPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFSPM_Responses:
        """
        Executes the unobservable command "Set Flow SPM"
            Set overlay total flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FSPM (Flow Setpoint Manual):
            The overlay total flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FSPMSet (Flow Setpoint Manual Set): The set manual overlay total flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.F_SPM = request.FSPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPM
        FSPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFSPM_Responses(FSPMSet=silaFW_pb2.Real(value=FSPMSet))

        return return_value

    def GetFSPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSPM_Responses:
        """
        Executes the unobservable command "Get Flow SP Manual"
            Get overlay total flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPM (Current Flow SP Manual): Current overlay total flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPM
        CurrentFSPM = node.get_value()
        return_value = OverlayServicer_pb2.GetFSPM_Responses(CurrentFSPM=silaFW_pb2.Real(value=CurrentFSPM))

        return return_value

    def SetFSPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFSPE_Responses:
        """
        Executes the unobservable command "Set Flow SPE"
            Set overlay total flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FSPE (Flow Setpoint External):
            The overlay total flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FSPESet (Flow Setpoint External Set): The set external overlay total flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.F_SPE = request.FSPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPE
        FSPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetFSPE_Responses(FSPESet=silaFW_pb2.Real(value=FSPESet))

        return return_value

    def GetFSPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSPE_Responses:
        """
        Executes the unobservable command "Get Flow SP External"
            Get overlay total flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPE (Current Flow SP External): Current overlay total flow external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPE
        CurrentFSPE = node.get_value()
        return_value = OverlayServicer_pb2.GetFSPE_Responses(CurrentFSPE=silaFW_pb2.Real(value=CurrentFSPE))

        return return_value

    def GetFSPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSPA_Responses:
        """
        Executes the unobservable command "Get Flow SP Automatic"
            Get overlay total flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPA (Current Flow SP Automatic): Current overlay total flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPA
        CurrentFSPA = node.get_value()
        return_value = OverlayServicer_pb2.GetFSPA_Responses(CurrentFSPA=silaFW_pb2.Real(value=CurrentFSPA))

        return return_value

    def GetFSPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSPR_Responses:
        """
        Executes the unobservable command "Get Flow SP Remote"
            Get overlay total flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPR (Current Flow SP Remote): Current overlay total flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPR
        CurrentFSPR = node.get_value()
        return_value = OverlayServicer_pb2.GetFSPR_Responses(CurrentFSPR=silaFW_pb2.Real(value=CurrentFSPR))

        return return_value

    def GetFSPL(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSPL_Responses:
        """
        Executes the unobservable command "Get Flow SP Local"
            Get overlay total flow local setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSPL (Current Flow SP Local): Current overlay total flow local setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_SPL
        CurrentFSPL = node.get_value()
        return_value = OverlayServicer_pb2.GetFSPL_Responses(CurrentFSPL=silaFW_pb2.Real(value=CurrentFSPL))

        return return_value

    def SetFMode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFMode_Responses:
        """
        Executes the unobservable command "Set Flow Mode"
            Set gas total flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FMode (Flow Mode):
            Set gas total flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FModeSet (Flow Mode Set): The set gas total flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.F_Mode = request.FMode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_Mode
        FModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFMode_Responses(FModeSet=silaFW_pb2.Integer(value=FModeSet))

        return return_value

    def GetFMode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFMode_Responses:
        """
        Executes the unobservable command "Get Flow Mode"
            Get gas total flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFMode (Current Flow Mode): Current gas total flow operation mode. Controller mode
            (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.F_Mode
        CurrentFMode = node.get_value()
        return_value = OverlayServicer_pb2.GetFMode_Responses(CurrentFMode=silaFW_pb2.Integer(value=CurrentFMode))

        return return_value

    def SetFSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFSetpointSelect_Responses:
        """
        Executes the unobservable command "Set Flow SetpointSelect"
            Set gas total flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FSetpointSelect (Flow SetpointSelect):
            Set gas total flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FSetpointSelectSet (Flow SetpointSelect Set): The set gas total flow setpoint selection (Local,
            Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.FSetpointSelect = request.FSetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FSetpointSelect
        FSetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFSetpointSelect_Responses(
            FSetpointSelectSet=silaFW_pb2.Integer(value=FSetpointSelectSet))

        return return_value

    def GetFSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFSetpointSelect_Responses:
        """
        Executes the unobservable command "Get Flow SetpointSelect"
            Get gas total flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFSetpointSelect (Current Flow SetpointSelect): Current gas total flow setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FSetpointSelect
        CurrentFSetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetFSetpointSelect_Responses(
            CurrentFSetpointSelect=silaFW_pb2.Integer(value=CurrentFSetpointSelect))

        return return_value

    def GetXCO2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2PV_Responses:
        """
        Executes the unobservable command "Get XCO2 PV"
            Get present value. Overlay XCO2 concentration process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2PV (Current XCO2 PV): Current present value. Overlay XCO2 concentration process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_PV
        CurrentXCO2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2PV_Responses(CurrentXCO2PV=silaFW_pb2.Real(value=CurrentXCO2PV))

        return return_value

    def GetXCO2SP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SP_Responses:
        """
        Executes the unobservable command "Get XCO2 SP"
            Get overlay XCO2 concentration setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SP (Current XCO2 SP): Current overlay XCO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SP
        CurrentXCO2SP = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SP_Responses(CurrentXCO2SP=silaFW_pb2.Real(value=CurrentXCO2SP))

        return return_value

    def SetXCO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXCO2SPM_Responses:
        """
        Executes the unobservable command "Set XCO2 SPM"
            Set overlay XCO2 concentration setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XCO2SPM (XCO2 Setpoint Manual):
            The overlay XCO2 concentration setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2SPMSet (XCO2 Setpoint Manual Set): The set manual overlay XCO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPM = request.XCO2SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPM
        XCO2SPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetXCO2SPM_Responses(XCO2SPMSet=silaFW_pb2.Real(value=XCO2SPMSet))

        return return_value

    def GetXCO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SPM_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Manual"
            Get overlay XCO2 concentration manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPM (Current XCO2 SP Manual): Current overlay XCO2 concentration manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPM
        CurrentXCO2SPM = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SPM_Responses(CurrentXCO2SPM=silaFW_pb2.Real(value=CurrentXCO2SPM))

        return return_value

    def SetXCO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXCO2SPE_Responses:
        """
        Executes the unobservable command "Set XCO2 SPE"
            Set overlay XCO2 concentration setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XCO2SPE (XCO2 Setpoint External):
            The overlay XCO2 concentration setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2SPESet (XCO2 Setpoint External Set): The set external overlay XCO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPE = request.XCO2SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPE
        XCO2SPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetXCO2SPE_Responses(XCO2SPESet=silaFW_pb2.Real(value=XCO2SPESet))

        return return_value

    def GetXCO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SPE_Responses:
        """
        Executes the unobservable command "Get XCO2 SP External"
            Get overlay XCO2 concentration external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPE (Current XCO2 SP External): Current overlay XCO2 concentration external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPE
        CurrentXCO2SPE = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SPE_Responses(CurrentXCO2SPE=silaFW_pb2.Real(value=CurrentXCO2SPE))

        return return_value
    
    
    def GetXCO2SPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SPA_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Automatic"
            Get overlay XCO2 concentration automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPA (Current XCO2 SP Automatic): Current overlay XCO2 concentration automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPA
        CurrentXCO2SPA = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SPA_Responses(CurrentXCO2SPA=silaFW_pb2.Real(value=CurrentXCO2SPA))

        return return_value

    def GetXCO2SPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SPR_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Remote"
            Get overlay XCO2 concentration remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPR (Current XCO2 SP Remote): Current overlay XCO2 concentration remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPR
        CurrentXCO2SPR = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SPR_Responses(CurrentXCO2SPR=silaFW_pb2.Real(value=CurrentXCO2SPR))

        return return_value

    def GetXCO2SPL(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SPL_Responses:
        """
        Executes the unobservable command "Get XCO2 SP Local"
            Get overlay XCO2 concentration local setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SPL (Current XCO2 SP Local): Current overlay XCO2 concentration local setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_SPL
        CurrentXCO2SPL = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SPL_Responses(CurrentXCO2SPL=silaFW_pb2.Real(value=CurrentXCO2SPL))

        return return_value

    def SetXCO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXCO2Mode_Responses:
        """
        Executes the unobservable command "Set XCO2 Mode"
            Set gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XCO2Mode (XCO2 Mode):
            Set gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2ModeSet (XCO2 Mode Set): The set gas XCO2 concentration operation mode. Controller mode
            (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.XCO2_Mode = request.XCO2Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_Mode
        XCO2ModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetXCO2Mode_Responses(XCO2ModeSet=silaFW_pb2.Integer(value=XCO2ModeSet))

        return return_value

    def GetXCO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2Mode_Responses:
        """
        Executes the unobservable command "Get XCO2 Mode"
            Get gas XCO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2Mode (Current XCO2 Mode): Current gas XCO2 concentration operation mode. Controller mode
            (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XCO2_Mode
        CurrentXCO2Mode = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2Mode_Responses(
            CurrentXCO2Mode=silaFW_pb2.Integer(value=CurrentXCO2Mode))

        return return_value

    def SetXCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set XCO2 SetpointSelect"
            Set gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XCO2SetpointSelect (XCO2 SetpointSelect):
            Set gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XCO2SetpointSelectSet (XCO2 SetpointSelect Set): The set gas XCO2 concentration setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.XCO2SetpointSelect = request.XCO2SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.XCO2SetpointSelect
        XCO2SetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetXCO2SetpointSelect_Responses(
            XCO2SetpointSelectSet=silaFW_pb2.Integer(value=XCO2SetpointSelectSet))

        return return_value

    def GetXCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get XCO2 SetpointSelect"
            Get gas XCO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXCO2SetpointSelect (Current XCO2 SetpointSelect): Current gas XCO2 concentration setpoint
            selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.XCO2SetpointSelect
        CurrentXCO2SetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetXCO2SetpointSelect_Responses(
            CurrentXCO2SetpointSelect=silaFW_pb2.Integer(value=CurrentXCO2SetpointSelect))

        return return_value

    def GetXO2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2PV_Responses:
        """
        Executes the unobservable command "Get XO2 PV"
            Get present value. Overlay XO2 concentration process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2PV (Current XO2 PV): Current present value. Overlay XO2 concentration process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_PV
        CurrentXO2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2PV_Responses(CurrentXO2PV=silaFW_pb2.Real(value=CurrentXO2PV))

        return return_value

    def GetXO2SP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SP_Responses:
        """
        Executes the unobservable command "Get XO2 SP"
            Get overlay XO2 concentration setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SP (Current XO2 SP): Current overlay XO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SP
        CurrentXO2SP = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SP_Responses(CurrentXO2SP=silaFW_pb2.Real(value=CurrentXO2SP))

        return return_value

    def SetXO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXO2SPM_Responses:
        """
        Executes the unobservable command "Set XO2 SPM"
            Set overlay XO2 concentration setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XO2SPM (XO2 Setpoint Manual):
            The overlay XO2 concentration setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2SPMSet (XO2 Setpoint Manual Set): The set manual overlay XO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.XO2_SPM = request.XO2SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPM
        XO2SPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetXO2SPM_Responses(XO2SPMSet=silaFW_pb2.Real(value=XO2SPMSet))

        return return_value

    def GetXO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SPM_Responses:
        """
        Executes the unobservable command "Get XO2 SP Manual"
            Get overlay XO2 concentration manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPM (Current XO2 SP Manual): Current overlay XO2 concentration manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPM
        CurrentXO2SPM = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SPM_Responses(CurrentXO2SPM=silaFW_pb2.Real(value=CurrentXO2SPM))

        return return_value

    def SetXO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXO2SPE_Responses:
        """
        Executes the unobservable command "Set XO2 SPE"
            Set overlay XO2 concentration setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.XO2SPE (XO2 Setpoint External):
            The overlay XO2 concentration setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2SPESet (XO2 Setpoint External Set): The set external overlay XO2 concentration setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.XO2_SPE = request.XO2SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPE
        XO2SPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetXO2SPE_Responses(XO2SPESet=silaFW_pb2.Real(value=XO2SPESet))

        return return_value

    def GetXO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SPE_Responses:
        """
        Executes the unobservable command "Get XO2 SP External"
            Get overlay XO2 concentration external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPE (Current XO2 SP External): Current overlay XO2 concentration external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPE
        CurrentXO2SPE = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SPE_Responses(CurrentXO2SPE=silaFW_pb2.Real(value=CurrentXO2SPE))

        return return_value

    def GetXO2SPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SPA_Responses:
        """
        Executes the unobservable command "Get XO2 SP Automatic"
            Get overlay XO2 concentration automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPA (Current XO2 SP Automatic): Current overlay XO2 concentration automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPA
        CurrentXO2SPA = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SPA_Responses(CurrentXO2SPA=silaFW_pb2.Real(value=CurrentXO2SPA))

        return return_value

    def GetXO2SPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SPR_Responses:
        """
        Executes the unobservable command "Get XO2 SP Remote"
            Get overlay XO2 concentration remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPR (Current XO2 SP Remote): Current overlay XO2 concentration remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPR
        CurrentXO2SPR = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SPR_Responses(CurrentXO2SPR=silaFW_pb2.Real(value=CurrentXO2SPR))

        return return_value

    def GetXO2SPL(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SPL_Responses:
        """
        Executes the unobservable command "Get XO2 SP Local"
            Get overlay XO2 concentration local setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SPL (Current XO2 SP Local): Current overlay XO2 concentration local setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_SPL
        CurrentXO2SPL = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SPL_Responses(CurrentXO2SPL=silaFW_pb2.Real(value=CurrentXO2SPL))

        return return_value

    def SetXO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXO2Mode_Responses:
        """
        Executes the unobservable command "Set XO2 Mode"
            Set gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XO2Mode (XO2 Mode):
            Set gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2ModeSet (XO2 Mode Set): The set gas XO2 concentration operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.XO2_Mode = request.XO2Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_Mode
        XO2ModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetXO2Mode_Responses(XO2ModeSet=silaFW_pb2.Integer(value=XO2ModeSet))

        return return_value

    def GetXO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2Mode_Responses:
        """
        Executes the unobservable command "Get XO2 Mode"
            Get gas XO2 concentration operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2Mode (Current XO2 Mode): Current gas XO2 concentration operation mode. Controller mode
            (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.XO2_Mode
        CurrentXO2Mode = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2Mode_Responses(CurrentXO2Mode=silaFW_pb2.Integer(value=CurrentXO2Mode))

        return return_value

    def SetXO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetXO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set XO2 SetpointSelect"
            Set gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.XO2SetpointSelect (XO2 SetpointSelect):
            Set gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.XO2SetpointSelectSet (XO2 SetpointSelect Set): The set gas XO2 concentration setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.XO2SetpointSelect = request.XO2SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.XO2SetpointSelect
        XO2SetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetXO2SetpointSelect_Responses(
            XO2SetpointSelectSet=silaFW_pb2.Integer(value=XO2SetpointSelectSet))

        return return_value

    def GetXO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetXO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get XO2 SetpointSelect"
            Get gas XO2 concentration setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentXO2SetpointSelect (Current XO2 SetpointSelect): Current gas XO2 concentration setpoint
            selection (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.XO2SetpointSelect
        CurrentXO2SetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetXO2SetpointSelect_Responses(
            CurrentXO2SetpointSelect=silaFW_pb2.Integer(value=CurrentXO2SetpointSelect))

        return return_value

    def GetFAirPV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirPV_Responses:
        """
        Executes the unobservable command "Get FAir PV"
            Get present value. Overlay air flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirPV (Current FAir PV): Current present value. Overlay air flow process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_PV
        CurrentFAirPV = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirPV_Responses(
            CurrentFAirPV=silaFW_pb2.Real(value=CurrentFAirPV))

        return return_value

    def GetVAirPV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetVAirPV_Responses:
        """
        Executes the unobservable command "Get V Air PV"
            Get present value. Overlay air flow volume value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVAirPV (Current V Air PV): Current present value. Overlay air flow volume value
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.VAir_PV
        CurrentVAirPV = node.get_value()
        return_value = OverlayServicer_pb2.GetVAirPV_Responses(
            CurrentVAirPV=silaFW_pb2.Real(value=CurrentVAirPV))

        return return_value

    def GetFAirSP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirSP_Responses:
        """
        Executes the unobservable command "Get FAir SP"
            Get overlay air flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSP (Current FAir SP): Current overlay air flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SP
        CurrentFAirSP = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirSP_Responses(CurrentFAirSP=silaFW_pb2.Real(value=CurrentFAirSP))

        return return_value

    def SetFAirSPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFAirSPM_Responses:
        """
        Executes the unobservable command "Set FAir SPM"
            Set overlay air flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FAirSPM (FAir Setpoint Manual):
            The overlay air flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirSPMSet (FAir Setpoint Manual Set): The set manual overlay air flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FAir_SPM = request.FAirSPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SPM
        FAirSPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFAirSPM_Responses(FAirSPMSet=silaFW_pb2.Real(value=FAirSPMSet))

        return return_value

    def GetFAirSPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirSPM_Responses:
        """
        Executes the unobservable command "Get FAir SP Manual"
            Get overlay air flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPM (Current FAir SP Manual): Current overlay air flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SPM
        CurrentFAirSPM = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirSPM_Responses(CurrentFAirSPM=silaFW_pb2.Real(value=CurrentFAirSPM))

        return return_value

    def SetFAirSPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFAirSPE_Responses:
        """
        Executes the unobservable command "Set FAir SPE"
            Set overlay air flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FAirSPE (FAir Setpoint External):
            The overlay air flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirSPESet (FAir Setpoint External Set): The set external overlay air flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FAir_SPE = request.FAirSPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SPE
        FAirSPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetFAirSPE_Responses(FAirSPESet=silaFW_pb2.Real(value=FAirSPESet))

        return return_value

    def GetFAirSPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirSPE_Responses:
        """
        Executes the unobservable command "Get FAir SP External"
            Get overlay air flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPE (Current FAir SP External): Current overlay air flow external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SPE
        CurrentFAirSPE = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirSPE_Responses(CurrentFAirSPE=silaFW_pb2.Real(value=CurrentFAirSPE))

        return return_value

    def GetFAirSPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirSPA_Responses:
        """
        Executes the unobservable command "Get FAir SP Automatic"
            Get overlay air flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPA (Current FAir SP Automatic): Current overlay air flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SPA
        CurrentFAirSPA = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirSPA_Responses(CurrentFAirSPA=silaFW_pb2.Real(value=CurrentFAirSPA))

        return return_value

    def GetFAirSPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirSPR_Responses:
        """
        Executes the unobservable command "Get FAir SP Remote"
            Get overlay air flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSPR (Current FAir SP Remote): Current overlay air flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_SPR
        CurrentFAirSPR = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirSPR_Responses(CurrentFAirSPR=silaFW_pb2.Real(value=CurrentFAirSPR))

        return return_value

    def SetFAirMode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFAirMode_Responses:
        """
        Executes the unobservable command "Set FAir Mode"
            Set gas air flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FAirMode (FAir Mode):
            Set gas air flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirModeSet (FAir Mode Set): The set gas air flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FAir_Mode = request.FAirMode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_Mode
        FAirModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFAirMode_Responses(FAirModeSet=silaFW_pb2.Integer(value=FAirModeSet))

        return return_value

    def GetFAirMode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirMode_Responses:
        """
        Executes the unobservable command "Get FAir Mode"
            Get gas air flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirMode (Current FAir Mode): Current gas air flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FAir_Mode
        CurrentFAirMode = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirMode_Responses(
            CurrentFAirMode=silaFW_pb2.Integer(value=CurrentFAirMode))

        return return_value

    def SetFAirSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFAirSetpointSelect_Responses:
        """
        Executes the unobservable command "Set FAir SetpointSelect"
            Set gas air flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FAirSetpointSelect (FAir SetpointSelect):
            Set gas air flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FAirSetpointSelectSet (FAir SetpointSelect Set): The set gas air flow setpoint selection (Local,
            Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.FAirSetpointSelect = request.FAirSetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FAirSetpointSelect
        FAirSetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFAirSetpointSelect_Responses(
            FAirSetpointSelectSet=silaFW_pb2.Integer(value=FAirSetpointSelectSet))

        return return_value

    def GetFAirSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFAirSetpointSelect_Responses:
        """
        Executes the unobservable command "Get FAir SetpointSelect"
            Get gas air flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFAirSetpointSelect (Current FAir SetpointSelect): Current gas air flow setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FAirSetpointSelect
        CurrentFAirSetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetFAirSetpointSelect_Responses(
            CurrentFAirSetpointSelect=silaFW_pb2.Integer(value=CurrentFAirSetpointSelect))

        return return_value

    def GetFO2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2PV_Responses:
        """
        Executes the unobservable command "Get FO2 PV"
            Get present value. Overlay O2 flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2PV (Current FO2 PV): Current present value. Overlay O2 flow process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_PV
        CurrentFO2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2PV_Responses(CurrentFO2PV=silaFW_pb2.Real(value=CurrentFO2PV))

        return return_value

    def GetVO2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetVO2PV_Responses:
        """
        Executes the unobservable command "Get V O2 PV"
            Get present value. Overlay O2 volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVO2PV (Current V O2 PV): Current present value. Overlay O2 volume process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.VO2_PV
        CurrentVO2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetVO2PV_Responses(CurrentVO2PV=silaFW_pb2.Real(value=CurrentVO2PV))

        return return_value

    def GetFO2SP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2SP_Responses:
        """
        Executes the unobservable command "Get FO2 SP"
            Get overlay O2 flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SP (Current FO2 SP): Current overlay O2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SP
        CurrentFO2SP = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2SP_Responses(CurrentFO2SP=silaFW_pb2.Real(value=CurrentFO2SP))

        return return_value

    def SetFO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFO2SPM_Responses:
        """
        Executes the unobservable command "Set FO2 SPM"
            Set overlay O2 flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FO2SPM (FO2 Setpoint Manual):
            The overlay O2 flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2SPMSet (FO2 Setpoint Manual Set): The set manual overlay O2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FO2_SPM = request.FO2SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SPM
        FO2SPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFO2SPM_Responses(FO2SPMSet=silaFW_pb2.Real(value=FO2SPMSet))
    
        return return_value

    def GetFO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2SPM_Responses:
        """
        Executes the unobservable command "Get FO2 SP Manual"
            Get overlay O2 flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPM (Current FO2 SP Manual): Current overlay O2 flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SPM
        CurrentFO2SPM = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2SPM_Responses(CurrentFO2SPM=silaFW_pb2.Real(value=CurrentFO2SPM))

        return return_value

    def SetFO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFO2SPE_Responses:
        """
        Executes the unobservable command "Set FO2 SPE"
            Set overlay O2 flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FO2SPE (FO2 Setpoint External):
            The overlay O2 flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2SPESet (FO2 Setpoint External Set): The set external overlay O2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FO2_SPE = request.FO2SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SPE
        FO2SPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetFO2SPE_Responses(FO2SPESet=silaFW_pb2.Real(value=FO2SPESet))

        return return_value

    def GetFO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2SPE_Responses:
        """
        Executes the unobservable command "Get FO2 SP External"
            Get overlay O2 flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPE (Current FO2 SP External): Current overlay O2 flow external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SPE
        CurrentFO2SPE = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2SPE_Responses(CurrentFO2SPE=silaFW_pb2.Real(value=CurrentFO2SPE))

        return return_value

    def GetFO2SPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2SPA_Responses:
        """
        Executes the unobservable command "Get FO2 SP Automatic"
            Get overlay O2 flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPA (Current FO2 SP Automatic): Current overlay O2 flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SPA
        CurrentFO2SPA = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2SPA_Responses(CurrentFO2SPA=silaFW_pb2.Real(value=CurrentFO2SPA))

        return return_value

    def GetFO2SPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2SPR_Responses:
        """
        Executes the unobservable command "Get FO2 SP Remote"
            Get overlay O2 flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SPR (Current FO2 SP Remote): Current overlay O2 flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_SPR
        CurrentFO2SPR = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2SPR_Responses(CurrentFO2SPR=silaFW_pb2.Real(value=CurrentFO2SPR))

        return return_value

    def SetFO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFO2Mode_Responses:
        """
        Executes the unobservable command "Set FO2 Mode"
            Set gas O2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FO2Mode (FO2 Mode):
            Set gas O2 flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2ModeSet (FO2 Mode Set): The set gas O2 flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FO2_Mode = request.FO2Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_Mode
        FO2ModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFO2Mode_Responses(FO2ModeSet=silaFW_pb2.Integer(value=FO2ModeSet))

        return return_value

    def GetFO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2Mode_Responses:
        """
        Executes the unobservable command "Get FO2 Mode"
            Get gas O2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2Mode (Current FO2 Mode): Current gas O2 flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FO2_Mode
        CurrentFO2Mode = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2Mode_Responses(CurrentFO2Mode=silaFW_pb2.Integer(value=CurrentFO2Mode))

        return return_value

    def SetFO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set FO2 SetpointSelect"
            Set gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FO2SetpointSelect (FO2 SetpointSelect):
            Set gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FO2SetpointSelectSet (FO2 SetpointSelect Set): The set gas O2 flow setpoint selection (Local,
            Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.FO2SetpointSelect = request.FO2SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FO2SetpointSelect
        FO2SetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFO2SetpointSelect_Responses(
            FO2SetpointSelectSet=silaFW_pb2.Integer(value=FO2SetpointSelectSet))

        return return_value

    def GetFO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get FO2 SetpointSelect"
            Get gas O2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFO2SetpointSelect (Current FO2 SetpointSelect): Current gas O2 flow setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FO2SetpointSelect
        CurrentFO2SetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetFO2SetpointSelect_Responses(
            CurrentFO2SetpointSelect=silaFW_pb2.Integer(value=CurrentFO2SetpointSelect))

        return return_value

    def GetFCO2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2PV_Responses:
        """
        Executes the unobservable command "Get FCO2 PV"
            Get present value. Overlay CO2  flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2PV (Current FCO2 PV): Current present value. Overlay CO2  flow process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_PV
        CurrentFCO2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2PV_Responses(CurrentFCO2PV=silaFW_pb2.Real(value=CurrentFCO2PV))

        return return_value

    def GetVCO2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetVCO2PV_Responses:
        """
        Executes the unobservable command "Get V CO2 PV"
            Get present value. Overlay CO2 volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVCO2PV (Current V CO2 PV): Current present value. Overlay CO2 volume process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.VCO2_PV
        CurrentVCO2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetVCO2PV_Responses(CurrentVCO2PV=silaFW_pb2.Real(value=CurrentVCO2PV))

        return return_value

    def GetFCO2SP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2SP_Responses:
        """
        Executes the unobservable command "Get FCO2 SP"
            Get overlay CO2  flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SP (Current FCO2 SP): Current overlay CO2  flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SP
        CurrentFCO2SP = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2SP_Responses(CurrentFCO2SP=silaFW_pb2.Real(value=CurrentFCO2SP))

        return return_value

    def SetFCO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFCO2SPM_Responses:
        """
        Executes the unobservable command "Set FCO2 SPM"
            Set overlay CO2  flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FCO2SPM (FCO2 Setpoint Manual):
            The overlay CO2  flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2SPMSet (FCO2 Setpoint Manual Set): The set manual overlay CO2  flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPM = request.FCO2SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPM
        FCO2SPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFCO2SPM_Responses(FCO2SPMSet=silaFW_pb2.Real(value=FCO2SPMSet))

        return return_value

    def GetFCO2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2SPM_Responses:
        """
        Executes the unobservable command "Get FCO2 SP Manual"
            Get overlay CO2  flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPM (Current FCO2 SP Manual): Current overlay CO2  flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPM
        CurrentFCO2SPM = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2SPM_Responses(CurrentFCO2SPM=silaFW_pb2.Real(value=CurrentFCO2SPM))

        return return_value

    def SetFCO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFCO2SPE_Responses:
        """
        Executes the unobservable command "Set FCO2 SPE"
            Set overlay CO2  flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FCO2SPE (FCO2 Setpoint External):
            The overlay CO2  flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2SPESet (FCO2 Setpoint External Set): The set external overlay CO2  flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPE = request.FCO2SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPE
        FCO2SPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetFCO2SPE_Responses(FCO2SPESet=silaFW_pb2.Real(value=FCO2SPESet))

        return return_value

    def GetFCO2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2SPE_Responses:
        """
        Executes the unobservable command "Get FCO2 SP External"
            Get overlay CO2  flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPE (Current FCO2 SP External): Current overlay CO2  flow external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPE
        CurrentFCO2SPE = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2SPE_Responses(CurrentFCO2SPE=silaFW_pb2.Real(value=CurrentFCO2SPE))

        return return_value

    def GetFCO2SPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2SPA_Responses:
        """
        Executes the unobservable command "Get FCO2 SP Automatic"
            Get overlay CO2  flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPA (Current FCO2 SP Automatic): Current overlay CO2  flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPA
        CurrentFCO2SPA = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2SPA_Responses(CurrentFCO2SPA=silaFW_pb2.Real(value=CurrentFCO2SPA))

        return return_value

    def GetFCO2SPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2SPR_Responses:
        """
        Executes the unobservable command "Get FCO2 SP Remote"
            Get overlay CO2  flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SPR (Current FCO2 SP Remote): Current overlay CO2  flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_SPR
        CurrentFCO2SPR = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2SPR_Responses(CurrentFCO2SPR=silaFW_pb2.Real(value=CurrentFCO2SPR))

        return return_value

    def SetFCO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFCO2Mode_Responses:
        """
        Executes the unobservable command "Set FCO2 Mode"
            Set gas CO2  flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FCO2Mode (FCO2 Mode):
            Set gas CO2  flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2ModeSet (FCO2 Mode Set): The set gas CO2  flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FCO2_Mode = request.FCO2Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_Mode
        FCO2ModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFCO2Mode_Responses(FCO2ModeSet=silaFW_pb2.Integer(value=FCO2ModeSet))

        return return_value

    def GetFCO2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2Mode_Responses:
        """
        Executes the unobservable command "Get FCO2 Mode"
            Get gas CO2  flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2Mode (Current FCO2 Mode): Current gas CO2  flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FCO2_Mode
        CurrentFCO2Mode = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2Mode_Responses(
            CurrentFCO2Mode=silaFW_pb2.Integer(value=CurrentFCO2Mode))

        return return_value

    def SetFCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set FCO2 SetpointSelect"
            Set gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FCO2SetpointSelect (FCO2 SetpointSelect):
            Set gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FCO2SetpointSelectSet (FCO2 SetpointSelect Set): The set gas CO2  flow setpoint selection (Local,
            Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.FCO2SetpointSelect = request.FCO2SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FCO2SetpointSelect
        FCO2SetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFCO2SetpointSelect_Responses(
            FCO2SetpointSelectSet=silaFW_pb2.Integer(value=FCO2SetpointSelectSet))

        return return_value

    def GetFCO2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFCO2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get FCO2 SetpointSelect"
            Get gas CO2  flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFCO2SetpointSelect (Current FCO2 SetpointSelect): Current gas CO2  flow setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FCO2SetpointSelect
        CurrentFCO2SetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetFCO2SetpointSelect_Responses(
            CurrentFCO2SetpointSelect=silaFW_pb2.Integer(value=CurrentFCO2SetpointSelect))

        return return_value

    def GetFN2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2PV_Responses:
        """
        Executes the unobservable command "Get FN2 PV"
            Get present value. Overlay N2 flow process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2PV (Current FN2 PV): Current present value. Overlay N2 flow process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_PV
        CurrentFN2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2PV_Responses(CurrentFN2PV=silaFW_pb2.Real(value=CurrentFN2PV))

        return return_value

    def GetVN2PV(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetVN2PV_Responses:
        """
        Executes the unobservable command "Get V N2 PV"
            Get present value. Overlay N2 volume process value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVN2PV (Current V N2 PV): Current present value. Overlay N2 volume process value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.VN2_PV
        CurrentVN2PV = node.get_value()
        return_value = OverlayServicer_pb2.GetVN2PV_Responses(CurrentVN2PV=silaFW_pb2.Real(value=CurrentVN2PV))

        return return_value

    def GetFN2SP(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2SP_Responses:
        """
        Executes the unobservable command "Get FN2 SP"
            Get overlay N2 flow setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SP (Current FN2 SP): Current overlay N2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SP
        CurrentFN2SP = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2SP_Responses(CurrentFN2SP=silaFW_pb2.Real(value=CurrentFN2SP))

        return return_value

    def SetFN2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFN2SPM_Responses:
        """
        Executes the unobservable command "Set FN2 SPM"
            Set overlay N2 flow setpoint manual.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FN2SPM (FN2 Setpoint Manual):
            The overlay N2 flow setpoint manual.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2SPMSet (FN2 Setpoint Manual Set): The set manual overlay N2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FN2_SPM = request.FN2SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SPM
        FN2SPMSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFN2SPM_Responses(FN2SPMSet=silaFW_pb2.Real(value=FN2SPMSet))

        return return_value

    def GetFN2SPM(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2SPM_Responses:
        """
        Executes the unobservable command "Get FN2 SP Manual"
            Get overlay N2 flow manual setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPM (Current FN2 SP Manual): Current overlay N2 flow manual setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SPM
        CurrentFN2SPM = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2SPM_Responses(CurrentFN2SPM=silaFW_pb2.Real(value=CurrentFN2SPM))

        return return_value

    def SetFN2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFN2SPE_Responses:
        """
        Executes the unobservable command "Set FN2 SPE"
            Set overlay N2 flow setpoint external.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor.
            request.FN2SPE (FN2 Setpoint External):
            The overlay N2 flow setpoint external.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2SPESet (FN2 Setpoint External Set): The set external overlay N2 flow setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FN2_SPE = request.FN2SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SPE
        FN2SPESet = node.get_value()
        return_value = OverlayServicer_pb2.SetFN2SPE_Responses(FN2SPESet=silaFW_pb2.Real(value=FN2SPESet))

        return return_value

    def GetFN2SPE(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2SPE_Responses:
        """
        Executes the unobservable command "Get FN2 SP External"
            Get overlay N2 flow external setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPE (Current FN2 SP External): Current overlay N2 flow external setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SPE
        CurrentFN2SPE = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2SPE_Responses(CurrentFN2SPE=silaFW_pb2.Real(value=CurrentFN2SPE))

        return return_value

    def GetFN2SPA(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2SPA_Responses:
        """
        Executes the unobservable command "Get FN2 SP Automatic"
            Get overlay N2 flow automatic setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPA (Current FN2 SP Automatic): Current overlay N2 flow automatic setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SPA
        CurrentFN2SPA = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2SPA_Responses(CurrentFN2SPA=silaFW_pb2.Real(value=CurrentFN2SPA))

        return return_value

    def GetFN2SPR(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2SPR_Responses:
        """
        Executes the unobservable command "Get FN2 SP Remote"
            Get overlay N2 flow remote setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SPR (Current FN2 SP Remote): Current overlay N2 flow remote setpoint.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_SPR
        CurrentFN2SPR = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2SPR_Responses(CurrentFN2SPR=silaFW_pb2.Real(value=CurrentFN2SPR))

        return return_value

    def SetFN2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFN2Mode_Responses:
        """
        Executes the unobservable command "Set FN2 Mode"
            Set gas N2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FN2Mode (FN2 Mode):
            Set gas N2 flow operation mode. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2ModeSet (FN2 Mode Set): The set gas N2 flow operation mode. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.FN2_Mode = request.FN2Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_Mode
        FN2ModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFN2Mode_Responses(FN2ModeSet=silaFW_pb2.Integer(value=FN2ModeSet))

        return return_value

    def GetFN2Mode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2Mode_Responses:
        """
        Executes the unobservable command "Get FN2 Mode"
            Get gas N2 flow operation mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2Mode (Current FN2 Mode): Current gas N2 flow operation mode. Controller mode (Manual,
            Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.FN2_Mode
        CurrentFN2Mode = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2Mode_Responses(CurrentFN2Mode=silaFW_pb2.Integer(value=CurrentFN2Mode))

        return return_value

    def SetFN2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetFN2SetpointSelect_Responses:
        """
        Executes the unobservable command "Set FN2 SetpointSelect"
            Set gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.FN2SetpointSelect (FN2 SetpointSelect):
            Set gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.FN2SetpointSelectSet (FN2 SetpointSelect Set): The set gas N2 flow setpoint selection (Local,
            Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.FN2SetpointSelect = request.FN2SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FN2SetpointSelect
        FN2SetpointSelectSet = node.get_value()
        return_value = OverlayServicer_pb2.SetFN2SetpointSelect_Responses(
            FN2SetpointSelectSet=silaFW_pb2.Integer(value=FN2SetpointSelectSet))

        return return_value

    def GetFN2SetpointSelect(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetFN2SetpointSelect_Responses:
        """
        Executes the unobservable command "Get FN2 SetpointSelect"
            Get gas N2 flow setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFN2SetpointSelect (Current FN2 SetpointSelect): Current gas N2 flow setpoint selection
            (Local, Manual, Internal, Script, External).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.FN2SetpointSelect
        CurrentFN2SetpointSelect = node.get_value()
        return_value = OverlayServicer_pb2.GetFN2SetpointSelect_Responses(
            CurrentFN2SetpointSelect=silaFW_pb2.Integer(value=CurrentFN2SetpointSelect))

        return return_value

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.status.Access
        CurrentAccess = node.get_value()
        return_value = OverlayServicer_pb2.GetAccess_Responses(CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        return return_value

    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller command of the Overlay module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.status.Cmd = request.Cmd.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.status.Cmd
        CmdSet = node.get_value()
        return_value = OverlayServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        return return_value

    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the Overlay module.
            Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.status.Cmd
        CurrentCmd = node.get_value()
        return_value = OverlayServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        return return_value

    def SetGassingMode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.SetGassingMode_Responses:
        """
        Executes the unobservable command "Set Gassing Mode"
            Gassing mode (Unknown, Mix, Flow).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.GassingMode (Gassing Mode):
            Gassing mode (Unknown, Mix, Flow).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.GassingModeSet (Gassing Mode Set): The set Gassing mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Overlay.setter.GassingMode = request.GassingMode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.GassingMode
        GassingModeSet = node.get_value()
        return_value = OverlayServicer_pb2.SetGassingMode_Responses(
            GassingModeSet=silaFW_pb2.Integer(value=GassingModeSet))

        return return_value

    def GetGassingMode(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetGassingMode_Responses:
        """
        Executes the unobservable command "Get Gassing Mode"
            Get the Gassing mode. Gassing mode (Unknown, Mix, Flow).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentGassingMode (Current Gassing Mode): Current Gassing mode value of the overlay module.
            Overlay mode (Unknown, Mix, Flow).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.setter.GassingMode
        CurrentGassingMode = node.get_value()
        return_value = OverlayServicer_pb2.GetGassingMode_Responses(
            CurrentGassingMode=silaFW_pb2.Integer(value=CurrentGassingMode))

        return return_value

    def GetState(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the Overlay module.
            Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.status.State
        CurrentState = node.get_value()
        return_value = OverlayServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        return return_value

    def GetType(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the Overlay module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.sysinfo.Type
        CurrentType = node.get_value()
        return_value = OverlayServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))
    
        return return_value

    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the
            Overlay module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.sysinfo.Available
        CurrentAvailable = node.get_value()
        return_value = OverlayServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        return return_value

    def GetName(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the Overlay module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.sysinfo.Name
        CurrentName = node.get_value()
        return_value = OverlayServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        return return_value

    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> OverlayServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the Overlay
            module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Overlay.sysinfo.Version
        CurrentVersion = node.get_value()
        return_value = OverlayServicer_pb2.GetVersion_Responses(CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        return return_value
