"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Pressure Servicer*

:details: PressureServicer:
    Control a DASGIP pressure module. Enables read and write operations for various parameters, including pressure
    sensor and controller.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    PressureServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.710861
:date: (last modification) 2020-04-16T10:19:14.710861

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import PressureServicer_pb2 as PressureServicer_pb2
# from .gRPC import PressureServicer_pb2_grpc as PressureServicer_pb2_grpc

# import default arguments
from .PressureServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class PressureServicerReal:
    """
    Implementation of the *Pressure Servicer* in *Real* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetPV(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetPV_Responses:
        """
        Executes the unobservable command "Get PV"
            Get present value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPV (Current PV): Current present value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.PV
        CurrentPV = node.get_value()
        return_value = PressureServicer_pb2.GetPV_Responses(CurrentPV=silaFW_pb2.Real(value=CurrentPV))

        return return_value

    def SetSPM(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSPM_Responses:
        """
        Executes the unobservable command "Set Manual Setpoint"
            Set the manual pressure setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPM (Manual Setpoint):
            The manual setpoint of the pressure module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPMSet (Manual Setpoint Set): The set manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.setter.SPM = request.SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SPM
        SPMSet = node.get_value()
        return_value = PressureServicer_pb2.SetSPM_Responses(SPMSet=silaFW_pb2.Real(value=SPMSet))

        return return_value

    def SetSPE(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSPE_Responses:
        """
        Executes the unobservable command "Set External Setpoint"
            Set the external pressure setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPE (External Setpoint):
            The external setpoint of the pressure module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPESet (External Setpoint Set): The set external setpoint.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.setter.SPE = request.SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SPE
        SPESet = node.get_value()
        return_value = PressureServicer_pb2.SetSPE_Responses(SPESet=silaFW_pb2.Real(value=SPESet))

        return return_value

    def GetSP(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSP_Responses:
        """
        Executes the unobservable command "Get SP"
            Get setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSP (Current SP): Current setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SP
        CurrentSP = node.get_value()
        return_value = PressureServicer_pb2.GetSP_Responses(CurrentSP=silaFW_pb2.Real(value=CurrentSP))

        return return_value

    def GetSPA(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPA_Responses:
        """
        Executes the unobservable command "Get SPA"
            Get automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPA (Current SPA): Current automatic setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SPA
        CurrentSPA = node.get_value()
        return_value = PressureServicer_pb2.GetSPA_Responses(CurrentSPA=silaFW_pb2.Real(value=CurrentSPA))

        return return_value

    def GetSPM(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPM_Responses:
        """
        Executes the unobservable command "Get SPM"
            Get manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPM (Current SPM): Current manual setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SPM
        CurrentSPM = node.get_value()
        return_value = PressureServicer_pb2.GetSPM_Responses(CurrentSPM=silaFW_pb2.Real(value=CurrentSPM))

        return return_value

    def GetSPE(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPE_Responses:
        """
        Executes the unobservable command "Get SPE"
            Get external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPE (Current SPE): Current external setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SPE
        CurrentSPE = node.get_value()
        return_value = PressureServicer_pb2.GetSPE_Responses(CurrentSPE=silaFW_pb2.Real(value=CurrentSPE))

        return return_value

    def GetSPR(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPR_Responses:
        """
        Executes the unobservable command "Get SPR"
            Get remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPR (Current SPR): Current remote setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SPR
        CurrentSPR = node.get_value()
        return_value = PressureServicer_pb2.GetSPR_Responses(CurrentSPR=silaFW_pb2.Real(value=CurrentSPR))

        return return_value

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.status.Access
        CurrentAccess = node.get_value()
        return_value = PressureServicer_pb2.GetAccess_Responses(CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        return return_value

    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller command of the pressure module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.status.Cmd = request.Cmd.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.status.Cmd
        CmdSet = node.get_value()
        return_value = PressureServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        return return_value

    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the pressure module. Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.status.Cmd
        CurrentCmd = node.get_value()
        return_value = PressureServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        return return_value

    def SetMode(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller mode of the pressure module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.status.Mode = request.Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.status.Mode
        ModeSet = node.get_value()
        return_value = PressureServicer_pb2.SetMode_Responses(ModeSet=silaFW_pb2.Integer(value=ModeSet))

        return return_value

    def GetMode(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the pressure module. Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.status.Mode
        CurrentMode = node.get_value()
        return_value = PressureServicer_pb2.GetMode_Responses(CurrentMode=silaFW_pb2.Integer(value=CurrentMode))

        return return_value

    def SetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSetpointSelect_Responses:
        """
        Executes the unobservable command "Set SetpointSelect"
            Set the selected setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SetpointSelect (Set SetpointSelect):
            The selected setpoint of the pressure module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetpointSelectSet (Setpoint selection Set): The set setpoint selection.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.setter.SetpointSelect = request.SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SetpointSelect 
        SetpointSelectSet = node.get_value()
        return_value = PressureServicer_pb2.SetSetpointSelect_Responses(SetpointSelectSet=silaFW_pb2.Integer(value=SetpointSelectSet))

        return return_value

    def GetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSetpointSelect_Responses:
        """
        Executes the unobservable command "Get SetpointSelect"
            Get the setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSetpointSelect (Current Setpoint Selection): Current setpoint selection value of the pressure module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.setter.SetpointSelect 
        CurrentSetpointSelect = node.get_value()
        return_value = PressureServicer_pb2.GetSetpointSelect_Responses(CurrentSetpointSelect=silaFW_pb2.Integer(value=CurrentSetpointSelect))

        return return_value

    def GetState(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the pressure module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.status.State
        CurrentState = node.get_value()
        return_value = PressureServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        return return_value

    def GetType(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the pressure module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sysinfo.Type
        CurrentType = node.get_value()
        # Todo: Why is this 'S' statement here? Uncommented for now.
        # CurrentType = "S"
        return_value = PressureServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        return return_value

    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the
            pressure module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sysinfo.Available
        CurrentAvailable = node.get_value()
        return_value = PressureServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        return return_value

    def GetName(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the pressure module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sysinfo.Name
        CurrentName = node.get_value()
        return_value = PressureServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        return return_value

    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the pressure
            module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sysinfo.Version
        CurrentVersion = node.get_value()
        return_value = PressureServicer_pb2.GetVersion_Responses(CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        return return_value

    def SetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSensorOffset_Responses:
        """
        Executes the unobservable command "Set Sensor Offset"
            Set the sensor offset value that should be used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorOffset (Set SensorOffset):
            The sensor offset value that should be used. Sensor offset calibration parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorOffsetSet (Sensor Offset Set): The set sensor offset value that is used. Sensor offset
            calibration parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.sensor.Offset = request.SensorOffset.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sensor.Offset
        SensorOffsetSet = node.get_value()
        return_value = PressureServicer_pb2.SetSensorOffset_Responses(
            SensorOffsetSet=silaFW_pb2.Real(value=SensorOffsetSet))

        return return_value

    def GetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSensorOffset_Responses:
        """
        Executes the unobservable command "Get Sensor Offset"
            Get the sensor offset value that is used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorOffset (Current Sensor Offset): Current sensor offset value of the pressure module.
            Sensor offset calibration parameter.
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sensor.Offset
        CurrentSensorOffset = node.get_value()
        return_value = PressureServicer_pb2.GetSensorOffset_Responses(
            CurrentSensorOffset=silaFW_pb2.Real(value=CurrentSensorOffset))

        return return_value

    def GetSensorPVRaw(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSensorPVRaw_Responses:
        """
        Executes the unobservable command "Get Sensor PVRaw"
            Get the sensor present raw value. Actual process raw value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorPVRaw (Current Sensor PVRaw): Current sensor present raw value of the pressure module.
            Actual process raw value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sensor.PVRaw
        CurrentSensorPVRaw = node.get_value()
        return_value = PressureServicer_pb2.GetSensorPVRaw_Responses(
            CurrentSensorPVRaw=silaFW_pb2.Real(value=CurrentSensorPVRaw))

        return return_value

    def SetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSensorCompensation_Responses:
        """
        Executes the unobservable command "Set Sensor Compensation"
            Set the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorCompensation (Set Sensor Compensation):
            The sensor slope value. Sensor temperature compensation parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorCompensationSet (Sensor Compensation Set): The set sensor compensation value. Sensor
            temperature compensation parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.sensor.Compensation = request.SensorCompensation.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sensor.Compensation
        SensorCompensationSet = node.get_value()
        return_value = PressureServicer_pb2.SetSensorCompensation_Responses(
            SensorCompensationSet=silaFW_pb2.Real(value=SensorCompensationSet))

        return return_value

    def GetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSensorCompensation_Responses:
        """
        Executes the unobservable command "Get Sensor Compensation"
            Get the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorCompensation (Current Sensor Compensation): Current sensor compensation value of the
            pressure module. Sensor temperature compensation parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.sensor.Compensation
        CurrentSensorCompensation = node.get_value()
        return_value = PressureServicer_pb2.GetSensorCompensation_Responses(
            CurrentSensorCompensation=silaFW_pb2.Real(value=CurrentSensorCompensation))

        return return_value

    def SetControllerDB(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerDB_Responses:
        """
        Executes the unobservable command "Set Controller DB"
            Set the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerDB (Set Controller DB):
            The controller deadband value. PID controller: deadband (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerDBSet (Controller DB Set): The set controller deadband value. PID controller: deadband
            (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.controller.DB = request.ControllerDB.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.DB
        ControllerDBSet = node.get_value()
        return_value = PressureServicer_pb2.SetControllerDB_Responses(
            ControllerDBSet=silaFW_pb2.Real(value=ControllerDBSet))

        return return_value

    def GetControllerDB(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerDB_Responses:
        """
        Executes the unobservable command "Get Controller DB"
            Get the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerDB (Current Controller DB): Current controller deadband value of the pressure
            module. PID controller: deadband (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.DB
        CurrentControllerDB = node.get_value()
        return_value = PressureServicer_pb2.GetControllerDB_Responses(
            CurrentControllerDB=silaFW_pb2.Real(value=CurrentControllerDB))

        return return_value

    def GetControllerOut(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerOut_Responses:
        """
        Executes the unobservable command "Get Controller Out"
            Get the controller output value. PID controller: actual output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerOut (Current Controller Out): Current controller output value of the pressure
            module. PID controller: actual output value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Out
        CurrentControllerOut = node.get_value()
        return_value = PressureServicer_pb2.GetControllerOut_Responses(
            CurrentControllerOut=silaFW_pb2.Real(value=CurrentControllerOut))

        return return_value

    def SetControllerP(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerP_Responses:
        """
        Executes the unobservable command "Set Controller P"
            Set the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerP (Set Controller P):
            The controller proportional parameter value. PID controller: proportional parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerPSet (Controller P Set): The set controller proportional parameter value. PID controller:
            proportional parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.controller.P = request.ControllerP.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.P
        ControllerPSet = node.get_value()
        return_value = PressureServicer_pb2.SetControllerP_Responses(
            ControllerPSet=silaFW_pb2.Real(value=ControllerPSet))

        return return_value

    def GetControllerP(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerP_Responses:
        """
        Executes the unobservable command "Get Controller P"
            Get the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerP (Current Controller P): Current controller proportional parameter value of the
            pressure module. PID controller: proportional parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.P
        CurrentControllerP = node.get_value()
        return_value = PressureServicer_pb2.GetControllerP_Responses(
            CurrentControllerP=silaFW_pb2.Real(value=CurrentControllerP))

        return return_value

    def SetControllerTd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerTd_Responses:
        """
        Executes the unobservable command "Set Controller Td"
            Set the controller differentiator time constant. PID controller: differentiator time constant (set to zero
            to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTd (Set Controller Td):
            The controller differentiator time constant. PID controller: differentiator time constant (set to zero to
            disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTdSet (Controller Td Set): The set controller differentiator time constant.
            PID controller: differentiator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.controller.Td = request.ControllerTd.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Td
        ControllerTdSet = node.get_value()
        return_value = PressureServicer_pb2.SetControllerTd_Responses(
            ControllerTdSet=silaFW_pb2.Real(value=ControllerTdSet))

        return return_value

    def GetControllerTd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerTd_Responses:
        """
        Executes the unobservable command "Get Controller Td"
            Get the controller differentiator time constant. PID controller: differentiator time constant (set to zero
            to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTd (Current Controller Td): Current controller differentiator time constant of the
            pressure module. PID controller: differentiator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Td
        CurrentControllerTd = node.get_value()
        return_value = PressureServicer_pb2.GetControllerTd_Responses(
            CurrentControllerTd=silaFW_pb2.Real(value=CurrentControllerTd))

        return return_value

    def SetControllerTi(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerTi_Responses:
        """
        Executes the unobservable command "Set Controller Ti"
            Set the controller integrator time constant. PID controller: integrator time constant (set to zero to
            disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTi (Set Controller Ti):
            The controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTiSet (Controller Ti Set): The set controller integrator time constant. PID controller:
            integrator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.controller.Ti = request.ControllerTi.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Ti
        ControllerTiSet = node.get_value()
        return_value = PressureServicer_pb2.SetControllerTi_Responses(
            ControllerTiSet=silaFW_pb2.Real(value=ControllerTiSet))

        return return_value

    def GetControllerTi(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerTi_Responses:
        """
        Executes the unobservable command "Get Controller Ti"
            Get the controller integrator time constant. PID controller: integrator time constant (set to zero to
            disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTi (Current Controller Ti): Current controller integrator time constant of the
            pressure module. PID controller: integrator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Ti
        CurrentControllerTi = node.get_value()
        return_value = PressureServicer_pb2.GetControllerTi_Responses(
            CurrentControllerTi=silaFW_pb2.Real(value=CurrentControllerTi))

        return return_value

    def SetControllerMin(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerMin_Responses:
        """
        Executes the unobservable command "Set Controller Min"
            Set the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMin (Set Controller Min):
            The controller minimal output value. PID controller: minimal output value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMinSet (Controller Min Set): The set controller minimal output value. PID controller:
            minimal output value.
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.controller.Min = request.ControllerMin.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Min
        ControllerMinSet = node.get_value()
        return_value = PressureServicer_pb2.SetControllerMin_Responses(
            ControllerMinSet=silaFW_pb2.Real(value=ControllerMinSet))

        return return_value

    def GetControllerMin(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerMin_Responses:
        """
        Executes the unobservable command "Get Controller Min"
            Get the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMin (Current Controller Min): Current controller minimal output value of the
            pressure module. PID controller: minimal output value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Min
        CurrentControllerMin = node.get_value()
        return_value = PressureServicer_pb2.GetControllerMin_Responses(
            CurrentControllerMin=silaFW_pb2.Real(value=CurrentControllerMin))

        return return_value

    def SetControllerMax(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerMax_Responses:
        """
        Executes the unobservable command "Set Controller Max"
            Set the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMax (Set Controller Max):
            The controller maximal output value. PID controller: maximaloutput value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMaxSet (Controller Max Set): The set controller maximal output value. PID controller:
            maximal output value.
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Pressure.controller.Max = request.ControllerMax.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Max
        ControllerMaxSet = node.get_value()
        return_value = PressureServicer_pb2.SetControllerMax_Responses(
            ControllerMaxSet=silaFW_pb2.Real(value=ControllerMaxSet))

        return return_value

    def GetControllerMax(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerMax_Responses:
        """
        Executes the unobservable command "Get Controller Max"
            Get the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMax (Current Controller Max): Current controller maximal output value of the
            pressure module. PID controller: maximal output value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Pressure.controller.Max
        CurrentControllerMax = node.get_value()
        return_value = PressureServicer_pb2.GetControllerMax_Responses(
            CurrentControllerMax=silaFW_pb2.Real(value=CurrentControllerMax))

        return return_value
