"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Pressure Servicer*

:details: PressureServicer:
    Control a DASGIP pressure module. Enables read and write operations for various parameters, including pressure
    sensor and controller.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    PressureServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.646705
:date: (last modification) 2020-04-16T10:19:14.646705

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import PressureServicer_pb2 as PressureServicer_pb2
from .gRPC import PressureServicer_pb2_grpc as PressureServicer_pb2_grpc

# import simulation and real implementation
from .PressureServicer_simulation import PressureServicerSimulation
from .PressureServicer_real import PressureServicerReal


class PressureServicer(PressureServicer_pb2_grpc.PressureServicerServicer):
    """
    This is a DASGIP Service
    """
    implementation: Union[PressureServicerSimulation, PressureServicerReal]
    simulation_mode: bool

    def __init__(self, reactors, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.reactors = reactors
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(PressureServicerSimulation(self.reactors))
        else:
            self._inject_implementation(PressureServicerReal(self.reactors))

    def _inject_implementation(self,
                               implementation: Union[PressureServicerSimulation,
                                                     PressureServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the DASGIP_ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(PressureServicerSimulation(self.reactors))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(PressureServicerReal(self.reactors))

    def GetPV(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetPV_Responses:
        """
        Executes the unobservable command "Get PV"
            Get present value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPV (Current PV): Current present value
        """
    
        logging.debug(
            "GetPV called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPV(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSPM(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSPM_Responses:
        """
        Executes the unobservable command "Set Manual Setpoint"
            Set the manual pressure setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPM (Manual Setpoint):
            The manual setpoint of the pressure module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPMSet (Manual Setpoint Set): The set manual setpoint.
        """
    
        logging.debug(
            "SetSPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSPE(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSPE_Responses:
        """
        Executes the unobservable command "Set External Setpoint"
            Set the external pressure setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPE (External Setpoint):
            The external setpoint of the pressure module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPESet (External Setpoint Set): The set external setpoint.
        """
    
        logging.debug(
            "SetSPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSP(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSP_Responses:
        """
        Executes the unobservable command "Get SP"
            Get setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSP (Current SP): Current setpoint value
        """
    
        logging.debug(
            "GetSP called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSP(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSPA(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPA_Responses:
        """
        Executes the unobservable command "Get SPA"
            Get automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPA (Current SPA): Current automatic setpoint value
        """
    
        logging.debug(
            "GetSPA called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSPA(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSPM(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPM_Responses:
        """
        Executes the unobservable command "Get SPM"
            Get manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPM (Current SPM): Current manual setpoint value
        """
    
        logging.debug(
            "GetSPM called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSPM(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSPE(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPE_Responses:
        """
        Executes the unobservable command "Get SPE"
            Get external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPE (Current SPE): Current external setpoint value
        """
    
        logging.debug(
            "GetSPE called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSPE(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSPR(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSPR_Responses:
        """
        Executes the unobservable command "Get SPR"
            Get remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPR (Current SPR): Current remote setpoint value
        """
    
        logging.debug(
            "GetSPR called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSPR(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        logging.debug(
            "GetAccess called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetAccess(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller command of the pressure module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        logging.debug(
            "SetCmd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCmd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the pressure module. Controller command (Nothing, Stop, Start)
        """
    
        logging.debug(
            "GetCmd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCmd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetMode(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller mode of the pressure module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        logging.debug(
            "SetMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMode(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the pressure module. Controller mode (Manual, Automatic).
        """
    
        logging.debug(
            "GetMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSetpointSelect_Responses:
        """
        Executes the unobservable command "Set SetpointSelect"
            Set the selected setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script, External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SetpointSelect (Set SetpointSelect):
            The selected setpoint of the pressure module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetpointSelectSet (Setpoint selection Set): The set setpoint selection.
        """
    
        logging.debug(
            "SetSetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSetpointSelect_Responses:
        """
        Executes the unobservable command "Get SetpointSelect"
            Get the setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSetpointSelect (Current Setpoint Selection): Current setpoint selection value of the pressure module. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetSetpointSelect called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSetpointSelect(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetState(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the pressure module. Controller state (Off, On, Error).
        """
    
        logging.debug(
            "GetState called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetState(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetType(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the pressure module.
        """
    
        logging.debug(
            "GetType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the pressure module.
        """
    
        logging.debug(
            "GetAvailable called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetAvailable(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetName(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the pressure module.
        """
    
        logging.debug(
            "GetName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the pressure module.
        """
    
        logging.debug(
            "GetVersion called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSensorOffset_Responses:
        """
        Executes the unobservable command "Set Sensor Offset"
            Set the sensor offset value that should be used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorOffset (Set SensorOffset):
            The sensor offset value that should be used. Sensor offset calibration parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorOffsetSet (Sensor Offset Set): The set sensor offset value that is used. Sensor offset calibration parameter.
        """
    
        logging.debug(
            "SetSensorOffset called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSensorOffset(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSensorOffset_Responses:
        """
        Executes the unobservable command "Get Sensor Offset"
            Get the sensor offset value that is used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorOffset (Current Sensor Offset): Current sensor offset value of the pressure module. Sensor offset calibration parameter.
        """
    
        logging.debug(
            "GetSensorOffset called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorOffset(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorPVRaw(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSensorPVRaw_Responses:
        """
        Executes the unobservable command "Get Sensor PVRaw"
            Get the sensor present raw value. Actual process raw value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorPVRaw (Current Sensor PVRaw): Current sensor present raw value of the pressure module. Actual process raw value.
        """
    
        logging.debug(
            "GetSensorPVRaw called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorPVRaw(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetSensorCompensation_Responses:
        """
        Executes the unobservable command "Set Sensor Compensation"
            Set the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorCompensation (Set Sensor Compensation):
            The sensor slope value. Sensor temperature compensation parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorCompensationSet (Sensor Compensation Set): The set sensor compensation value. Sensor temperature compensation parameter.
        """
    
        logging.debug(
            "SetSensorCompensation called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSensorCompensation(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetSensorCompensation_Responses:
        """
        Executes the unobservable command "Get Sensor Compensation"
            Get the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorCompensation (Current Sensor Compensation): Current sensor compensation value of the pressure module. Sensor temperature compensation parameter.
        """
    
        logging.debug(
            "GetSensorCompensation called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorCompensation(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControllerDB(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerDB_Responses:
        """
        Executes the unobservable command "Set Controller DB"
            Set the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerDB (Set Controller DB):
            The controller deadband value. PID controller: deadband (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerDBSet (Controller DB Set): The set controller deadband value. PID controller: deadband (set to zero to disable).
        """
    
        logging.debug(
            "SetControllerDB called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControllerDB(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerDB(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerDB_Responses:
        """
        Executes the unobservable command "Get Controller DB"
            Get the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerDB (Current Controller DB): Current controller deadband value of the pressure module. PID controller: deadband (set to zero to disable).
        """
    
        logging.debug(
            "GetControllerDB called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerDB(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerOut(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerOut_Responses:
        """
        Executes the unobservable command "Get Controller Out"
            Get the controller output value. PID controller: actual output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerOut (Current Controller Out): Current controller output value of the pressure module. PID controller: actual output value.
        """
    
        logging.debug(
            "GetControllerOut called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerOut(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControllerP(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerP_Responses:
        """
        Executes the unobservable command "Set Controller P"
            Set the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerP (Set Controller P):
            The controller proportional parameter value. PID controller: proportional parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerPSet (Controller P Set): The set controller proportional parameter value. PID controller: proportional parameter.
        """
    
        logging.debug(
            "SetControllerP called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControllerP(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerP(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerP_Responses:
        """
        Executes the unobservable command "Get Controller P"
            Get the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerP (Current Controller P): Current controller proportional parameter value of the pressure module. PID controller: proportional parameter.
        """
    
        logging.debug(
            "GetControllerP called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerP(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControllerTd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerTd_Responses:
        """
        Executes the unobservable command "Set Controller Td"
            Set the controller differentiator time constant. PID controller: differentiator time constant (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTd (Set Controller Td):
            The controller differentiator time constant. PID controller: differentiator time constant (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTdSet (Controller Td Set): The set controller differentiator time constant. PID controller: differentiator time constant (set to zero to disable).
        """
    
        logging.debug(
            "SetControllerTd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControllerTd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerTd(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerTd_Responses:
        """
        Executes the unobservable command "Get Controller Td"
            Get the controller differentiator time constant. PID controller: differentiator time constant (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTd (Current Controller Td): Current controller differentiator time constant of the pressure module. PID controller: differentiator time constant (set to zero to disable).
        """
    
        logging.debug(
            "GetControllerTd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerTd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControllerTi(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerTi_Responses:
        """
        Executes the unobservable command "Set Controller Ti"
            Set the controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTi (Set Controller Ti):
            The controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTiSet (Controller Ti Set): The set controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
        """
    
        logging.debug(
            "SetControllerTi called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControllerTi(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerTi(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerTi_Responses:
        """
        Executes the unobservable command "Get Controller Ti"
            Get the controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTi (Current Controller Ti): Current controller integrator time constant of the pressure module. PID controller: integrator time constant (set to zero to disable).
        """
    
        logging.debug(
            "GetControllerTi called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerTi(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControllerMin(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerMin_Responses:
        """
        Executes the unobservable command "Set Controller Min"
            Set the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMin (Set Controller Min):
            The controller minimal output value. PID controller: minimal output value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMinSet (Controller Min Set): The set controller minimal output value. PID controller: minimal output value.
        """
    
        logging.debug(
            "SetControllerMin called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControllerMin(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerMin(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerMin_Responses:
        """
        Executes the unobservable command "Get Controller Min"
            Get the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMin (Current Controller Min): Current controller minimal output value of the pressure module. PID controller: minimal output value.
        """
    
        logging.debug(
            "GetControllerMin called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerMin(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControllerMax(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.SetControllerMax_Responses:
        """
        Executes the unobservable command "Set Controller Max"
            Set the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMax (Set Controller Max):
            The controller maximal output value. PID controller: maximaloutput value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMaxSet (Controller Max Set): The set controller maximal output value. PID controller: maximal output value.
        """
    
        logging.debug(
            "SetControllerMax called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControllerMax(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControllerMax(self, request, context: grpc.ServicerContext) \
            -> PressureServicer_pb2.GetControllerMax_Responses:
        """
        Executes the unobservable command "Get Controller Max"
            Get the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMax (Current Controller Max): Current controller maximal output value of the pressure module. PID controller: maximal output value.
        """
    
        logging.debug(
            "GetControllerMax called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControllerMax(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
