"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Reactor Servicer*

:details: ReactorServicer:
    Control a DASGIP reactor module. Enables read and write operations for various parameters, including reactor sensor,
    controller, and alarm.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    ReactorServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:14.984973
:date: (last modification) 2020-04-16T10:19:14.984973

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import ReactorServicer_pb2 as ReactorServicer_pb2
# from .gRPC import ReactorServicer_pb2_grpc as ReactorServicer_pb2_grpc

# import default arguments
from .ReactorServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class ReactorServicerSimulation:
    """
    Implementation of the *Reactor Servicer* in *Simulation* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetVInitial(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.GetVInitial_Responses:
        """
        Executes the unobservable command "Get VInitial"
            Get initial liquid volume value. Initial liquid volume (initial working volume).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVInitial (Current VInitial): Current initial liquid volume value. Initial liquid volume 
            (initial working volume).
        """
    
        # initialise the return value
        return_value = None

        CurrentVInitial = 0.0
        return_value = ReactorServicer_pb2.GetVInitial_Responses(CurrentVInitial=silaFW_pb2.Real(value=CurrentVInitial))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.GetVInitial_Responses(
                **default_dict['GetVInitial_Responses']
            )
    
        return return_value

    def GetVLiquid(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.GetVLiquid_Responses:
        """
        Executes the unobservable command "Get VLiquid"
            Get actual liquid volume value. Actual liquid volume (working volume).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVLiquid (Current VLiquid): Current actual liquid volume value. Actual liquid volume 
            (working volume).
        """
    
        # initialise the return value
        return_value = None

        CurrentVLiquid = 0.0
        return_value = ReactorServicer_pb2.GetVLiquid_Responses(CurrentVLiquid=silaFW_pb2.Real(value=CurrentVLiquid))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.GetVLiquid_Responses(
                **default_dict['GetVLiquid_Responses']
            )
    
        return return_value

    def SetVLiquid(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.SetVLiquid_Responses:
        """
        Executes the unobservable command "Set VLiquid"
            Set the reactor actual liquid volume value. Actual liquid volume (working volume).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.VLiquid (Volume Liquid):
            The reactor actual liquid volume value. Actual liquid volume (working volume).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VLiquidSet (VLiquid Set): The set actual liquid volume value. Actual liquid volume (working volume).
        """
    
        # initialise the return value
        return_value = None

        VLiquidSet = 0.0
        return_value = ReactorServicer_pb2.SetVLiquid_Responses(VLiquidSet=silaFW_pb2.Real(value=VLiquidSet))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.SetVLiquid_Responses(
                **default_dict['SetVLiquid_Responses']
            )
    
        return return_value

    def GetVMax(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.GetVMax_Responses:
        """
        Executes the unobservable command "Get VMax"
            Get max liquid volume value. Max allowed liquid volume.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVMax (Current VMax): Current max liquid volume value. Max allowed liquid volume.
        """
    
        # initialise the return value
        return_value = None

        CurrentVMax = 0.0
        return_value = ReactorServicer_pb2.GetVMax_Responses(CurrentVMax=silaFW_pb2.Real(value=CurrentVMax))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.GetVMax_Responses(
                **default_dict['GetVMax_Responses']
            )
    
        return return_value

    def SetVMax(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.SetVMax_Responses:
        """
        Executes the unobservable command "Set VMax"
            Set the reactor max liquid volume value. Max allowed liquid volume.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.VMax (Volume Max):
            The reactor max liquid volume value. Max allowed liquid volume.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VMaxSet (VMax Set): The set max liquid volume value. Max allowed liquid volume.
        """
    
        # initialise the return value
        return_value = None

        VMaxSet = 0.0
        return_value = ReactorServicer_pb2.SetVMax_Responses(VMaxSet=silaFW_pb2.Real(value=VMaxSet))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.SetVMax_Responses(
                **default_dict['SetVMax_Responses']
            )
    
        return return_value

    def GetVMin(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.GetVMin_Responses:
        """
        Executes the unobservable command "Get VMin"
            Get min liquid volume value. Min allowed liquid volume.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVMin (Current VMin): Current min liquid volume value. Min allowed liquid volume.
        """
    
        # initialise the return value
        return_value = None

        CurrentVMin = 0.0
        return_value = ReactorServicer_pb2.GetVMin_Responses(CurrentVMin=silaFW_pb2.Real(value=CurrentVMin))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.GetVMin_Responses(
                **default_dict['GetVMin_Responses']
            )
    
        return return_value

    def SetVMin(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.SetVMin_Responses:
        """
        Executes the unobservable command "Set VMin"
            Set the reactor min liquid volume value. Min allowed liquid volume.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.VMin (Volume Min):
            The reactor min liquid volume value. Min allowed liquid volume.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VMinSet (VMin Set): The set min liquid volume value. Min allowed liquid volume.
        """
    
        # initialise the return value
        return_value = None

        VMinSet = 0.0
        return_value = ReactorServicer_pb2.SetVMin_Responses(VMinSet=silaFW_pb2.Real(value=VMinSet))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.SetVMin_Responses(
                **default_dict['SetVMin_Responses']
            )
    
        return return_value

    def GetVTotal(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.GetVTotal_Responses:
        """
        Executes the unobservable command "Get VTotal"
            Get total liquid volume value. Total vessel volume.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVTotal (Current VTotal): Current total liquid volume value. Total vessel volume.
        """
    
        # initialise the return value
        return_value = None

        CurrentVTotal = 0.0
        return_value = ReactorServicer_pb2.GetVTotal_Responses(CurrentVTotal=silaFW_pb2.Real(value=CurrentVTotal))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.GetVTotal_Responses(
                **default_dict['GetVTotal_Responses']
            )
    
        return return_value

    def SetVTotal(self, request, context: grpc.ServicerContext) \
            -> ReactorServicer_pb2.SetVTotal_Responses:
        """
        Executes the unobservable command "Set VTotal"
            Set the reactor total liquid volume value. Total vessel volume.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.VTotal (Volume Total):
            The reactor total liquid volume value. Total vessel volume.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.VTotalSet (VTotal Set): The set total liquid volume value. Total vessel volume.
        """
    
        # initialise the return value
        return_value = None

        VTotalSet = 0.0
        return_value = ReactorServicer_pb2.SetVTotal_Responses(VTotalSet=silaFW_pb2.Real(value=VTotalSet))

        # fallback to default
        if return_value is None:
            return_value = ReactorServicer_pb2.SetVTotal_Responses(
                **default_dict['SetVTotal_Responses']
            )
    
        return return_value
