"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Redox Servicer*

:details: RedoxServicer:
    Control a DASGIP Redox module. Enables read and write operations for various parameters, including Redox sensor,
    controller, and alarm.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    RedoxServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:15.151715
:date: (last modification) 2020-04-16T10:19:15.151715

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import RedoxServicer_pb2 as RedoxServicer_pb2
# from .gRPC import RedoxServicer_pb2_grpc as RedoxServicer_pb2_grpc

# import default arguments
from .RedoxServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class RedoxServicerReal:
    """
    Implementation of the *Redox Servicer* in *Real* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetPV(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetPV_Responses:
        """
        Executes the unobservable command "Get PV"
            Get present value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPV (Current PV): Current present value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.PV
        CurrentPV = node.get_value()
        return_value = RedoxServicer_pb2.GetPV_Responses(CurrentPV=silaFW_pb2.Real(value=CurrentPV))

        return return_value

    def SetSPM(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetSPM_Responses:
        """
        Executes the unobservable command "Set Manual Setpoint"
            Set the manual Redox setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPM (Manual Setpoint):
            The manual setpoint of the Redox module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPMSet (Manual Setpoint Set): The set manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.setter.SPM = request.SPM.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SPM
        SPMSet = node.get_value()
        return_value = RedoxServicer_pb2.SetSPM_Responses(SPMSet=silaFW_pb2.Real(value=SPMSet))

        return return_value

    def SetSPE(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetSPE_Responses:
        """
        Executes the unobservable command "Set External Setpoint"
            Set the external Redox setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPE (External Setpoint):
            The external setpoint of the Redox module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPESet (External Setpoint Set): The set external setpoint.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.setter.SPE = request.SPE.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SPE
        SPESet = node.get_value()
        return_value = RedoxServicer_pb2.SetSPE_Responses(SPESet=silaFW_pb2.Real(value=SPESet))

        return return_value

    def GetSP(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSP_Responses:
        """
        Executes the unobservable command "Get SP"
            Get setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSP (Current SP): Current setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SP
        CurrentSP = node.get_value()
        return_value = RedoxServicer_pb2.GetSP_Responses(CurrentSP=silaFW_pb2.Real(value=CurrentSP))

        return return_value

    def GetSPA(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSPA_Responses:
        """
        Executes the unobservable command "Get SPA"
            Get automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPA (Current SPA): Current automatic setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SPA
        CurrentSPA = node.get_value()
        return_value = RedoxServicer_pb2.GetSPA_Responses(CurrentSPA=silaFW_pb2.Real(value=CurrentSPA))

        return return_value

    def GetSPM(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSPM_Responses:
        """
        Executes the unobservable command "Get SPM"
            Get manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPM (Current SPM): Current manual setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SPM
        CurrentSPM = node.get_value()
        return_value = RedoxServicer_pb2.GetSPM_Responses(CurrentSPM=silaFW_pb2.Real(value=CurrentSPM))

        return return_value

    def GetSPE(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSPE_Responses:
        """
        Executes the unobservable command "Get SPE"
            Get external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPE (Current SPE): Current external setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SPE
        CurrentSPE = node.get_value()
        return_value = RedoxServicer_pb2.GetSPE_Responses(CurrentSPE=silaFW_pb2.Real(value=CurrentSPE))

        return return_value

    def GetSPR(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSPR_Responses:
        """
        Executes the unobservable command "Get SPR"
            Get remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPR (Current SPR): Current remote setpoint value
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SPR
        CurrentSPR = node.get_value()
        return_value = RedoxServicer_pb2.GetSPR_Responses(CurrentSPR=silaFW_pb2.Real(value=CurrentSPR))

        return return_value

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.status.Access
        CurrentAccess = node.get_value()
        return_value = RedoxServicer_pb2.GetAccess_Responses(CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        return return_value

    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller command of the Redox module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.status.Cmd = request.Cmd.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.status.Cmd
        CmdSet = node.get_value()
        return_value = RedoxServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        return return_value

    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the Redox module.
            Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.status.Cmd
        CurrentCmd = node.get_value()
        return_value = RedoxServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        return return_value

    def SetMode(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller mode of the Redox module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.status.Mode = request.Mode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.status.Mode
        ModeSet = node.get_value()
        return_value = RedoxServicer_pb2.SetMode_Responses(ModeSet=silaFW_pb2.Integer(value=ModeSet))

        return return_value

    def GetMode(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the Redox module.
            Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.status.Mode
        CurrentMode = node.get_value()
        return_value = RedoxServicer_pb2.GetMode_Responses(CurrentMode=silaFW_pb2.Integer(value=CurrentMode))

        return return_value

    def SetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetSetpointSelect_Responses:
        """
        Executes the unobservable command "Set SetpointSelect"
            Set the selected setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script,
            External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SetpointSelect (Set SetpointSelect):
            The selected setpoint of the Redox module. Setpoint selection (Local, Manual, Internal, Script, External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetpointSelectSet (Setpoint selection Set): The set setpoint selection.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.setter.SetpointSelect = request.SetpointSelect.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SetpointSelect 
        SetpointSelectSet = node.get_value()
        return_value = RedoxServicer_pb2.SetSetpointSelect_Responses(
            SetpointSelectSet=silaFW_pb2.Integer(value=SetpointSelectSet))

        return return_value

    def GetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSetpointSelect_Responses:
        """
        Executes the unobservable command "Get SetpointSelect"
            Get the setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSetpointSelect (Current Setpoint Selection): Current setpoint selection value of the Redox
            module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.setter.SetpointSelect 
        CurrentSetpointSelect = node.get_value()
        return_value = RedoxServicer_pb2.GetSetpointSelect_Responses(
            CurrentSetpointSelect=silaFW_pb2.Integer(value=CurrentSetpointSelect))

        return return_value

    def GetState(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the Redox module.
            Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.status.State
        CurrentState = node.get_value()
        return_value = RedoxServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        return return_value

    def GetType(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the Redox module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sysinfo.Type
        CurrentType = node.get_value()
        return_value = RedoxServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        return return_value

    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the Redox
            module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sysinfo.Available
        CurrentAvailable = node.get_value()
        return_value = RedoxServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        return return_value

    def GetName(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the Redox module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sysinfo.Name
        CurrentName = node.get_value()
        return_value = RedoxServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        return return_value

    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the Redox
            module.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sysinfo.Version
        CurrentVersion = node.get_value()
        return_value = RedoxServicer_pb2.GetVersion_Responses(CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        return return_value

    def SetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetSensorOffset_Responses:
        """
        Executes the unobservable command "Set Sensor Offset"
            Set the sensor offset value that should be used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorOffset (Set SensorOffset):
            The sensor offset value that should be used. Sensor offset calibration parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorOffsetSet (Sensor Offset Set): The set sensor offset value that is used. Sensor offset
            calibration parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.sensor.Offset = request.SensorOffset.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sensor.Offset
        SensorOffsetSet = node.get_value()
        return_value = RedoxServicer_pb2.SetSensorOffset_Responses(
            SensorOffsetSet=silaFW_pb2.Real(value=SensorOffsetSet))

        return return_value

    def GetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSensorOffset_Responses:
        """
        Executes the unobservable command "Get Sensor Offset"
            Get the sensor offset value that is used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorOffset (Current Sensor Offset): Current sensor offset value of the Redox module.
            Sensor offset calibration parameter.
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sensor.Offset
        CurrentSensorOffset = node.get_value()
        return_value = RedoxServicer_pb2.GetSensorOffset_Responses(
            CurrentSensorOffset=silaFW_pb2.Real(value=CurrentSensorOffset))

        return return_value

    def GetSensorPVRaw(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSensorPVRaw_Responses:
        """
        Executes the unobservable command "Get Sensor PVRaw"
            Get the sensor present raw value. Actual process raw value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorPVRaw (Current Sensor PVRaw): Current sensor present raw value of the Redox module.
            Actual process raw value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sensor.PVRaw
        CurrentSensorPVRaw = node.get_value()
        return_value = RedoxServicer_pb2.GetSensorPVRaw_Responses(
            CurrentSensorPVRaw=silaFW_pb2.Real(value=CurrentSensorPVRaw))

        return return_value

    def SetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetSensorCompensation_Responses:
        """
        Executes the unobservable command "Set Sensor Compensation"
            Set the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorCompensation (Set Sensor Compensation):
            The sensor slope value. Sensor temperature compensation parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorCompensationSet (Sensor Compensation Set): The set sensor compensation value. Sensor
            temperature compensation parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.sensor.Compensation = request.SensorCompensation.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sensor.Compensation
        SensorCompensationSet = node.get_value()
        return_value = RedoxServicer_pb2.SetSensorCompensation_Responses(
            SensorCompensationSet=silaFW_pb2.Real(value=SensorCompensationSet))

        return return_value

    def GetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetSensorCompensation_Responses:
        """
        Executes the unobservable command "Get Sensor Compensation"
            Get the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorCompensation (Current Sensor Compensation): Current sensor compensation value of the
            Redox module. Sensor temperature compensation parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.sensor.Compensation
        CurrentSensorCompensation = node.get_value()
        return_value = RedoxServicer_pb2.GetSensorCompensation_Responses(
            CurrentSensorCompensation=silaFW_pb2.Real(value=CurrentSensorCompensation))

        return return_value

    def SetControllerDB(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetControllerDB_Responses:
        """
        Executes the unobservable command "Set Controller DB"
            Set the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerDB (Set Controller DB):
            The controller deadband value. PID controller: deadband (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerDBSet (Controller DB Set): The set controller deadband value. PID controller: deadband
            (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.controller.DB = request.ControllerDB.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.DB
        ControllerDBSet = node.get_value()
        return_value = RedoxServicer_pb2.SetControllerDB_Responses(
            ControllerDBSet=silaFW_pb2.Real(value=ControllerDBSet))

        return return_value

    def GetControllerDB(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerDB_Responses:
        """
        Executes the unobservable command "Get Controller DB"
            Get the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerDB (Current Controller DB): Current controller deadband value of the Redox module.
            PID controller: deadband (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.DB
        CurrentControllerDB = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerDB_Responses(
            CurrentControllerDB=silaFW_pb2.Real(value=CurrentControllerDB))

        return return_value

    def GetControllerOut(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerOut_Responses:
        """
        Executes the unobservable command "Get Controller Out"
            Get the controller output value. PID controller: actual output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerOut (Current Controller Out): Current controller output value of the Redox module.
            PID controller: actual output value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Out
        CurrentControllerOut = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerOut_Responses(
            CurrentControllerOut=silaFW_pb2.Real(value=CurrentControllerOut))

        return return_value

    def SetControllerP(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetControllerP_Responses:
        """
        Executes the unobservable command "Set Controller P"
            Set the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerP (Set Controller P):
            The controller proportional parameter value. PID controller: proportional parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerPSet (Controller P Set): The set controller proportional parameter value. PID controller:
            proportional parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.controller.P = request.ControllerP.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.P
        ControllerPSet = node.get_value()
        return_value = RedoxServicer_pb2.SetControllerP_Responses(ControllerPSet=silaFW_pb2.Real(value=ControllerPSet))

        return return_value

    def GetControllerP(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerP_Responses:
        """
        Executes the unobservable command "Get Controller P"
            Get the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerP (Current Controller P): Current controller proportional parameter value of the
            Redox module. PID controller: proportional parameter.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.P
        CurrentControllerP = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerP_Responses(
            CurrentControllerP=silaFW_pb2.Real(value=CurrentControllerP))

        return return_value

    def SetControllerTd(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetControllerTd_Responses:
        """
        Executes the unobservable command "Set Controller Td"
            Set the controller differentiator time constant. PID controller: differentiator time constant (set to zero
            to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTd (Set Controller Td):
            The controller differentiator time constant. PID controller: differentiator time constant (set to zero to
            disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTdSet (Controller Td Set): The set controller differentiator time constant. PID
            controller: differentiator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Redox.controller.Td = request.ControllerTd.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Td
        ControllerTdSet = node.get_value()
        return_value = RedoxServicer_pb2.SetControllerTd_Responses(
            ControllerTdSet=silaFW_pb2.Real(value=ControllerTdSet))

        return return_value

    def GetControllerTd(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerTd_Responses:
        """
        Executes the unobservable command "Get Controller Td"
            Get the controller differentiator time constant. PID controller: differentiator time constant (set to zero
            to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTd (Current Controller Td): Current controller differentiator time constant of the
            Redox module. PID controller: differentiator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Td
        CurrentControllerTd = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerTd_Responses(
            CurrentControllerTd=silaFW_pb2.Real(value=CurrentControllerTd))

        return return_value

    def SetControllerTi(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetControllerTi_Responses:
        """
        Executes the unobservable command "Set Controller Ti"
            Set the controller integrator time constant. PID controller: integrator time constant (set to zero to
            disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTi (Set Controller Ti):
            The controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTiSet (Controller Ti Set): The set controller integrator time constant. PID controller:
            integrator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Redox.controller.Ti = request.ControllerTi.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Ti
        ControllerTiSet = node.get_value()
        return_value = RedoxServicer_pb2.SetControllerTi_Responses(
            ControllerTiSet=silaFW_pb2.Real(value=ControllerTiSet))

        return return_value

    def GetControllerTi(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerTi_Responses:
        """
        Executes the unobservable command "Get Controller Ti"
            Get the controller integrator time constant. PID controller: integrator time constant (set to zero to
            disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTi (Current Controller Ti): Current controller integrator time constant of the
            Redox module. PID controller: integrator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Ti
        CurrentControllerTi = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerTi_Responses(
            CurrentControllerTi=silaFW_pb2.Real(value=CurrentControllerTi))

        return return_value

    def SetControllerMin(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetControllerMin_Responses:
        """
        Executes the unobservable command "Set Controller Min"
            Set the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMin (Set Controller Min):
            The controller minimal output value. PID controller: minimal output value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMinSet (Controller Min Set): The set controller minimal output value. PID controller:
            minimal output value.
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Redox.controller.Min = request.ControllerMin.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Min
        ControllerMinSet = node.get_value()
        return_value = RedoxServicer_pb2.SetControllerMin_Responses(
            ControllerMinSet=silaFW_pb2.Real(value=ControllerMinSet))

        return return_value

    def GetControllerMin(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerMin_Responses:
        """
        Executes the unobservable command "Get Controller Min"
            Get the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMin (Current Controller Min): Current controller minimal output value of the Redox
            module. PID controller: minimal output value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Min
        CurrentControllerMin = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerMin_Responses(
            CurrentControllerMin=silaFW_pb2.Real(value=CurrentControllerMin))

        return return_value

    def SetControllerMax(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetControllerMax_Responses:
        """
        Executes the unobservable command "Set Controller Max"
            Set the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMax (Set Controller Max):
            The controller maximal output value. PID controller: maximaloutput value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMaxSet (Controller Max Set): The set controller maximal output value. PID controller:
            maximal output value.
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Redox.controller.Max = request.ControllerMax.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Max
        ControllerMaxSet = node.get_value()
        return_value = RedoxServicer_pb2.SetControllerMax_Responses(
            ControllerMaxSet=silaFW_pb2.Real(value=ControllerMaxSet))

        return return_value

    def GetControllerMax(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetControllerMax_Responses:
        """
        Executes the unobservable command "Get Controller Max"
            Get the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMax (Current Controller Max): Current controller maximal output value of the
            Redox module. PID controller: maximal output value.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.controller.Max
        CurrentControllerMax = node.get_value()
        return_value = RedoxServicer_pb2.GetControllerMax_Responses(
            CurrentControllerMax=silaFW_pb2.Real(value=CurrentControllerMax))

        return return_value

    def SetAlarmEnabled(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmEnabled_Responses:
        """
        Executes the unobservable command "Set Alarm Enabled"
            Set the alarm enabled value. Enables alarm function.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmEnabled (Set Alarm Enabled):
            The alarm enabled value. Enables alarm function.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmEnabledSet (Alarm Enabled Set): The set alarm enabled value. Enables alarm function.
        """
    
        # initialise the return value
        return_value = None
    
       # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.Enabled = request.AlarmEnabled.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.Enabled
        AlarmEnabledSet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmEnabled_Responses(
            AlarmEnabledSet=silaFW_pb2.Integer(value=AlarmEnabledSet))

        return return_value

    def GetAlarmEnabled(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmEnabled_Responses:
        """
        Executes the unobservable command "Get Alarm Enabled"
            Get the alarm enabled value. Enables alarm function.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmEnabled (Current Alarm Enabled): Current alarm enabled value of the Redox module.
            Enables alarm function.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.Enabled
        CurrentAlarmEnabled = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmEnabled_Responses(
            CurrentAlarmEnabled=silaFW_pb2.Integer(value=CurrentAlarmEnabled))

        return return_value

    def SetAlarmAlarmHigh(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Executes the unobservable command "Set Alarm AlarmHigh"
            Set the alarm alarmhigh value. Higher alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmAlarmHigh (Set Alarm AlarmHigh):
            The alarm alarmhigh value. Higher alarm limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmAlarmHighSet (Alarm AlarmHigh Set): The set alarm alarmhigh value. Higher alarm limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.AlarmHigh = request.AlarmAlarmHigh.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.AlarmHigh
        AlarmAlarmHighSet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmAlarmHigh_Responses(
            AlarmAlarmHighSet=silaFW_pb2.Real(value=AlarmAlarmHighSet))

        return return_value

    def GetAlarmAlarmHigh(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Executes the unobservable command "Get Alarm AlarmHigh"
            Get the alarm alarmhigh value. Higher alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmAlarmHigh (Current Alarm AlarmHigh): Current alarm alarmhigh value of the Redox module.
            Higher alarm limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.AlarmHigh
        CurrentAlarmAlarmHigh = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmAlarmHigh_Responses(
            CurrentAlarmAlarmHigh=silaFW_pb2.Real(value=CurrentAlarmAlarmHigh))

        return return_value

    def SetAlarmAlarmLow(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Executes the unobservable command "Set Alarm AlarmLow"
            Set the alarm alarmlow value. Lower alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmAlarmLow (Set Alarm AlarmLow):
            The alarm alarmlow value. Lower alarm limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmAlarmLowSet (Alarm AlarmLow Set): The set alarm alarmlow value. Lower alarm limit.
        """
    
        # initialise the return value
        return_value = None

        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.AlarmLow = request.AlarmAlarmLow.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.AlarmLow
        AlarmAlarmLowSet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmAlarmLow_Responses(
            AlarmAlarmLowSet=silaFW_pb2.Real(value=AlarmAlarmLowSet))

        return return_value

    def GetAlarmAlarmLow(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Executes the unobservable command "Get Alarm AlarmLow"
            Get the alarm alarmlow value. Lower alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmAlarmLow (Current Alarm AlarmLow): Current alarm alarmlow value of the Redox module.
            Lower alarm limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.AlarmLow
        CurrentAlarmAlarmLow = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmAlarmLow_Responses(
            CurrentAlarmAlarmLow=silaFW_pb2.Real(value=CurrentAlarmAlarmLow))

        return return_value

    def SetAlarmMode(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmMode_Responses:
        """
        Executes the unobservable command "Set Alarm Mode"
            Set the alarm mode value. Alarm mode.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmMode (Set Alarm Mode):
            The alarm mode value. Alarm mode.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmModeSet (Alarm Mode Set): The set alarm mode value. Alarm mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.Mode = request.AlarmMode.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.Mode
        AlarmModeSet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmMode_Responses(AlarmModeSet=silaFW_pb2.Integer(value=AlarmModeSet))

        return return_value

    def GetAlarmMode(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmMode_Responses:
        """
        Executes the unobservable command "Get Alarm Mode"
            Get the alarm mode value. Alarm mode.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmMode (Current Alarm Mode): Current alarm mode value of the Redox module. Alarm mode.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.Mode
        CurrentAlarmMode = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmMode_Responses(
            CurrentAlarmMode=silaFW_pb2.Integer(value=CurrentAlarmMode))

        return return_value

    def GetAlarmState(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmState_Responses:
        """
        Executes the unobservable command "Get Alarm State"
            Get the alarm state value. Alarm state.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmState (Current Alarm State): Current alarm state value of the Redox module. Alarm state.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.State
        CurrentAlarmState = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmState_Responses(
            CurrentAlarmState=silaFW_pb2.Integer(value=CurrentAlarmState))

        return return_value

    def SetAlarmDelay(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmDelay_Responses:
        """
        Executes the unobservable command "Set Alarm Delay"
            Set the alarm delay value. Alarm hysteresis time.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmDelay (Set Alarm Delay):
            The alarm delay value. Alarm hysteresis time.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmDelaySet (Alarm Delay Set): The set alarm delay value. Alarm hysteresis time.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.Delay = request.AlarmDelay.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.Delay
        AlarmDelaySet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmDelay_Responses(AlarmDelaySet=silaFW_pb2.Real(value=AlarmDelaySet))

        return return_value

    def GetAlarmDelay(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmDelay_Responses:
        """
        Executes the unobservable command "Get Alarm Delay"
            Get the alarm delay value.Alarm hysteresis time.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmDelay (Current Alarm Delay): Current alarm delay value of the Redox module. Alarm
            hysteresis time.
        """
    
        # initialise the return value
        return_value = None

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.Delay
        CurrentAlarmDelay = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmDelay_Responses(
            CurrentAlarmDelay=silaFW_pb2.Real(value=CurrentAlarmDelay))

        return return_value

    def SetAlarmWarnHigh(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Executes the unobservable command "Set Alarm WarnHigh"
            Set the alarm higher warning value. Higher warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmWarnHigh (Set Alarm WarnHigh):
            The alarm higher warning value. Higher warning limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmWarnHighSet (Alarm WarnHigh Set): The set alarm higher warning value. Higher warning limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.WarnHigh = request.AlarmWarnHigh.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.WarnHigh
        AlarmWarnHighSet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmWarnHigh_Responses(
            AlarmWarnHighSet=silaFW_pb2.Real(value=AlarmWarnHighSet))

        return return_value

    def GetAlarmWarnHigh(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Executes the unobservable command "Get Alarm WarnHigh"
            Get the alarm higher warning value. Higher warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmWarnHigh (Current Alarm WarnHigh): Current alarm higher warning value of the Redox
            module. Higher warning limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.WarnHigh
        CurrentAlarmWarnHigh = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmWarnHigh_Responses(
            CurrentAlarmWarnHigh=silaFW_pb2.Real(value=CurrentAlarmWarnHigh))

        return return_value

    def SetAlarmWarnLow(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Executes the unobservable command "Set Alarm WarnLow"
            Set the alarm lower warning value. Lower warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmWarnLow (Set Alarm WarnLow):
            The alarm lower warning value. Lower warning limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmWarnLowSet (Alarm WarnLow Set): The set alarm lower warning value. Lower warning limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Set-command
        self.reactors[request.UnitID.value].unit.Redox.alarm.WarnLow = request.AlarmWarnLow.value

        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.WarnLow
        AlarmWarnLowSet = node.get_value()
        return_value = RedoxServicer_pb2.SetAlarmWarnLow_Responses(
            AlarmWarnLowSet=silaFW_pb2.Real(value=AlarmWarnLowSet))

        return return_value

    def GetAlarmWarnLow(self, request, context: grpc.ServicerContext) \
            -> RedoxServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Executes the unobservable command "Get Alarm WarnLow"
            Get the alarm lower warning value. Lower warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmWarnLow (Current Alarm WarnLow): Current alarm lower warning value of the Redox module.
            Lower warning limit.
        """
    
        # initialise the return value
        return_value = None
    
        # Get command
        node = self.reactors[request.UnitID.value].unit.Redox.alarm.WarnLow
        CurrentAlarmWarnLow = node.get_value()
        return_value = RedoxServicer_pb2.GetAlarmWarnLow_Responses(
            CurrentAlarmWarnLow=silaFW_pb2.Real(value=CurrentAlarmWarnLow))

        return return_value
