"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Temperature Servicer*

:details: TemperatureServicer:
    Control a DASGIP temperature module. Enables read and write operations for various parameters, including temperature
    sensor, controller, and alarm.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    TemperatureServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:15.246958
:date: (last modification) 2020-04-16T10:19:15.246958

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import TemperatureServicer_pb2 as TemperatureServicer_pb2
# from .gRPC import TemperatureServicer_pb2_grpc as TemperatureServicer_pb2_grpc

# import default arguments
from .TemperatureServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class TemperatureServicerSimulation:
    """
    Implementation of the *Temperature Servicer* in *Simulation* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetPV(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetPV_Responses:
        """
        Executes the unobservable command "Get PV"
            Get present value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPV (Current PV): Current present value
        """
    
        # initialise the return value
        return_value = None

        CurrentPV = 0.0
        return_value = TemperatureServicer_pb2.GetPV_Responses(CurrentPV=silaFW_pb2.Real(value=CurrentPV))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetPV_Responses(
                **default_dict['GetPV_Responses']
            )
    
        return return_value

    def SetSPM(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetSPM_Responses:
        """
        Executes the unobservable command "Set Manual Setpoint"
            Set the manual temperature setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPM (Manual Setpoint):
            The manual setpoint of the temperature module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPMSet (Manual Setpoint Set): The set manual setpoint.
        """
    
        # initialise the return value
        return_value = None

        SPMSet = 0.0
        return_value = TemperatureServicer_pb2.SetSPM_Responses(SPMSet=silaFW_pb2.Real(value=SPMSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetSPM_Responses(
                **default_dict['SetSPM_Responses']
            )
    
        return return_value

    def SetSPE(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetSPE_Responses:
        """
        Executes the unobservable command "Set External Setpoint"
            Set the external temperature setpoint.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SPE (External Setpoint):
            The external setpoint of the temperature module.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SPESet (External Setpoint Set): The set external setpoint.
        """
    
        # initialise the return value
        return_value = None

        SPESet = 0.0
        return_value = TemperatureServicer_pb2.SetSPE_Responses(SPESet=silaFW_pb2.Real(value=SPESet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetSPE_Responses(
                **default_dict['SetSPE_Responses']
            )
    
        return return_value

    def GetSP(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSP_Responses:
        """
        Executes the unobservable command "Get SP"
            Get setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSP (Current SP): Current setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentSP = 0.0
        return_value = TemperatureServicer_pb2.GetSP_Responses(CurrentSP=silaFW_pb2.Real(value=CurrentSP))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSP_Responses(
                **default_dict['GetSP_Responses']
            )
    
        return return_value

    def GetSPA(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSPA_Responses:
        """
        Executes the unobservable command "Get SPA"
            Get automatic setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPA (Current SPA): Current automatic setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentSPA = 0.0
        return_value = TemperatureServicer_pb2.GetSPA_Responses(CurrentSPA=silaFW_pb2.Real(value=CurrentSPA))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSPA_Responses(
                **default_dict['GetSPA_Responses']
            )
    
        return return_value

    def GetSPM(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSPM_Responses:
        """
        Executes the unobservable command "Get SPM"
            Get manual setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPM (Current SPM): Current manual setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentSPM = 0.0
        return_value = TemperatureServicer_pb2.GetSPM_Responses(CurrentSPM=silaFW_pb2.Real(value=CurrentSPM))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSPM_Responses(
                **default_dict['GetSPM_Responses']
            )
    
        return return_value

    def GetSPE(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSPE_Responses:
        """
        Executes the unobservable command "Get SPE"
            Get external setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPE (Current SPE): Current external setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentSPE = 0.0
        return_value = TemperatureServicer_pb2.GetSPE_Responses(CurrentSPE=silaFW_pb2.Real(value=CurrentSPE))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSPE_Responses(
                **default_dict['GetSPE_Responses']
            )
    
        return return_value

    def GetSPR(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSPR_Responses:
        """
        Executes the unobservable command "Get SPR"
            Get remote setpoint value
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSPR (Current SPR): Current remote setpoint value
        """
    
        # initialise the return value
        return_value = None

        CurrentSPR = 0.0
        return_value = TemperatureServicer_pb2.GetSPR_Responses(CurrentSPR=silaFW_pb2.Real(value=CurrentSPR))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSPR_Responses(
                **default_dict['GetSPR_Responses']
            )
    
        return return_value

    def GetAccess(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAccess_Responses:
        """
        Executes the unobservable command "Get Access Mode"
            Get access mode value. Controller access (Local, Remote).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAccess (Current Access Mode): Current access mode value. Controller access (Local, Remote)
        """
    
        # initialise the return value
        return_value = None

        CurrentAccess = 1
        return_value = TemperatureServicer_pb2.GetAccess_Responses(
            CurrentAccess=silaFW_pb2.Integer(value=CurrentAccess))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAccess_Responses(
                **default_dict['GetAccess_Responses']
            )
    
        return return_value

    def SetCmd(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetCmd_Responses:
        """
        Executes the unobservable command "Set Controller Command"
            Set the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Cmd (Controller Command):
            The controller command of the temperature module. Controller command (Nothing, Stop, Start).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CmdSet (Cmd Set): The set controller command.
        """
    
        # initialise the return value
        return_value = None

        CmdSet = 0
        return_value = TemperatureServicer_pb2.SetCmd_Responses(CmdSet=silaFW_pb2.Integer(value=CmdSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetCmd_Responses(
                **default_dict['SetCmd_Responses']
            )
    
        return return_value

    def GetCmd(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetCmd_Responses:
        """
        Executes the unobservable command "Get Controller Command"
            Get the controller command. Controller command (Nothing, Stop, Start).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCmd (Current Controller Command): Current controller command value of the temperature module. 
            Controller command (Nothing, Stop, Start)
        """
    
        # initialise the return value
        return_value = None

        CurrentCmd = 0
        return_value = TemperatureServicer_pb2.GetCmd_Responses(CurrentCmd=silaFW_pb2.Integer(value=CurrentCmd))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetCmd_Responses(
                **default_dict['GetCmd_Responses']
            )
    
        return return_value

    def SetMode(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetMode_Responses:
        """
        Executes the unobservable command "Set Controller Mode"
            Set the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.Mode (Controller Mode):
            The controller mode of the temperature module. Controller mode (Manual, Automatic).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ModeSet (Controller Mode Set): The set controller mode.
        """
    
        # initialise the return value
        return_value = None

        ModeSet = 1
        return_value = TemperatureServicer_pb2.SetMode_Responses(ModeSet=silaFW_pb2.Integer(value=ModeSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetMode_Responses(
                **default_dict['SetMode_Responses']
            )
    
        return return_value

    def GetMode(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetMode_Responses:
        """
        Executes the unobservable command "Get Controller Mode"
            Get the controller mode. Controller mode (Manual, Automatic).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMode (Current Controller Mode): Current controller mode value of the temperature module. 
            Controller mode (Manual, Automatic).
        """
    
        # initialise the return value
        return_value = None

        CurrentMode = 1
        return_value = TemperatureServicer_pb2.GetMode_Responses(CurrentMode=silaFW_pb2.Integer(value=CurrentMode))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetMode_Responses(
                **default_dict['GetMode_Responses']
            )
    
        return return_value

    def SetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetSetpointSelect_Responses:
        """
        Executes the unobservable command "Set SetpointSelect"
            Set the selected setpoint that should be used. Setpoint selection (Local, Manual, Internal, Script, 
            External).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SetpointSelect (Set SetpointSelect):
            The selected setpoint of the temperature module. Setpoint selection (Local, Manual, Internal, Script, 
            External).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetpointSelectSet (Setpoint selection Set): The set setpoint selection.
        """
    
        # initialise the return value
        return_value = None

        SetpointSelectSet = 2
        return_value = TemperatureServicer_pb2.SetSetpointSelect_Responses(
            SetpointSelectSet=silaFW_pb2.Integer(value=SetpointSelectSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetSetpointSelect_Responses(
                **default_dict['SetSetpointSelect_Responses']
            )
    
        return return_value

    def GetSetpointSelect(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSetpointSelect_Responses:
        """
        Executes the unobservable command "Get SetpointSelect"
            Get the setpoint selection. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSetpointSelect (Current Setpoint Selection): Current setpoint selection value of the 
            temperature module. Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None

        CurrentSetpointSelect = 2
        return_value = TemperatureServicer_pb2.GetSetpointSelect_Responses(
            CurrentSetpointSelect=silaFW_pb2.Integer(value=CurrentSetpointSelect))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSetpointSelect_Responses(
                **default_dict['GetSetpointSelect_Responses']
            )
    
        return return_value

    def GetState(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetState_Responses:
        """
        Executes the unobservable command "Get State"
            Get controller state. Controller state (Off, On, Error).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentState (Current Controller State): Current controller state value of the temperature module. 
            Controller state (Off, On, Error).
        """
    
        # initialise the return value
        return_value = None

        CurrentState = 0
        return_value = TemperatureServicer_pb2.GetState_Responses(CurrentState=silaFW_pb2.Integer(value=CurrentState))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetState_Responses(
                **default_dict['GetState_Responses']
            )
    
        return return_value

    def GetType(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the temperature module.
        """
    
        # initialise the return value
        return_value = None

        CurrentType = 'SimTemperatureType'
        return_value = TemperatureServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetType_Responses(
                **default_dict['GetType_Responses']
            )
    
        return return_value

    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the 
            temperature module.
        """
    
        # initialise the return value
        return_value = None

        CurrentAvailable = 0
        return_value = TemperatureServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAvailable_Responses(
                **default_dict['GetAvailable_Responses']
            )
    
        return return_value

    def GetName(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the temperature module.
        """
    
        # initialise the return value
        return_value = None

        CurrentName = 'SimTemperature'
        return_value = TemperatureServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetName_Responses(
                **default_dict['GetName_Responses']
            )
    
        return return_value

    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the temperature 
            module.
        """
    
        # initialise the return value
        return_value = None

        CurrentVersion = 'SimTemperatureVersion_1.0'
        return_value = TemperatureServicer_pb2.GetVersion_Responses(
            CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetVersion_Responses(
                **default_dict['GetVersion_Responses']
            )
    
        return return_value

    def SetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetSensorOffset_Responses:
        """
        Executes the unobservable command "Set Sensor Offset"
            Set the sensor offset value that should be used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorOffset (Set SensorOffset):
            The sensor offset value that should be used. Sensor offset calibration parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorOffsetSet (Sensor Offset Set): The set sensor offset value that is used. Sensor offset 
            calibration parameter.
        """
    
        # initialise the return value
        return_value = None

        SensorOffsetSet = 0.0
        return_value = TemperatureServicer_pb2.SetSensorOffset_Responses(
            SensorOffsetSet=silaFW_pb2.Real(value=SensorOffsetSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetSensorOffset_Responses(
                **default_dict['SetSensorOffset_Responses']
            )
    
        return return_value

    def GetSensorOffset(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSensorOffset_Responses:
        """
        Executes the unobservable command "Get Sensor Offset"
            Get the sensor offset value that is used. Sensor offset calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorOffset (Current Sensor Offset): Current sensor offset value of the temperature module. 
            Sensor offset calibration parameter.
        """
    
        # initialise the return value
        return_value = None

        CurrentSensorOffset = 0.0
        return_value = TemperatureServicer_pb2.GetSensorOffset_Responses(
            CurrentSensorOffset=silaFW_pb2.Real(value=CurrentSensorOffset))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSensorOffset_Responses(
                **default_dict['GetSensorOffset_Responses']
            )
    
        return return_value

    def GetSensorPVRaw(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSensorPVRaw_Responses:
        """
        Executes the unobservable command "Get Sensor PVRaw"
            Get the sensor present raw value. Actual process raw value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorPVRaw (Current Sensor PVRaw): Current sensor present raw value of the temperature 
            module. Actual process raw value.
        """
    
        # initialise the return value
        return_value = None

        CurrentSensorPVRaw = 0.0
        return_value = TemperatureServicer_pb2.GetSensorPVRaw_Responses(
            CurrentSensorPVRaw=silaFW_pb2.Real(value=CurrentSensorPVRaw))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSensorPVRaw_Responses(
                **default_dict['GetSensorPVRaw_Responses']
            )
    
        return return_value

    def SetSensorSlope(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetSensorSlope_Responses:
        """
        Executes the unobservable command "Set Sensor Slope"
            Set the sensor slope value. Sensor slope calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorSlope (Set Sensor Slope):
            The sensor slope value. Sensor slope calibration parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorSlopeSet (Sensor Slope Set): The set sensor slope value. Sensor slope calibration parameter.
        """
    
        # initialise the return value
        return_value = None

        SensorSlopeSet = 0.0
        return_value = TemperatureServicer_pb2.SetSensorSlope_Responses(
            SensorSlopeSet=silaFW_pb2.Real(value=SensorSlopeSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetSensorSlope_Responses(
                **default_dict['SetSensorSlope_Responses']
            )
    
        return return_value

    def GetSensorSlope(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSensorSlope_Responses:
        """
        Executes the unobservable command "Get Sensor Slope"
            Get the sensor slope value. Sensor slope calibration parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorSlope (Current Sensor Slope): Current sensor slope value of the temperature module. 
            Sensor slope calibration parameter.
        """
    
        # initialise the return value
        return_value = None

        CurrentSensorSlope = 0.0
        return_value = TemperatureServicer_pb2.GetSensorSlope_Responses(
            CurrentSensorSlope=silaFW_pb2.Real(value=CurrentSensorSlope))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSensorSlope_Responses(
                **default_dict['GetSensorSlope_Responses']
            )
    
        return return_value

    def SetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetSensorCompensation_Responses:
        """
        Executes the unobservable command "Set Sensor Compensation"
            Set the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.SensorCompensation (Set Sensor Compensation):
            The sensor slope value. Sensor temperature compensation parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SensorCompensationSet (Sensor Compensation Set): The set sensor compensation value. Sensor 
            temperature compensation parameter.
        """
    
        # initialise the return value
        return_value = None

        SensorCompensationSet = 0.0
        return_value = TemperatureServicer_pb2.SetSensorCompensation_Responses(
            SensorCompensationSet=silaFW_pb2.Real(value=SensorCompensationSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetSensorCompensation_Responses(
                **default_dict['SetSensorCompensation_Responses']
            )
    
        return return_value

    def GetSensorCompensation(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetSensorCompensation_Responses:
        """
        Executes the unobservable command "Get Sensor Compensation"
            Get the sensor compensation value. Sensor temperature compensation parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorCompensation (Current Sensor Compensation): Current sensor compensation value of the 
            temperature module. Sensor temperature compensation parameter.
        """
    
        # initialise the return value
        return_value = None

        CurrentSensorCompensation = 0.0
        return_value = TemperatureServicer_pb2.GetSensorCompensation_Responses(
            CurrentSensorCompensation=silaFW_pb2.Real(value=CurrentSensorCompensation))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetSensorCompensation_Responses(
                **default_dict['GetSensorCompensation_Responses']
            )
    
        return return_value

    def SetControllerDB(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetControllerDB_Responses:
        """
        Executes the unobservable command "Set Controller DB"
            Set the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerDB (Set Controller DB):
            The controller deadband value. PID controller: deadband (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerDBSet (Controller DB Set): The set controller deadband value. PID controller: deadband 
            (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        ControllerDBSet = 0.0
        return_value = TemperatureServicer_pb2.SetControllerDB_Responses(
            ControllerDBSet=silaFW_pb2.Real(value=ControllerDBSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetControllerDB_Responses(
                **default_dict['SetControllerDB_Responses']
            )
    
        return return_value

    def GetControllerDB(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerDB_Responses:
        """
        Executes the unobservable command "Get Controller DB"
            Get the controller deadband value. PID controller: deadband (set to zero to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerDB (Current Controller DB): Current controller deadband value of the temperature 
            module. PID controller: deadband (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerDB = 0.0
        return_value = TemperatureServicer_pb2.GetControllerDB_Responses(
            CurrentControllerDB=silaFW_pb2.Real(value=CurrentControllerDB))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerDB_Responses(
                **default_dict['GetControllerDB_Responses']
            )
    
        return return_value

    def GetControllerOut(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerOut_Responses:
        """
        Executes the unobservable command "Get Controller Out"
            Get the controller output value. PID controller: actual output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerOut (Current Controller Out): Current controller output value of the temperature 
            module. PID controller: actual output value.
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerOut = 0.0
        return_value = TemperatureServicer_pb2.GetControllerOut_Responses(
            CurrentControllerOut=silaFW_pb2.Real(value=CurrentControllerOut))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerOut_Responses(
                **default_dict['GetControllerOut_Responses']
            )
    
        return return_value

    def SetControllerP(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetControllerP_Responses:
        """
        Executes the unobservable command "Set Controller P"
            Set the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerP (Set Controller P):
            The controller proportional parameter value. PID controller: proportional parameter.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerPSet (Controller P Set): The set controller proportional parameter value. PID controller: 
            proportional parameter.
        """
    
        # initialise the return value
        return_value = None

        ControllerPSet = 0.0
        return_value = TemperatureServicer_pb2.SetControllerP_Responses(
            ControllerPSet=silaFW_pb2.Real(value=ControllerPSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetControllerP_Responses(
                **default_dict['SetControllerP_Responses']
            )
    
        return return_value

    def GetControllerP(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerP_Responses:
        """
        Executes the unobservable command "Get Controller P"
            Get the controller proportional parameter value. PID controller: proportional parameter.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerP (Current Controller P): Current controller proportional parameter value of the 
            temperature module. PID controller: proportional parameter.
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerP = 0.0
        return_value = TemperatureServicer_pb2.GetControllerP_Responses(
            CurrentControllerP=silaFW_pb2.Real(value=CurrentControllerP))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerP_Responses(
                **default_dict['GetControllerP_Responses']
            )
    
        return return_value

    def SetControllerTd(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetControllerTd_Responses:
        """
        Executes the unobservable command "Set Controller Td"
            Set the controller differentiator time constant. PID controller: differentiator time constant (set to zero 
            to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTd (Set Controller Td):
            The controller differentiator time constant. PID controller: differentiator time constant (set to zero to 
            disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTdSet (Controller Td Set): The set controller differentiator time constant. PID 
            controller: differentiator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        ControllerTdSet = 0.0
        return_value = TemperatureServicer_pb2.SetControllerTd_Responses(
            ControllerTdSet=silaFW_pb2.Real(value=ControllerTdSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetControllerTd_Responses(
                **default_dict['SetControllerTd_Responses']
            )
    
        return return_value

    def GetControllerTd(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerTd_Responses:
        """
        Executes the unobservable command "Get Controller Td"
            Get the controller differentiator time constant. PID controller: differentiator time constant (set to zero 
            to disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTd (Current Controller Td): Current controller differentiator time constant of the 
            temperature module. PID controller: differentiator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerTd = 0.0
        return_value = TemperatureServicer_pb2.GetControllerTd_Responses(
            CurrentControllerTd=silaFW_pb2.Real(value=CurrentControllerTd))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerTd_Responses(
                **default_dict['GetControllerTd_Responses']
            )
    
        return return_value

    def SetControllerTi(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetControllerTi_Responses:
        """
        Executes the unobservable command "Set Controller Ti"
            Set the controller integrator time constant. PID controller: integrator time constant (set to zero to 
            disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerTi (Set Controller Ti):
            The controller integrator time constant. PID controller: integrator time constant (set to zero to disable).
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerTiSet (Controller Ti Set): The set controller integrator time constant. PID controller: 
            integrator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        ControllerTiSet = 0.0
        return_value = TemperatureServicer_pb2.SetControllerTi_Responses(
            ControllerTiSet=silaFW_pb2.Real(value=ControllerTiSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetControllerTi_Responses(
                **default_dict['SetControllerTi_Responses']
            )
    
        return return_value

    def GetControllerTi(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerTi_Responses:
        """
        Executes the unobservable command "Get Controller Ti"
            Get the controller integrator time constant. PID controller: integrator time constant (set to zero to 
            disable).
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerTi (Current Controller Ti): Current controller integrator time constant of the 
            temperature module. PID controller: integrator time constant (set to zero to disable).
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerTi = 0.0
        return_value = TemperatureServicer_pb2.GetControllerTi_Responses(
            CurrentControllerTi=silaFW_pb2.Real(value=CurrentControllerTi))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerTi_Responses(
                **default_dict['GetControllerTi_Responses']
            )
    
        return return_value

    def SetControllerMin(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetControllerMin_Responses:
        """
        Executes the unobservable command "Set Controller Min"
            Set the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMin (Set Controller Min):
            The controller minimal output value. PID controller: minimal output value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMinSet (Controller Min Set): The set controller minimal output value. PID controller: 
            minimal output value.
        """
    
        # initialise the return value
        return_value = None

        ControllerMinSet = 0.0
        return_value = TemperatureServicer_pb2.SetControllerMin_Responses(
            ControllerMinSet=silaFW_pb2.Real(value=ControllerMinSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetControllerMin_Responses(
                **default_dict['SetControllerMin_Responses']
            )
    
        return return_value

    def GetControllerMin(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerMin_Responses:
        """
        Executes the unobservable command "Get Controller Min"
            Get the controller minimal output value. PID controller: minimal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMin (Current Controller Min): Current controller minimal output value of the 
            temperature module. PID controller: minimal output value.
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerMin = 0.0
        return_value = TemperatureServicer_pb2.GetControllerMin_Responses(
            CurrentControllerMin=silaFW_pb2.Real(value=CurrentControllerMin))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerMin_Responses(
                **default_dict['GetControllerMin_Responses']
            )
    
        return return_value

    def SetControllerMax(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetControllerMax_Responses:
        """
        Executes the unobservable command "Set Controller Max"
            Set the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.ControllerMax (Set Controller Max):
            The controller maximal output value. PID controller: maximaloutput value.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControllerMaxSet (Controller Max Set): The set controller maximal output value. PID controller: 
            maximal output value.
        """
    
        # initialise the return value
        return_value = None

        ControllerMaxSet = 0.0
        return_value = TemperatureServicer_pb2.SetControllerMax_Responses(
            ControllerMaxSet=silaFW_pb2.Real(value=ControllerMaxSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetControllerMax_Responses(
                **default_dict['SetControllerMax_Responses']
            )
    
        return return_value

    def GetControllerMax(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetControllerMax_Responses:
        """
        Executes the unobservable command "Get Controller Max"
            Get the controller maximal output value. PID controller: maximal output value.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControllerMax (Current Controller Max): Current controller maximal output value of the 
            temperature module. PID controller: maximal output value.
        """
    
        # initialise the return value
        return_value = None

        CurrentControllerMax = 0.0
        return_value = TemperatureServicer_pb2.GetControllerMax_Responses(
            CurrentControllerMax=silaFW_pb2.Real(value=CurrentControllerMax))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetControllerMax_Responses(
                **default_dict['GetControllerMax_Responses']
            )
    
        return return_value

    def SetAlarmEnabled(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmEnabled_Responses:
        """
        Executes the unobservable command "Set Alarm Enabled"
            Set the alarm enabled value. Enables alarm function.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmEnabled (Set Alarm Enabled):
            The alarm enabled value. Enables alarm function.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmEnabledSet (Alarm Enabled Set): The set alarm enabled value. Enables alarm function.
        """
    
        # initialise the return value
        return_value = None

        AlarmEnabledSet = 0
        return_value = TemperatureServicer_pb2.SetAlarmEnabled_Responses(
            AlarmEnabledSet=silaFW_pb2.Integer(value=AlarmEnabledSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmEnabled_Responses(
                **default_dict['SetAlarmEnabled_Responses']
            )
    
        return return_value

    def GetAlarmEnabled(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmEnabled_Responses:
        """
        Executes the unobservable command "Get Alarm enabled"
            Get the alarm enabled value. Enables alarm function.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmEnabled (Current Alarm Enabled): Current alarm enabled value of the temperature module. 
            Enables alarm function.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmEnabled = 0
        return_value = TemperatureServicer_pb2.GetAlarmEnabled_Responses(
            CurrentAlarmEnabled=silaFW_pb2.Integer(value=CurrentAlarmEnabled))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmEnabled_Responses(
                **default_dict['GetAlarmEnabled_Responses']
            )
    
        return return_value

    def SetAlarmAlarmHigh(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmAlarmHigh_Responses:
        """
        Executes the unobservable command "Set Alarm AlarmHigh"
            Set the alarm alarmhigh value. Higher alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmAlarmHigh (Set Alarm AlarmHigh):
            The alarm alarmhigh value. Higher alarm limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmAlarmHighSet (Alarm AlarmHigh Set): The set alarm alarmhigh value. Higher alarm limit.
        """
    
        # initialise the return value
        return_value = None

        AlarmAlarmHighSet = 0.0
        return_value = TemperatureServicer_pb2.SetAlarmAlarmHigh_Responses(
            AlarmAlarmHighSet=silaFW_pb2.Real(value=AlarmAlarmHighSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmAlarmHigh_Responses(
                **default_dict['SetAlarmAlarmHigh_Responses']
            )
    
        return return_value

    def GetAlarmAlarmHigh(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmAlarmHigh_Responses:
        """
        Executes the unobservable command "Get Alarm AlarmHigh"
            Get the alarm alarmhigh value. Higher alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmAlarmHigh (Current Alarm AlarmHigh): Current alarm alarmhigh value of the temperature 
            module. Higher alarm limit.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmAlarmHigh = 0.0
        return_value = TemperatureServicer_pb2.GetAlarmAlarmHigh_Responses(
            CurrentAlarmAlarmHigh=silaFW_pb2.Real(value=CurrentAlarmAlarmHigh))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmAlarmHigh_Responses(
                **default_dict['GetAlarmAlarmHigh_Responses']
            )
    
        return return_value

    def SetAlarmAlarmLow(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmAlarmLow_Responses:
        """
        Executes the unobservable command "Set Alarm AlarmLow"
            Set the alarm alarmlow value. Lower alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmAlarmLow (Set Alarm AlarmLow):
            The alarm alarmlow value. Lower alarm limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmAlarmLowSet (Alarm AlarmLow Set): The set alarm alarmlow value. Lower alarm limit.
        """
    
        # initialise the return value
        return_value = None

        AlarmAlarmLowSet = 0.0
        return_value = TemperatureServicer_pb2.SetAlarmAlarmLow_Responses(
            AlarmAlarmLowSet=silaFW_pb2.Real(value=AlarmAlarmLowSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmAlarmLow_Responses(
                **default_dict['SetAlarmAlarmLow_Responses']
            )
    
        return return_value

    def GetAlarmAlarmLow(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmAlarmLow_Responses:
        """
        Executes the unobservable command "Get Alarm AlarmLow"
            Get the alarm alarmlow value. Lower alarm limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmAlarmLow (Current Alarm AlarmLow): Current alarm alarmlow value of the temperature 
            module. Lower alarm limit.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmAlarmLow = 0.0
        return_value = TemperatureServicer_pb2.GetAlarmAlarmLow_Responses(
            CurrentAlarmAlarmLow=silaFW_pb2.Real(value=CurrentAlarmAlarmLow))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmAlarmLow_Responses(
                **default_dict['GetAlarmAlarmLow_Responses']
            )
    
        return return_value

    def SetAlarmMode(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmMode_Responses:
        """
        Executes the unobservable command "Set Alarm Mode"
            Set the alarm mode value. Alarm mode.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmMode (Set Alarm Mode):
            The alarm mode value. Alarm mode.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmModeSet (Alarm Mode Set): The set alarm mode value. Alarm mode.
        """
    
        # initialise the return value
        return_value = None

        AlarmModeSet = 1
        return_value = TemperatureServicer_pb2.SetAlarmMode_Responses(
            AlarmModeSet=silaFW_pb2.Integer(value=AlarmModeSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmMode_Responses(
                **default_dict['SetAlarmMode_Responses']
            )
    
        return return_value

    def GetAlarmMode(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmMode_Responses:
        """
        Executes the unobservable command "Get Alarm Mode"
            Get the alarm mode value. Alarm mode.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmMode (Current Alarm Mode): Current alarm mode value of the temperature module. Alarm 
            mode.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmMode = 1
        return_value = TemperatureServicer_pb2.GetAlarmMode_Responses(
            CurrentAlarmMode=silaFW_pb2.Integer(value=CurrentAlarmMode))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmMode_Responses(
                **default_dict['GetAlarmMode_Responses']
            )
    
        return return_value

    def GetAlarmState(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmState_Responses:
        """
        Executes the unobservable command "Get Alarm State"
            Get the alarm state value. Alarm state.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmState (Current Alarm State): Current alarm state value of the temperature module. Alarm 
            state.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmState = 0
        return_value = TemperatureServicer_pb2.GetAlarmState_Responses(
            CurrentAlarmState=silaFW_pb2.Integer(value=CurrentAlarmState))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmState_Responses(
                **default_dict['GetAlarmState_Responses']
            )
    
        return return_value

    def SetAlarmDelay(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmDelay_Responses:
        """
        Executes the unobservable command "Set Alarm Delay"
            Set the alarm delay value. Alarm hysteresis time.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmDelay (Set Alarm Delay):
            The alarm delay value. Alarm hysteresis time.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmDelaySet (Alarm Delay Set): The set alarm delay value. Alarm hysteresis time.
        """
    
        # initialise the return value
        return_value = None

        AlarmDelaySet = 0.0
        return_value = TemperatureServicer_pb2.SetAlarmDelay_Responses(
            AlarmDelaySet=silaFW_pb2.Real(value=AlarmDelaySet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmDelay_Responses(
                **default_dict['SetAlarmDelay_Responses']
            )
    
        return return_value

    def GetAlarmDelay(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmDelay_Responses:
        """
        Executes the unobservable command "Get Alarm Delay"
            Get the alarm delay value.Alarm hysteresis time.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmDelay (Current Alarm Delay): Current alarm delay value of the temperature module. Alarm 
            hysteresis time.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmDelay = 0.0
        return_value = TemperatureServicer_pb2.GetAlarmDelay_Responses(
            CurrentAlarmDelay=silaFW_pb2.Real(value=CurrentAlarmDelay))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmDelay_Responses(
                **default_dict['GetAlarmDelay_Responses']
            )
    
        return return_value

    def SetAlarmWarnHigh(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmWarnHigh_Responses:
        """
        Executes the unobservable command "Set Alarm WarnHigh"
            Set the alarm higher warning value. Higher warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmWarnHigh (Set Alarm WarnHigh):
            The alarm higher warning value. Higher warning limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmWarnHighSet (Alarm WarnHigh Set): The set alarm higher warning value. Higher warning limit.
        """
    
        # initialise the return value
        return_value = None

        AlarmWarnHighSet = 0.0
        return_value = TemperatureServicer_pb2.SetAlarmWarnHigh_Responses(
            AlarmWarnHighSet=silaFW_pb2.Real(value=AlarmWarnHighSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmWarnHigh_Responses(
                **default_dict['SetAlarmWarnHigh_Responses']
            )
    
        return return_value

    def GetAlarmWarnHigh(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmWarnHigh_Responses:
        """
        Executes the unobservable command "Get Alarm WarnHigh"
            Get the alarm higher warning value. Higher warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmWarnHigh (Current Alarm WarnHigh): Current alarm higher warning value of the temperature 
            module. Higher warning limit.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmWarnHigh = 0.0
        return_value = TemperatureServicer_pb2.GetAlarmWarnHigh_Responses(
            CurrentAlarmWarnHigh=silaFW_pb2.Real(value=CurrentAlarmWarnHigh))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmWarnHigh_Responses(
                **default_dict['GetAlarmWarnHigh_Responses']
            )
    
        return return_value

    def SetAlarmWarnLow(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.SetAlarmWarnLow_Responses:
        """
        Executes the unobservable command "Set Alarm WarnLow"
            Set the alarm lower warning value. Lower warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
            request.AlarmWarnLow (Set Alarm WarnLow):
            The alarm lower warning value. Lower warning limit.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.AlarmWarnLowSet (Alarm WarnLow Set): The set alarm lower warning value. Lower warning limit.
        """
    
        # initialise the return value
        return_value = None

        AlarmWarnLowSet = 0.0
        return_value = TemperatureServicer_pb2.SetAlarmWarnLow_Responses(
            AlarmWarnLowSet=silaFW_pb2.Real(value=AlarmWarnLowSet))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.SetAlarmWarnLow_Responses(
                **default_dict['SetAlarmWarnLow_Responses']
            )
    
        return return_value

    def GetAlarmWarnLow(self, request, context: grpc.ServicerContext) \
            -> TemperatureServicer_pb2.GetAlarmWarnLow_Responses:
        """
        Executes the unobservable command "Get Alarm WarnLow"
            Get the alarm lower warning value. Lower warning limit.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmWarnLow (Current Alarm WarnLow): Current alarm lower warning value of the temperature 
            module. Lower warning limit.
        """
    
        # initialise the return value
        return_value = None

        CurrentAlarmWarnLow = 0.0
        return_value = TemperatureServicer_pb2.GetAlarmWarnLow_Responses(
            CurrentAlarmWarnLow=silaFW_pb2.Real(value=CurrentAlarmWarnLow))

        # fallback to default
        if return_value is None:
            return_value = TemperatureServicer_pb2.GetAlarmWarnLow_Responses(
                **default_dict['GetAlarmWarnLow_Responses']
            )
    
        return return_value
