"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Turbidity Servicer*

:details: TurbidityServicer:
    Control a DASGIP turbidity module. Enables read and write operations for various parameters, including turbidity
    sensor, controller, and alarm.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    TurbidityServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:19:15.307162
:date: (last modification) 2020-04-16T10:19:15.307162

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "0.0.1"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import TurbidityServicer_pb2 as TurbidityServicer_pb2
# from .gRPC import TurbidityServicer_pb2_grpc as TurbidityServicer_pb2_grpc

# import default arguments
from .TurbidityServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class TurbidityServicerSimulation:
    """
    Implementation of the *Turbidity Servicer* in *Simulation* mode
        This is a DASGIP Service
    """

    def __init__(self, reactors):
        """Class initialiser"""
        self.reactors = reactors
        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetAUPV(self, request, context: grpc.ServicerContext) \
            -> TurbidityServicer_pb2.GetAUPV_Responses:
        """
        Executes the unobservable command "Get AU PV"
            Get present value in absorption unit. Turbidity signal in absorption units.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAUPV (Current AU PV): Current present value in absorption unit. Turbidity signal in 
            absorption units.
        """
    
        # initialise the return value
        return_value = None

        CurrentAUPV = 0.0
        return_value = TurbidityServicer_pb2.GetAUPV_Responses(CurrentAUPV=silaFW_pb2.Real(value=CurrentAUPV))

        # fallback to default
        if return_value is None:
            return_value = TurbidityServicer_pb2.GetAUPV_Responses(
                **default_dict['GetAUPV_Responses']
            )
    
        return return_value

    def GetCXPV(self, request, context: grpc.ServicerContext) \
            -> TurbidityServicer_pb2.GetCXPV_Responses:
        """
        Executes the unobservable command "Get CX PV"
            Get calculated turbidity present value. Calculated turbidity signal, i.e. OD600, CDW or others.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCXPV (Current CX PV): Current calculated turbidity present value. Calculated turbidity 
            signal, i.e. OD600, CDW or others.
        """
    
        # initialise the return value
        return_value = None

        CurrentCXPV = 0.0
        return_value = TurbidityServicer_pb2.GetCXPV_Responses(CurrentCXPV=silaFW_pb2.Real(value=CurrentCXPV))

        # fallback to default
        if return_value is None:
            return_value = TurbidityServicer_pb2.GetCXPV_Responses(
                **default_dict['GetCXPV_Responses']
            )
    
        return return_value

    def GetType(self, request, context: grpc.ServicerContext) \
            -> TurbidityServicer_pb2.GetType_Responses:
        """
        Executes the unobservable command "Get Function Type"
            Get function type.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentType (Current Function Type): Current function type value of the turbidity module.
        """
    
        # initialise the return value
        return_value = None

        CurrentType = 'SimTurbidityType'
        return_value = TurbidityServicer_pb2.GetType_Responses(CurrentType=silaFW_pb2.String(value=CurrentType))

        # fallback to default
        if return_value is None:
            return_value = TurbidityServicer_pb2.GetType_Responses(
                **default_dict['GetType_Responses']
            )
    
        return return_value

    def GetAvailable(self, request, context: grpc.ServicerContext) \
            -> TurbidityServicer_pb2.GetAvailable_Responses:
        """
        Executes the unobservable command "Get Function Availability"
            Get function availability.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAvailable (Current Function Availability): Current function availability value of the 
            turbidity module.
        """
    
        # initialise the return value
        return_value = None

        CurrentAvailable = 0
        return_value = TurbidityServicer_pb2.GetAvailable_Responses(
            CurrentAvailable=silaFW_pb2.Integer(value=CurrentAvailable))

        # fallback to default
        if return_value is None:
            return_value = TurbidityServicer_pb2.GetAvailable_Responses(
                **default_dict['GetAvailable_Responses']
            )
    
        return return_value

    def GetName(self, request, context: grpc.ServicerContext) \
            -> TurbidityServicer_pb2.GetName_Responses:
        """
        Executes the unobservable command "Get Function Name"
            Get function name.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentName (Current Function Name): Current function name of the turbidity module.
        """
    
        # initialise the return value
        return_value = None

        CurrentName = 'SimTurbidity'
        return_value = TurbidityServicer_pb2.GetName_Responses(CurrentName=silaFW_pb2.String(value=CurrentName))

        # fallback to default
        if return_value is None:
            return_value = TurbidityServicer_pb2.GetName_Responses(
                **default_dict['GetName_Responses']
            )
    
        return return_value

    def GetVersion(self, request, context: grpc.ServicerContext) \
            -> TurbidityServicer_pb2.GetVersion_Responses:
        """
        Executes the unobservable command "Get Function Version"
            Get function model version number.
    
        :param request: gRPC request containing the parameters passed:
            request.UnitID (UnitID):
            The UnitID of the adressed reactor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVersion (Current Function Version): Current function model version number of the turbidity 
            module.
        """
    
        # initialise the return value
        return_value = None

        CurrentVersion = 'SimTurbidityVersion_1.0'
        return_value = TurbidityServicer_pb2.GetVersion_Responses(
            CurrentVersion=silaFW_pb2.String(value=CurrentVersion))

        # fallback to default
        if return_value is None:
            return_value = TurbidityServicer_pb2.GetVersion_Responses(
                **default_dict['GetVersion_Responses']
            )
    
        return return_value
