"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Service*

:details: CalibrationService:
    Delivers full information of the calibration system and allows complete overwriting of it.
    By Lukas Bromig and Jose de Jesus Pina, Institute of Biochemical Engineering, Technical University of Munich,
    02.12.2020
           
:file:    CalibrationService_servicer.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-03-19T13:54:01.470330
:date: (last modification) 2021-03-19T13:54:01.470330

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import CalibrationService_pb2 as CalibrationService_pb2
from .gRPC import CalibrationService_pb2_grpc as CalibrationService_pb2_grpc

# import simulation and real implementation
from .CalibrationService_simulation import CalibrationServiceSimulation
from .CalibrationService_real import CalibrationServiceReal


class CalibrationService(CalibrationService_pb2_grpc.CalibrationServiceServicer):
    """
    This is a flowmeter service
    """
    implementation: Union[CalibrationServiceSimulation, CalibrationServiceReal]
    simulation_mode: bool

    def __init__(self, ser, lock, status, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """

        self.lock = lock
        self.ser = ser
        self.status = status
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(CalibrationServiceSimulation(status=self.status))
        else:
            self._inject_implementation(CalibrationServiceReal(ser=self.ser, status=self.status))

    def _inject_implementation(self,
                               implementation: Union[CalibrationServiceSimulation,
                                                     CalibrationServiceReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the FlowmeterServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(CalibrationServiceSimulation(status=self.status))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(CalibrationServiceReal(ser=self.ser, status=self.status))

    def GetCalibrationCertificate(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetCalibrationCertificate_Responses:
        """
        Executes the unobservable command "Get calibration certificate"
            Number of calibration certificate (last basic calibration)
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LastCalibrationCertificate (Last calibration certificate): Number of calibration certificate (last basic calibration)
        """
    
        logging.debug(
            "GetCalibrationCertificate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCalibrationCertificate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCalibrationCertificate(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetCalibrationCertificate_Responses:
        """
        Executes the unobservable command "Set calibration certificate"
            Set new calibration certificate
    
        :param request: gRPC request containing the parameters passed:
            request.SetCalibrationCertificate (Set new calibration certificate):
            Set new certificate of the last basic calibration
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set calibration service
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set calibration service status applies
        """
    
        logging.debug(
            "SetCalibrationCertificate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCalibrationCertificate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCalibrationDate(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetCalibrationDate_Responses:
        """
        Executes the unobservable command "Get Calibration date"
            Date of last (basic) calibration
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LastCalibrationDate (Last calibration date): Date of last (basic) calibration
        """
    
        logging.debug(
            "GetCalibrationDate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCalibrationDate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCalibrationDate(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetCalibrationDate_Responses:
        """
        Executes the unobservable command "Set calibration date"
            Set new calibration date
    
        :param request: gRPC request containing the parameters passed:
            request.SetCalibrationDate (Set calibration date):
            New date of the last basic calibration
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set calibration date
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set calibration date status applies
        """
    
        logging.debug(
            "SetCalibrationDate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCalibrationDate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetServiceNumber(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetServiceNumber_Responses:
        """
        Executes the unobservable command "Get Service number"
            Service number for repair/re-building/re-calibration
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LastServiceNumber (Last service number):
            Last service number for repair/re-building/re-calibration
        """
    
        logging.debug(
            "GetServiceNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetServiceNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetServiceNumber(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetServiceNumber_Responses:
        """
        Executes the unobservable command "Set service number"
            Set new service number for repair/re-building/re-calibration
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set service number
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set service number status applies
        """
    
        logging.debug(
            "SetServiceNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetServiceNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetServiceDate(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetServiceDate_Responses:
        """
        Executes the unobservable command "Get service date"
            Date of last maintenance service
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LastServiceDate (Last service date): Date of last service
        """
    
        logging.debug(
            "GetServiceDate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetServiceDate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetServiceDate(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetServiceDate_Responses:
        """
        Executes the unobservable command "Set service date"
            Set new date of last maintenance service
    
        :param request: gRPC request containing the parameters passed:
            request.SetServiceDate (Set service date):
            Set new date of last maintenance service
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set service date
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set service date status applies
        """
    
        logging.debug(
            "SetServiceDate called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetServiceDate(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorCalibrationTemperature(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetSensorCalibrationTemperature_Responses:
        """
        Executes the unobservable command "Get Sensor calibration temperature"
            Sensor temperature from the last calibration in degree Celsius
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorCalibrationTemperature (Current sensor calibration temperature in degree Celsius ): Sensor temperature from the last calibration in
        """
    
        logging.debug(
            "GetSensorCalibrationTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorCalibrationTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSensorCalibrationTemperature(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetSensorCalibrationTemperature_Responses:
        """
        Executes the unobservable command "Set sensor calibration temperature"
            Set sensor calibration temperature in degree Celsius
    
        :param request: gRPC request containing the parameters passed:
            request.SetSensorCalibrationTemperature (Set sensor calibration temperature): Set new sensor calibration temperature in degree Celsuis
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status):
            Command status: Request response of command set sensor calibration temperature
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set sensor calibration temperature status applies
        """
    
        logging.debug(
            "SetSensorCalibrationTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSensorCalibrationTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
