"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Service*

:details: DeviceService:
    Delivers full information of the device, actual parameters, relevant information and allows modification of device
    parameters
    By Lukas Bromig and Jose de Jesus Pina, Institute of Biochemical Engineering, Technical University of Munich,
    12.02.2020
           
:file:    DeviceService_servicer.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-03-21T13:49:44.208267
:date: (last modification) 2021-03-21T13:49:44.208267

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceService_pb2 as DeviceService_pb2
from .gRPC import DeviceService_pb2_grpc as DeviceService_pb2_grpc

# import simulation and real implementation
from .DeviceService_simulation import DeviceServiceSimulation
from .DeviceService_real import DeviceServiceReal


class DeviceService(DeviceService_pb2_grpc.DeviceServiceServicer):
    """
    This is a flowmeter service
    """
    implementation: Union[DeviceServiceSimulation, DeviceServiceReal]
    simulation_mode: bool

    def __init__(self, ser, lock, status, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.lock = lock
        self.ser = ser
        self.status = status
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceServiceSimulation(status=self.status))
        else:
            self._inject_implementation(DeviceServiceReal(ser=self.ser, status=self.status))

    def _inject_implementation(self,
                               implementation: Union[DeviceServiceSimulation,
                                                     DeviceServiceReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the FlowmeterServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceServiceSimulation(status=self.status))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceServiceReal(ser=self.ser, status=self.status))

    def GetIdentificationString(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetIdentificationString_Responses:
        """
        Executes the unobservable command "Get Identification String"
            Identification number of the device and software version
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentIdentificationString (Current identification string): Identification number of the device and software version
        """
    
        logging.debug(
            "GetIdentificationString called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetIdentificationString(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPrimaryNodeAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetPrimaryNodeAddress_Responses:
        """
        Executes the unobservable command "Get primary node address "
            Primary node address: network parameter Flow-Bus
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPrimaryNodeAddress (Current primary node address): Primary node address: network parameter Flow-Bus
        """
    
        logging.debug(
            "GetPrimaryNodeAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPrimaryNodeAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPrimaryNodeAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.SetPrimaryNodeAddress_Responses:
        """
        Executes the unobservable command "Set primary node address"
            Primary node address: network parameter Flow-Bus
    
        :param request: gRPC request containing the parameters passed:
            request.SetPrimaryNodeAddress (Set primary node address): Primary node address: network parameter Flow-Bus
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set primary node address
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set primary node address applies
        """
    
        logging.debug(
            "SetPrimaryNodeAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPrimaryNodeAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSecondaryNodeAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetSecondaryNodeAddress_Responses:
        """
        Executes the unobservable command "Get secondary node address "
            Secondary node address: network parameter Flow-Bus
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSecondaryNodeAddress (Current secondary node address): Secondary node address: network parameter Flow-Bus
        """
    
        logging.debug(
            "GetSecondaryNodeAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSecondaryNodeAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetNextNodeAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetNextNodeAddress_Responses:
        """
        Executes the unobservable command "Get next node address"
            Next node address: network parameter Flow-Bus
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentNextNodeAddress (Current next node address): Next node address: network parameter Flow-Bus
        """
    
        logging.debug(
            "GetNextNodeAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetNextNodeAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLastNodeAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetLastNodeAddress_Responses:
        """
        Executes the unobservable command "Get last node address "
            Last node address: network parameter Flow-Bus
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLastNodeAddress (current last node address): Last node address: network parameter Flow-Bus
        """
    
        logging.debug(
            "GetLastNodeAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetLastNodeAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorType(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetSensorType_Responses:
        """
        Executes the unobservable command "Get sensor type"
            Sensor type information for actual reading and sensor/controller indication
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorType (current sensor type): Sensor type information for actual reading and sensor/controller indication
        """
    
        logging.debug(
            "GetSensorType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetAlarmInformation(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetAlarmInformation_Responses:
        """
        Executes the unobservable command "Get alarm information"
            Information of several alarms/errors in the instrument
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentAlarmInformation (Current alarm information): Information of several alarms/errors in the instrument
        """
    
        logging.debug(
            "GetAlarmInformation called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetAlarmInformation(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDeviceType(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetDeviceType_Responses:
        """
        Executes the unobservable command "Get device type"
            Flow bus device type information
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDeviceType (Current device type): Current flow bus device type information
        """
    
        logging.debug(
            "GetDeviceType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDeviceType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFirmwareVersion(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetFirmwareVersion_Responses:
        """
        Executes the unobservable command "Get firmware version"
            revision number of the firmware
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFirmwareVersion (Current firmware version): revision number of the firmware
        """
    
        logging.debug(
            "GetFirmwareVersion called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFirmwareVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPressureSensorType(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetPressureSensorType_Responses:
        """
        Executes the unobservable command "Get pressure sensor type"
            type of pressure sensor
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPressureSensorType (Current pressure sensor type): type of pressure sensor
        """
    
        logging.debug(
            "GetPressureSensorType called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPressureSensorType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorName(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetSensorName_Responses:
        """
        Executes the unobservable command "Get sensor name"
            label with information about stop sensor
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorName (Current sensor name): label with information about stop sensor
        """
    
        logging.debug(
            "GetSensorName called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorName(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetIdentificationNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetIdentificationNumber_Responses:
        """
        Executes the unobservable command "Get identification number"
            Identification number type of instrument/device
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentIdentificationNumber (Current identification number): Identification number type of instrument/device
        """
    
        logging.debug(
            "GetIdentificationNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetIdentificationNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPowerMode(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetPowerMode_Responses:
        """
        Executes the unobservable command "Get power mode"
            power suppy indication in Vdc
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPowerMode (Current power mode): power supply indication in Vdc
        """
    
        logging.debug(
            "GetPowerMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPowerMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetBusDiagnostic(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetBusDiagnostic_Responses:
        """
        Executes the unobservable command "Get bus diagnostic"
            Fieldbus baudrate (top interface)
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentBusDiagnostic (Current bus diagnostic): Fieldbus baudrate (top interface)
        """
    
        logging.debug(
            "GetBusDiagnostic called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetBusDiagnostic(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFieldbus(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetFieldbus_Responses:
        """
        Executes the unobservable command "Get fieldbus string"
            Fieldbus string name of the top interface
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFieldbus (Current bus string): Fieldbus string name of the top interface
        """
    
        logging.debug(
            "GetFieldbus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFieldbus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetInstrumentProperties(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetInstrumentProperties_Responses:
        """
        Executes the unobservable command "Get instrument properties"
            instrument properties
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentInstrumentProperties (Current instrument properties): Instrument properties
        """
    
        logging.debug(
            "GetInstrumentProperties called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetInstrumentProperties(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCommunicationProtocol(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetCommunicationProtocol_Responses:
        """
        Executes the unobservable command "Get communication protocol"
            Current communication protocol between the program adn the device.
            2 possible options: "binary" and "ascii"
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCommunicationProtocol (Current communication protocol): Primary node address: network parameter Flow-Bus
        """
    
        logging.debug(
            "GetCommunicationProtocol called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCommunicationProtocol(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCommunicationProtocol(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.SetCommunicationProtocol_Responses:
        """
        Executes the unobservable command "Set communication protocol"
            Allows to choose the communication protocol between the program adn the device.
            2 possible options:_ "binary" and "ascii"
    
        :param request: gRPC request containing the parameters passed:
            request.SetCommunicationProtocol (Set communication protocol):
            Allows to choose the communication protocol between the program adn the device.
            2 possible options:_ "binary" and "ascii"
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EmptyResponse (Empty Response): An empty response data type used if no response is required.
        """
    
        logging.debug(
            "SetCommunicationProtocol called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCommunicationProtocol(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSerialPort(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetSerialPort_Responses:
        """
        Executes the unobservable command "Get serial port"
            Current devices serial port
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EmptyResponse (Empty Response): An empty response data type used if no response is required.
        """
    
        logging.debug(
            "GetSerialPort called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSerialPort(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSerialPort(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.SetSerialPort_Responses:
        """
        Executes the unobservable command "Set serial port"
            Sets devices new serial port
    
        :param request: gRPC request containing the parameters passed:
            request.SetSerialPort (Set serial port): Sets devices new serial port
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.EmptyResponse (Empty Response): An empty response data type used if no response is required.
        """
    
        logging.debug(
            "SetSerialPort called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSerialPort(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
