#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*FlowmeterService client*

:details: FlowmeterService:
    This is a flowmeter service

:file:    FlowmeterService_client.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-03-19T13:54:01.553049
:date: (last modification) 2021-03-19T13:54:01.553049

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from AlarmService.gRPC import AlarmService_pb2
from AlarmService.gRPC import AlarmService_pb2_grpc
# import default arguments for this feature
from AlarmService.AlarmService_default_arguments import default_dict as AlarmService_default_dict
from CalibrationService.gRPC import CalibrationService_pb2
from CalibrationService.gRPC import CalibrationService_pb2_grpc
# import default arguments for this feature
from CalibrationService.CalibrationService_default_arguments import default_dict as CalibrationService_default_dict
from DeviceService.gRPC import DeviceService_pb2
from DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from FluidDefinitionService.gRPC import FluidDefinitionService_pb2
from FluidDefinitionService.gRPC import FluidDefinitionService_pb2_grpc
# import default arguments for this feature
from FluidDefinitionService.FluidDefinitionService_default_arguments import default_dict as FluidDefinitionService_default_dict
from MeasurementProvider.gRPC import MeasurementProvider_pb2
from MeasurementProvider.gRPC import MeasurementProvider_pb2_grpc
# import default arguments for this feature
from MeasurementProvider.MeasurementProvider_default_arguments import default_dict as MeasurementProvider_default_dict
from MeasurementSettingsService.gRPC import MeasurementSettingsService_pb2
from MeasurementSettingsService.gRPC import MeasurementSettingsService_pb2_grpc
# import default arguments for this feature
from MeasurementSettingsService.MeasurementSettingsService_default_arguments import default_dict as MeasurementSettingsService_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class FlowmeterServiceClient(SiLA2Client):
    """
        This is a flowmeter service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "FlowmeterServiceClient", description: str = "This is a flowmeter service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "lukas.bromig@tum.de",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service FlowmeterService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.AlarmService_stub = \
            AlarmService_pb2_grpc.AlarmServiceStub(self.channel)
        self.CalibrationService_stub = \
            CalibrationService_pb2_grpc.CalibrationServiceStub(self.channel)
        self.DeviceService_stub = \
            DeviceService_pb2_grpc.DeviceServiceStub(self.channel)
        self.FluidDefinitionService_stub = \
            FluidDefinitionService_pb2_grpc.FluidDefinitionServiceStub(self.channel)
        self.MeasurementProvider_stub = \
            MeasurementProvider_pb2_grpc.MeasurementProviderStub(self.channel)
        self.MeasurementSettingsService_stub = \
            MeasurementSettingsService_pb2_grpc.MeasurementSettingsServiceStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def GetAlarmLimitMaximum(self,
                      parameter: AlarmService_pb2.GetAlarmLimitMaximum_Parameters = None) \
            -> AlarmService_pb2.GetAlarmLimitMaximum_Responses:
        """
        Wrapper to call the unobservable command GetAlarmLimitMaximum on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmLimitMaximum:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.GetAlarmLimitMaximum_Parameters(
                    **AlarmService_default_dict['GetAlarmLimitMaximum_Parameters']
                )
    
            response = self.AlarmService_stub.GetAlarmLimitMaximum(parameter)
    
            logging.debug('GetAlarmLimitMaximum response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetAlarmLimitMaximum(self,
                      parameter: AlarmService_pb2.SetAlarmLimitMaximum_Parameters = None) \
            -> AlarmService_pb2.SetAlarmLimitMaximum_Responses:
        """
        Wrapper to call the unobservable command SetAlarmLimitMaximum on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmLimitMaximum:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.SetAlarmLimitMaximum_Parameters(
                    **AlarmService_default_dict['SetAlarmLimitMaximum_Parameters']
                )
    
            response = self.AlarmService_stub.SetAlarmLimitMaximum(parameter)
    
            logging.debug('SetAlarmLimitMaximum response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetAlarmLimitMinimum(self,
                      parameter: AlarmService_pb2.GetAlarmLimitMinimum_Parameters = None) \
            -> AlarmService_pb2.GetAlarmLimitMinimum_Responses:
        """
        Wrapper to call the unobservable command GetAlarmLimitMinimum on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmLimitMinimum:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.GetAlarmLimitMinimum_Parameters(
                    **AlarmService_default_dict['GetAlarmLimitMinimum_Parameters']
                )
    
            response = self.AlarmService_stub.GetAlarmLimitMinimum(parameter)
    
            logging.debug('GetAlarmLimitMinimum response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetAlarmLimitMinimum(self,
                      parameter: AlarmService_pb2.SetAlarmLimitMinimum_Parameters = None) \
            -> AlarmService_pb2.SetAlarmLimitMinimum_Responses:
        """
        Wrapper to call the unobservable command SetAlarmLimitMinimum on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmLimitMinimum:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.SetAlarmLimitMinimum_Parameters(
                    **AlarmService_default_dict['SetAlarmLimitMinimum_Parameters']
                )
    
            response = self.AlarmService_stub.SetAlarmLimitMinimum(parameter)
    
            logging.debug('SetAlarmLimitMinimum response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetAlarmMode(self,
                      parameter: AlarmService_pb2.GetAlarmMode_Parameters = None) \
            -> AlarmService_pb2.GetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.GetAlarmMode_Parameters(
                    **AlarmService_default_dict['GetAlarmMode_Parameters']
                )
    
            response = self.AlarmService_stub.GetAlarmMode(parameter)
    
            logging.debug('GetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetAlarmMode(self,
                      parameter: AlarmService_pb2.SetAlarmMode_Parameters = None) \
            -> AlarmService_pb2.SetAlarmMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.SetAlarmMode_Parameters(
                    **AlarmService_default_dict['SetAlarmMode_Parameters']
                )
    
            response = self.AlarmService_stub.SetAlarmMode(parameter)
    
            logging.debug('SetAlarmMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetAlarmOutputMode(self,
                      parameter: AlarmService_pb2.GetAlarmOutputMode_Parameters = None) \
            -> AlarmService_pb2.GetAlarmOutputMode_Responses:
        """
        Wrapper to call the unobservable command GetAlarmOutputMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmOutputMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.GetAlarmOutputMode_Parameters(
                    **AlarmService_default_dict['GetAlarmOutputMode_Parameters']
                )
    
            response = self.AlarmService_stub.GetAlarmOutputMode(parameter)
    
            logging.debug('GetAlarmOutputMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetAlarmOutputMode(self,
                      parameter: AlarmService_pb2.SetAlarmOutputMode_Parameters = None) \
            -> AlarmService_pb2.SetAlarmOutputMode_Responses:
        """
        Wrapper to call the unobservable command SetAlarmOutputMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmOutputMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.SetAlarmOutputMode_Parameters(
                    **AlarmService_default_dict['SetAlarmOutputMode_Parameters']
                )
    
            response = self.AlarmService_stub.SetAlarmOutputMode(parameter)
    
            logging.debug('SetAlarmOutputMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetAlarmSetpoint(self,
                      parameter: AlarmService_pb2.GetAlarmSetpoint_Parameters = None) \
            -> AlarmService_pb2.GetAlarmSetpoint_Responses:
        """
        Wrapper to call the unobservable command GetAlarmSetpoint on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmSetpoint:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.GetAlarmSetpoint_Parameters(
                    **AlarmService_default_dict['GetAlarmSetpoint_Parameters']
                )
    
            response = self.AlarmService_stub.GetAlarmSetpoint(parameter)
    
            logging.debug('GetAlarmSetpoint response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetAlarmSetpoint(self,
                      parameter: AlarmService_pb2.SetAlarmSetpoint_Parameters = None) \
            -> AlarmService_pb2.SetAlarmSetpoint_Responses:
        """
        Wrapper to call the unobservable command SetAlarmSetpoint on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetAlarmSetpoint:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = AlarmService_pb2.SetAlarmSetpoint_Parameters(
                    **AlarmService_default_dict['SetAlarmSetpoint_Parameters']
                )
    
            response = self.AlarmService_stub.SetAlarmSetpoint(parameter)
    
            logging.debug('SetAlarmSetpoint response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCalibrationCertificate(self,
                      parameter: CalibrationService_pb2.GetCalibrationCertificate_Parameters = None) \
            -> CalibrationService_pb2.GetCalibrationCertificate_Responses:
        """
        Wrapper to call the unobservable command GetCalibrationCertificate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCalibrationCertificate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetCalibrationCertificate_Parameters(
                    **CalibrationService_default_dict['GetCalibrationCertificate_Parameters']
                )
    
            response = self.CalibrationService_stub.GetCalibrationCertificate(parameter)
    
            logging.debug('GetCalibrationCertificate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCalibrationCertificate(self,
                      parameter: CalibrationService_pb2.SetCalibrationCertificate_Parameters = None) \
            -> CalibrationService_pb2.SetCalibrationCertificate_Responses:
        """
        Wrapper to call the unobservable command SetCalibrationCertificate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCalibrationCertificate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.SetCalibrationCertificate_Parameters(
                    **CalibrationService_default_dict['SetCalibrationCertificate_Parameters']
                )
    
            response = self.CalibrationService_stub.SetCalibrationCertificate(parameter)
    
            logging.debug('SetCalibrationCertificate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCalibrationDate(self,
                      parameter: CalibrationService_pb2.GetCalibrationDate_Parameters = None) \
            -> CalibrationService_pb2.GetCalibrationDate_Responses:
        """
        Wrapper to call the unobservable command GetCalibrationDate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCalibrationDate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetCalibrationDate_Parameters(
                    **CalibrationService_default_dict['GetCalibrationDate_Parameters']
                )
    
            response = self.CalibrationService_stub.GetCalibrationDate(parameter)
    
            logging.debug('GetCalibrationDate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCalibrationDate(self,
                      parameter: CalibrationService_pb2.SetCalibrationDate_Parameters = None) \
            -> CalibrationService_pb2.SetCalibrationDate_Responses:
        """
        Wrapper to call the unobservable command SetCalibrationDate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCalibrationDate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.SetCalibrationDate_Parameters(
                    **CalibrationService_default_dict['SetCalibrationDate_Parameters']
                )
    
            response = self.CalibrationService_stub.SetCalibrationDate(parameter)
    
            logging.debug('SetCalibrationDate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetServiceNumber(self,
                      parameter: CalibrationService_pb2.GetServiceNumber_Parameters = None) \
            -> CalibrationService_pb2.GetServiceNumber_Responses:
        """
        Wrapper to call the unobservable command GetServiceNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetServiceNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetServiceNumber_Parameters(
                    **CalibrationService_default_dict['GetServiceNumber_Parameters']
                )
    
            response = self.CalibrationService_stub.GetServiceNumber(parameter)
    
            logging.debug('GetServiceNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetServiceNumber(self,
                      parameter: CalibrationService_pb2.SetServiceNumber_Parameters = None) \
            -> CalibrationService_pb2.SetServiceNumber_Responses:
        """
        Wrapper to call the unobservable command SetServiceNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetServiceNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.SetServiceNumber_Parameters(
                    **CalibrationService_default_dict['SetServiceNumber_Parameters']
                )
    
            response = self.CalibrationService_stub.SetServiceNumber(parameter)
    
            logging.debug('SetServiceNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetServiceDate(self,
                      parameter: CalibrationService_pb2.GetServiceDate_Parameters = None) \
            -> CalibrationService_pb2.GetServiceDate_Responses:
        """
        Wrapper to call the unobservable command GetServiceDate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetServiceDate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetServiceDate_Parameters(
                    **CalibrationService_default_dict['GetServiceDate_Parameters']
                )
    
            response = self.CalibrationService_stub.GetServiceDate(parameter)
    
            logging.debug('GetServiceDate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetServiceDate(self,
                      parameter: CalibrationService_pb2.SetServiceDate_Parameters = None) \
            -> CalibrationService_pb2.SetServiceDate_Responses:
        """
        Wrapper to call the unobservable command SetServiceDate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetServiceDate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.SetServiceDate_Parameters(
                    **CalibrationService_default_dict['SetServiceDate_Parameters']
                )
    
            response = self.CalibrationService_stub.SetServiceDate(parameter)
    
            logging.debug('SetServiceDate response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSensorCalibrationTemperature(self,
                      parameter: CalibrationService_pb2.GetSensorCalibrationTemperature_Parameters = None) \
            -> CalibrationService_pb2.GetSensorCalibrationTemperature_Responses:
        """
        Wrapper to call the unobservable command GetSensorCalibrationTemperature on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorCalibrationTemperature:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetSensorCalibrationTemperature_Parameters(
                    **CalibrationService_default_dict['GetSensorCalibrationTemperature_Parameters']
                )
    
            response = self.CalibrationService_stub.GetSensorCalibrationTemperature(parameter)
    
            logging.debug('GetSensorCalibrationTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetSensorCalibrationTemperature(self,
                      parameter: CalibrationService_pb2.SetSensorCalibrationTemperature_Parameters = None) \
            -> CalibrationService_pb2.SetSensorCalibrationTemperature_Responses:
        """
        Wrapper to call the unobservable command SetSensorCalibrationTemperature on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSensorCalibrationTemperature:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.SetSensorCalibrationTemperature_Parameters(
                    **CalibrationService_default_dict['SetSensorCalibrationTemperature_Parameters']
                )
    
            response = self.CalibrationService_stub.SetSensorCalibrationTemperature(parameter)
    
            logging.debug('SetSensorCalibrationTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetIdentificationString(self,
                      parameter: DeviceService_pb2.GetIdentificationString_Parameters = None) \
            -> DeviceService_pb2.GetIdentificationString_Responses:
        """
        Wrapper to call the unobservable command GetIdentificationString on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetIdentificationString:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetIdentificationString_Parameters(
                    **DeviceService_default_dict['GetIdentificationString_Parameters']
                )
    
            response = self.DeviceService_stub.GetIdentificationString(parameter)
    
            logging.debug('GetIdentificationString response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPrimaryNodeAddress(self,
                      parameter: DeviceService_pb2.GetPrimaryNodeAddress_Parameters = None) \
            -> DeviceService_pb2.GetPrimaryNodeAddress_Responses:
        """
        Wrapper to call the unobservable command GetPrimaryNodeAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPrimaryNodeAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetPrimaryNodeAddress_Parameters(
                    **DeviceService_default_dict['GetPrimaryNodeAddress_Parameters']
                )
    
            response = self.DeviceService_stub.GetPrimaryNodeAddress(parameter)
    
            logging.debug('GetPrimaryNodeAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPrimaryNodeAddress(self,
                      parameter: DeviceService_pb2.SetPrimaryNodeAddress_Parameters = None) \
            -> DeviceService_pb2.SetPrimaryNodeAddress_Responses:
        """
        Wrapper to call the unobservable command SetPrimaryNodeAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPrimaryNodeAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SetPrimaryNodeAddress_Parameters(
                    **DeviceService_default_dict['SetPrimaryNodeAddress_Parameters']
                )
    
            response = self.DeviceService_stub.SetPrimaryNodeAddress(parameter)
    
            logging.debug('SetPrimaryNodeAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSecondaryNodeAddress(self,
                      parameter: DeviceService_pb2.GetSecondaryNodeAddress_Parameters = None) \
            -> DeviceService_pb2.GetSecondaryNodeAddress_Responses:
        """
        Wrapper to call the unobservable command GetSecondaryNodeAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSecondaryNodeAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetSecondaryNodeAddress_Parameters(
                    **DeviceService_default_dict['GetSecondaryNodeAddress_Parameters']
                )
    
            response = self.DeviceService_stub.GetSecondaryNodeAddress(parameter)
    
            logging.debug('GetSecondaryNodeAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetNextNodeAddress(self,
                      parameter: DeviceService_pb2.GetNextNodeAddress_Parameters = None) \
            -> DeviceService_pb2.GetNextNodeAddress_Responses:
        """
        Wrapper to call the unobservable command GetNextNodeAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetNextNodeAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetNextNodeAddress_Parameters(
                    **DeviceService_default_dict['GetNextNodeAddress_Parameters']
                )
    
            response = self.DeviceService_stub.GetNextNodeAddress(parameter)
    
            logging.debug('GetNextNodeAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLastNodeAddress(self,
                      parameter: DeviceService_pb2.GetLastNodeAddress_Parameters = None) \
            -> DeviceService_pb2.GetLastNodeAddress_Responses:
        """
        Wrapper to call the unobservable command GetLastNodeAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLastNodeAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetLastNodeAddress_Parameters(
                    **DeviceService_default_dict['GetLastNodeAddress_Parameters']
                )
    
            response = self.DeviceService_stub.GetLastNodeAddress(parameter)
    
            logging.debug('GetLastNodeAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSensorType(self,
                      parameter: DeviceService_pb2.GetSensorType_Parameters = None) \
            -> DeviceService_pb2.GetSensorType_Responses:
        """
        Wrapper to call the unobservable command GetSensorType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorType:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetSensorType_Parameters(
                    **DeviceService_default_dict['GetSensorType_Parameters']
                )
    
            response = self.DeviceService_stub.GetSensorType(parameter)
    
            logging.debug('GetSensorType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetAlarmInformation(self,
                      parameter: DeviceService_pb2.GetAlarmInformation_Parameters = None) \
            -> DeviceService_pb2.GetAlarmInformation_Responses:
        """
        Wrapper to call the unobservable command GetAlarmInformation on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetAlarmInformation:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetAlarmInformation_Parameters(
                    **DeviceService_default_dict['GetAlarmInformation_Parameters']
                )
    
            response = self.DeviceService_stub.GetAlarmInformation(parameter)
    
            logging.debug('GetAlarmInformation response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDeviceType(self,
                      parameter: DeviceService_pb2.GetDeviceType_Parameters = None) \
            -> DeviceService_pb2.GetDeviceType_Responses:
        """
        Wrapper to call the unobservable command GetDeviceType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDeviceType:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetDeviceType_Parameters(
                    **DeviceService_default_dict['GetDeviceType_Parameters']
                )
    
            response = self.DeviceService_stub.GetDeviceType(parameter)
    
            logging.debug('GetDeviceType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFirmwareVersion(self,
                      parameter: DeviceService_pb2.GetFirmwareVersion_Parameters = None) \
            -> DeviceService_pb2.GetFirmwareVersion_Responses:
        """
        Wrapper to call the unobservable command GetFirmwareVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFirmwareVersion:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetFirmwareVersion_Parameters(
                    **DeviceService_default_dict['GetFirmwareVersion_Parameters']
                )
    
            response = self.DeviceService_stub.GetFirmwareVersion(parameter)
    
            logging.debug('GetFirmwareVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPressureSensorType(self,
                      parameter: DeviceService_pb2.GetPressureSensorType_Parameters = None) \
            -> DeviceService_pb2.GetPressureSensorType_Responses:
        """
        Wrapper to call the unobservable command GetPressureSensorType on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPressureSensorType:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetPressureSensorType_Parameters(
                    **DeviceService_default_dict['GetPressureSensorType_Parameters']
                )
    
            response = self.DeviceService_stub.GetPressureSensorType(parameter)
    
            logging.debug('GetPressureSensorType response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSensorName(self,
                      parameter: DeviceService_pb2.GetSensorName_Parameters = None) \
            -> DeviceService_pb2.GetSensorName_Responses:
        """
        Wrapper to call the unobservable command GetSensorName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorName:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetSensorName_Parameters(
                    **DeviceService_default_dict['GetSensorName_Parameters']
                )
    
            response = self.DeviceService_stub.GetSensorName(parameter)
    
            logging.debug('GetSensorName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetIdentificationNumber(self,
                      parameter: DeviceService_pb2.GetIdentificationNumber_Parameters = None) \
            -> DeviceService_pb2.GetIdentificationNumber_Responses:
        """
        Wrapper to call the unobservable command GetIdentificationNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetIdentificationNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetIdentificationNumber_Parameters(
                    **DeviceService_default_dict['GetIdentificationNumber_Parameters']
                )
    
            response = self.DeviceService_stub.GetIdentificationNumber(parameter)
    
            logging.debug('GetIdentificationNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPowerMode(self,
                      parameter: DeviceService_pb2.GetPowerMode_Parameters = None) \
            -> DeviceService_pb2.GetPowerMode_Responses:
        """
        Wrapper to call the unobservable command GetPowerMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPowerMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetPowerMode_Parameters(
                    **DeviceService_default_dict['GetPowerMode_Parameters']
                )
    
            response = self.DeviceService_stub.GetPowerMode(parameter)
    
            logging.debug('GetPowerMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetBusDiagnostic(self,
                      parameter: DeviceService_pb2.GetBusDiagnostic_Parameters = None) \
            -> DeviceService_pb2.GetBusDiagnostic_Responses:
        """
        Wrapper to call the unobservable command GetBusDiagnostic on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetBusDiagnostic:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetBusDiagnostic_Parameters(
                    **DeviceService_default_dict['GetBusDiagnostic_Parameters']
                )
    
            response = self.DeviceService_stub.GetBusDiagnostic(parameter)
    
            logging.debug('GetBusDiagnostic response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFieldbus(self,
                      parameter: DeviceService_pb2.GetFieldbus_Parameters = None) \
            -> DeviceService_pb2.GetFieldbus_Responses:
        """
        Wrapper to call the unobservable command GetFieldbus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFieldbus:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetFieldbus_Parameters(
                    **DeviceService_default_dict['GetFieldbus_Parameters']
                )
    
            response = self.DeviceService_stub.GetFieldbus(parameter)
    
            logging.debug('GetFieldbus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetInstrumentProperties(self,
                      parameter: DeviceService_pb2.GetInstrumentProperties_Parameters = None) \
            -> DeviceService_pb2.GetInstrumentProperties_Responses:
        """
        Wrapper to call the unobservable command GetInstrumentProperties on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetInstrumentProperties:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetInstrumentProperties_Parameters(
                    **DeviceService_default_dict['GetInstrumentProperties_Parameters']
                )
    
            response = self.DeviceService_stub.GetInstrumentProperties(parameter)
    
            logging.debug('GetInstrumentProperties response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCommunicationProtocol(self,
                      parameter: DeviceService_pb2.GetCommunicationProtocol_Parameters = None) \
            -> DeviceService_pb2.GetCommunicationProtocol_Responses:
        """
        Wrapper to call the unobservable command GetCommunicationProtocol on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCommunicationProtocol:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetCommunicationProtocol_Parameters(
                    **DeviceService_default_dict['GetCommunicationProtocol_Parameters']
                )
    
            response = self.DeviceService_stub.GetCommunicationProtocol(parameter)
    
            logging.debug('GetCommunicationProtocol response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCommunicationProtocol(self,
                      parameter: DeviceService_pb2.SetCommunicationProtocol_Parameters = None) \
            -> DeviceService_pb2.SetCommunicationProtocol_Responses:
        """
        Wrapper to call the unobservable command SetCommunicationProtocol on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCommunicationProtocol:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SetCommunicationProtocol_Parameters(
                    **DeviceService_default_dict['SetCommunicationProtocol_Parameters']
                )
    
            response = self.DeviceService_stub.SetCommunicationProtocol(parameter)
    
            logging.debug('SetCommunicationProtocol response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSerialPort(self,
                      parameter: DeviceService_pb2.GetSerialPort_Parameters = None) \
            -> DeviceService_pb2.GetSerialPort_Responses:
        """
        Wrapper to call the unobservable command GetSerialPort on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSerialPort:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetSerialPort_Parameters(
                    **DeviceService_default_dict['GetSerialPort_Parameters']
                )
    
            response = self.DeviceService_stub.GetSerialPort(parameter)
    
            logging.debug('GetSerialPort response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetSerialPort(self,
                      parameter: DeviceService_pb2.SetSerialPort_Parameters = None) \
            -> DeviceService_pb2.SetSerialPort_Responses:
        """
        Wrapper to call the unobservable command SetSerialPort on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSerialPort:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SetSerialPort_Parameters(
                    **DeviceService_default_dict['SetSerialPort_Parameters']
                )
    
            response = self.DeviceService_stub.SetSerialPort(parameter)
    
            logging.debug('SetSerialPort response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFluidSetProperties(self,
                      parameter: FluidDefinitionService_pb2.GetFluidSetProperties_Parameters = None) \
            -> FluidDefinitionService_pb2.GetFluidSetProperties_Responses:
        """
        Wrapper to call the unobservable command GetFluidSetProperties on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFluidSetProperties:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.GetFluidSetProperties_Parameters(
                    **FluidDefinitionService_default_dict['GetFluidSetProperties_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.GetFluidSetProperties(parameter)
    
            logging.debug('GetFluidSetProperties response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFluidsetProperties(self,
                      parameter: FluidDefinitionService_pb2.SetFluidsetProperties_Parameters = None) \
            -> FluidDefinitionService_pb2.SetFluidsetProperties_Responses:
        """
        Wrapper to call the unobservable command SetFluidsetProperties on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFluidsetProperties:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.SetFluidsetProperties_Parameters(
                    **FluidDefinitionService_default_dict['SetFluidsetProperties_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.SetFluidsetProperties(parameter)
    
            logging.debug('SetFluidsetProperties response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFluidNumber(self,
                      parameter: FluidDefinitionService_pb2.GetFluidNumber_Parameters = None) \
            -> FluidDefinitionService_pb2.GetFluidNumber_Responses:
        """
        Wrapper to call the unobservable command GetFluidNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFluidNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.GetFluidNumber_Parameters(
                    **FluidDefinitionService_default_dict['GetFluidNumber_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.GetFluidNumber(parameter)
    
            logging.debug('GetFluidNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFluidNumber(self,
                      parameter: FluidDefinitionService_pb2.SetFluidNumber_Parameters = None) \
            -> FluidDefinitionService_pb2.SetFluidNumber_Responses:
        """
        Wrapper to call the unobservable command SetFluidNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFluidNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.SetFluidNumber_Parameters(
                    **FluidDefinitionService_default_dict['SetFluidNumber_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.SetFluidNumber(parameter)
    
            logging.debug('SetFluidNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFluidName(self,
                      parameter: FluidDefinitionService_pb2.GetFluidName_Parameters = None) \
            -> FluidDefinitionService_pb2.GetFluidName_Responses:
        """
        Wrapper to call the unobservable command GetFluidName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFluidName:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.GetFluidName_Parameters(
                    **FluidDefinitionService_default_dict['GetFluidName_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.GetFluidName(parameter)
    
            logging.debug('GetFluidName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFluidName(self,
                      parameter: FluidDefinitionService_pb2.SetFluidName_Parameters = None) \
            -> FluidDefinitionService_pb2.SetFluidName_Responses:
        """
        Wrapper to call the unobservable command SetFluidName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFluidName:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.SetFluidName_Parameters(
                    **FluidDefinitionService_default_dict['SetFluidName_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.SetFluidName(parameter)
    
            logging.debug('SetFluidName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetHeatCapacity(self,
                      parameter: FluidDefinitionService_pb2.GetHeatCapacity_Parameters = None) \
            -> FluidDefinitionService_pb2.GetHeatCapacity_Responses:
        """
        Wrapper to call the unobservable command GetHeatCapacity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetHeatCapacity:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.GetHeatCapacity_Parameters(
                    **FluidDefinitionService_default_dict['GetHeatCapacity_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.GetHeatCapacity(parameter)
    
            logging.debug('GetHeatCapacity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetHeatCapacity(self,
                      parameter: FluidDefinitionService_pb2.SetHeatCapacity_Parameters = None) \
            -> FluidDefinitionService_pb2.SetHeatCapacity_Responses:
        """
        Wrapper to call the unobservable command SetHeatCapacity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetHeatCapacity:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.SetHeatCapacity_Parameters(
                    **FluidDefinitionService_default_dict['SetHeatCapacity_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.SetHeatCapacity(parameter)
    
            logging.debug('SetHeatCapacity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetViscosity(self,
                      parameter: FluidDefinitionService_pb2.GetViscosity_Parameters = None) \
            -> FluidDefinitionService_pb2.GetViscosity_Responses:
        """
        Wrapper to call the unobservable command GetViscosity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetViscosity:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.GetViscosity_Parameters(
                    **FluidDefinitionService_default_dict['GetViscosity_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.GetViscosity(parameter)
    
            logging.debug('GetViscosity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetViscosity(self,
                      parameter: FluidDefinitionService_pb2.SetViscosity_Parameters = None) \
            -> FluidDefinitionService_pb2.SetViscosity_Responses:
        """
        Wrapper to call the unobservable command SetViscosity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetViscosity:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = FluidDefinitionService_pb2.SetViscosity_Parameters(
                    **FluidDefinitionService_default_dict['SetViscosity_Parameters']
                )
    
            response = self.FluidDefinitionService_stub.SetViscosity(parameter)
    
            logging.debug('SetViscosity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTemperature(self,
                      parameter: MeasurementProvider_pb2.GetTemperature_Parameters = None) \
            -> MeasurementProvider_pb2.GetTemperature_Responses:
        """
        Wrapper to call the unobservable command GetTemperature on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTemperature:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetTemperature_Parameters(
                    **MeasurementProvider_default_dict['GetTemperature_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetTemperature(parameter)
    
            logging.debug('GetTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPressure(self,
                      parameter: MeasurementProvider_pb2.GetPressure_Parameters = None) \
            -> MeasurementProvider_pb2.GetPressure_Responses:
        """
        Wrapper to call the unobservable command GetPressure on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPressure:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetPressure_Parameters(
                    **MeasurementProvider_default_dict['GetPressure_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetPressure(parameter)
    
            logging.debug('GetPressure response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTime(self,
                      parameter: MeasurementProvider_pb2.GetTime_Parameters = None) \
            -> MeasurementProvider_pb2.GetTime_Responses:
        """
        Wrapper to call the unobservable command GetTime on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTime:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetTime_Parameters(
                    **MeasurementProvider_default_dict['GetTime_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetTime(parameter)
    
            logging.debug('GetTime response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCalibratedVolume(self,
                      parameter: MeasurementProvider_pb2.GetCalibratedVolume_Parameters = None) \
            -> MeasurementProvider_pb2.GetCalibratedVolume_Responses:
        """
        Wrapper to call the unobservable command GetCalibratedVolume on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCalibratedVolume:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetCalibratedVolume_Parameters(
                    **MeasurementProvider_default_dict['GetCalibratedVolume_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetCalibratedVolume(parameter)
    
            logging.debug('GetCalibratedVolume response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSensorNumber(self,
                      parameter: MeasurementProvider_pb2.GetSensorNumber_Parameters = None) \
            -> MeasurementProvider_pb2.GetSensorNumber_Responses:
        """
        Wrapper to call the unobservable command GetSensorNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSensorNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetSensorNumber_Parameters(
                    **MeasurementProvider_default_dict['GetSensorNumber_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetSensorNumber(parameter)
    
            logging.debug('GetSensorNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetNormalVolumeFlow(self,
                      parameter: MeasurementProvider_pb2.GetNormalVolumeFlow_Parameters = None) \
            -> MeasurementProvider_pb2.GetNormalVolumeFlow_Responses:
        """
        Wrapper to call the unobservable command GetNormalVolumeFlow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetNormalVolumeFlow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetNormalVolumeFlow_Parameters(
                    **MeasurementProvider_default_dict['GetNormalVolumeFlow_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetNormalVolumeFlow(parameter)
    
            logging.debug('GetNormalVolumeFlow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetVolumeFlow(self,
                      parameter: MeasurementProvider_pb2.GetVolumeFlow_Parameters = None) \
            -> MeasurementProvider_pb2.GetVolumeFlow_Responses:
        """
        Wrapper to call the unobservable command GetVolumeFlow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetVolumeFlow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetVolumeFlow_Parameters(
                    **MeasurementProvider_default_dict['GetVolumeFlow_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetVolumeFlow(parameter)
    
            logging.debug('GetVolumeFlow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDeltaPressure(self,
                      parameter: MeasurementProvider_pb2.GetDeltaPressure_Parameters = None) \
            -> MeasurementProvider_pb2.GetDeltaPressure_Responses:
        """
        Wrapper to call the unobservable command GetDeltaPressure on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDeltaPressure:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetDeltaPressure_Parameters(
                    **MeasurementProvider_default_dict['GetDeltaPressure_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetDeltaPressure(parameter)
    
            logging.debug('GetDeltaPressure response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetMassFlow(self,
                      parameter: MeasurementProvider_pb2.GetMassFlow_Parameters = None) \
            -> MeasurementProvider_pb2.GetMassFlow_Responses:
        """
        Wrapper to call the unobservable command GetMassFlow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMassFlow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetMassFlow_Parameters(
                    **MeasurementProvider_default_dict['GetMassFlow_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetMassFlow(parameter)
    
            logging.debug('GetMassFlow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetMass(self,
                      parameter: MeasurementProvider_pb2.GetMass_Parameters = None) \
            -> MeasurementProvider_pb2.GetMass_Responses:
        """
        Wrapper to call the unobservable command GetMass on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMass:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementProvider_pb2.GetMass_Parameters(
                    **MeasurementProvider_default_dict['GetMass_Parameters']
                )
    
            response = self.MeasurementProvider_stub.GetMass(parameter)
    
            logging.debug('GetMass response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPistonOperationMode(self,
                      parameter: MeasurementSettingsService_pb2.GetPistonOperationMode_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetPistonOperationMode_Responses:
        """
        Wrapper to call the unobservable command GetPistonOperationMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPistonOperationMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetPistonOperationMode_Parameters(
                    **MeasurementSettingsService_default_dict['GetPistonOperationMode_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetPistonOperationMode(parameter)
    
            logging.debug('GetPistonOperationMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPistonOperationMode(self,
                      parameter: MeasurementSettingsService_pb2.SetPistonOperationMode_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetPistonOperationMode_Responses:
        """
        Wrapper to call the unobservable command SetPistonOperationMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPistonOperationMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetPistonOperationMode_Parameters(
                    **MeasurementSettingsService_default_dict['SetPistonOperationMode_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetPistonOperationMode(parameter)
    
            logging.debug('SetPistonOperationMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetTimeOut(self,
                      parameter: MeasurementSettingsService_pb2.GetTimeOut_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetTimeOut_Responses:
        """
        Wrapper to call the unobservable command GetTimeOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetTimeOut:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetTimeOut_Parameters(
                    **MeasurementSettingsService_default_dict['GetTimeOut_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetTimeOut(parameter)
    
            logging.debug('GetTimeOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetTimeOut(self,
                      parameter: MeasurementSettingsService_pb2.SetTimeOut_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetTimeOut_Responses:
        """
        Wrapper to call the unobservable command SetTimeOut on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetTimeOut:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetTimeOut_Parameters(
                    **MeasurementSettingsService_default_dict['SetTimeOut_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetTimeOut(parameter)
    
            logging.debug('SetTimeOut response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFrequency(self,
                      parameter: MeasurementSettingsService_pb2.GetFrequency_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetFrequency_Responses:
        """
        Wrapper to call the unobservable command GetFrequency on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFrequency:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetFrequency_Parameters(
                    **MeasurementSettingsService_default_dict['GetFrequency_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetFrequency(parameter)
    
            logging.debug('GetFrequency response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFrequency(self,
                      parameter: MeasurementSettingsService_pb2.SetFrequency_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetFrequency_Responses:
        """
        Wrapper to call the unobservable command SetFrequency on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFrequency:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetFrequency_Parameters(
                    **MeasurementSettingsService_default_dict['SetFrequency_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetFrequency(parameter)
    
            logging.debug('SetFrequency response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetDensityActual(self,
                      parameter: MeasurementSettingsService_pb2.GetDensityActual_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetDensityActual_Responses:
        """
        Wrapper to call the unobservable command GetDensityActual on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDensityActual:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetDensityActual_Parameters(
                    **MeasurementSettingsService_default_dict['GetDensityActual_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetDensityActual(parameter)
    
            logging.debug('GetDensityActual response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetDensityActual(self,
                      parameter: MeasurementSettingsService_pb2.SetDensityActual_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetDensityActual_Responses:
        """
        Wrapper to call the unobservable command SetDensityActual on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetDensityActual:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetDensityActual_Parameters(
                    **MeasurementSettingsService_default_dict['SetDensityActual_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetDensityActual(parameter)
    
            logging.debug('SetDensityActual response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPressureInlet(self,
                      parameter: MeasurementSettingsService_pb2.GetPressureInlet_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetPressureInlet_Responses:
        """
        Wrapper to call the unobservable command GetPressureInlet on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPressureInlet:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetPressureInlet_Parameters(
                    **MeasurementSettingsService_default_dict['GetPressureInlet_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetPressureInlet(parameter)
    
            logging.debug('GetPressureInlet response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPressureInlet(self,
                      parameter: MeasurementSettingsService_pb2.SetPressureInlet_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetPressureInlet_Responses:
        """
        Wrapper to call the unobservable command SetPressureInlet on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPressureInlet:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetPressureInlet_Parameters(
                    **MeasurementSettingsService_default_dict['SetPressureInlet_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetPressureInlet(parameter)
    
            logging.debug('SetPressureInlet response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPressureOutlet(self,
                      parameter: MeasurementSettingsService_pb2.GetPressureOutlet_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetPressureOutlet_Responses:
        """
        Wrapper to call the unobservable command GetPressureOutlet on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPressureOutlet:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetPressureOutlet_Parameters(
                    **MeasurementSettingsService_default_dict['GetPressureOutlet_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetPressureOutlet(parameter)
    
            logging.debug('GetPressureOutlet response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetPressureOutlet(self,
                      parameter: MeasurementSettingsService_pb2.SetPressureOutlet_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetPressureOutlet_Responses:
        """
        Wrapper to call the unobservable command SetPressureOutlet on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPressureOutlet:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetPressureOutlet_Parameters(
                    **MeasurementSettingsService_default_dict['SetPressureOutlet_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetPressureOutlet(parameter)
    
            logging.debug('SetPressureOutlet response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFluidTemperature(self,
                      parameter: MeasurementSettingsService_pb2.GetFluidTemperature_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetFluidTemperature_Responses:
        """
        Wrapper to call the unobservable command GetFluidTemperature on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFluidTemperature:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetFluidTemperature_Parameters(
                    **MeasurementSettingsService_default_dict['GetFluidTemperature_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetFluidTemperature(parameter)
    
            logging.debug('GetFluidTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFluidTemperature(self,
                      parameter: MeasurementSettingsService_pb2.SetFluidTemperature_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetFluidTemperature_Responses:
        """
        Wrapper to call the unobservable command SetFluidTemperature on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFluidTemperature:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetFluidTemperature_Parameters(
                    **MeasurementSettingsService_default_dict['SetFluidTemperature_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetFluidTemperature(parameter)
    
            logging.debug('SetFluidTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetThermalConductivity(self,
                      parameter: MeasurementSettingsService_pb2.GetThermalConductivity_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetThermalConductivity_Responses:
        """
        Wrapper to call the unobservable command GetThermalConductivity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetThermalConductivity:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetThermalConductivity_Parameters(
                    **MeasurementSettingsService_default_dict['GetThermalConductivity_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetThermalConductivity(parameter)
    
            logging.debug('GetThermalConductivity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetThermalConductivity(self,
                      parameter: MeasurementSettingsService_pb2.SetThermalConductivity_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetThermalConductivity_Responses:
        """
        Wrapper to call the unobservable command SetThermalConductivity on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetThermalConductivity:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetThermalConductivity_Parameters(
                    **MeasurementSettingsService_default_dict['SetThermalConductivity_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetThermalConductivity(parameter)
    
            logging.debug('SetThermalConductivity response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetStandardMassFlow(self,
                      parameter: MeasurementSettingsService_pb2.GetStandardMassFlow_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetStandardMassFlow_Responses:
        """
        Wrapper to call the unobservable command GetStandardMassFlow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetStandardMassFlow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetStandardMassFlow_Parameters(
                    **MeasurementSettingsService_default_dict['GetStandardMassFlow_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetStandardMassFlow(parameter)
    
            logging.debug('GetStandardMassFlow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetStandardMassFlow(self,
                      parameter: MeasurementSettingsService_pb2.SetStandardMassFlow_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetStandardMassFlow_Responses:
        """
        Wrapper to call the unobservable command SetStandardMassFlow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetStandardMassFlow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetStandardMassFlow_Parameters(
                    **MeasurementSettingsService_default_dict['SetStandardMassFlow_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetStandardMassFlow(parameter)
    
            logging.debug('SetStandardMassFlow response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetOrificeDiameter(self,
                      parameter: MeasurementSettingsService_pb2.GetOrificeDiameter_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetOrificeDiameter_Responses:
        """
        Wrapper to call the unobservable command GetOrificeDiameter on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetOrificeDiameter:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetOrificeDiameter_Parameters(
                    **MeasurementSettingsService_default_dict['GetOrificeDiameter_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetOrificeDiameter(parameter)
    
            logging.debug('GetOrificeDiameter response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetOrificeDiameter(self,
                      parameter: MeasurementSettingsService_pb2.SetOrificeDiameter_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetOrificeDiameter_Responses:
        """
        Wrapper to call the unobservable command SetOrificeDiameter on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetOrificeDiameter:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetOrificeDiameter_Parameters(
                    **MeasurementSettingsService_default_dict['SetOrificeDiameter_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetOrificeDiameter(parameter)
    
            logging.debug('SetOrificeDiameter response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetBarometerPressure(self,
                      parameter: MeasurementSettingsService_pb2.GetBarometerPressure_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetBarometerPressure_Responses:
        """
        Wrapper to call the unobservable command GetBarometerPressure on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetBarometerPressure:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetBarometerPressure_Parameters(
                    **MeasurementSettingsService_default_dict['GetBarometerPressure_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetBarometerPressure(parameter)
    
            logging.debug('GetBarometerPressure response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetBarometerPressure(self,
                      parameter: MeasurementSettingsService_pb2.SetBarometerPressure_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetBarometerPressure_Responses:
        """
        Wrapper to call the unobservable command SetBarometerPressure on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetBarometerPressure:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetBarometerPressure_Parameters(
                    **MeasurementSettingsService_default_dict['SetBarometerPressure_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetBarometerPressure(parameter)
    
            logging.debug('SetBarometerPressure response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetNumberVanes(self,
                      parameter: MeasurementSettingsService_pb2.GetNumberVanes_Parameters = None) \
            -> MeasurementSettingsService_pb2.GetNumberVanes_Responses:
        """
        Wrapper to call the unobservable command GetNumberVanes on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetNumberVanes:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.GetNumberVanes_Parameters(
                    **MeasurementSettingsService_default_dict['GetNumberVanes_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.GetNumberVanes(parameter)
    
            logging.debug('GetNumberVanes response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetNumberVanes(self,
                      parameter: MeasurementSettingsService_pb2.SetNumberVanes_Parameters = None) \
            -> MeasurementSettingsService_pb2.SetNumberVanes_Responses:
        """
        Wrapper to call the unobservable command SetNumberVanes on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetNumberVanes:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementSettingsService_pb2.SetNumberVanes_Parameters(
                    **MeasurementSettingsService_default_dict['SetNumberVanes_Parameters']
                )
    
            response = self.MeasurementSettingsService_stub.SetNumberVanes(parameter)
    
            logging.debug('SetNumberVanes response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    #   No properties defined

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error = client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: FlowmeterService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = FlowmeterServiceClient(server_ip='127.0.0.1', server_port=50004) #server_port=50001
    sila_client.run()

    response = sila_client.GetIdentificationNumber()


    #response get
    """
    response = sila_client.GetAlarmLimitMaximum()
    response = sila_client.GetAlarmLimitMinimum()
    response = sila_client.GetAlarmMode()
    response = sila_client.GetAlarmOutputMode()
    response = sila_client.GetAlarmSetpoint()
    response = sila_client.GetCalibrationCertificate()
    response = sila_client.GetCalibrationDate()
    response = sila_client.GetServiceNumber()
    response = sila_client.GetServiceDate()
    response = sila_client.GetSensorCalibrationTemperature()
    response = sila_client.GetIdentificationString()
    response = sila_client.GetPrimaryNodeAddress()
    response = sila_client.GetSecondaryNodeAddress()
    response = sila_client.GetNextNodeAddress()
    response = sila_client.GetLastNodeAddress()
    response = sila_client.GetSensorType()
    response = sila_client.GetAlarmInformation()
    response = sila_client.GetDeviceType()
    response = sila_client.GetFirmwareVersion()
    response = sila_client.GetPressureSensorType()
    response = sila_client.GetSensorName()
    response = sila_client.GetIdentificationNumber()
    response = sila_client.GetPowerMode()
    response = sila_client.GetBusDiagnostic()
    response = sila_client.GetFieldbus()
    response = sila_client.GetInstrumentProperties()
    response = sila_client.GetFluidSetProperties()
    #response = sila_client.GetFluidNumber() #No response
    response = sila_client.GetFluidName()
    response = sila_client.GetHeatCapacity()
    response = sila_client.GetViscosity()
    response = sila_client.GetTemperature()
    response = sila_client.GetPressure()
    response = sila_client.GetTime()
    response = sila_client.GetVolumeFlow()
    response = sila_client.GetSensorNumber()
    response = sila_client.GetNormalVolumeFlow()
    response = sila_client.GetDeltaPressure()
    response = sila_client.GetMassFlow()
    response = sila_client.GetMass()
    response = sila_client.GetPistonOperationMode()
    response = sila_client.GetTimeOut()
    response = sila_client.GetFrequency()
    response = sila_client.GetDensityActual()
    response = sila_client.GetPressureInlet()
    #response = sila_client.GetPressureOutlet() #typing error in FDL file
    response = sila_client.GetFluidTemperature()
    response = sila_client.GetThermalConductivity()
    response = sila_client.GetStandardMassFlow()
    response = sila_client.GetOrificeDiameter()
    response = sila_client.GetBarometerPressure()
    response = sila_client.GetNumberVanes()
    
    #Response set
    #response = sila_client.SetSensorCalibrationTemperature(parameter=CalibrationService_pb2.SetSensorCalibrationTemperature_Parameters(SetSensorCalibrationTemperature=silaFW_pb2.Real(value=float(1.0))))

    # Alarm Service

    response = sila_client.SetAlarmLimitMaximum(parameter=AlarmService_pb2.SetAlarmLimitMaximum_Parameters(
SetAlarmLimitMaximum=silaFW_pb2.Real(value=float(.2))))

    response = sila_client.SetAlarmLimitMinimum(parameter=AlarmService_pb2.SetAlarmLimitMinimum_Parameters(
        SetAlarmLimitMinimum=silaFW_pb2.Real(value=float(.3))))

    response = sila_client.SetAlarmMode(
        parameter=AlarmService_pb2.SetAlarmMode_Parameters(SetAlarmMode=silaFW_pb2.Integer(value=int(2))))

    response = sila_client.SetAlarmOutputMode(
        parameter=AlarmService_pb2.SetAlarmOutputMode_Parameters(SetAlarmOutputMode=silaFW_pb2.Integer(value=int(2))))

    response = sila_client.SetAlarmSetpoint(
        parameter=AlarmService_pb2.SetAlarmSetpoint_Parameters(SetAlarmSetpoint=silaFW_pb2.Integer(value=int(2))))

    # Alarm Service

    response = sila_client.SetAlarmLimitMaximum(parameter=AlarmService_pb2.SetAlarmLimitMaximum_Parameters(
        SetAlarmLimitMaximum=silaFW_pb2.Real(value=float(.2))))

    response = sila_client.SetAlarmLimitMinimum(parameter=AlarmService_pb2.SetAlarmLimitMinimum_Parameters(
        SetAlarmLimitMinimum=silaFW_pb2.Real(value=float(.3))))

    response = sila_client.SetAlarmMode(
        parameter=AlarmService_pb2.SetAlarmMode_Parameters(SetAlarmMode=silaFW_pb2.Integer(value=int(2))))

    response = sila_client.SetAlarmOutputMode(
        parameter=AlarmService_pb2.SetAlarmOutputMode_Parameters(SetAlarmOutputMode=silaFW_pb2.Integer(value=int(2))))

    response = sila_client.SetAlarmSetpoint(
        parameter=AlarmService_pb2.SetAlarmSetpoint_Parameters(SetAlarmSetpoint=silaFW_pb2.Integer(value=int(2))))

    # Calibration Service
    response = sila_client.SetCalibrationCertificate(parameter=CalibrationService_pb2.SetCalibrationCertificate_Parameters(SetCalibrationCertificate=silaFW_pb2.String(value=str(1))))


    response = sila_client.SetCalibrationDate(parameter=CalibrationService_pb2.SetCalibrationDate_Parameters(
        SetCalibrationDate=silaFW_pb2.String(value=str(1))))

    # response = sila_client.SetServiceNumber(parameter=CalibrationService_pb2.SetServiceNumber_Parameters(SetServiceNumber=silaFW_pb2.String(value=str(1))))
    # Typing error in FDL files

    response = sila_client.SetServiceDate(
        parameter=CalibrationService_pb2.SetServiceDate_Parameters(SetServiceDate=silaFW_pb2.String(value=str(1))))

    response = sila_client.SetSensorCalibrationTemperature(parameter=CalibrationService_pb2.SetSensorCalibrationTemperature_Parameters(SetSensorCalibrationTemperature=silaFW_pb2.Real(value=float(1.0))))

    #Device Service
    response = sila_client.SetPrimaryNodeAddress(parameter=DeviceService_pb2.SetPrimaryNodeAddress_Parameters
    (SetPrimaryNodeAddress=silaFW_pb2.String(value=str(2))))

    #Fluid Definition Service
    
    response = sila_client.SetFluidsetProperties(parameter=FluidDefinitionService_pb2.SetFluidsetProperties_Parameters
    (SetFluidProperties=silaFW_pb2.String(value=str(2))))

    response = sila_client.SetFluidNumber(parameter=FluidDefinitionService_pb2.SetFluidNumber_Parameters
    (SetFluidNumber=silaFW_pb2.String(value=str(2))))
    
    response = sila_client.SetFluidName(parameter=FluidDefinitionService_pb2.SetFluidName_Parameters
    (SetFluidName=silaFW_pb2.String(value=str(2))))
    
    response = sila_client.SetHeatCapacity(parameter=FluidDefinitionService_pb2.SetHeatCapacity_Parameters
    (SetHeatCapacity=silaFW_pb2.Real(value=float(2.0))))
    
    response = sila_client.SetViscosity(parameter=FluidDefinitionService_pb2.SetViscosity_Parameters
    (SetViscosity=silaFW_pb2.Real(value=float(2.0))))


    #Measurement Settings

    response = sila_client.SetPistonOperationMode(parameter=MeasurementSettingsService_pb2.SetPistonOperationMode_Parameters
    (SetPistonOperationMode=silaFW_pb2.String(value=str(1))))

    response = sila_client.SetTimeOut(parameter=MeasurementSettingsService_pb2.SetTimeOut_Parameters
    (SetTimeOut=silaFW_pb2.Integer(value=int(13))))

    response = sila_client.SetFrequency(parameter=MeasurementSettingsService_pb2.SetFrequency_Parameters
    (SetFrequency=silaFW_pb2.Real(value=float(13.3))))

    response = sila_client.SetDensityActual(parameter=MeasurementSettingsService_pb2.SetDensityActual_Parameters
    (SetDensityActual=silaFW_pb2.String(value=str(12))))

    response = sila_client.SetPressureInlet(parameter=MeasurementSettingsService_pb2.SetPressureInlet_Parameters
    (SetPressureInlet=silaFW_pb2.Real(value=float(12.0))))

    response = sila_client.SetFluidTemperature(parameter=MeasurementSettingsService_pb2.SetFluidTemperature_Parameters
    (SetFluidTemperature=silaFW_pb2.Real(value=float(12.0))))

    response = sila_client.SetStandardMassFlow(parameter=MeasurementSettingsService_pb2.SetStandardMassFlow_Parameters
    (SetStandardFlow=silaFW_pb2.Real(value=float(12.0))))

    response = sila_client.SetBarometerPressure(parameter=MeasurementSettingsService_pb2.SetBarometerPressure_Parameters
    (SetBarometerPressure=silaFW_pb2.Real(value=float(12.1))))

    response = sila_client.SetNumberVanes(parameter=MeasurementSettingsService_pb2.SetNumberVanes_Parameters
    (SetNumberVanes=silaFW_pb2.String(value=str(12))))



    """

    print(response)

    #parameter=AlarmService_pb2.SetAlarmLimitMaximum_Parameters({'SetAlarmLimitMaximum': silaFW_pb2.Real(value=0.0)}
    #    )
    #)
    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )