#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*FlowmeterService*

:details: FlowmeterService:
    This is a flowmeter service
           
:file:    FlowmeterService_server.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-03-19T13:54:01.529224
:date: (last modification) 2021-03-19T13:54:01.529224

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

import os
import logging
import argparse

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.Flowmeter.FlowmeterService.AlarmService.gRPC import AlarmService_pb2
from sila2lib_implementations.Flowmeter.FlowmeterService.AlarmService.gRPC import AlarmService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter.FlowmeterService.AlarmService.AlarmService_default_arguments import default_dict as AlarmService_default_dict
from sila2lib_implementations.Flowmeter.FlowmeterService.CalibrationService.gRPC import CalibrationService_pb2
from sila2lib_implementations.Flowmeter.FlowmeterService.CalibrationService.gRPC import CalibrationService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter.FlowmeterService.CalibrationService.CalibrationService_default_arguments import default_dict as CalibrationService_default_dict
from sila2lib_implementations.Flowmeter.FlowmeterService.DeviceService.gRPC import DeviceService_pb2
from sila2lib_implementations.Flowmeter.FlowmeterService.DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter.FlowmeterService.DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from sila2lib_implementations.Flowmeter.FlowmeterService.FluidDefinitionService.gRPC import FluidDefinitionService_pb2
from sila2lib_implementations.Flowmeter.FlowmeterService.FluidDefinitionService.gRPC import FluidDefinitionService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter.FlowmeterService.FluidDefinitionService.FluidDefinitionService_default_arguments import default_dict as FluidDefinitionService_default_dict
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementProvider.gRPC import MeasurementProvider_pb2
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementProvider.gRPC import MeasurementProvider_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementProvider.MeasurementProvider_default_arguments import default_dict as MeasurementProvider_default_dict
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementSettingsService.gRPC import MeasurementSettingsService_pb2
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementSettingsService.gRPC import MeasurementSettingsService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementSettingsService.MeasurementSettingsService_default_arguments import default_dict as MeasurementSettingsService_default_dict

# Import the servicer modules for each feature
from sila2lib_implementations.Flowmeter.FlowmeterService.AlarmService.AlarmService_servicer import AlarmService
from sila2lib_implementations.Flowmeter.FlowmeterService.CalibrationService.CalibrationService_servicer import CalibrationService
from sila2lib_implementations.Flowmeter.FlowmeterService.DeviceService.DeviceService_servicer import DeviceService
from sila2lib_implementations.Flowmeter.FlowmeterService.FluidDefinitionService.FluidDefinitionService_servicer import FluidDefinitionService
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementProvider.MeasurementProvider_servicer import MeasurementProvider
from sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementSettingsService.MeasurementSettingsService_servicer import MeasurementSettingsService

# import custom implementation libraries
import serial
import serial.tools.list_ports
import multiprocessing
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.SerialDetector import serial_ports


class FlowmeterServiceServer(SiLA2Server):
    """
    This is a flowmeter service
    """

    def __init__(self, cmd_args, ip: str = '127.0.0.1', port: int = 50001, simulation_mode: bool = True):
        """Class initialiser"""
        super().__init__(
            name=cmd_args.server_name, description=cmd_args.description,
            server_type=cmd_args.server_type, server_uuid=None,
            version=__version__,
            vendor_url="",
            ip=ip, port=port,
            key_file=cmd_args.encryption_key, cert_file=cmd_args.encryption_cert,
            simulation_mode=simulation_mode, server_hostname=f'{cmd_args.server_name}.sila',
            server_path=os.path.dirname(os.path.realpath(__file__))
        )

        logging.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=cmd_args.server_name
            )
        )
        self.lock = multiprocessing.Lock()
        self.status = "Idle"
        self.simulation_mode = simulation_mode

        if not simulation_mode:
            ports_required = ['/dev/tty.usbserial-AL0347P6']
            # Opening a serial port for data communication automatically. ONLY use if no other COM ports exist!
            available_ports = serial_ports()
            ports = []
            ports_not_required = []
            for i in range(0, len(available_ports), 1):
                if available_ports[i] in ports_required:
                    ports.append(available_ports[i])
                else:
                    ports_not_required.append(available_ports[i])
            unavailable_ports = list(set(ports_required) - set(ports))
            if unavailable_ports is not []:
                logging.info(
                    "The following COM/USB ports are not available: {ports}".format(ports=unavailable_ports))
            if ports == []:
                logging.info(
                    "No available COM/USB port to establish connection: {ports}".format(ports=ports))
            else:
                self.ser = serial.Serial(port=ports[0], baudrate=38400, parity=serial.PARITY_NONE,
                                         stopbits=serial.STOPBITS_ONE, bytesize=serial.EIGHTBITS, timeout=.5)
                logging.info(
                    "Connection established on port: {ports}".format(ports=ports[0]))

            # On Debian use the following and specify the Comport name!
            # ser = serial.Serial(port="/dev/ttyS0", baudrate = 9600,parity=serial.PARITY_NONE, stopbits=serial.STOPBITS_ONE,bytesize=8,timeout=1, xonxoff=0)
        else:
            self.ser = None

        # registering features
        #  Register AlarmService
        self.AlarmService_servicer = AlarmService(ser=self.ser, lock=self.lock, status=self.status,
                                                  simulation_mode=self.simulation_mode)
        AlarmService_pb2_grpc.add_AlarmServiceServicer_to_server(
            self.AlarmService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='AlarmService',
                         servicer=self.AlarmService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register CalibrationService
        self.CalibrationService_servicer = CalibrationService(ser=self.ser, lock=self.lock, status=self.status,
                                                              simulation_mode=self.simulation_mode)
        CalibrationService_pb2_grpc.add_CalibrationServiceServicer_to_server(
            self.CalibrationService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='CalibrationService',
                         servicer=self.CalibrationService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register DeviceService
        self.DeviceService_servicer = DeviceService(ser=self.ser, lock=self.lock, status=self.status,
                                                      simulation_mode=self.simulation_mode)
        DeviceService_pb2_grpc.add_DeviceServiceServicer_to_server(
            self.DeviceService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceService',
                         servicer=self.DeviceService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register FluidDefinitionService
        self.FluidDefinitionService_servicer = FluidDefinitionService(ser=self.ser, lock=self.lock, status=self.status,
                                                                      simulation_mode=self.simulation_mode)
        FluidDefinitionService_pb2_grpc.add_FluidDefinitionServiceServicer_to_server(
            self.FluidDefinitionService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='FluidDefinitionService',
                         servicer=self.FluidDefinitionService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register MeasurementProvider
        self.MeasurementProvider_servicer = MeasurementProvider(ser=self.ser, lock=self.lock, status=self.status,
                                                                simulation_mode=self.simulation_mode)
        MeasurementProvider_pb2_grpc.add_MeasurementProviderServicer_to_server(
            self.MeasurementProvider_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='MeasurementProvider',
                         servicer=self.MeasurementProvider_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register MeasurementSettingsService
        self.MeasurementSettingsService_servicer = MeasurementSettingsService(ser=self.ser, lock=self.lock,
                                                                              status=self.status,
                                                                              simulation_mode=self.simulation_mode)
        MeasurementSettingsService_pb2_grpc.add_MeasurementSettingsServiceServicer_to_server(
            self.MeasurementSettingsService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='MeasurementSettingsService',
                         servicer=self.MeasurementSettingsService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )

        self.simulation_mode = simulation_mode

        # starting and running the gRPC/SiLA2 server
        self.run()


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: FlowmeterService")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="FlowmeterService", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a flowmeter service", help='SiLA server description')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args
    
        
if __name__ == '__main__':
    # or use logging.ERROR for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)
    
    args = parse_command_line()

    # generate SiLA2Server
    sila_server = FlowmeterServiceServer(cmd_args=args, ip='127.0.0.1', port=50004, simulation_mode=True)
