"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Measurement Provider*

:details: MeasurementProvider:
    Used to acquire general status of the current flow of the flowmeter.
    By Lukas Bromig and Jose de Jesus Pina, Institute of Biochemical Engineering, Technical University of Munich,
    02.12.2020
           
:file:    MeasurementProvider_servicer.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-03-19T13:54:01.503405
:date: (last modification) 2021-03-19T13:54:01.503405

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import MeasurementProvider_pb2 as MeasurementProvider_pb2
from .gRPC import MeasurementProvider_pb2_grpc as MeasurementProvider_pb2_grpc

# import simulation and real implementation
from .MeasurementProvider_simulation import MeasurementProviderSimulation
from .MeasurementProvider_real import MeasurementProviderReal


class MeasurementProvider(MeasurementProvider_pb2_grpc.MeasurementProviderServicer):
    """
    This is a flowmeter service
    """
    implementation: Union[MeasurementProviderSimulation, MeasurementProviderReal]
    simulation_mode: bool

    def __init__(self, ser, lock, status, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.lock = lock
        self.ser = ser
        self.status = status
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(MeasurementProviderSimulation(status=self.status))
        else:
            self._inject_implementation(MeasurementProviderReal(ser=self.ser, status=self.status))

    def _inject_implementation(self,
                               implementation: Union[MeasurementProviderSimulation,
                                                     MeasurementProviderReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the FlowmeterServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(MeasurementProviderSimulation(status=self.status))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(MeasurementProviderReal(ser=self.ser, status=self.status))

    def GetTemperature(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetTemperature_Responses:
        """
        Executes the unobservable command "GetTemperature"
            Absolute temperature in  degree Celsius
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTemperature (Current temperature): Absolute temperature in degree Celsius
        """
    
        logging.debug(
            "GetTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPressure(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetPressure_Responses:
        """
        Executes the unobservable command "Get pressure"
            Absolute pressure in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPressure (Current pressure): Current absolute pressure in millibar
        """
    
        logging.debug(
            "GetPressure called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPressure(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTime(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetTime_Responses:
        """
        Executes the unobservable command "Get time"
            
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.RealTime (Real Time): Real time in milliseconds
        """
    
        logging.debug(
            "GetTime called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTime(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCalibratedVolume(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetCalibratedVolume_Responses:
        """
        Executes the unobservable command "Get calibrated volume"
            Calibrated volume
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCalibratedVolume (Current calibrated volume): Current calibrated volume
        """
    
        logging.debug(
            "GetCalibratedVolume called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCalibratedVolume(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSensorNumber(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetSensorNumber_Responses:
        """
        Executes the unobservable command "Get sensor number"
            Pointer to sensor number in calibration tube FPP
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSensorNumber (Current sensor number): Pointer to sensor number in calibration tube FPP
        """
    
        logging.debug(
            "GetSensorNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSensorNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetNormalVolumeFlow(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetNormalVolumeFlow_Responses:
        """
        Executes the unobservable command "Get normal volume flow"
            Volume flow referenced to normal conditions (0 Celsius degree;  1013.25HPa=1atm) in liters/min
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentNormalVolumeFlow (Current normal volume flow):
            Volume flow referenced to normal conditions (0 Celsius degree;  1013.25HPa=1atm) in liters/min
        """
    
        logging.debug(
            "GetNormalVolumeFlow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetNormalVolumeFlow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetVolumeFlow(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetVolumeFlow_Responses:
        """
        Executes the unobservable command "Get volume flow"
            Volume flow at actual conditions in liters per min
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentVolumeFlow (Current volume flow):
            VVolume flow at actual conditions in liters permin
        """
    
        logging.debug(
            "GetVolumeFlow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetVolumeFlow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDeltaPressure(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetDeltaPressure_Responses:
        """
        Executes the unobservable command "Get delta pressure"
            Relative pressure between atmosphere and sensor in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDeltaPressure (Current delta pressure):
            Relative pressure between atmosphere and sensor in millibar
        """
    
        logging.debug(
            "GetDeltaPressure called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDeltaPressure(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMassFlow(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetMassFlow_Responses:
        """
        Executes the unobservable command "Get mass flow"
            real mass flow in Kg pro min
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMassFlow (Current mass flow):
            Real mass flow in Kg pro min
        """
    
        logging.debug(
            "GetMassFlow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMassFlow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetMass(self, request, context: grpc.ServicerContext) \
            -> MeasurementProvider_pb2.GetMass_Responses:
        """
        Executes the unobservable command "Get mass"
            Net mass in g
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentMass (Current mass): Net Mass in g
        """
    
        logging.debug(
            "GetMass called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetMass(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
