"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Measurement Settings Service*

:details: MeasurementSettingsService:
    Used to acquire and modify general status and parameters of the flowmeter.
    By Lukas Bromig and Jose de Jesus Pina, Institute of Biochemical Engineering, Technical University of Munich,
    02.12.2020
           
:file:    MeasurementSettingsService_servicer.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-03-19T13:54:01.514949
:date: (last modification) 2021-03-19T13:54:01.514949

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import MeasurementSettingsService_pb2 as MeasurementSettingsService_pb2
from .gRPC import MeasurementSettingsService_pb2_grpc as MeasurementSettingsService_pb2_grpc

# import simulation and real implementation
from .MeasurementSettingsService_simulation import MeasurementSettingsServiceSimulation
from .MeasurementSettingsService_real import MeasurementSettingsServiceReal


class MeasurementSettingsService(MeasurementSettingsService_pb2_grpc.MeasurementSettingsServiceServicer):
    """
    This is a flowmeter service
    """
    implementation: Union[MeasurementSettingsServiceSimulation, MeasurementSettingsServiceReal]
    simulation_mode: bool

    def __init__(self, ser, lock, status, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.lock = lock
        self.ser = ser
        self.status = status
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(MeasurementSettingsServiceSimulation(status=self.status))
        else:
            self._inject_implementation(MeasurementSettingsServiceReal(ser=self.ser, status=self.status))

    def _inject_implementation(self,
                               implementation: Union[MeasurementSettingsServiceSimulation,
                                                     MeasurementSettingsServiceReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the FlowmeterServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(MeasurementSettingsServiceSimulation(status=self.status))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(MeasurementSettingsServiceReal(ser=self.ser, status=self.status))

    def GetPistonOperationMode(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetPistonOperationMode_Responses:
        """
        Executes the unobservable command "Get piston operation mode"
            Piston prover operation mode and its status information
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPistonOperationMode (Current piston operation mode): Current piston prover operation mode and its status information
        """
    
        logging.debug(
            "GetPistonOperationMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPistonOperationMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPistonOperationMode(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetPistonOperationMode_Responses:
        """
        Executes the unobservable command "Set piston operation mode"
            Set the new piston prover operation mode
    
        :param request: gRPC request containing the parameters passed:
            request.SetPistonOperationMode (Set piston operation mode):
            The the new piston prover operation mode
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set piston operation mode
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the Set piston operation mode applies
        """
    
        logging.debug(
            "SetPistonOperationMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPistonOperationMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetTimeOut(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetTimeOut_Responses:
        """
        Executes the unobservable command "Get time out"
            Maximum admitted duration time for specific procedure (in 0,1seconds; 100 milliseconds)
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTimeOut (Current time out):
            Current maximum admitted duration time for specific procedure (in 0,1seconds; 100 milliseconds)
        """
    
        logging.debug(
            "GetTimeOut called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetTimeOut(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetTimeOut(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetTimeOut_Responses:
        """
        Executes the unobservable command "Set time out"
            Set the new maximum admitted duration time for specific procedure (in 0,1seconds; 100 milliseconds)
    
        :param request: gRPC request containing the parameters passed:
            request.SetTimeOut (Set time out):
            The the new admitted duration time for specific procedure in 0,1seconds; 100milliseconds.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set time out
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set time out applies
        """
    
        logging.debug(
            "SetTimeOut called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetTimeOut(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFrequency(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetFrequency_Responses:
        """
        Executes the unobservable command "Get frequency"
            Piston frequency in Hz
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFrequency (Current frequency):
            Current piston frequency in Hz
        """
    
        logging.debug(
            "GetFrequency called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFrequency(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetFrequency(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetFrequency_Responses:
        """
        Executes the unobservable command "Set frequency"
            Set the new piston frequency in Hz
    
        :param request: gRPC request containing the parameters passed:
            request.SetFrequency (set frequency):
            New piston frequency to be set in Hz
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set frequency
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set frequency applies
        """
    
        logging.debug(
            "SetFrequency called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFrequency(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDensityActual(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetDensityActual_Responses:
        """
        Executes the unobservable command "Get density actual"
            reference density of selected fluid in Kg pro m3
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDensity (Current density actual): Reference density of selected fluid in Kgm pro m3
        """
    
        logging.debug(
            "GetDensityActual called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDensityActual(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetDensityActual(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetDensityActual_Responses:
        """
        Executes the unobservable command "Set densityActual"
            Set the new reference density of the selected fluid in Kg prom3
    
        :param request: gRPC request containing the parameters passed:
            request.SetDensityActual (set densityActual):
            New density of selected fluid in Kg/m3
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set density actual
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set density actual applies
        """
    
        logging.debug(
            "SetDensityActual called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetDensityActual(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPressureInlet(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetPressureInlet_Responses:
        """
        Executes the unobservable command "Get pressure inlet"
            Pressure inlet (upstream) of fluid in bar, for the first fluid-Nr. only in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPressureInlet (Current pressure inlet):
            Pressure inlet (upstream) of fluid in bar, for the first fluid-Nr. only in millibar
        """
    
        logging.debug(
            "GetPressureInlet called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPressureInlet(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPressureInlet(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetPressureInlet_Responses:
        """
        Executes the unobservable command "Set pressure inlet"
            Set the new pressure inlet (upstream) of fluid in bar (first fluid only)
    
        :param request: gRPC request containing the parameters passed:
            request.SetPressureInlet (set pressure inlet):
            New pressure inlet in millibar
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set pressure inlet
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set pressure inlet applies
        """
    
        logging.debug(
            "SetPressureInlet called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPressureInlet(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPressureOutlet(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetPressureOutlet_Responses:
        """
        Executes the unobservable command "Get pressure outlet"
            Pressure outlet (downstream) of fluid in bar, for the first fluid-Nr. only. in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPressureInlet (Current pressure inlet):
            Pressure outlet (downstream) of fluid in bar, for the first fluid-Nr. only. in millibar
        """
    
        logging.debug(
            "GetPressureOutlet called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPressureOutlet(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetPressureOutlet(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetPressureOutlet_Responses:
        """
        Executes the unobservable command "Set pressure outlet"
            Set the new pressure outlet (downstream) of fluid in bar (first fluid only) in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.SetPressureOutlet (set pressure outlet):
            New pressure outlet (downstream) of fluid in bar (first fluid only) in millibar
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status):
            Command status: Request response of command set pressure outlet in millibar
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set pressure outlet applies
        """
    
        logging.debug(
            "SetPressureOutlet called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPressureOutlet(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFluidTemperature(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetFluidTemperature_Responses:
        """
        Executes the unobservable command "Get fluid temperature"
            temperature of fluid through instrument (for first fluid only) in degree Celsius
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFluidTemperature (Current fluid temperature): Fluid temperature through instrument (for first fluid only) in  degree Celsius
        """
    
        logging.debug(
            "GetFluidTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFluidTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetFluidTemperature(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetFluidTemperature_Responses:
        """
        Executes the unobservable command "Set fluid temperature"
            Set the new temperature of fluid through instrument (for first fluid only) in Celsius degree
    
        :param request: gRPC request containing the parameters passed:
            request.SetFluidTemperature (Set fluid temperature):
            Set the new temperature of fluid through instrument (for first fluid only) in grades Celsius degree
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set fluid temperature
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set fluid temperature applies
        """
    
        logging.debug(
            "SetFluidTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetFluidTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetThermalConductivity(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetThermalConductivity_Responses:
        """
        Executes the unobservable command "Get thermal conductivity"
            Thermal conductivity at sensor conditions at Watt/(m*K). Value is equal or bigger than 0
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentThermalConductivity (Current thermal conductivity):
            Thermal conductivity at sensor conditions at Watt/(m*K). Value is equal or bigger than 0
        """
    
        logging.debug(
            "GetThermalConductivity called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetThermalConductivity(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetThermalConductivity(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetThermalConductivity_Responses:
        """
        Executes the unobservable command "SetThermalConductivity"
            Set the new thermal conductivity in sensor conditions in Watt/(m*K)
    
        :param request: gRPC request containing the parameters passed:
            request.SetThermalConductivity (set thermal conductivity):
            Set the new thermal conductivity in sensor conditions in Watt/(m*K)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set thermal conductivity
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set thermal conductivity applies
        """
    
        logging.debug(
            "SetThermalConductivity called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetThermalConductivity(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetStandardMassFlow(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetStandardMassFlow_Responses:
        """
        Executes the unobservable command "Get standard mass flow"
            Standard mass flow in l/min air (20°C, 1atm, 1.01325bar) or g/h H2O equivalent. Value bigger than 0
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentStandardMassFlow (Current standard mass flow):
            Standard mass flow in l/min air (20°C, 1atm, 1.01325bar) or g/h H2O equivalent. Value bigger than 0
        """
    
        logging.debug(
            "GetStandardMassFlow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetStandardMassFlow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetStandardMassFlow(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetStandardMassFlow_Responses:
        """
        Executes the unobservable command "Set standard mass flow"
            Set the new standard mass flow in l/min air (20°C, 1atm, 1.01325bar) or g/h H2O equivalent. Value bigger than 0
    
        :param request: gRPC request containing the parameters passed:
            request.SetStandardFlow (set standard flow):
            Set the new standard mass flow in l/min air (20°C, 1atm, 1.01325bar) or g/h H2O equivalent. Value bigger than 0
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set standard flow
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set standard flow
        """
    
        logging.debug(
            "SetStandardMassFlow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetStandardMassFlow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetOrificeDiameter(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetOrificeDiameter_Responses:
        """
        Executes the unobservable command "Get orifice diameter"
            Orifice diameter in mm
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentOrificeDiameter (Current orifice diameter): Orifice diameter in mm
        """
    
        logging.debug(
            "GetOrificeDiameter called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetOrificeDiameter(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetOrificeDiameter(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetOrificeDiameter_Responses:
        """
        Executes the unobservable command "Set orifice diameter"
            Set new orifice diameter in mm
    
        :param request: gRPC request containing the parameters passed:
            request.SetOrificeDiameter (Set new orifice diameter):
            New orifice diameter to be set
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set orifice diameter
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set orifice diameter applies
        """
    
        logging.debug(
            "SetOrificeDiameter called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetOrificeDiameter(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetBarometerPressure(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetBarometerPressure_Responses:
        """
        Executes the unobservable command "Get barometer pressure"
            barometer atmospheric pressure in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentBarometerPressure (Current barometer pressure): Barometer atmospheric pressure in mbar
        """
    
        logging.debug(
            "GetBarometerPressure called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetBarometerPressure(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetBarometerPressure(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetBarometerPressure_Responses:
        """
        Executes the unobservable command "Set barometer pressure"
            set current barometer atmospheric pressure in millibar
    
        :param request: gRPC request containing the parameters passed:
            request.SetBarometerPressure (Set barometer pressure): Set current barometer atmospheric pressure in millibar
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set barometer pressure
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set barometer pressure applies
        """
    
        logging.debug(
            "SetBarometerPressure called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetBarometerPressure(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetNumberVanes(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.GetNumberVanes_Responses:
        """
        Executes the unobservable command "Get number vanes"
            Current number of vanes used in rotor
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentNumberVanes (Current Number vanes): Current number of vanes used in rotor
        """
    
        logging.debug(
            "GetNumberVanes called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetNumberVanes(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetNumberVanes(self, request, context: grpc.ServicerContext) \
            -> MeasurementSettingsService_pb2.SetNumberVanes_Responses:
        """
        Executes the unobservable command "Set number vanes"
            Set number of vanes used in rotor
    
        :param request: gRPC request containing the parameters passed:
            request.SetNumberVanes (Set number of vanes used in rotor):
            number of vanes used in rotor
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Status (Status): Command status: Request response of command set number vanes
            request.IndexPointing (Index pointing):
            Index pointing to the first byte in the send message for which the set number vanes
        """
    
        logging.debug(
            "SetNumberVanes called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetNumberVanes(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
