"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Service*

:details: DeviceService:
    Allows full control of the device features of the flowmeter.
    By Lukas Bromig and Jose de Jesus Pina, Institute of Biochemical Engineering, Technical University of Munich,
    02.12.2020
           
:file:    DeviceService_servicer.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-04-14T10:22:07.860124
:date: (last modification) 2021-04-14T10:22:07.860124

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceService_pb2 as DeviceService_pb2
from .gRPC import DeviceService_pb2_grpc as DeviceService_pb2_grpc

# import simulation and real implementation
from .DeviceService_simulation import DeviceServiceSimulation
from .DeviceService_real import DeviceServiceReal


class DeviceService(DeviceService_pb2_grpc.DeviceServiceServicer):
    """
    This is a flowmeter service
    """
    implementation: Union[DeviceServiceSimulation, DeviceServiceReal]
    simulation_mode: bool

    def __init__(self, ser, lock, port, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.lock = lock
        self.ser = ser
        self.port = port
        self.simulation_mode = simulation_mode

        if simulation_mode:
            self._inject_implementation(DeviceServiceSimulation(port=self.port))
        else:
            self._inject_implementation(DeviceServiceReal(ser=self.ser, port=self.port))

    def _inject_implementation(self,
                               implementation: Union[DeviceServiceSimulation,
                                                     DeviceServiceReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the FlowmeterElflowPrestigeServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceServiceSimulation(port=self.port))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceServiceReal(ser=self.ser, port=self.port))

    def GetValveOutput(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetValveOutput_Responses:
        """
        Executes the unobservable command "Get valve output"
            It represents the controller output signal for control valve operation. It goes from 0 to 300mAdc.
            In reality it reaches until 250mAdc
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentValveOutput (Current valve output):
            It shows the setpoint in the capacity unit for which the instrument is set.
        """
    
        logging.debug(
            "GetValveOutput called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetValveOutput(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCapacity100(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetCapacity100_Responses:
        """
        Executes the unobservable command "Get capacity 100"
            This parameter sets the maximum readout/control value (100%) for the current fluid in readout units corresponding to Capacity Unit.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCapacity100 (Current capacity 100):
            This parameter sets the maximum readout/control value (100%) for the current fluid in readout units corresponding to Capacity Unit.
        """
    
        logging.debug(
            "GetCapacity100 called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCapacity100(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCapacityUnit(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetCapacityUnit_Responses:
        """
        Executes the unobservable command "Get capacity unit"
            This parameter defines the units in which is the measured value and set value are represented.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCapacityUnit (Current capacity unit):
            current  parameter which defines the units in which is the measured value and set value are represented.
        """
    
        logging.debug(
            "GetCapacityUnit called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCapacityUnit(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSerialNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetSerialNumber_Responses:
        """
        Executes the unobservable command "Get serial number"
            Serial number of the device and software version
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSerialNumber (Current serial number): it gets the serial number of the device and software version
        """
    
        logging.debug(
            "GetSerialNumber called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSerialNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPrimaryNodeAddress(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetPrimaryNodeAddress_Responses:
        """
        Executes the unobservable command "Get primary node address "
            Primary node address: network parameter Flow-Bus
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPrimaryNodeAddress (Current primary node address): Primary node address: network parameter Flow-Bus
        """
    
        logging.debug(
            "GetPrimaryNodeAddress called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPrimaryNodeAddress(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFirmwareVersion(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetFirmwareVersion_Responses:
        """
        Executes the unobservable command "Get firmware version"
            revision number of the firmware
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFirmwareVersion (Current firmware version): revision number of the firmware
        """
    
        logging.debug(
            "GetFirmwareVersion called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFirmwareVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetCommunicationProtocol(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetCommunicationProtocol_Responses:
        """
        Executes the unobservable command "Get communication protocol"
            Current communication protocol between the program adn the device.
            2 possible options: "binary" and "ascii"
            Binary is the default protocol
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCommunicationProtocol (Current communication protocol): Current communication protocol working with
        """
    
        logging.debug(
            "GetCommunicationProtocol called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetCommunicationProtocol(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCommunicationProtocolBinary(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.SetCommunicationProtocolBinary_Responses:
        """
        Executes the unobservable command "Set communication protocol binary"
            it sets the protocol communication to binary
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCommunicationProtocolBinary (Current communication protocol): Current Communication Protocol: binary
        """
    
        logging.debug(
            "SetCommunicationProtocolBinary called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCommunicationProtocolBinary(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetCommunicationProtocolAscii(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.SetCommunicationProtocolAscii_Responses:
        """
        Executes the unobservable command "Set communication protocol ascii"
            it sets the protocol communication to ascii
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentCommunicationProtocolAscii (Current communication protocol ascii): Current Communication Protocol: ascii
        """
    
        logging.debug(
            "SetCommunicationProtocolAscii called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetCommunicationProtocolAscii(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSerialPort(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.GetSerialPort_Responses:
        """
        Executes the unobservable command "Get serial port"
            Current devices serial port. "50001" is the predefined value
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentSerialPort (Current serial port): Current serial port. "50001" is the predefined value
        """
    
        logging.debug(
            "GetSerialPort called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSerialPort(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetSerialPort(self, request, context: grpc.ServicerContext) \
            -> DeviceService_pb2.SetSerialPort_Responses:
        """
        Executes the unobservable command "Set serial port"
            Sets devices new serial port
    
        :param request: gRPC request containing the parameters passed:
            request.SetSerialPort (Set serial port):
            Sets devices new serial port. "50001" is the predefined value
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.NewSerialPort (New serial port): New serial port.
        """
    
        logging.debug(
            "SetSerialPort called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetSerialPort(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
