#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*FlowmeterElflowPrestigeService client*

:details: FlowmeterElflowPrestigeService:
    This is a flowmeter service

:file:    FlowmeterElflowPrestigeService_client.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-04-14T10:22:07.880230
:date: (last modification) 2021-04-14T10:22:07.880230

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err

# Import gRPC libraries of features
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.gRPC import DeviceService_pb2
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.gRPC import MeasurementService_pb2
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.gRPC import MeasurementService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.MeasurementService_default_arguments import default_dict as MeasurementService_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class FlowmeterElflowPrestigeServiceClient(SiLA2Client):
    """
        This is a flowmeter service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "FlowmeterElflowPrestigeServiceClient", description: str = "This is a flowmeter service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "lukas.bromig@tum.de",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service FlowmeterElflowPrestigeService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.DeviceService_stub = \
            DeviceService_pb2_grpc.DeviceServiceStub(self.channel)
        self.MeasurementService_stub = \
            MeasurementService_pb2_grpc.MeasurementServiceStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def GetValveOutput(self,
                      parameter: DeviceService_pb2.GetValveOutput_Parameters = None) \
            -> DeviceService_pb2.GetValveOutput_Responses:
        """
        Wrapper to call the unobservable command GetValveOutput on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetValveOutput:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetValveOutput_Parameters(
                    **DeviceService_default_dict['GetValveOutput_Parameters']
                )
    
            response = self.DeviceService_stub.GetValveOutput(parameter)
    
            logging.debug('GetValveOutput response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCapacity100(self,
                      parameter: DeviceService_pb2.GetCapacity100_Parameters = None) \
            -> DeviceService_pb2.GetCapacity100_Responses:
        """
        Wrapper to call the unobservable command GetCapacity100 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCapacity100:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetCapacity100_Parameters(
                    **DeviceService_default_dict['GetCapacity100_Parameters']
                )
    
            response = self.DeviceService_stub.GetCapacity100(parameter)
    
            logging.debug('GetCapacity100 response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCapacityUnit(self,
                      parameter: DeviceService_pb2.GetCapacityUnit_Parameters = None) \
            -> DeviceService_pb2.GetCapacityUnit_Responses:
        """
        Wrapper to call the unobservable command GetCapacityUnit on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCapacityUnit:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetCapacityUnit_Parameters(
                    **DeviceService_default_dict['GetCapacityUnit_Parameters']
                )
    
            response = self.DeviceService_stub.GetCapacityUnit(parameter)
    
            logging.debug('GetCapacityUnit response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSerialNumber(self,
                      parameter: DeviceService_pb2.GetSerialNumber_Parameters = None) \
            -> DeviceService_pb2.GetSerialNumber_Responses:
        """
        Wrapper to call the unobservable command GetSerialNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSerialNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetSerialNumber_Parameters(
                    **DeviceService_default_dict['GetSerialNumber_Parameters']
                )
    
            response = self.DeviceService_stub.GetSerialNumber(parameter)
    
            logging.debug('GetSerialNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetPrimaryNodeAddress(self,
                      parameter: DeviceService_pb2.GetPrimaryNodeAddress_Parameters = None) \
            -> DeviceService_pb2.GetPrimaryNodeAddress_Responses:
        """
        Wrapper to call the unobservable command GetPrimaryNodeAddress on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPrimaryNodeAddress:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetPrimaryNodeAddress_Parameters(
                    **DeviceService_default_dict['GetPrimaryNodeAddress_Parameters']
                )
    
            response = self.DeviceService_stub.GetPrimaryNodeAddress(parameter)
    
            logging.debug('GetPrimaryNodeAddress response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFirmwareVersion(self,
                      parameter: DeviceService_pb2.GetFirmwareVersion_Parameters = None) \
            -> DeviceService_pb2.GetFirmwareVersion_Responses:
        """
        Wrapper to call the unobservable command GetFirmwareVersion on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFirmwareVersion:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetFirmwareVersion_Parameters(
                    **DeviceService_default_dict['GetFirmwareVersion_Parameters']
                )
    
            response = self.DeviceService_stub.GetFirmwareVersion(parameter)
    
            logging.debug('GetFirmwareVersion response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetCommunicationProtocol(self,
                      parameter: DeviceService_pb2.GetCommunicationProtocol_Parameters = None) \
            -> DeviceService_pb2.GetCommunicationProtocol_Responses:
        """
        Wrapper to call the unobservable command GetCommunicationProtocol on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetCommunicationProtocol:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetCommunicationProtocol_Parameters(
                    **DeviceService_default_dict['GetCommunicationProtocol_Parameters']
                )
    
            response = self.DeviceService_stub.GetCommunicationProtocol(parameter)
    
            logging.debug('GetCommunicationProtocol response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCommunicationProtocolBinary(self,
                      parameter: DeviceService_pb2.SetCommunicationProtocolBinary_Parameters = None) \
            -> DeviceService_pb2.SetCommunicationProtocolBinary_Responses:
        """
        Wrapper to call the unobservable command SetCommunicationProtocolBinary on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCommunicationProtocolBinary:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SetCommunicationProtocolBinary_Parameters(
                    **DeviceService_default_dict['SetCommunicationProtocolBinary_Parameters']
                )
    
            response = self.DeviceService_stub.SetCommunicationProtocolBinary(parameter)
    
            logging.debug('SetCommunicationProtocolBinary response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetCommunicationProtocolAscii(self,
                      parameter: DeviceService_pb2.SetCommunicationProtocolAscii_Parameters = None) \
            -> DeviceService_pb2.SetCommunicationProtocolAscii_Responses:
        """
        Wrapper to call the unobservable command SetCommunicationProtocolAscii on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetCommunicationProtocolAscii:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SetCommunicationProtocolAscii_Parameters(
                    **DeviceService_default_dict['SetCommunicationProtocolAscii_Parameters']
                )
    
            response = self.DeviceService_stub.SetCommunicationProtocolAscii(parameter)
    
            logging.debug('SetCommunicationProtocolAscii response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSerialPort(self,
                      parameter: DeviceService_pb2.GetSerialPort_Parameters = None) \
            -> DeviceService_pb2.GetSerialPort_Responses:
        """
        Wrapper to call the unobservable command GetSerialPort on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSerialPort:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetSerialPort_Parameters(
                    **DeviceService_default_dict['GetSerialPort_Parameters']
                )
    
            response = self.DeviceService_stub.GetSerialPort(parameter)
    
            logging.debug('GetSerialPort response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetSerialPort(self,
                      parameter: DeviceService_pb2.SetSerialPort_Parameters = None) \
            -> DeviceService_pb2.SetSerialPort_Responses:
        """
        Wrapper to call the unobservable command SetSerialPort on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSerialPort:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SetSerialPort_Parameters(
                    **DeviceService_default_dict['SetSerialPort_Parameters']
                )
    
            response = self.DeviceService_stub.SetSerialPort(parameter)
    
            logging.debug('SetSerialPort response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetMeasuredValue(self,
                      parameter: MeasurementService_pb2.GetMeasuredValue_Parameters = None) \
            -> MeasurementService_pb2.GetMeasuredValue_Responses:
        """
        Wrapper to call the unobservable command GetMeasuredValue on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetMeasuredValue:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementService_pb2.GetMeasuredValue_Parameters(
                    **MeasurementService_default_dict['GetMeasuredValue_Parameters']
                )
    
            response = self.MeasurementService_stub.GetMeasuredValue(parameter)
    
            logging.debug('GetMeasuredValue response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetSetpointValue(self,
                      parameter: MeasurementService_pb2.GetSetpointValue_Parameters = None) \
            -> MeasurementService_pb2.GetSetpointValue_Responses:
        """
        Wrapper to call the unobservable command GetSetpointValue on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointValue:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementService_pb2.GetSetpointValue_Parameters(
                    **MeasurementService_default_dict['GetSetpointValue_Parameters']
                )
    
            response = self.MeasurementService_stub.GetSetpointValue(parameter)
    
            logging.debug('GetSetpointValue response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetSetpointValue(self,
                      parameter: MeasurementService_pb2.SetSetpointValue_Parameters = None) \
            -> MeasurementService_pb2.SetSetpointValue_Responses:
        """
        Wrapper to call the unobservable command SetSetpointValue on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetSetpointValue:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementService_pb2.SetSetpointValue_Parameters(
                    **MeasurementService_default_dict['SetSetpointValue_Parameters']
                )
    
            response = self.MeasurementService_stub.SetSetpointValue(parameter)
    
            logging.debug('SetSetpointValue response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFluidNumber(self,
                      parameter: MeasurementService_pb2.GetFluidNumber_Parameters = None) \
            -> MeasurementService_pb2.GetFluidNumber_Responses:
        """
        Wrapper to call the unobservable command GetFluidNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFluidNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementService_pb2.GetFluidNumber_Parameters(
                    **MeasurementService_default_dict['GetFluidNumber_Parameters']
                )
    
            response = self.MeasurementService_stub.GetFluidNumber(parameter)
    
            logging.debug('GetFluidNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def SetFluidNumber(self,
                      parameter: MeasurementService_pb2.SetFluidNumber_Parameters = None) \
            -> MeasurementService_pb2.SetFluidNumber_Responses:
        """
        Wrapper to call the unobservable command SetFluidNumber on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetFluidNumber:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementService_pb2.SetFluidNumber_Parameters(
                    **MeasurementService_default_dict['SetFluidNumber_Parameters']
                )
    
            response = self.MeasurementService_stub.SetFluidNumber(parameter)
    
            logging.debug('SetFluidNumber response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetFluidName(self,
                      parameter: MeasurementService_pb2.GetFluidName_Parameters = None) \
            -> MeasurementService_pb2.GetFluidName_Responses:
        """
        Wrapper to call the unobservable command GetFluidName on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFluidName:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MeasurementService_pb2.GetFluidName_Parameters(
                    **MeasurementService_default_dict['GetFluidName_Parameters']
                )
    
            response = self.MeasurementService_stub.GetFluidName(parameter)
    
            logging.debug('GetFluidName response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    #   No properties defined

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: FlowmeterElflowPrestigeService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = FlowmeterElflowPrestigeServiceClient(server_ip='127.0.0.1', server_port=50004)
    sila_client.run()

    """
    response = sila_client.GetCommunicationProtocol()
    print(f'Communication protocol is: ', response)
    response = sila_client.SetCommunicationProtocolBinary()
    response = sila_client.GetCommunicationProtocol()
    print(f'Communication protocol is: ', response)
    response = sila_client.SetCommunicationProtocolAscii()
    response = sila_client.GetCommunicationProtocol()
    print(f'Communication protocol is: ', response)
    response = sila_client.GetFluidNumber()
    print(response)
    """

    # response = sila_client.SetCommunicationProtocolBinary()
    # response = sila_client.GetCommunicationProtocol()


    # ---------------------------
    # response = sila_client.SetCommunicationProtocolAscii()
    # response = sila_client.GetCommunicationProtocol()


    #response = sila_client.SetSerialPort(parameter=DeviceService_pb2.SetSerialPort_Parameters(SetSerialPort=silaFW_pb2.String(value=str("50003"))))
    #for flow in range(1000):
        # response = sila_client.SetSetpointValue(parameter=MeasurementService_pb2.SetSetpointValue_Parameters(SetSetpointValue=silaFW_pb2.Real(value=float(flow/10))))
        # response = sila_client.GetSetpointValue()
        # time.sleep(0.5)
    response = sila_client.SetCommunicationProtocolBinary()
    response = sila_client.GetCommunicationProtocol()

    for flow in [0, 5, 10, 15, 35, 45, 50, 70, 71, 72, 73, 76, 85, 99, 100]:
        print(flow)
        response = sila_client.SetSetpointValue(parameter=MeasurementService_pb2.SetSetpointValue_Parameters(
            SetSetpointValue=silaFW_pb2.Real(value=float(flow))))
        response = sila_client.GetSetpointValue()
        time.sleep(5)

        # response = sila_client.GetSetpointValue()

    response = sila_client.SetCommunicationProtocolAscii()
    response = sila_client.GetCommunicationProtocol()

    for flow in [0, 5, 10, 15, 35, 45, 50, 70, 71, 72, 73, 76, 85, 99, 100, 0]:
        print(flow)
        response = sila_client.SetSetpointValue(parameter=MeasurementService_pb2.SetSetpointValue_Parameters(
            SetSetpointValue=silaFW_pb2.Real(value=float(flow))))
        response = sila_client.GetSetpointValue()
        time.sleep(5)

        # response = sila_client.GetSetpointValue()


    """
fluid_name = "AiR\000\000\000\000\000\000\000".replace('\000', '')
    # replace('\r\n', '')
    print(fluid_name)
"""

    """
     # JA

     response = sila_client.GetValveOutput()
     response = sila_client.GetCapacity100()
     response = sila_client.GetCapacityUnit()
     response = sila_client.GetSerialNumber()  
     response = sila_client.GetPrimaryNodeAddress()
     response = sila_client.GetFirmwareVersion()  
     response = sila_client.GetCommunicationProtocol()
     response = sila_client.GetSerialPort()

     response = sila_client.SetCommunicationProtocolBinary()
     response = sila_client.SetCommunicationProtocolAscii()
     response = sila_client.SetSerialPort(
         parameter=DeviceService_pb2.SetSerialPort_Parameters(SetSerialPort=silaFW_pb2.String(value=str("50003"))))
     # --------------------------------------------------------------------
     response = sila_client.GetMeasuredValue()
     response = sila_client.GetSetpointValue()
     response = sila_client.GetFluidNumber()
     response = sila_client.GetFluidName()  

     response = sila_client.SetSerialPort(parameter=DeviceService_pb2.SetSerialPort_Parameters(SetSerialPort=silaFW_pb2.String(value=str("50003"))))
     response = sila_client.SetSetpointValue(parameter=MeasurementService_pb2.SetSetpointValue_Parameters(
         SetSetpointValue=silaFW_pb2.Real(value=float(0.18))))
     response = sila_client.SetFluidNumber(parameter=MeasurementService_pb2.SetFluidNumber_Parameters(SetFluidNumber=silaFW_pb2.Integer(value=int(3))))
     """
    print(response)

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )
