#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*FlowmeterElflowPrestigeService*

:details: FlowmeterElflowPrestigeService:
    This is a flowmeter service
           
:file:    FlowmeterElflowPrestigeService_server.py
:authors: Lukas Bromig and Jose de Jesus Pina

:date: (creation)          2021-04-14T10:22:07.873420
:date: (last modification) 2021-04-14T10:22:07.873420

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

import os
import sys
import logging
import argparse

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.gRPC import DeviceService_pb2
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.gRPC import MeasurementService_pb2
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.gRPC import MeasurementService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.MeasurementService_default_arguments import default_dict as MeasurementService_default_dict

# Import the servicer modules for each feature
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.DeviceService_servicer import DeviceService
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.MeasurementService_servicer import MeasurementService

# import custom implementation libraries
import serial
import serial.tools.list_ports
import multiprocessing
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.SerialDetector import serial_ports
from sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService import shared

class FlowmeterElflowPrestigeServiceServer(SiLA2Server):
    """
    This is a flowmeter service
    """

    def __init__(self, cmd_args, ip: str = '127.0.0.1', port: int = 50001, simulation_mode: bool = True, com_port = None):
        """Class initialiser"""
        super().__init__(
            name=cmd_args.server_name, description=cmd_args.description,
            server_type=cmd_args.server_type, server_uuid=None,
            version=__version__,
            vendor_url="",
            ip=ip, port=port,
            key_file=cmd_args.encryption_key, cert_file=cmd_args.encryption_cert,
            simulation_mode=simulation_mode, server_hostname=f'{cmd_args.server_name}.sila',
            # server_path=os.path.dirname(os.path.realpath(__file__))
        )

        logging.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=cmd_args.server_name
            )
        )
        self.lock = multiprocessing.Lock()
        shared.status = "Idle"
        shared.protocol = 'binary'
        shared.node = '03'

        self.port ='50001'
        self.simulation_mode = simulation_mode
        self.com_port = com_port

        if not simulation_mode:
            ports_required = [self.com_port]
            # Opening a serial port for data communication automatically. ONLY use if no other COM ports exist!
            available_ports = serial_ports()
            ports = []
            ports_not_required = []
            for i in range(0, len(available_ports), 1):
                if available_ports[i] in ports_required:
                    ports.append(available_ports[i])
                else:
                    ports_not_required.append(available_ports[i])
            unavailable_ports = list(set(ports_required) - set(ports))
            if unavailable_ports is not []:
                logging.info(
                    "The following COM/USB ports are not available: {ports}".format(ports=unavailable_ports))
            if ports == []:
                logging.info(
                    "No available COM/USB port to establish connection: {ports}".format(ports=ports))
            else:
                self.ser = serial.Serial(port=ports[0], baudrate=38400, parity=serial.PARITY_NONE,
                                         stopbits=serial.STOPBITS_ONE, bytesize=serial.EIGHTBITS, timeout=.5)
                logging.info(
                    "Connection established on port: {ports}".format(ports=ports[0]))

            # On Debian use the following and specify the Comport name!
            # ser = serial.Serial(port="/dev/ttyS0", baudrate = 9600,parity=serial.PARITY_NONE, stopbits=serial.STOPBITS_ONE,bytesize=8,timeout=1, xonxoff=0)
        else:
            self.ser = None

        # registering features
        #  Register DeviceService
        self.DeviceService_servicer = DeviceService(ser=self.ser,
                                                    lock=self.lock,
                                                    port=self.port,
                                                    simulation_mode=self.simulation_mode)
        DeviceService_pb2_grpc.add_DeviceServiceServicer_to_server(
            self.DeviceService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceService',
                         servicer=self.DeviceService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register MeasurementService
        self.MeasurementService_servicer = MeasurementService(ser=self.ser,
                                                              lock=self.lock,
                                                              port=self.port,
                                                              simulation_mode=self.simulation_mode)
        MeasurementService_pb2_grpc.add_MeasurementServiceServicer_to_server(
            self.MeasurementService_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='MeasurementService',
                         servicer=self.MeasurementService_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )

        self.simulation_mode = simulation_mode

        # starting and running the gRPC/SiLA2 server
        self.run()


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: FlowmeterElflowPrestigeService")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="FlowmeterElflowPrestigeService", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a flowmeter service", help='SiLA server description')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args
    

def init():
    if __name__ == '__main__':
        # or use logging.ERROR for less output
        logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

        args = parse_command_line()

        # generate SiLA2Server
        sila_server = FlowmeterElflowPrestigeServiceServer(cmd_args=args, ip='127.0.0.1', port=50004, simulation_mode=False, com_port='/dev/ttyUSB0')  # /dev/tty.usbserial-AL0347P6
        sys.exit(sila_server.run())


init()
