"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Control Parameter Servicer*

:details: ControlParameterServicer:
    Set and retrieve the control parameter values of the in-built PID-controller of the LAUDA L250 Thermostat.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    ControlParameterServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:02.015922
:date: (last modification) 2020-04-17T12:22:02.015922

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import ControlParameterServicer_pb2 as ControlParameterServicer_pb2
from .gRPC import ControlParameterServicer_pb2_grpc as ControlParameterServicer_pb2_grpc

# import simulation and real implementation
from .ControlParameterServicer_simulation import ControlParameterServicerSimulation
from .ControlParameterServicer_real import ControlParameterServicerReal


class ControlParameterServicer(ControlParameterServicer_pb2_grpc.ControlParameterServicerServicer):
    """
    This is a LAUDA L250 Thermostat Service
    """
    implementation: Union[ControlParameterServicerSimulation, ControlParameterServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(ControlParameterServicerSimulation())
        else:
            self._inject_implementation(ControlParameterServicerReal(ser = self.ser))

    def _inject_implementation(self,
                               implementation: Union[ControlParameterServicerSimulation,
                                                     ControlParameterServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the LAUDA_ThermostatServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(ControlParameterServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(ControlParameterServicerReal(ser = self.ser))

    def SetControlParamXp(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamXp_Responses:
        """
        Executes the unobservable command "Set Control Parameter Xp Value"
            Set the control parameter Xp of the PID controller in Kelvin, K.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamXp (Control Param Xp):
            The control parameter Xp for the proportional gain of the PID-controller in K.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamXpSet (Control Param Xp Set): Control Param Xp succeeded to Set.
        """
    
        logging.debug(
            "SetControlParamXp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControlParamXp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControlParamTn(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamTn_Responses:
        """
        Executes the unobservable command "Set Control Parameter Tn Value"
            Set the control parameter Tn of the PID controller in seconds, s.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamTn (Control Param Tn):
            The control parameter Tn for the integral part of the PID-controller in s.
            The length of the interval to be integrated to calculate the control deviation.
            A value of 181s deactivates the I-part of the PID-controller.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamTnSet (Control Param Tn Set): Control Param Tn succeeded to Set.
        """
    
        logging.debug(
            "SetControlParamTn called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControlParamTn(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControlParamTv(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamTv_Responses:
        """
        Executes the unobservable command "Set Control Parameter Tv Value"
            Set the control parameter Tv of the PID controller in seconds, s.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamTv (Control Param Tv):
            The control parameter Tv for the derivative part of the PID-controller in s.
            The derivative time dampens the effect of the proportional and the integral part.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamTvSet (Control Param Tv Set): Control Param Tv succeeded to Set.
        """
    
        logging.debug(
            "SetControlParamTv called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControlParamTv(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetControlParamTd(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamTd_Responses:
        """
        Executes the unobservable command "Set Control Parameter Td Value"
            Set the control parameter Td of the PID controller in seconds, s.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamTd (Control Param Td):
            The control parameter Td introduces a dampening effect on the derivative part Tv of the PID-controller in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamTdSet (Control Param Td Set): Control Param Td succeeded to Set.
        """
    
        logging.debug(
            "SetControlParamTd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetControlParamTd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControlParamXp(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamXp_Responses:
        """
        Executes the unobservable command "Get Control Param Xp"
            Get control parameter of the proportional factor, Xp, of the PID-controller in K.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamXp (Current Control Param Xp): Current control parameter of the proportional factor, Xp, of the PID-controller in K.
        """
    
        logging.debug(
            "GetControlParamXp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControlParamXp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControlParamTn(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamTn_Responses:
        """
        Executes the unobservable command "Get Control Param Tn"
            Get control parameter of the integral factor, Tn, of the PID-controller in s.
            A value of Tn=181 is equivalent to "off".
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamTn (Current Control Param Tn): Current control parameter of the integral factor, Tn, of the PID-controller in s.
            A value of Tn=181 is equivalent to "off".
        """
    
        logging.debug(
            "GetControlParamTn called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControlParamTn(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControlParamTv(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamTv_Responses:
        """
        Executes the unobservable command "Get Control Param Tv"
            Get control parameter of the derivative factor, Tv, of the PID-controller in s.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamTv (Current Control Param Tv): Current control parameter of the derivative factor, Tv, of the PID-controller in s.
        """
    
        logging.debug(
            "GetControlParamTv called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControlParamTv(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetControlParamTd(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamTd_Responses:
        """
        Executes the unobservable command "Get Control Param Td"
            Get control parameter dampening factor, Td, of the derivative factor, Tv, of the PID-controller in s.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamTd (Current Control Param Td): Current control parameter dampening factor, Td, of the derivative factor, Tv, of the PID-controller in s.
        """
    
        logging.debug(
            "GetControlParamTd called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetControlParamTd(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
