"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Control Parameter Servicer*

:details: ControlParameterServicer:
    Set and retrieve the control parameter values of the in-built PID-controller of the LAUDA L250 Thermostat.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    ControlParameterServicer_simulation.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:02.023877
:date: (last modification) 2020-04-17T12:22:02.023877

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import ControlParameterServicer_pb2 as ControlParameterServicer_pb2
# from .gRPC import ControlParameterServicer_pb2_grpc as ControlParameterServicer_pb2_grpc

# import default arguments
from .ControlParameterServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class ControlParameterServicerSimulation:
    """
    Implementation of the *Control Parameter Servicer* in *Simulation* mode
        This is a LAUDA L250 Thermostat Service
    """

    def __init__(self):
        """Class initialiser"""

        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def SetControlParamXp(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamXp_Responses:
        """
        Executes the unobservable command "Set Control Parameter Xp Value"
            Set the control parameter Xp of the PID controller in Kelvin, K.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamXp (Control Param Xp):
            The control parameter Xp for the proportional gain of the PID-controller in K.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamXpSet (Control Param Xp Set): Control Param Xp succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetControlParamXp here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.SetControlParamXp_Responses(
                **default_dict['SetControlParamXp_Responses']
            )
    
        return return_value
    
    
    def SetControlParamTn(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamTn_Responses:
        """
        Executes the unobservable command "Set Control Parameter Tn Value"
            Set the control parameter Tn of the PID controller in seconds, s.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamTn (Control Param Tn):
            The control parameter Tn for the integral part of the PID-controller in s.
            The length of the interval to be integrated to calculate the control deviation.
            A value of 181s deactivates the I-part of the PID-controller.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamTnSet (Control Param Tn Set): Control Param Tn succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetControlParamTn here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.SetControlParamTn_Responses(
                **default_dict['SetControlParamTn_Responses']
            )
    
        return return_value
    
    
    def SetControlParamTv(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamTv_Responses:
        """
        Executes the unobservable command "Set Control Parameter Tv Value"
            Set the control parameter Tv of the PID controller in seconds, s.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamTv (Control Param Tv):
            The control parameter Tv for the derivative part of the PID-controller in s.
            The derivative time dampens the effect of the proportional and the integral part.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamTvSet (Control Param Tv Set): Control Param Tv succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetControlParamTv here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.SetControlParamTv_Responses(
                **default_dict['SetControlParamTv_Responses']
            )
    
        return return_value
    
    
    def SetControlParamTd(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.SetControlParamTd_Responses:
        """
        Executes the unobservable command "Set Control Parameter Td Value"
            Set the control parameter Td of the PID controller in seconds, s.
    
        :param request: gRPC request containing the parameters passed:
            request.ControlParamTd (Control Param Td):
            The control parameter Td introduces a dampening effect on the derivative part Tv of the PID-controller in s.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.ControlParamTdSet (Control Param Td Set): Control Param Td succeeded to Set.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command SetControlParamTd here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.SetControlParamTd_Responses(
                **default_dict['SetControlParamTd_Responses']
            )
    
        return return_value
    
    
    def GetControlParamXp(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamXp_Responses:
        """
        Executes the unobservable command "Get Control Param Xp"
            Get control parameter of the proportional factor, Xp, of the PID-controller in K.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamXp (Current Control Param Xp): Current control parameter of the proportional factor, Xp, of the PID-controller in K.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetControlParamXp here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.GetControlParamXp_Responses(
                **default_dict['GetControlParamXp_Responses']
            )
    
        return return_value
    
    
    def GetControlParamTn(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamTn_Responses:
        """
        Executes the unobservable command "Get Control Param Tn"
            Get control parameter of the integral factor, Tn, of the PID-controller in s.
            A value of Tn=181 is equivalent to "off".
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamTn (Current Control Param Tn): Current control parameter of the integral factor, Tn, of the PID-controller in s.
            A value of Tn=181 is equivalent to "off".
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetControlParamTn here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.GetControlParamTn_Responses(
                **default_dict['GetControlParamTn_Responses']
            )
    
        return return_value
    
    
    def GetControlParamTv(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamTv_Responses:
        """
        Executes the unobservable command "Get Control Param Tv"
            Get control parameter of the derivative factor, Tv, of the PID-controller in s.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamTv (Current Control Param Tv): Current control parameter of the derivative factor, Tv, of the PID-controller in s.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetControlParamTv here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.GetControlParamTv_Responses(
                **default_dict['GetControlParamTv_Responses']
            )
    
        return return_value
    
    
    def GetControlParamTd(self, request, context: grpc.ServicerContext) \
            -> ControlParameterServicer_pb2.GetControlParamTd_Responses:
        """
        Executes the unobservable command "Get Control Param Td"
            Get control parameter dampening factor, Td, of the derivative factor, Tv, of the PID-controller in s.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentControlParamTd (Current Control Param Td): Current control parameter dampening factor, Td, of the derivative factor, Tv, of the PID-controller in s.
        """
    
        # initialise the return value
        return_value = None
    
        # TODO:
        #   Add implementation of Simulation for command GetControlParamTd here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = ControlParameterServicer_pb2.GetControlParamTd_Responses(
                **default_dict['GetControlParamTd_Responses']
            )
    
        return return_value
    

    
