"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Servicer*

:details: DeviceServicer:
    General device settings can be retrieved and changed within this function.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    DeviceServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:01.981021
:date: (last modification) 2020-04-17T12:22:01.981021

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import DeviceServicer_pb2 as DeviceServicer_pb2
# from .gRPC import DeviceServicer_pb2_grpc as DeviceServicer_pb2_grpc

# import default arguments
from .DeviceServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class DeviceServicerReal:
    """
    Implementation of the *Device Servicer* in *Real* mode
        This is a LAUDA L250 Thermostat Service
    """

    def __init__(self, ser):
        """Class initialiser"""
        self.ser = ser
        self.status = "Test-status. Not implemented yet!"
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def GetLog(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Executes the observable command "Get Log"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A command confirmation object with the following information:
            commandId: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution: The (maximum) lifetime of this command call.
        """
    
        # initialise default values
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        lifetime_of_execution: silaFW_pb2.Duration = None
    
        # TODO:
        #   Execute the actual command
        #   Optional: Generate a lifetime_of_execution
    
        # respond with UUID and lifetime of execution
        command_uuid = silaFW_pb2.CommandExecutionUUID(value=str(uuid.uuid4()))
        if lifetime_of_execution is not None:
            return silaFW_pb2.CommandConfirmation(
                commandExecutionUUID=command_uuid,
                lifetimeOfExecution=lifetime_of_execution
            )
        else:
            return silaFW_pb2.CommandConfirmation(
                commandExecutionUUID=command_uuid
            )
    
    def GetLog_Info(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Returns execution information regarding the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            commandId: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: An ExecutionInfo response stream for the command with the following fields:
            commandStatus: Status of the command (enumeration)
            progressInfo: Information on the progress of the command (0 to 1)
            estimatedRemainingTime: Estimate of the remaining time required to run the command
            updatedLifetimeOfExecution: An update on the execution lifetime
        """
        # Get the UUID of the command
        command_uuid = request.value
    
        # Get the current state
        execution_info = self._get_command_state(command_uuid=command_uuid)
    
        # construct the initial return dictionary in case while is not executed
        return_values = {'commandStatus': execution_info.commandStatus}
        if execution_info.HasField('progressInfo'):
            return_values['progressInfo'] = execution_info.progressInfo
        if execution_info.HasField('estimatedRemainingTime'):
            return_values['estimatedRemainingTime'] = execution_info.estimatedRemainingTime
        if execution_info.HasField('updatedLifetimeOfExecution'):
            return_values['updatedLifetimeOfExecution'] = execution_info.updatedLifetimeOfExecution
    
        # we loop only as long as the command is running
        while execution_info.commandStatus == silaFW_pb2.ExecutionInfo.CommandStatus.waiting \
                or execution_info.commandStatus == silaFW_pb2.ExecutionInfo.CommandStatus.running:
            # TODO:
            #   Evaluate the command status --> command_status. Options:
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.running
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.finishedSuccessfully
            #       command_stats = silaFW_pb2.ExecutionInfo.CommandStatus.finishedWithError
            #   Optional:
            #       * Determine the progress (progressInfo)
            #       * Determine the estimated remaining time
            #       * Update the Lifetime of execution
    
            # Update all values
            execution_info = self._get_command_state(command_uuid=command_uuid)
    
            # construct the return dictionary
            return_values = {'commandStatus': execution_info.commandStatus}
            if execution_info.HasField('progressInfo'):
                return_values['progressInfo'] = execution_info.progressInfo
            if execution_info.HasField('estimatedRemainingTime'):
                return_values['estimatedRemainingTime'] = execution_info.estimatedRemainingTime
            if execution_info.HasField('updatedLifetimeOfExecution'):
                return_values['updatedLifetimeOfExecution'] = execution_info.updatedLifetimeOfExecution
    
            yield silaFW_pb2.ExecutionInfo(**return_values)
    
            # we add a small delay to give the client a chance to keep up.
            time.sleep(0.5)
        else:
            # one last time yield the status
            yield silaFW_pb2.ExecutionInfo(**return_values)
    
    def GetLog_Result(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Returns the final result of the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLogLevel (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogTimestamp (Current Log Timestamp): The current log timestamp of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogMessage (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
        """
    
        # initialise the return value
        return_value: DeviceServicer_pb2.GetLog_Responses = None
    
        # Get the UUID of the command
        command_uuid = request.value
    
        # TODO:
        #   Add implementation of Real for command GetLog here and write the resulting response
        #   in return_value
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetLog_Responses(
                **default_dict['GetLog_Responses']
            )
    
        return return_value
    
    
    def SetKeyLockMode(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetKeyLockMode_Responses:
        """
        Executes the unobservable command "Set Key Lock Mode"
            Set the lock mode of the keyboard lock.
    
        :param request: gRPC request containing the parameters passed:
            request.KeyLockMode (Key Lock Mode):
            The lock mode of the keyboard lock. 0=free/1=locked.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.KeyLockModeSet (Key Lock Mode Set): Mode of the keyboard lock succeeded to Set.
        """
    
        # initialise the return value
        return_value = None

        command = 'OUT_MODE_00_%s\r\n'%request.KeyLockMode.value
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
        except:
            print("ERROR")
            read = "Error setting keyboard lock mode"

        return_value = DeviceServicer_pb2.SetKeyLockMode_Responses(
            KeyLockModeSet=silaFW_pb2.String(value=read))

        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.SetKeyLockMode_Responses(
                **default_dict['SetKeyLockMode_Responses']
            )
    
        return return_value
    
    
    def GetKeyLockMode(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetKeyLockMode_Responses:
        """
        Executes the unobservable command "Get Key Lock MOde"
            Get mode of the keyboard lock feature. 0=unlocked, 1=locked.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentKeyLockMode (Current Key Lock Mode): Current mode of the keyboard lock feature. 0=unlocked, 1=locked.
        """
    
        # initialise the return value
        return_value = None
    
        command = 'IN_MODE_00\r\n'
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "999.99"
            else:
                pass
        except:
            print("ERROR")
            read = "Error reading keyboard lock mode"

        return_value = DeviceServicer_pb2.GetKeyLockMode_Responses(
            CurrentKeyLockMode=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetKeyLockMode_Responses(
                **default_dict['GetKeyLockMode_Responses']
            )
    
        return return_value
    
    
    def StartThermostat(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.StartThermostat_Responses:
        """
        Executes the unobservable command "Start The Thermostat"
            Starts the thermostat out of stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.Start (Start):
            Boolean that defines wether system is started or not. User input 0 = no start, 1 = start up.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartStatus (Start Status): Start of thermostat succeeded.
        """
    
        # initialise the return value
        return_value = None

        if request.Start.value == "y":
            command = 'START\r\n'
            try:
                self.ser.write(str.encode(command))
                read = str(bytes.decode(self.ser.readline().rstrip()))
            except:
                print("ERROR")
        elif request.Start.value == "n":
            read = "Remaining in standby!"
        else:
            read = "InputError! Use y or n"

        return_value = DeviceServicer_pb2.StartThermostat_Responses(
            StartStatus=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.StartThermostat_Responses(
                **default_dict['StartThermostat_Responses']
            )
    
        return return_value
    
    
    def StopThermostat(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.StopThermostat_Responses:
        """
        Executes the unobservable command "Stop Thermostat"
            Stops the thermostat and puts it into stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.Stop (Stop):
            Boolean that defines wether system is shut down or not.
            User input 0 = no shut-down, 1 = shut-down.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StopStatus (Stop Status): Shut-down of thermostat succeeded.
        """
    
        # initialise the return value
        return_value = None
    
        if request.Start.value == "y":
            command = 'STOP\r\n'
            try:
                self.ser.write(str.encode(command))
                read = str(bytes.decode(self.ser.readline().rstrip()))
            except:
                print("ERROR")
        elif request.Start.value == "n":
            read = "Remaining in operation!"
        else:
            read = "InputError! Use y or n"

        return_value = DeviceServicer_pb2.StopThermostat_Responses(
            StopStatus=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.StopThermostat_Responses(
                **default_dict['StopThermostat_Responses']
            )
    
        return return_value
    
    
    def GetDeviceStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetDeviceStatus_Responses:
        """
        Executes the unobservable command "Get Device Status"
            Get the device status. 0 = status ok/ 1 = malfunction.
    
        :param request: gRPC request containing the parameters passed:
            request.DeviceStatus (Device Status): The device status. 0 = status ok/ 1 = malfunction.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDeviceStatus (Current Device Status): Current device status query. 0 = status ok/ 1 = malfunction.
        """
    
        # initialise the return value
        return_value = None
    
        command = 'STATUS\r\n'
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "Error reading status. NONE"
            else:
                pass
        except:
            print("ERROR")
            read = "Error reading device status"

        return_value = DeviceServicer_pb2.GetDeviceStatus_Responses(
            CurrentDeviceStatus=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetDeviceStatus_Responses(
                **default_dict['GetDeviceStatus_Responses']
            )
    
        return return_value
    
    
    def GetDeviceStatusDiagnosis(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetDeviceStatusDiagnosis_Responses:
        """
        Executes the unobservable command "Get Device Status Diagnosis"
            Get the device status malfunction diagnosis. String of form XXXXXXX; 0=no malfunction,1=malfunction.
            For X1 = Error, X2-X4 = unassigned, X5 = sublevel, X6-X7 = unassigned.
    
        :param request: gRPC request containing the parameters passed:
            request.DeviceStatusDiagnosis (Device Status Diagnosis):
            The device status malfunction diagnosis. String of form XXXXXXX; 0=no malfunction,1=malfunction.
            For X1 = Error, X2-X4 = unassigned, X5 = sublevel, X6-X7 = unassigned.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDeviceStatusDiagnosis (Current Device Status Diagnosis):
            Current device status malfunction diagnosis. String of form XXXXXXX; 0=no malfunction,1=malfunction.
            For X1 = Error, X2-X4 = unassigned, X5 = sublevel, X6-X7 = unassigned.
        """
    
        # initialise the return value
        return_value = None
    
        command = 'STAT\r\n'
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "Error reading status diagnosis. NONE"
            else:
                pass
        except:
            print("ERROR")
            read = "Error reading device status diagnosis"

        return_value = DeviceServicer_pb2.GetDeviceStatusDiagnosis_Responses(
            CurrentDeviceStatusDiagnosis=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetDeviceStatusDiagnosis_Responses(
                **default_dict['GetDeviceStatusDiagnosis_Responses']
            )
    
        return return_value
    
    
    def GetPowerStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPowerStatus_Responses:
        """
        Executes the unobservable command "Get Power Status"
            Get power/standby mode. 0=On, 1=Off/Standby.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPowerStatus (Current Power Status): Current power/standby mode. 0=On, 1=Off/Standby.
        """
    
        # initialise the return value
        return_value = None

        command = 'IN_MODE_02\r\n'
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "Error reading power status. Return NONE"
            else:
                pass
        except:
            print("ERROR")
            read = "Error reading power status. Connection Error"

        return_value = DeviceServicer_pb2.GetPowerStatus_Responses(
            CurrentPowerStatus=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.GetPowerStatus_Responses(
                **default_dict['GetPowerStatus_Responses']
            )
    
        return return_value
    

    def Subscribe_CurrentStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """
        Requests the observable property Current Status
            Get the current status of the device from the internal state machine of the SiLA server.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.CurrentStatus (Current Status): Get the current status of the device from the internal state machine of the SiLA server.
        """
    
        # initialise the return value
        return_value: DeviceServicer_pb2.Subscribe_CurrentStatus_Responses = None
    
        # we could use a timeout here if we wanted
        while True:
            par_dict = {
                'CurrentStatus': silaFW_pb2.String(value=self.status)
            }
            return_value = DeviceServicer_pb2.Subscribe_CurrentStatus_Responses(**par_dict)
            # TODO:
            #   Add implementation of Real for property CurrentStatus here and write the resulting
            #   response in return_value
    
            # create the default value
            if return_value is None:
                return_value = DeviceServicer_pb2.Subscribe_CurrentStatus_Responses(
                    **default_dict['Subscribe_CurrentStatus_Responses']
                )
    
    
            yield return_value
    
    
    def Get_CurrentSoftwareVersion(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_CurrentSoftwareVersion_Responses:
        """
        Requests the unobservable property Current Software Version
            Get thermostat software version. Response is string. 
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.CurrentSoftwareVersion (Current Software Version): Get thermostat software version. Response is string.
        """
    
        # initialise the return value
        return_value: DeviceServicer_pb2.Get_CurrentSoftwareVersion_Responses = None
    
        command = 'VERSION\r\n'
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "Error reading software version! Return none."
            else:
                pass
        except:
            print("ERROR")
            read = "Error reading software version! Connection Error."

        return_value = DeviceServicer_pb2.Get_CurrentSoftwareVersion_Responses(
            CurrentSoftwareVersion=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = DeviceServicer_pb2.Get_CurrentSoftwareVersion_Responses(
                **default_dict['Get_CurrentSoftwareVersion_Responses']
            )
    
        return return_value
