"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Servicer*

:details: DeviceServicer:
    General device settings can be retrieved and changed within this function.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    DeviceServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:01.932122
:date: (last modification) 2020-04-17T12:22:01.932122

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import DeviceServicer_pb2 as DeviceServicer_pb2
from .gRPC import DeviceServicer_pb2_grpc as DeviceServicer_pb2_grpc

# import simulation and real implementation
from .DeviceServicer_simulation import DeviceServicerSimulation
from .DeviceServicer_real import DeviceServicerReal


class DeviceServicer(DeviceServicer_pb2_grpc.DeviceServicerServicer):
    """
    This is a LAUDA L250 Thermostat Service
    """
    implementation: Union[DeviceServicerSimulation, DeviceServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceServicerSimulation())
        else:
            self._inject_implementation(DeviceServicerReal(ser = self.ser))

    def _inject_implementation(self,
                               implementation: Union[DeviceServicerSimulation,
                                                     DeviceServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the LAUDA_ThermostatServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceServicerReal(ser = self.ser))

    def GetLog(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Executes the observable command "Get Log"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A command confirmation object with the following information:
            commandId: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution: The (maximum) lifetime of this command call.
        """
    
        logging.debug(
            "GetLog called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLog_Info(self, request, context: grpc.ServicerContext) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Returns execution information regarding the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: An ExecutionInfo response stream for the command with the following fields:
            commandStatus: Status of the command (enumeration)
            progressInfo: Information on the progress of the command (0 to 1)
            estimatedRemainingTime: Estimate of the remaining time required to run the command
            updatedLifetimeOfExecution: An update on the execution lifetime
        """
    
        logging.debug(
            "GetLog_Info called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog_Info(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLog_Result(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Returns the final result of the command call :meth:`~.GetLog`.
    
        :param request: A request object with the following properties
            CommandExecutionUUID: The UUID of the command executed.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLogLevel (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogTimestamp (Current Log Timestamp): The current log timestamp of the latest logs , retrieved from the SiLA server log file.
            request.CurrentLogMessage (Current Log Level): The current log level of the latest logs , retrieved from the SiLA server log file.
        """
    
        logging.debug(
            "GetLog_Result called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.GetLog_Result(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    
    def SetKeyLockMode(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.SetKeyLockMode_Responses:
        """
        Executes the unobservable command "Set Key Lock Mode"
            Set the lock mode of the keyboard lock.
    
        :param request: gRPC request containing the parameters passed:
            request.KeyLockMode (Key Lock Mode):
            The lock mode of the keyboard lock. 0=free/1=locked.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.KeyLockModeSet (Key Lock Mode Set): Mode of the keyboard lock succeeded to Set.
        """
    
        logging.debug(
            "SetKeyLockMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetKeyLockMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetKeyLockMode(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetKeyLockMode_Responses:
        """
        Executes the unobservable command "Get Key Lock MOde"
            Get mode of the keyboard lock feature. 0=unlocked, 1=locked.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentKeyLockMode (Current Key Lock Mode): Current mode of the keyboard lock feature. 0=unlocked, 1=locked.
        """
    
        logging.debug(
            "GetKeyLockMode called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetKeyLockMode(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def StartThermostat(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.StartThermostat_Responses:
        """
        Executes the unobservable command "Start The Thermostat"
            Starts the thermostat out of stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.Start (Start):
            Boolean that defines wether system is started or not. User input 0 = no start, 1 = start up.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StartStatus (Start Status): Start of thermostat succeeded.
        """
    
        logging.debug(
            "StartThermostat called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StartThermostat(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def StopThermostat(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.StopThermostat_Responses:
        """
        Executes the unobservable command "Stop Thermostat"
            Stops the thermostat and puts it into stand-by mode.
    
        :param request: gRPC request containing the parameters passed:
            request.Stop (Stop):
            Boolean that defines wether system is shut down or not.
            User input 0 = no shut-down, 1 = shut-down.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.StopStatus (Stop Status): Shut-down of thermostat succeeded.
        """
    
        logging.debug(
            "StopThermostat called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.StopThermostat(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDeviceStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetDeviceStatus_Responses:
        """
        Executes the unobservable command "Get Device Status"
            Get the device status. 0 = status ok/ 1 = malfunction.
    
        :param request: gRPC request containing the parameters passed:
            request.DeviceStatus (Device Status): The device status. 0 = status ok/ 1 = malfunction.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDeviceStatus (Current Device Status): Current device status query. 0 = status ok/ 1 = malfunction.
        """
    
        logging.debug(
            "GetDeviceStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDeviceStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetDeviceStatusDiagnosis(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetDeviceStatusDiagnosis_Responses:
        """
        Executes the unobservable command "Get Device Status Diagnosis"
            Get the device status malfunction diagnosis. String of form XXXXXXX; 0=no malfunction,1=malfunction.
            For X1 = Error, X2-X4 = unassigned, X5 = sublevel, X6-X7 = unassigned.
    
        :param request: gRPC request containing the parameters passed:
            request.DeviceStatusDiagnosis (Device Status Diagnosis):
            The device status malfunction diagnosis. String of form XXXXXXX; 0=no malfunction,1=malfunction.
            For X1 = Error, X2-X4 = unassigned, X5 = sublevel, X6-X7 = unassigned.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentDeviceStatusDiagnosis (Current Device Status Diagnosis):
            Current device status malfunction diagnosis. String of form XXXXXXX; 0=no malfunction,1=malfunction.
            For X1 = Error, X2-X4 = unassigned, X5 = sublevel, X6-X7 = unassigned.
        """
    
        logging.debug(
            "GetDeviceStatusDiagnosis called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetDeviceStatusDiagnosis(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetPowerStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.GetPowerStatus_Responses:
        """
        Executes the unobservable command "Get Power Status"
            Get power/standby mode. 0=On, 1=Off/Standby.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPowerStatus (Current Power Status): Current power/standby mode. 0=On, 1=Off/Standby.
        """
    
        logging.debug(
            "GetPowerStatus called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetPowerStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    def Subscribe_CurrentStatus(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """
        Requests the observable property Current Status
            Get the current status of the device from the internal state machine of the SiLA server.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response stream with the following fields:
            request.CurrentStatus (Current Status): Get the current status of the device from the internal state machine of the SiLA server.
        """
    
        logging.debug(
            "Property CurrentStatus requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Subscribe_CurrentStatus(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    
    def Get_CurrentSoftwareVersion(self, request, context: grpc.ServicerContext) \
            -> DeviceServicer_pb2.Get_CurrentSoftwareVersion_Responses:
        """
        Requests the unobservable property Current Software Version
            Get thermostat software version. Response is string. 
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.CurrentSoftwareVersion (Current Software Version): Get thermostat software version. Response is string.
        """
    
        logging.debug(
            "Property CurrentSoftwareVersion requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_CurrentSoftwareVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
