#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*LAUDA_ThermostatService client*

:details: LAUDA_ThermostatService:
    This is a LAUDA L250 Thermostat Service

:file:    LAUDA_ThermostatService_client.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:02.121614
:date: (last modification) 2020-04-17T12:22:02.121614

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from .DeviceServicer.gRPC import DeviceServicer_pb2
from .DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from .DeviceServicer.DeviceServicer_default_arguments import default_dict as DeviceServicer_default_dict
from .ControlParameterServicer.gRPC import ControlParameterServicer_pb2
from .ControlParameterServicer.gRPC import ControlParameterServicer_pb2_grpc
# import default arguments for this feature
from .ControlParameterServicer.ControlParameterServicer_default_arguments import default_dict as ControlParameterServicer_default_dict
from .TemperatureControlServicer.gRPC import TemperatureControlServicer_pb2
from .TemperatureControlServicer.gRPC import TemperatureControlServicer_pb2_grpc
# import default arguments for this feature
from .TemperatureControlServicer.TemperatureControlServicer_default_arguments import default_dict as TemperatureControlServicer_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class LAUDA_ThermostatServiceClient(SiLA2Client):
    """
        This is a LAUDA L250 Thermostat Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "LAUDA_ThermostatServiceClient", description: str = "This is a LAUDA L250 Thermostat Service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
                 cert_file: Optional[str] = None):
        """Class initialiser"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname, server_ip=server_ip, server_port=server_port,
            cert_file=cert_file
        )

        logging.info(
            "Starting SiLA2 service client for service LAUDA_ThermostatService with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.ControlParameterServicer_stub = \
            ControlParameterServicer_pb2_grpc.ControlParameterServicerStub(self.channel)
        self.TemperatureControlServicer_stub = \
            TemperatureControlServicer_pb2_grpc.TemperatureControlServicerStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                logging.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        logging.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            logging.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
            return response
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            logging.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            logging.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            logging.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def DeviceServicer_GetLog(self,
                      parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Info(self,
                           uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Result(self,
                             uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_SetKeyLockMode(self, input) \
            -> DeviceServicer_pb2.SetKeyLockMode_Responses:
        """
        Wrapper to call the unobservable command SetKeyLockMode on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetKeyLockMode:")
        par_dict = {
            'KeyLockMode': silaFW_pb2.String(value=input)
        }
        try:
            parameter = DeviceServicer_pb2.SetKeyLockMode_Parameters(**par_dict)
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.SetKeyLockMode_Parameters(
                    **DeviceServicer_default_dict['SetKeyLockMode_Parameters']
                )
    
            response = self.DeviceServicer_stub.SetKeyLockMode(parameter)
    
            logging.debug('SetKeyLockMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetKeyLockMode(self) \
            -> DeviceServicer_pb2.GetKeyLockMode_Responses:
        """
        Wrapper to call the unobservable command GetKeyLockMode on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetKeyLockMode:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            parameter = None
            if parameter is None:
                parameter = DeviceServicer_pb2.GetKeyLockMode_Parameters(
                    **DeviceServicer_default_dict['GetKeyLockMode_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetKeyLockMode(parameter)
    
            logging.debug('GetKeyLockMode response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_StartThermostat(self, input) \
            -> DeviceServicer_pb2.StartThermostat_Responses:
        """
        Wrapper to call the unobservable command StartThermostat on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StartThermostat:")
        par_dict = {
            'Start': silaFW_pb2.String(value=input)
        }
        try:
            parameter = DeviceServicer_pb2.StartThermostat_Parameters(**par_dict)
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.StartThermostat_Parameters(
                    **DeviceServicer_default_dict['StartThermostat_Parameters']
                )
    
            response = self.DeviceServicer_stub.StartThermostat(parameter)
    
            logging.debug('StartThermostat response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_StopThermostat(self, input) \
            -> DeviceServicer_pb2.StopThermostat_Responses:
        """
        Wrapper to call the unobservable command StopThermostat on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling StopThermostat:")
        par_dict = {
            'Stop': silaFW_pb2.String(value=input)
        }
        try:
            parameter = DeviceServicer_pb2.StopThermostat_Parameters(**par_dict)
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.StopThermostat_Parameters(
                    **DeviceServicer_default_dict['StopThermostat_Parameters']
                )
    
            response = self.DeviceServicer_stub.StopThermostat(parameter)
    
            logging.debug('StopThermostat response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetDeviceStatus(self) \
            -> DeviceServicer_pb2.GetDeviceStatus_Responses:
        """
        Wrapper to call the unobservable command GetDeviceStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDeviceStatus:")
        try:
            parameter = None
            if parameter is None:
                parameter = DeviceServicer_pb2.GetDeviceStatus_Parameters(
                    **DeviceServicer_default_dict['GetDeviceStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetDeviceStatus(parameter)
    
            logging.debug('GetDeviceStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetDeviceStatusDiagnosis(self) \
            -> DeviceServicer_pb2.GetDeviceStatusDiagnosis_Responses:
        """
        Wrapper to call the unobservable command GetDeviceStatusDiagnosis on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetDeviceStatusDiagnosis:")
        try:
            parameter = None
            if parameter is None:
                parameter = DeviceServicer_pb2.GetDeviceStatusDiagnosis_Parameters(
                    **DeviceServicer_default_dict['GetDeviceStatusDiagnosis_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetDeviceStatusDiagnosis(parameter)
    
            logging.debug('GetDeviceStatusDiagnosis response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetPowerStatus(self) \
            -> DeviceServicer_pb2.GetPowerStatus_Responses:
        """
        Wrapper to call the unobservable command GetPowerStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetPowerStatus:")
        try:
            parameter = None
            if parameter is None:
                parameter = DeviceServicer_pb2.GetPowerStatus_Parameters(
                    **DeviceServicer_default_dict['GetPowerStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetPowerStatus(parameter)
    
            logging.debug('GetPowerStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_SetControlParamXp(self, input) \
            -> ControlParameterServicer_pb2.SetControlParamXp_Responses:
        """
        Wrapper to call the unobservable command SetControlParamXp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControlParamXp:")
        par_dict = {
            'ControlParamXp': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = ControlParameterServicer_pb2.SetControlParamXp_Parameters(**par_dict)
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = ControlParameterServicer_pb2.SetControlParamXp_Parameters(
                    **ControlParameterServicer_default_dict['SetControlParamXp_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.SetControlParamXp(parameter)
    
            logging.debug('SetControlParamXp response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_SetControlParamTn(self, input) \
            -> ControlParameterServicer_pb2.SetControlParamTn_Responses:
        """
        Wrapper to call the unobservable command SetControlParamTn on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControlParamTn:")
        par_dict = {
            'ControlParamTn': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = ControlParameterServicer_pb2.SetControlParamTn_Parameters(**par_dict)
            if parameter is None:
                parameter = ControlParameterServicer_pb2.SetControlParamTn_Parameters(
                    **ControlParameterServicer_default_dict['SetControlParamTn_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.SetControlParamTn(parameter)
    
            logging.debug('SetControlParamTn response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_SetControlParamTv(self, input) \
            -> ControlParameterServicer_pb2.SetControlParamTv_Responses:
        """
        Wrapper to call the unobservable command SetControlParamTv on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControlParamTv:")
        par_dict = {
            'ControlParamTv': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = ControlParameterServicer_pb2.SetControlParamTv_Parameters(**par_dict)
            if parameter is None:
                parameter = ControlParameterServicer_pb2.SetControlParamTv_Parameters(
                    **ControlParameterServicer_default_dict['SetControlParamTv_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.SetControlParamTv(parameter)
    
            logging.debug('SetControlParamTv response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_SetControlParamTd(self, input) \
            -> ControlParameterServicer_pb2.SetControlParamTd_Responses:
        """
        Wrapper to call the unobservable command SetControlParamTd on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetControlParamTd:")
        par_dict = {
            'ControlParamTd': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = ControlParameterServicer_pb2.SetControlParamTd_Parameters(**par_dict)
            if parameter is None:
                parameter = ControlParameterServicer_pb2.SetControlParamTd_Parameters(
                    **ControlParameterServicer_default_dict['SetControlParamTd_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.SetControlParamTd(parameter)
    
            logging.debug('SetControlParamTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_GetControlParamXp(self) \
            -> ControlParameterServicer_pb2.GetControlParamXp_Responses:
        """
        Wrapper to call the unobservable command GetControlParamXp on the server.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControlParamXp:")
        try:
            parameter = None
            if parameter is None:
                parameter = ControlParameterServicer_pb2.GetControlParamXp_Parameters(
                    **ControlParameterServicer_default_dict['GetControlParamXp_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.GetControlParamXp(parameter)
    
            logging.debug('GetControlParamXp response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_GetControlParamTn(self) \
            -> ControlParameterServicer_pb2.GetControlParamTn_Responses:
        """
        Wrapper to call the unobservable command GetControlParamTn on the server.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControlParamTn:")
        try:
            parameter = None
            if parameter is None:
                parameter = ControlParameterServicer_pb2.GetControlParamTn_Parameters(
                    **ControlParameterServicer_default_dict['GetControlParamTn_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.GetControlParamTn(parameter)
    
            logging.debug('GetControlParamTn response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_GetControlParamTv(self) \
            -> ControlParameterServicer_pb2.GetControlParamTv_Responses:
        """
        Wrapper to call the unobservable command GetControlParamTv on the server.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControlParamTv:")
        try:
            parameter = None
            if parameter is None:
                parameter = ControlParameterServicer_pb2.GetControlParamTv_Parameters(
                    **ControlParameterServicer_default_dict['GetControlParamTv_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.GetControlParamTv(parameter)
    
            logging.debug('GetControlParamTv response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def ControlParameterServicer_GetControlParamTd(self) \
            -> ControlParameterServicer_pb2.GetControlParamTd_Responses:
        """
        Wrapper to call the unobservable command GetControlParamTd on the server.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetControlParamTd:")
        try:
            parameter = None
            if parameter is None:
                parameter = ControlParameterServicer_pb2.GetControlParamTd_Parameters(
                    **ControlParameterServicer_default_dict['GetControlParamTd_Parameters']
                )
    
            response = self.ControlParameterServicer_stub.GetControlParamTd(parameter)
    
            logging.debug('GetControlParamTd response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_SetPointTemperature(self, input) \
            -> TemperatureControlServicer_pb2.SetPointTemperature_Responses:
        """
        Wrapper to call the unobservable command SetPointTemperature on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetPointTemperature:")
        par_dict = {
            'SetTemperature': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = TemperatureControlServicer_pb2.SetPointTemperature_Parameters(**par_dict)
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.SetPointTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['SetPointTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.SetPointTemperature(parameter)
    
            logging.debug('SetPointTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_SetUpperLimTemperature(self, input) \
            -> TemperatureControlServicer_pb2.SetUpperLimTemperature_Responses:
        """
        Wrapper to call the unobservable command SetUpperLimTemperature on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetUpperLimTemperature:")
        par_dict = {
            'UpperLimTemperature': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = TemperatureControlServicer_pb2.SetUpperLimTemperature_Parameters(**par_dict)
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.SetUpperLimTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['SetUpperLimTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.SetUpperLimTemperature(parameter)
    
            logging.debug('SetUpperLimTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_SetLowerLimTemperature(self, input) \
            -> TemperatureControlServicer_pb2.SetLowerLimTemperature_Responses:
        """
        Wrapper to call the unobservable command SetLowerLimTemperature on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling SetLowerLimTemperature:")
        par_dict = {
            'LowerLimTemperature': silaFW_pb2.Real(value=input)
        }
        try:
            parameter = TemperatureControlServicer_pb2.SetLowerLimTemperature_Parameters(**par_dict)
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.SetLowerLimTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['SetLowerLimTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.SetLowerLimTemperature(parameter)
    
            logging.debug('SetLowerLimTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_GetFeedLineTemperature(self) \
            -> TemperatureControlServicer_pb2.GetFeedLineTemperature_Responses:
        """
        Wrapper to call the unobservable command GetFeedLineTemperature on the server.
    
        :param input: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetFeedLineTemperature:")

        try:
            parameter = None
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.GetFeedLineTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['GetFeedLineTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.GetFeedLineTemperature(parameter)
    
            logging.debug('GetFeedLineTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_GetSetpointTemperature(self) \
            -> TemperatureControlServicer_pb2.GetSetpointTemperature_Responses:
        """
        Wrapper to call the unobservable command GetSetpointTemperature on the server.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetSetpointTemperature:")
        try:
            parameter = None
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.GetSetpointTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['GetSetpointTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.GetSetpointTemperature(parameter)
    
            logging.debug('GetSetpointTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_GetUpperLimTemperature(self) \
            -> TemperatureControlServicer_pb2.GetUpperLimTemperature_Responses:
        """
        Wrapper to call the unobservable command GetUpperLimTemperature on the server.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetUpperLimTemperature:")
        try:
            parameter = None
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.GetUpperLimTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['GetUpperLimTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.GetUpperLimTemperature(parameter)
    
            logging.debug('GetUpperLimTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def TemperatureControlServicer_GetLowerLimTemperature(self) \
            -> TemperatureControlServicer_pb2.GetLowerLimTemperature_Responses:
        """
        Wrapper to call the unobservable command GetLowerLimTemperature on the server.

        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLowerLimTemperature:")
        try:
            parameter = None
            if parameter is None:
                parameter = TemperatureControlServicer_pb2.GetLowerLimTemperature_Parameters(
                    **TemperatureControlServicer_default_dict['GetLowerLimTemperature_Parameters']
                )
    
            response = self.TemperatureControlServicer_stub.GetLowerLimTemperature(parameter)
    
            logging.debug('GetLowerLimTemperature response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Subscribe_DeviceServicer_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceServicer_stub.Subscribe_CurrentStatus(
                DeviceServicer_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_DeviceServicer_CurrentSoftwareVersion(self) \
            -> DeviceServicer_pb2.Get_CurrentSoftwareVersion_Responses:
        """Wrapper to get property CurrentSoftwareVersion from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property CurrentSoftwareVersion:")
        try:
            response = self.DeviceServicer_stub.Get_CurrentSoftwareVersion(
                DeviceServicer_pb2.Get_CurrentSoftwareVersion_Parameters()
            )
            logging.debug(
                'Get_CurrentSoftwareVersion response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: LAUDA_ThermostatService")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = LAUDA_ThermostatServiceClient(server_ip='127.0.0.1', server_port=50001)
    sila_client.run()

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
