#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*LAUDA_ThermostatService*

:details: LAUDA_ThermostatService:
    This is a LAUDA L250 Thermostat Service
           
:file:    LAUDA_ThermostatService_server.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:02.091694
:date: (last modification) 2020-04-17T12:22:02.091694

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

import os
import sys
import logging
import argparse

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.LAUDA.LAUDA_ThermostatService.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
from sila2lib_implementations.LAUDA.LAUDA_ThermostatService.ControlParameterServicer.gRPC import ControlParameterServicer_pb2_grpc
from sila2lib_implementations.LAUDA.LAUDA_ThermostatService.TemperatureControlServicer.gRPC import TemperatureControlServicer_pb2_grpc

# Import the servicer modules for each feature
from sila2lib_implementations.LAUDA.LAUDA_ThermostatService.DeviceServicer.DeviceServicer_servicer import DeviceServicer
from sila2lib_implementations.LAUDA.LAUDA_ThermostatService.ControlParameterServicer.ControlParameterServicer_servicer import ControlParameterServicer
from sila2lib_implementations.LAUDA.LAUDA_ThermostatService.TemperatureControlServicer.TemperatureControlServicer_servicer import TemperatureControlServicer

# import custom implementation libraries
import serial
import serial.tools.list_ports


class LAUDA_ThermostatServiceServer(SiLA2Server):
    """
    This is a LAUDA L250 Thermostat Service
    """

    def __init__(self, cmd_args, ip: str = '127.0.0.1', port: int = 50001, simulation_mode: bool = True):
        """Class initializer"""
        super().__init__(
            name=cmd_args.server_name, description=cmd_args.description,
            server_type=cmd_args.server_type, server_uuid=None,
            version=__version__,
            vendor_url="",
            ip=ip, port=port,
            key_file=cmd_args.encryption_key, cert_file=cmd_args.encryption_cert
        )

        logging.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=cmd_args.server_name
            )
        )

        if not simulation_mode:
            # Opening a serial port for data communication
            # Not available on BeagleBone/Debian
            ports = list(serial.tools.list_ports.comports(include_links=True))
            try:
                print("Using serial port: %s" % ports[0])
                self.ser = serial.Serial(port=ports[0][0], baudrate=9600, parity=serial.PARITY_NONE,
                                         stopbits=serial.STOPBITS_ONE,bytesize=8, timeout=1, xonxoff=0)
            except:
                logging.error('No serial cable attached or recognized')
        else:
            self.ser = []
        # On Debian use the following and specify the Comport name!
        # ser = serial.Serial(port="/dev/ttyS0", baudrate = 9600,parity=serial.PARITY_NONE, stopbits=serial.STOPBITS_ONE,bytesize=8,timeout=1, xonxoff=0)

        self.simulation_mode = simulation_mode

        # registering features
        #  Register DeviceServicer
        self.DeviceServicer_servicer = DeviceServicer(ser=self.ser, simulation_mode=self.simulation_mode)
        DeviceServicer_pb2_grpc.add_DeviceServicerServicer_to_server(
            self.DeviceServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceServicer',
                         servicer=self.DeviceServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register ControlParameterServicer
        self.ControlParameterServicer_servicer = ControlParameterServicer(ser=self.ser, simulation_mode=self.simulation_mode)
        ControlParameterServicer_pb2_grpc.add_ControlParameterServicerServicer_to_server(
            self.ControlParameterServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='ControlParameterServicer',
                         servicer=self.ControlParameterServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register TemperatureControlServicer
        self.TemperatureControlServicer_servicer = TemperatureControlServicer(ser=self.ser, simulation_mode=self.simulation_mode)
        TemperatureControlServicer_pb2_grpc.add_TemperatureControlServicerServicer_to_server(
            self.TemperatureControlServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='TemperatureControlServicer',
                         servicer=self.TemperatureControlServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )

        # starting and running the gRPC/SiLA2 server
        self.run()


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: LAUDA_ThermostatService")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="LAUDA_ThermostatService", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a LAUDA L250 Thermostat Service", help='SiLA server description')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args
    
def init():
    if __name__ == '__main__':
        # or use logging.ERROR for less output
        logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

        args = parse_command_line()

        # generate SiLA2Server
        sila_server = LAUDA_ThermostatServiceServer(cmd_args=args, ip='127.0.0.1', port=50001, simulation_mode=True)
        sys.exit(sila_server.run())

init()
