"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Temperature Control Servicer*

:details: TemperatureControlServicer:
    Set and retrieve information regarding the temperature setpoints and current temperature readings of the LAUDA LOOP
    250 thermostat. Setpoint thresholds may be defined within the range of the upper and lower temperature limits THi
    and TLo.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    TemperatureControlServicer_real.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:02.065796
:date: (last modification) 2020-04-17T12:22:02.065796

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import TemperatureControlServicer_pb2 as TemperatureControlServicer_pb2
# from .gRPC import TemperatureControlServicer_pb2_grpc as TemperatureControlServicer_pb2_grpc

# import default arguments
from .TemperatureControlServicer_default_arguments import default_dict


# noinspection PyPep8Naming,PyUnusedLocal
class TemperatureControlServicerReal:
    """
    Implementation of the *Temperature Control Servicer* in *Real* mode
        This is a LAUDA L250 Thermostat Service
    """

    def __init__(self, ser):
        """Class initialiser"""
        self.ser = ser
        logging.debug('Started server in mode: {mode}'.format(mode='Real'))

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def SetPointTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.SetPointTemperature_Responses:
        """
        Executes the unobservable command "Set Temperature value"
            Set the desired temperature of the thermostat
    
        :param request: gRPC request containing the parameters passed:
            request.SetTemperature (Set Temperature):
            The target temperature that the thermostat will try to reach. Depending on the control mechanism
            and the selected correcting values, the temperature might oscillate around or not reach the set
            temperature at all. More on the control mechanism can be found in the user manual, p29.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetTemperatureSet (Set Temperature Set): Set Temperature succeeded to Set.
        """
    
        # initialise the return value
        return_value = None

        command = 'OUT_SP_00_%s\r\n'%request.SetTemperature.value
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
        except:
            print("ERROR")
            read = "Error setting temperature setpoint"

        return_value = TemperatureControlServicer_pb2.SetPointTemperature_Responses(
            SetTemperatureSet=silaFW_pb2.String(value=read))

        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.SetPointTemperature_Responses(
                **default_dict['SetPointTemperature_Responses']
            )
    
        return return_value
    
    
    def SetUpperLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.SetUpperLimTemperature_Responses:
        """
        Executes the unobservable command "Set Upper Lim Temperature Value"
            Set the upper limit of the feed line temperature of the thermostat, Tih.
            The temperature limits restrict the input range of the temperature setpoint, Tset.
    
        :param request: gRPC request containing the parameters passed:
            request.UpperLimTemperature (Upper Lim Temperature):
            Value of the upper limit of the feed line temperature, Tih, for the thermostat.
            Tih restricts the maximum of the input range of the temperature setpoint, Tset.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.UpperLimTemperatureSet (Upper Lim Temperature Set): Upper limit temperature succeeded to Set.
        """
    
        # initialise the return value
        return_value = None

        command = 'OUT_SP_04_%s\r\n' % request.UpperLimTemperature.value
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
        except:
            print("ERROR")
            read = "Error setting upper temperature limit"

        return_value = TemperatureControlServicer_pb2.SetUpperLimTemperature_Responses(
            UpperLimTemperatureSet=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.SetUpperLimTemperature_Responses(
                **default_dict['SetUpperLimTemperature_Responses']
            )
    
        return return_value
    
    
    def SetLowerLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.SetLowerLimTemperature_Responses:
        """
        Executes the unobservable command "Set Lower Lim Temperature Value"
            Set the lower limit of the feed line temperature of the thermostat, Til.
            The temperature limits restrict the input range of the temperature setpoint, Tset.
    
        :param request: gRPC request containing the parameters passed:
            request.LowerLimTemperature (Lower Lim Temperature):
            Set the lower limit of the feed line temperature, Til, for the thermostat.
            Til restricts the maximum of the input range of the temperature setpoint, Tset.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LowerLimTemperatureSet (Lower Lim Temperature Set): Lower limit temperature succeeded to Set (Bool).
        """
    
        # initialise the return value
        return_value = None
    
        command = 'OUT_SP_05_%s\r\n' % request.LowerLimTemperature.value
        try:
            self.ser.write(str.encode(command))
            read = str(bytes.decode(self.ser.readline().rstrip()))
        except:
            print("ERROR")
            read = "Error setting lower temperature limit"

        return_value = TemperatureControlServicer_pb2.SetLowerLimTemperature_Responses(
            LowerLimTemperatureSet=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.SetLowerLimTemperature_Responses(
                **default_dict['SetLowerLimTemperature_Responses']
            )
    
        return return_value
    
    
    def GetFeedLineTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetFeedLineTemperature_Responses:
        """
        Executes the unobservable command "Get Feed Line Temperature"
            Get Feed Line Temperature of the Thermostat.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFeedLineTemperature (Current Feed Line Temperature): Current Feed Line Temperature of the Thermostat.
        """
    
        # initialise the return value
        return_value = None

        command = 'IN_PV_00\r\n'
        try:
            self.ser.write(str.encode(command))
            read = float(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "999.99"
            else:
                read = str(read)
        except:
            print("ERROR")
            read = "Error getting feed line temperature"

        return_value = TemperatureControlServicer_pb2.GetFeedLineTemperature_Responses(
            CurrentFeedLineTemperature=silaFW_pb2.String(value=read))

        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.GetFeedLineTemperature_Responses(
                **default_dict['GetFeedLineTemperature_Responses']
            )
    
        return return_value
    
    
    def GetSetpointTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetSetpointTemperature_Responses:
        """
        Executes the unobservable command "Get Setpoint Temperature value"
            Get the desired setpoint temperature of the thermostat
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTemperatureSetpoint (Current Temperature Setpoint): Current Temperature setpoint of the thermostat is retrieved.
        """
    
        # initialise the return value
        return_value = None
    
        command = 'IN_SP_00\r\n'
        try:
            self.ser.write(str.encode(command))
            read = float(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "999.99"
            else:
                read = str(read)
        except:
            print("ERROR")
            read = "Error getting current setpoint temperature"

        return_value = TemperatureControlServicer_pb2.GetSetpointTemperature_Responses(
            CurrentTemperatureSetpoint=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.GetSetpointTemperature_Responses(
                **default_dict['GetSetpointTemperature_Responses']
            )
    
        return return_value
    
    
    def GetUpperLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetUpperLimTemperature_Responses:
        """
        Executes the unobservable command "Get Upper Lim Temperature"
            Get upper limit temperature.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentUpperLimTemperature (Current Upper Lim Temperature): Current upper limit temperature.
        """
    
        # initialise the return value
        return_value = None
    
        command = 'IN_SP_04\r\n'
        try:
            self.ser.write(str.encode(command))
            read = float(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "999.99"
            else:
                read = str(read)
        except:
            print("ERROR")
            read = "Error getting upper lim temperature"

        return_value = TemperatureControlServicer_pb2.GetUpperLimTemperature_Responses(
            CurrentUpperLimTemperature=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.GetUpperLimTemperature_Responses(
                **default_dict['GetUpperLimTemperature_Responses']
            )
    
        return return_value
    
    
    def GetLowerLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetLowerLimTemperature_Responses:
        """
        Executes the unobservable command "Get Lower Lim Temperature"
            Get lower limit temperature.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLowerLimTemperature (Current Lower Lim Temperature): Current lower limit temperature.
        """
    
        # initialise the return value
        return_value = None

        command = 'IN_SP_05\r\n'
        try:
            self.ser.write(str.encode(command))
            read = float(bytes.decode(self.ser.readline().rstrip()))
            if read == None:
                read = "999.99"
            else:
                read = str(read)
        except:
            print("ERROR")
            read = "Error getting lower lim temperature"

        return_value = TemperatureControlServicer_pb2.GetLowerLimTemperature_Responses(
            CurrentLowerLimTemperature=silaFW_pb2.String(value=read))
    
        # fallback to default
        if return_value is None:
            return_value = TemperatureControlServicer_pb2.GetLowerLimTemperature_Responses(
                **default_dict['GetLowerLimTemperature_Responses']
            )
    
        return return_value
    

    
