"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Temperature Control Servicer*

:details: TemperatureControlServicer:
    Set and retrieve information regarding the temperature setpoints and current temperature readings of the LAUDA LOOP
    250 thermostat. Setpoint thresholds may be defined within the range of the upper and lower temperature limits THi
    and TLo.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    TemperatureControlServicer_servicer.py
:authors: Lukas Bromig

:date: (creation)          2020-04-17T12:22:02.040830
:date: (last modification) 2020-04-17T12:22:02.040830

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import TemperatureControlServicer_pb2 as TemperatureControlServicer_pb2
from .gRPC import TemperatureControlServicer_pb2_grpc as TemperatureControlServicer_pb2_grpc

# import simulation and real implementation
from .TemperatureControlServicer_simulation import TemperatureControlServicerSimulation
from .TemperatureControlServicer_real import TemperatureControlServicerReal


class TemperatureControlServicer(TemperatureControlServicer_pb2_grpc.TemperatureControlServicerServicer):
    """
    This is a LAUDA L250 Thermostat Service
    """
    implementation: Union[TemperatureControlServicerSimulation, TemperatureControlServicerReal]
    simulation_mode: bool

    def __init__(self, ser, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        """
        self.ser = ser
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(TemperatureControlServicerSimulation())
        else:
            self._inject_implementation(TemperatureControlServicerReal(ser = self.ser))

    def _inject_implementation(self,
                               implementation: Union[TemperatureControlServicerSimulation,
                                                     TemperatureControlServicerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the LAUDA_ThermostatServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(TemperatureControlServicerSimulation())

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(TemperatureControlServicerReal(ser = self.ser))

    def SetPointTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.SetPointTemperature_Responses:
        """
        Executes the unobservable command "Set Temperature value"
            Set the desired temperature of the thermostat
    
        :param request: gRPC request containing the parameters passed:
            request.SetTemperature (Set Temperature):
            The target temperature that the thermostat will try to reach. Depending on the control mechanism
            and the selected correcting values, the temperature might oscillate around or not reach the set
            temperature at all. More on the control mechanism can be found in the user manual, p29.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SetTemperatureSet (Set Temperature Set): Set Temperature succeeded to Set.
        """
    
        logging.debug(
            "SetPointTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetPointTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetUpperLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.SetUpperLimTemperature_Responses:
        """
        Executes the unobservable command "Set Upper Lim Temperature Value"
            Set the upper limit of the feed line temperature of the thermostat, Tih.
            The temperature limits restrict the input range of the temperature setpoint, Tset.
    
        :param request: gRPC request containing the parameters passed:
            request.UpperLimTemperature (Upper Lim Temperature):
            Value of the upper limit of the feed line temperature, Tih, for the thermostat.
            Tih restricts the maximum of the input range of the temperature setpoint, Tset.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.UpperLimTemperatureSet (Upper Lim Temperature Set): Upper limit temperature succeeded to Set.
        """
    
        logging.debug(
            "SetUpperLimTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetUpperLimTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def SetLowerLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.SetLowerLimTemperature_Responses:
        """
        Executes the unobservable command "Set Lower Lim Temperature Value"
            Set the lower limit of the feed line temperature of the thermostat, Til.
            The temperature limits restrict the input range of the temperature setpoint, Tset.
    
        :param request: gRPC request containing the parameters passed:
            request.LowerLimTemperature (Lower Lim Temperature):
            Set the lower limit of the feed line temperature, Til, for the thermostat.
            Til restricts the maximum of the input range of the temperature setpoint, Tset.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.LowerLimTemperatureSet (Lower Lim Temperature Set): Lower limit temperature succeeded to Set (Bool).
        """
    
        logging.debug(
            "SetLowerLimTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.SetLowerLimTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetFeedLineTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetFeedLineTemperature_Responses:
        """
        Executes the unobservable command "Get Feed Line Temperature"
            Get Feed Line Temperature of the Thermostat.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentFeedLineTemperature (Current Feed Line Temperature): Current Feed Line Temperature of the Thermostat.
        """
    
        logging.debug(
            "GetFeedLineTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetFeedLineTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetSetpointTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetSetpointTemperature_Responses:
        """
        Executes the unobservable command "Get Setpoint Temperature value"
            Get the desired setpoint temperature of the thermostat
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentTemperatureSetpoint (Current Temperature Setpoint): Current Temperature setpoint of the thermostat is retrieved.
        """
    
        logging.debug(
            "GetSetpointTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetSetpointTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetUpperLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetUpperLimTemperature_Responses:
        """
        Executes the unobservable command "Get Upper Lim Temperature"
            Get upper limit temperature.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentUpperLimTemperature (Current Upper Lim Temperature): Current upper limit temperature.
        """
    
        logging.debug(
            "GetUpperLimTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetUpperLimTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def GetLowerLimTemperature(self, request, context: grpc.ServicerContext) \
            -> TemperatureControlServicer_pb2.GetLowerLimTemperature_Responses:
        """
        Executes the unobservable command "Get Lower Lim Temperature"
            Get lower limit temperature.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentLowerLimTemperature (Current Lower Lim Temperature): Current lower limit temperature.
        """
    
        logging.debug(
            "GetLowerLimTemperature called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        try:
            return self.implementation.GetLowerLimTemperature(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
