#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*MT_Viper_SW_Balance_Service client*

:details: MT_Viper_SW_Balance_Service:
    This is a Mettler Toledo Viper SW balance service

:file:    DeviceInformationProvider_client.py
:authors: Lukas Bromig

:date: (creation)          2021-04-09T13:29:06.793239
:date: (last modification) 2021-04-09T13:29:06.793239

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time
import datetime

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.error_handling import client_err

# import default arguments for this feature
from sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DeviceInformationProvider.gRPC import DeviceInformationProvider_pb2
from sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DeviceInformationProvider.gRPC import DeviceInformationProvider_pb2_grpc


# noinspection PyPep8Naming, PyUnusedLocal
class DeviceInformationProviderClient:
    """
        This is a Mettler Toledo Viper SW balance service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 channel = None):
        """Class initialiser"""

        # Create stub objects used to communicate with the server
        self.DeviceInformationProvider_stub = \
            DeviceInformationProvider_pb2_grpc.DeviceInformationProviderStub(channel)
        

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Reset(self,
                Confirmation: str = 'default string'
                     ): # -> (DeviceInformationProvider):
        """
        Wrapper to call the unobservable command Reset on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling Reset:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceInformationProvider_pb2.Reset_Parameters(
                                    Confirmation=silaFW_pb2.String(value=Confirmation)
                )
    
            response = self.DeviceInformationProvider_stub.Reset(parameter, metadata)
            logging.debug(f"Reset response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_ImplementedCommands(self) \
            -> DeviceInformationProvider_pb2.Get_ImplementedCommands_Responses:
        """Wrapper to get property ImplementedCommands from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property ImplementedCommands:")
        try:
            response = self.DeviceInformationProvider_stub.Get_ImplementedCommands(
                DeviceInformationProvider_pb2.Get_ImplementedCommands_Parameters()
            )
            logging.debug(
                'Get_ImplementedCommands response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_DeviceType(self) \
            -> DeviceInformationProvider_pb2.Get_DeviceType_Responses:
        """Wrapper to get property DeviceType from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property DeviceType:")
        try:
            response = self.DeviceInformationProvider_stub.Get_DeviceType(
                DeviceInformationProvider_pb2.Get_DeviceType_Parameters()
            )
            logging.debug(
                'Get_DeviceType response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_WeighingCapacity(self) \
            -> DeviceInformationProvider_pb2.Get_WeighingCapacity_Responses:
        """Wrapper to get property WeighingCapacity from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property WeighingCapacity:")
        try:
            response = self.DeviceInformationProvider_stub.Get_WeighingCapacity(
                DeviceInformationProvider_pb2.Get_WeighingCapacity_Parameters()
            )
            logging.debug(
                'Get_WeighingCapacity response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_FirmwareVersion(self) \
            -> DeviceInformationProvider_pb2.Get_FirmwareVersion_Responses:
        """Wrapper to get property FirmwareVersion from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property FirmwareVersion:")
        try:
            response = self.DeviceInformationProvider_stub.Get_FirmwareVersion(
                DeviceInformationProvider_pb2.Get_FirmwareVersion_Parameters()
            )
            logging.debug(
                'Get_FirmwareVersion response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_TypeDefinitionNumber(self) \
            -> DeviceInformationProvider_pb2.Get_TypeDefinitionNumber_Responses:
        """Wrapper to get property TypeDefinitionNumber from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property TypeDefinitionNumber:")
        try:
            response = self.DeviceInformationProvider_stub.Get_TypeDefinitionNumber(
                DeviceInformationProvider_pb2.Get_TypeDefinitionNumber_Parameters()
            )
            logging.debug(
                'Get_TypeDefinitionNumber response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_SerialNumber(self) \
            -> DeviceInformationProvider_pb2.Get_SerialNumber_Responses:
        """Wrapper to get property SerialNumber from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property SerialNumber:")
        try:
            response = self.DeviceInformationProvider_stub.Get_SerialNumber(
                DeviceInformationProvider_pb2.Get_SerialNumber_Parameters()
            )
            logging.debug(
                'Get_SerialNumber response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        logging.error(grpc_error.error_type)
        if hasattr(grpc_error.message, "parameter"):
            logging.error(grpc_error.message.parameter)
        logging.error(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'InternalError' :
            raise InternalErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'LogicalError' :
            raise LogicalErrorError(grpc_error.message.message)
        

class InternalErrorError(Exception):
    """Internal Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"InternalErrorError: {self.message}"
        else:
            return f"InternalErrorError."


class LogicalErrorError(Exception):
    """Logical Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"LogicalErrorError: {self.message}"
        else:
            return f"LogicalErrorError."


