"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Information Provider_defined_errors*

:details: DeviceInformationProvider Defined SiLA Error factories:
    General device information regarding firmware and hardware can be retrieved and changed within this feature.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 07.04.2021

:file:    DeviceInformationProvider_defined_errors.py
:authors: Lukas Bromig

:date: (creation)          2021-04-09T13:29:06.791200
:date: (last modification) 2021-04-09T13:29:06.791200

.. note:: Code generated by sila2codegenerator 0.3.6

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
from sila2lib.error_handling.server_err import SiLAExecutionError

# SiLA Defined Error factories

def generate_def_error_InternalError(extra_message: str = "") \
        -> SiLAExecutionError:
    """
    Generates a defined SiLAExcecutionError with id "InternalError"

    :param extra_message: extra message, that can be added to the default message
    :returns: SiLAExecutionError
    """

    msg = f"""Internal error. The balance is not ready yet! \n{extra_message}"""
    return SiLAExecutionError(error_identifier="InternalError",
                         msg=msg)

def generate_def_error_LogicalError(extra_message: str = "") \
        -> SiLAExecutionError:
    """
    Generates a defined SiLAExcecutionError with id "LogicalError"

    :param extra_message: extra message, that can be added to the default message
    :returns: SiLAExecutionError
    """

    msg = f"""Logical error. The parameter is not allowed! \n{extra_message}"""
    return SiLAExecutionError(error_identifier="LogicalError",
                         msg=msg)

