"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Device Information Provider*

:details: DeviceInformationProvider:
    General device information regarding firmware and hardware can be retrieved and changed within this feature.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 07.04.2021
           
:file:    DeviceInformationProvider_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-04-09T13:29:06.762572
:date: (last modification) 2021-04-09T13:29:06.762572

.. note:: Code generated by sila2codegenerator 0.3.6

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError, SiLAValidationError

# import gRPC modules for this feature
from .gRPC import DeviceInformationProvider_pb2 as DeviceInformationProvider_pb2
from .gRPC import DeviceInformationProvider_pb2_grpc as DeviceInformationProvider_pb2_grpc

# import simulation and real implementation
from .DeviceInformationProvider_simulation import DeviceInformationProviderSimulation
from .DeviceInformationProvider_real import DeviceInformationProviderReal

# import SiLA Defined Error factories
from .DeviceInformationProvider_defined_errors import generate_def_error_InternalError, generate_def_error_LogicalError

class DeviceInformationProvider(DeviceInformationProvider_pb2_grpc.DeviceInformationProviderServicer):
    """
    This is a Mettler Toledo Viper SW balance service
    """
    implementation: Union[DeviceInformationProviderSimulation, DeviceInformationProviderReal]
    simulation_mode: bool

    def __init__(self, simulation_mode: bool = True, hardware_interface=None):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        :param hardware_interface (optional): access to shared hardware interface, like serial interface. 
        """

        self.hardware_interface = hardware_interface

        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DeviceInformationProviderSimulation(hardware_interface=self.hardware_interface))
        else:
            self._inject_implementation(DeviceInformationProviderReal(hardware_interface=self.hardware_interface))

    def _inject_implementation(self,
                               implementation: Union[DeviceInformationProviderSimulation,
                                                     DeviceInformationProviderReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the MT_Viper_SW_Balance_ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DeviceInformationProviderSimulation(hardware_interface=self.hardware_interface))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DeviceInformationProviderReal(hardware_interface=self.hardware_interface))

    def Reset(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Reset_Responses:
        """
        Executes the unobservable command "Reset"
            Get the current status of the device from the state machine of the SiLA server.
    
        :param request: gRPC request containing the parameters passed:
            request.Confirmation (Confirmation): Confirm the reset command with Y.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.SerialNumber (Serial Number): The serial number is emitted; the weigh module/balance is ready for operation.
        """
    
        logging.debug(
            "Reset called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            return self.implementation.Reset(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    def Get_ImplementedCommands(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Get_ImplementedCommands_Responses:
        """
        Requests the unobservable property Implemented Commands
            Lists all commands implemented in the present software version. All commands (MT-SICS) ordered according to level in alphabetical order.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.ImplementedCommands (Implemented Commands): Lists all commands implemented in the present software version. All commands (MT-SICS) ordered according to level in alphabetical order.
        """
    
        logging.debug(
            "Property ImplementedCommands requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_ImplementedCommands(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_DeviceType(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Get_DeviceType_Responses:
        """
        Requests the unobservable property Device Type
            Query device type.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.DeviceType (Device Type): Query device type.
        """
    
        logging.debug(
            "Property DeviceType requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_DeviceType(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_WeighingCapacity(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Get_WeighingCapacity_Responses:
        """
        Requests the unobservable property Weighing Capacity
            Query weighing capacity. The maximum allowed balance capacity in g.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.WeighingCapacity (Weighing Capacity): Query weighing capacity. The maximum allowed balance capacity in g.
        """
    
        logging.debug(
            "Property WeighingCapacity requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_WeighingCapacity(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_FirmwareVersion(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Get_FirmwareVersion_Responses:
        """
        Requests the unobservable property Firmware Version
            Provides the software version number
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.FirmwareVersion (Firmware Version): Provides the software version number
        """
    
        logging.debug(
            "Property FirmwareVersion requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_FirmwareVersion(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_TypeDefinitionNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Get_TypeDefinitionNumber_Responses:
        """
        Requests the unobservable property Type Definition Number
            Provides the type definition number
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.TypeDefinitionNumber (Type Definition Number): Provides the type definition number
        """
    
        logging.debug(
            "Property TypeDefinitionNumber requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_TypeDefinitionNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def Get_SerialNumber(self, request, context: grpc.ServicerContext) \
            -> DeviceInformationProvider_pb2.Get_SerialNumber_Responses:
        """
        Requests the unobservable property Serial Number
            Query the serial number of the balance terminal. The serial number agrees with that on the model plate and is different for every MT balance. If no terminal is present, the SN of the bridge is issued instead.
    
        :param request: An empty gRPC request object (properties have no parameters)
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: A response object with the following fields:
            request.SerialNumber (Serial Number): Query the serial number of the balance terminal. The serial number agrees with that on the model plate and is different for every MT balance. If no terminal is present, the SN of the bridge is issued instead.
        """
    
        logging.debug(
            "Property SerialNumber requested in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
        try:
            return self.implementation.Get_SerialNumber(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
