#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*MT_Viper_SW_Balance_Service client*

:details: MT_Viper_SW_Balance_Service:
    This is a Mettler Toledo Viper SW balance service

:file:    DisplayController_client.py
:authors: Lukas Bromig

:date: (creation)          2021-04-09T13:29:06.813819
:date: (last modification) 2021-04-09T13:29:06.813819

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time
import datetime

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling import client_err

# import default arguments for this feature
from sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DisplayController.gRPC import DisplayController_pb2
from sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DisplayController.gRPC import DisplayController_pb2_grpc


# noinspection PyPep8Naming, PyUnusedLocal
class DisplayControllerClient:
    """
        This is a Mettler Toledo Viper SW balance service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 channel = None):
        """Class initialiser"""

        # Create stub objects used to communicate with the server
        self.DisplayController_stub = \
            DisplayController_pb2_grpc.DisplayControllerStub(channel)
        

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def WriteToDisplay(self,
                Text: str = 'default string'
                     ): # -> (DisplayController):
        """
        Wrapper to call the unobservable command WriteToDisplay on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling WriteToDisplay:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DisplayController_pb2.WriteToDisplay_Parameters(
                                    Text=silaFW_pb2.String(value=Text)
                )
    
            response = self.DisplayController_stub.WriteToDisplay(parameter, metadata)
            logging.debug(f"WriteToDisplay response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response.Successful.value
    
    
    def ShowWeight(self,
                EmptyParameter: bytes = b''
                     ): # -> (DisplayController):
        """
        Wrapper to call the unobservable command ShowWeight on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling ShowWeight:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DisplayController_pb2.ShowWeight_Parameters(
                                    
                )
    
            response = self.DisplayController_stub.ShowWeight(parameter, metadata)
            logging.debug(f"ShowWeight response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response.Successful.value
    
    

    #   No properties defined

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        logging.error(grpc_error.error_type)
        if hasattr(grpc_error.message, "parameter"):
            logging.error(grpc_error.message.parameter)
        logging.error(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'OverloadError' :
            raise OverloadErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'UnderloadError' :
            raise UnderloadErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'InternalError' :
            raise InternalErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'LogicalError' :
            raise LogicalErrorError(grpc_error.message.message)
        

class OverloadErrorError(Exception):
    """Overload Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"OverloadErrorError: {self.message}"
        else:
            return f"OverloadErrorError."


class UnderloadErrorError(Exception):
    """Underload Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"UnderloadErrorError: {self.message}"
        else:
            return f"UnderloadErrorError."


class InternalErrorError(Exception):
    """Internal Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"InternalErrorError: {self.message}"
        else:
            return f"InternalErrorError."


class LogicalErrorError(Exception):
    """Logical Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"LogicalErrorError: {self.message}"
        else:
            return f"LogicalErrorError."


