"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Display Controller*

:details: DisplayController:
    THis feature contains functions to control the balances display.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019
           
:file:    DisplayController_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-04-09T13:29:06.800386
:date: (last modification) 2021-04-09T13:29:06.800386

.. note:: Code generated by sila2codegenerator 0.3.6

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError, SiLAValidationError

# import gRPC modules for this feature
from .gRPC import DisplayController_pb2 as DisplayController_pb2
from .gRPC import DisplayController_pb2_grpc as DisplayController_pb2_grpc

# import simulation and real implementation
from .DisplayController_simulation import DisplayControllerSimulation
from .DisplayController_real import DisplayControllerReal

# import SiLA Defined Error factories
from .DisplayController_defined_errors import generate_def_error_OverloadError, generate_def_error_UnderloadError, generate_def_error_InternalError, generate_def_error_LogicalError

class DisplayController(DisplayController_pb2_grpc.DisplayControllerServicer):
    """
    This is a Mettler Toledo Viper SW balance service
    """
    implementation: Union[DisplayControllerSimulation, DisplayControllerReal]
    simulation_mode: bool

    def __init__(self, simulation_mode: bool = True, hardware_interface=None):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        :param hardware_interface (optional): access to shared hardware interface, like serial interface. 
        """

        self.hardware_interface = hardware_interface

        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(DisplayControllerSimulation(hardware_interface=self.hardware_interface))
        else:
            self._inject_implementation(DisplayControllerReal(hardware_interface=self.hardware_interface))

    def _inject_implementation(self,
                               implementation: Union[DisplayControllerSimulation,
                                                     DisplayControllerReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the MT_Viper_SW_Balance_ServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(DisplayControllerSimulation(hardware_interface=self.hardware_interface))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(DisplayControllerReal(hardware_interface=self.hardware_interface))

    def WriteToDisplay(self, request, context: grpc.ServicerContext) \
            -> DisplayController_pb2.WriteToDisplay_Responses:
        """
        Executes the unobservable command "Write to Display"
            Write text to the balance display.
    
        :param request: gRPC request containing the parameters passed:
            request.Text (Text): The text to be displayed. An empty string will clear the balance display. If the maximum number of characters is exceeded, the text disappears on the right side.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Successful (Successful): The command has been executed successfully.
        """
    
        logging.debug(
            "WriteToDisplay called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            return self.implementation.WriteToDisplay(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
    
    def ShowWeight(self, request, context: grpc.ServicerContext) \
            -> DisplayController_pb2.ShowWeight_Responses:
        """
        Executes the unobservable command "Show Weight"
            Resets the display after using the WriteToDisplay command. The device display will show the current weight value and unit.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Successful (Successful): The command has been executed successfully.
        """
    
        logging.debug(
            "ShowWeight called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            return self.implementation.ShowWeight(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)

    
