#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*MT_Viper_SW_Balance_Service test client*

:details: MT_Viper_SW_Balance_Service:
    This is a Mettler Toledo Viper SW balance service

:file:    MT_Viper_SW_Balance_Service_testclient.py
:authors: Lukas Bromig

:date: (creation)          2021-04-09T13:29:06.875058
:date: (last modification) 2021-04-09T13:29:06.875058

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import time
import datetime

# import meta packages
from typing import Union, Optional

# import SiLA client module
from MT_Viper_SW_Balance_Service_client import MT_Viper_SW_Balance_ServiceClient


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(
        description="A SiLA2 test client for: MT_Viper_SW_Balance_Service")

    # connection parameters
    parser.add_argument('-i', '--server-ip-address', action='store', default='10.152.248.1',
                        help='SiLA server IP address')
    parser.add_argument('--server-hostname', action='store', default='localhost',
                        help='SiLA server hostname')
    parser.add_argument('-p', '--server-port', action='store', default=50001,
                        help='SiLA server port')

    # encryption
    parser.add_argument('-X', '--encryption', action='store', default='sila2_server',
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version',
                        version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use logging.INFO (=20) or logging.ERROR (=30) for less output
    logging.basicConfig(
        format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the client
    sila_client = MT_Viper_SW_Balance_ServiceClient(server_ip=parsed_args.server_ip_address,
                                        server_port=int(parsed_args.server_port))
    sila_client.run()

    # Log connection info
    logging.info(
        (
            f'Connected to SiLA Server {sila_client.server_display_name} running in version {sila_client.server_version}.' '\n'
            f'Service description: {sila_client.server_description}'
        )
    )

    # TODO:
    #   Uncomment the calls you would like to test and remove type hints (given only for orientation) or
    #   write your further function calls here to run the client as a standalone application.

    # ------------- command calls -------------------

    # implemented_features = sila_client.get_implemented_features()
    # print(implemented_features)
    # print(implemented_features[0].value)
    # for feature in implemented_features:
    #     results = sila_client.get_feature_definition(feature_identifier=feature.value)
    #    print(results)

    # ----- BalanceService 
    # results = sila_client.balanceService_client.Zero()
    # print("Zero res: ", results)
    
    # results = sila_client.balanceService_client.ZeroImmediate()
    # print("ZeroImmediate res: ", results)
    
    # results = sila_client.balanceService_client.Tare()
    # print("Tare res: ", results)
    
    # uuid = sila_client.balanceService_client.WeightValueOnChange({'WeightChange': 1.0})
    # print("WeightValueOnChange res: ", uuid)
    # results = sila_client.balanceService_client.WeightValueOnChange_Info(uuid=uuid.commandExecutionUUID)
    # print("WeightValueOnChange res: ", results)
    # print(dir(results))
    # print(results.time_remaining())
    # print(results.is_active())
    # print(results.initial_metadata())
    # print(results.done())
    # results = sila_client.balanceService_client.WeightValueOnChange_Result(uuid.commandExecutionUUID)
    # print("WeightValueOnChange res: ", results)

    # results = sila_client.balanceService_client.PresetTareWeight(TarePresetValue = 1.0)
    # print("PresetTareWeight res: ", results)
    
    # results = sila_client.balanceService_client.ClearTareValue(EmptyParameter=b'')
    # print("ClearTareValue res: ", results)

    # results = sila_client.balanceService_client.TareImmediately(EmptyParameter=b'')
    # print("TareImmediately res: ", results)
    
    # ----- DeviceInformationProvider 
    # results = sila_client.deviceInformationProvider_client.Reset(Confirmation: str = 'default string')
    # print("Reset res: ", results)
    
    # ----- DisplayController 
    # results = sila_client.displayController_client.WriteToDisplay(Text='default string')
    # print("WriteToDisplay res: ", results)
    
    # results = sila_client.displayController_client.ShowWeight(EmptyParameter=b'')
    # print("ShowWeight res: ", results)
    

    # ------------- property calls -------------------

    # ----- BalanceService 
    # results = sila_client.balanceService_client.Get_StableWeightValue()
    # print("StableWeightValue res: ", results)
    
    results = sila_client.balanceService_client.Get_ImmediateWeightValue()
    print("ImmediateWeightValue res: ", results)
    
    # results = sila_client.balanceService_client.Subscribe_CurrentWeightValue()
    # print("CurrentWeightValue res: ", results)
    # for i in range(5):
    #     print(results.next())

    # results = sila_client.balanceService_client.Get_TareWeightValue()
    # print("TareWeightValue res: ", results)
    
    # ----- DeviceInformationProvider 
    # results = sila_client.deviceInformationProvider_client.Get_ImplementedCommands()
    # print("ImplementedCommands res: ", results)
    
    # results = sila_client.deviceInformationProvider_client.Get_DeviceType()
    # print("DeviceType res: ", results)
    
    # results = sila_client.deviceInformationProvider_client.Get_WeighingCapacity()
    # print("WeighingCapacity res: ", results)
    
    # results = sila_client.deviceInformationProvider_client.Get_FirmwareVersion()
    # print("FirmwareVersion res: ", results)
    
    # results = sila_client.deviceInformationProvider_client.Get_TypeDefinitionNumber()
    # print("TypeDefinitionNumber res: ", results)
    
    # results = sila_client.deviceInformationProvider_client.Get_SerialNumber()
    # print("SerialNumber res: ", results)
    
    # ----- DisplayController 
