#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*MT_Viper_SW_Balance_Service client*

:details: MT_Viper_SW_Balance_Service:
    This is a Mettler Toledo Viper SW balance service

:file:    BalanceService_client.py
:authors: Lukas Bromig

:date: (creation)          2021-04-07T13:30:01.315279
:date: (last modification) 2021-04-07T13:30:01.315279

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time
import datetime

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from BalanceService.gRPC import BalanceService_pb2
from BalanceService.gRPC import BalanceService_pb2_grpc
# import default arguments for this feature
from BalanceService.BalanceService_default_arguments import default_dict as BalanceService_default_dict
from DeviceInformationProvider.gRPC import DeviceInformationProvider_pb2
from DeviceInformationProvider.gRPC import DeviceInformationProvider_pb2_grpc
# import default arguments for this feature
from DeviceInformationProvider.DeviceInformationProvider_default_arguments import default_dict as DeviceInformationProvider_default_dict
from DisplayController.gRPC import DisplayController_pb2
from DisplayController.gRPC import DisplayController_pb2_grpc
# import default arguments for this feature
from DisplayController.DisplayController_default_arguments import default_dict as DisplayController_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class BalanceServiceClient:
    """
        This is a Mettler Toledo Viper SW balance service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 channel = None):
        """Class initialiser"""

        # Create stub objects used to communicate with the server
        self.BalanceService_stub = \
            BalanceService_pb2_grpc.BalanceServiceStub(channel)
        

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Zero(self,
                EmptyParameter: bytes = b''
                     ): # -> (BalanceService):
        """
        Wrapper to call the unobservable command Zero on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling Zero:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = BalanceService_pb2.Zero_Parameters(
                    **BalanceService_default_dict['Zero_Parameters']
                )
    
            response = self.BalanceService_stub.Zero(parameter, metadata)
            logging.debug(f"Zero response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    
    def ZeroImmediate(self,
                EmptyParameter: bytes = b''
                     ): # -> (BalanceService):
        """
        Wrapper to call the unobservable command ZeroImmediate on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling ZeroImmediate:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = BalanceService_pb2.ZeroImmediate_Parameters(
                    **BalanceService_default_dict['ZeroImmediate_Parameters']
                )
    
            response = self.BalanceService_stub.ZeroImmediate(parameter, metadata)
            logging.debug(f"ZeroImmediate response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Tare(self,
                EmptyParameter: bytes = b''
                     ): # -> (BalanceService):
        """
        Wrapper to call the unobservable command Tare on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling Tare:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = BalanceService_pb2.Tare_Parameters(
                    **BalanceService_default_dict['Tare_Parameters']
                )
    
            response = self.BalanceService_stub.Tare(parameter, metadata)
            logging.debug(f"Tare response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def WeightValueOnChange(self,
                      parameter: BalanceService_pb2.WeightValueOnChange_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command WeightValueOnChange on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling WeightValueOnChange:")
        try:
            if parameter is None:
                parameter = BalanceService_pb2.WeightValueOnChange_Parameters(
                    **BalanceService_default_dict['WeightValueOnChange_Parameters']
                )
            else:
                par_dict = {
                    'WeightChange': silaFW_pb2.Real(value=parameter['WeightChange']),
                }
                parameter = BalanceService_pb2.WeightValueOnChange_Parameters(
                    **par_dict
                )
            response = self.BalanceService_stub.WeightValueOnChange(parameter)
    
            logging.debug('WeightValueOnChange response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def WeightValueOnChange_Info(self,
                           uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command WeightValueOnChange on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command WeightValueOnChange (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.BalanceService_stub.WeightValueOnChange_Info(uuid)
            logging.debug('WeightValueOnChange status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def WeightValueOnChange_Result(self,
                             uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> BalanceService_pb2.WeightValueOnChange_Responses:
        """
        Wrapper to get an intermediate response for the observable command WeightValueOnChange on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`WeightValueOnChange_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command WeightValueOnChange (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.BalanceService_stub.WeightValueOnChange_Result(uuid)
            logging.debug('WeightValueOnChange result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def PresetTareWeight(self,
                TarePresetValue: float = 1.0
                     ): # -> (BalanceService):
        """
        Wrapper to call the unobservable command PresetTareWeight on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling PresetTareWeight:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = BalanceService_pb2.PresetTareWeight_Parameters(
                                    TarePresetValue=silaFW_pb2.Real(value=TarePresetValue)
                )
    
            response = self.BalanceService_stub.PresetTareWeight(parameter, metadata)
            logging.debug(f"PresetTareWeight response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    
    def ClearTareValue(self,
                EmptyParameter: bytes = b''
                     ): # -> (BalanceService):
        """
        Wrapper to call the unobservable command ClearTareValue on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling ClearTareValue:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = BalanceService_pb2.ClearTareValue_Parameters(
                                    
                )
    
            response = self.BalanceService_stub.ClearTareValue(parameter, metadata)
            logging.debug(f"ClearTareValue response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    
    def TareImmediately(self,
                EmptyParameter: bytes = b''
                     ): # -> (BalanceService):
        """
        Wrapper to call the unobservable command TareImmediately on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling TareImmediately:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = BalanceService_pb2.TareImmediately_Parameters(
                                    
                )
    
            response = self.BalanceService_stub.TareImmediately(parameter, metadata)
            logging.debug(f"TareImmediately response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    

    def Get_StableWeightValue(self) \
            -> BalanceService_pb2.Get_StableWeightValue_Responses:
        """Wrapper to get property StableWeightValue from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property StableWeightValue:")
        try:
            response = self.BalanceService_stub.Get_StableWeightValue(
                BalanceService_pb2.Get_StableWeightValue_Parameters()
            )
            logging.debug(
                'Get_StableWeightValue response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Get_ImmediateWeightValue(self) \
            -> BalanceService_pb2.Get_ImmediateWeightValue_Responses:
        """Wrapper to get property ImmediateWeightValue from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property ImmediateWeightValue:")
        try:
            response = self.BalanceService_stub.Get_ImmediateWeightValue(
                BalanceService_pb2.Get_ImmediateWeightValue_Parameters()
            )
            logging.debug(
                'Get_ImmediateWeightValue response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def Subscribe_CurrentWeightValue(self) \
            -> BalanceService_pb2.Subscribe_CurrentWeightValue_Responses:
        """Wrapper to get property CurrentWeightValue from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentWeightValue:")
        try:
            response = self.BalanceService_stub.Subscribe_CurrentWeightValue(
                BalanceService_pb2.Subscribe_CurrentWeightValue_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentWeightValue response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_TareWeightValue(self) \
            -> BalanceService_pb2.Get_TareWeightValue_Responses:
        """Wrapper to get property TareWeightValue from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading unobservable property TareWeightValue:")
        try:
            response = self.BalanceService_stub.Get_TareWeightValue(
                BalanceService_pb2.Get_TareWeightValue_Parameters()
            )
            logging.debug(
                'Get_TareWeightValue response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        logging.error(grpc_error.error_type)
        if hasattr(grpc_error.message, "parameter"):
            logging.error(grpc_error.message.parameter)
        logging.error(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'OverloadError' :
            raise OverloadErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'UnderloadError' :
            raise UnderloadErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'InternalError' :
            raise InternalErrorError(grpc_error.message.message)
        if grpc_error.error_type == client_err.SiLAError.DEFINED_EXECUTION_ERROR:
          if grpc_error.message.errorIdentifier == 'LogicalError' :
            raise LogicalErrorError(grpc_error.message.message)
        

class OverloadErrorError(Exception):
    """Overload Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"OverloadErrorError: {self.message}"
        else:
            return f"OverloadErrorError."


class UnderloadErrorError(Exception):
    """Underload Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"UnderloadErrorError: {self.message}"
        else:
            return f"UnderloadErrorError."


class InternalErrorError(Exception):
    """Internal Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"InternalErrorError: {self.message}"
        else:
            return f"InternalErrorError."


class LogicalErrorError(Exception):
    """Logical Error
    """

    def __init__(self, *args):
        if args:
            self.message = args[0]
        else:
            self.message = None

    def __str__(self):
        if self.message:
            return f"LogicalErrorError: {self.message}"
        else:
            return f"LogicalErrorError."


