"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Display Controller*

:details: DisplayController:
    THis feature contains functions to control the balances display.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 20.05.2019

:file:    DisplayController_simulation.py
:authors: Lukas Bromig

:date: (creation)          2021-04-07T13:30:01.369383
:date: (last modification) 2021-04-07T13:30:01.369383

.. note:: Code generated by sila2codegenerator 0.3.6

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import time         # used for observables
import uuid         # used for observables
import grpc         # used for type hinting only
import inspect      # used for status determination
import numpy as np       # used for simulated values and random response selection

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2

# import gRPC modules for this feature
from .gRPC import DisplayController_pb2 as DisplayController_pb2
# from .gRPC import DisplayController_pb2_grpc as DisplayController_pb2_grpc

# import default arguments
from .DisplayController_default_arguments import default_dict

# import SiLA Defined Error factories
from .DisplayController_defined_errors import generate_def_error_OverloadError, generate_def_error_UnderloadError, generate_def_error_InternalError, generate_def_error_LogicalError


# noinspection PyPep8Naming,PyUnusedLocal
class DisplayControllerSimulation:
    """
    Implementation of the *Display Controller* in *Simulation* mode
        This is a Mettler Toledo Viper SW balance service
    """

    def __init__(self, hardware_interface=None):
        """Class initialiser"""

        self.hardware_interface = hardware_interface

        logging.debug('Started server in mode: {mode}'.format(mode='Simulation'))

    @staticmethod
    def _get_function_name():
        return inspect.stack()[1][3]

    def _get_command_state(self, command_uuid: str) -> silaFW_pb2.ExecutionInfo:
        """
        Method to fill an ExecutionInfo message from the SiLA server for observable commands

        :param command_uuid: The uuid of the command for which to return the current state

        :return: An execution info object with the current command state
        """

        #: Enumeration of silaFW_pb2.ExecutionInfo.CommandStatus
        command_status = silaFW_pb2.ExecutionInfo.CommandStatus.waiting
        #: Real silaFW_pb2.Real(0...1)
        command_progress = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_estimated_remaining = None
        #: Duration silaFW_pb2.Duration(seconds=<seconds>, nanos=<nanos>)
        command_lifetime_of_execution = None

        # TODO: check the state of the command with the given uuid and return the correct information

        # just return a default in this example
        return silaFW_pb2.ExecutionInfo(
            commandStatus=command_status,
            progressInfo=(
                command_progress if command_progress is not None else None
            ),
            estimatedRemainingTime=(
                command_estimated_remaining if command_estimated_remaining is not None else None
            ),
            updatedLifetimeOfExecution=(
                command_lifetime_of_execution if command_lifetime_of_execution is not None else None
            )
        )

    def WriteToDisplay(self, request, context: grpc.ServicerContext) \
            -> DisplayController_pb2.WriteToDisplay_Responses:
        """
        Executes the unobservable command "Write to Display"
            Write text to the balance display.
    
        :param request: gRPC request containing the parameters passed:
            request.Text (Text): The text to be displayed. An empty string will clear the balance display. If the maximum number of characters is exceeded, the text disappears on the right side.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Successful (Successful): The command has been executed successfully.
        """
    
        # initialise the return value
        return_value = None
        read = None

        self.hardware_interface.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.hardware_interface.status}')

        display_text = str(request.Text.value)
        command = f'D "{display_text}"\r\n'

        possible_responses = [f'D A', 'D I', 'D L']
        read = possible_responses[np.random.randint(0, 3)]
        logging.debug('Executed command WriteToDisplay in mode: {mode} with response: {response}'
                      .format(mode='Real', response=read))

        if 'D A' in read:
            par_dict = {
                'Successful': silaFW_pb2.Boolean(value=True)
            }
            return_value = DisplayController_pb2.WriteToDisplay_Responses(**par_dict)
        elif read == 'D L':
            raise generate_def_error_LogicalError()
        elif read == 'D I':
            raise generate_def_error_InternalError()

        # fallback to default
        if return_value is None:
            return_value = DisplayController_pb2.WriteToDisplay_Responses(
                **default_dict['WriteToDisplay_Responses']
                # Successful=silaFW_pb2.Boolean(value=False)
            )
    
        return return_value

    def ShowWeight(self, request, context: grpc.ServicerContext) \
            -> DisplayController_pb2.ShowWeight_Responses:
        """
        Executes the unobservable command "Show Weight"
            Resets the display after using the WriteToDisplay command. The device display will show the current weight value and unit.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.Successful (Successful): The command has been executed successfully.
        """
    
        # initialise the return value
        return_value = None
        read = None

        self.hardware_interface.status = f'{self._get_function_name()}'
        logging.debug(f'New status is: {self.hardware_interface.status}')

        command = f'DW\r\n'

        possible_responses = [f'DW A', 'DW I']
        read = possible_responses[np.random.randint(0, 2)]
        logging.debug('Executed command ShowWeight in mode: {mode} with response: {response}'
                      .format(mode='Real', response=read))

        if 'DW A' in read:
            par_dict = {
                'Successful': silaFW_pb2.Boolean(value=True)
            }
            return_value = DisplayController_pb2.ShowWeight_Responses(**par_dict)
        elif read == 'DW I':
            raise generate_def_error_InternalError()
    
        # fallback to default
        if return_value is None:
            return_value = DisplayController_pb2.ShowWeight_Responses(
                **default_dict['ShowWeight_Responses']
                # Successful=silaFW_pb2.Boolean(value=False)
            )
    
        return return_value
