#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*PresensService client*

:details: PresensService:
    This is a Presens MCR Service

:file:    CalibrationService_client.py
:authors: Lukas Bromig

:date: (creation)          2021-05-17T10:13:20.798238
:date: (last modification) 2021-05-17T10:13:20.798238

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time
import datetime

# import meta packages
from typing import Union, Optional, List

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from sila2lib_implementations.Presens.PresensService.DeviceService.gRPC import DeviceService_pb2
from sila2lib_implementations.Presens.PresensService.DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC import CalibrationService_pb2
from sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC import CalibrationService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.CalibrationService.CalibrationService_default_arguments import default_dict as CalibrationService_default_dict
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.SensorProvider.SensorProvider_default_arguments import default_dict as SensorProvider_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class CalibrationServiceClient:
    """
        This is a Presens MCR Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 channel = None):
        """Class initialiser"""

        # Create stub objects used to communicate with the server
        self.CalibrationService_stub = \
            CalibrationService_pb2_grpc.CalibrationServiceStub(channel)
        self.SensorProvider_stub = \
            SensorProvider_pb2_grpc.SensorProviderStub(channel)
        

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def GetO2CalLow(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetO2CalLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetO2CalLow:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetO2CalLow_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetO2CalLow(parameter, metadata)
            logging.debug(f"GetO2CalLow response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetO2CalLow(self, SetO2CalLow: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetO2CalLow on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetO2CalLow:")
        # Input list:
        # SetO2CalLow_List = [57,57,57,57,57,57] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetO2CalLow) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetO2CalLow), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetO2CalLow': []
            }
            for i, SetO2CalLow in enumerate(SetO2CalLow):
                par_dict['SetO2CalLow'].append(silaFW_pb2.Real(value=SetO2CalLow))

            try:
                parameter = CalibrationService_pb2.SetO2CalLow_Parameters(**par_dict)

                if parameter is None:
                    parameter = CalibrationService_pb2.SetO2CalLow_Parameters(
                                        SetO2CalLow=[silaFW_pb2.Real(value=SetO2CalLow)]
                    )

                response = self.CalibrationService_stub.SetO2CalLow(parameter, metadata)
                logging.debug(f"SetO2CalLow response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    def GetO2CalHigh(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetO2CalHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetO2CalHigh:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetO2CalHigh_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetO2CalHigh(parameter, metadata)
            logging.debug(f"GetO2CalHigh response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetO2CalHigh(self, SetO2CalHigh: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetO2CalHigh on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetO2CalHigh:")
        # Input list:
        # SetO2CalLow_List = [27,27,27,27,27,27] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetO2CalHigh) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetO2CalHigh), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetO2CalHigh': []
            }
            for i, SetO2CalHigh in enumerate(SetO2CalHigh):
                par_dict['SetO2CalHigh'].append(silaFW_pb2.Real(value=SetO2CalHigh))


            try:
                parameter = CalibrationService_pb2.SetO2CalHigh_Parameters(**par_dict)

                if parameter is None:
                    parameter = CalibrationService_pb2.SetO2CalHigh_Parameters(
                                        SetO2CalHigh=[silaFW_pb2.Real(value=SetO2CalHigh)]
                    )

                response = self.CalibrationService_stub.SetO2CalHigh(parameter, metadata)
                logging.debug(f"SetO2CalHigh response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    def GetO2CalTemp(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetO2CalTemp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetO2CalTemp:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetO2CalTemp_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetO2CalTemp(parameter, metadata)
            logging.debug(f"GetO2CalTemp response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetO2CalTemp(self, SetO2CalTemp: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetO2CalTemp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetO2CalTemp:")
        # Input list:
        # SetO2CalTemp_List = [20,20,20,20,20,20] A setting between -10-60 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetO2CalTemp) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetO2CalTemp), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetO2CalTemp': []
            }
            for i, SetO2CalTemp in enumerate(SetO2CalTemp):
                par_dict['SetO2CalTemp'].append(silaFW_pb2.Real(value=SetO2CalTemp))

        try:
            parameter = CalibrationService_pb2.SetO2CalTemp_Parameters(**par_dict)
            if parameter is None:
                parameter = CalibrationService_pb2.SetO2CalTemp_Parameters(
                                    SetO2CalTemp=[silaFW_pb2.Real(value=SetO2CalTemp)]
                )
    
            response = self.CalibrationService_stub.SetO2CalTemp(parameter, metadata)
            logging.debug(f"SetO2CalTemp response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GetPHImax(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetPHImax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetPHImax:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetPHImax_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetPHImax(parameter, metadata)
            logging.debug(f"GetPHImax response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetPHImax(self,SetPHImax: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetPHImax on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetPHImax:")
        # Input list:
        # SetPHImax = [0,0,0,0,0,0] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetPHImax) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHImax), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHImax': []
            }
            for i, SetPHImax in enumerate(SetPHImax):
                par_dict['SetPHImax'].append(silaFW_pb2.Real(value=SetPHImax))
            try:
                parameter = CalibrationService_pb2.SetPHImax_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationService_pb2.SetPHImax_Parameters(
                                        SetPHImax=[silaFW_pb2.Real(value=SetPHImax)]
                    )

                response = self.CalibrationService_stub.SetPHImax(parameter, metadata)
                logging.debug(f"SetPHImax response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    def GetPHImin(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetPHImin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetPHImin:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetPHImin_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetPHImin(parameter, metadata)
            logging.debug(f"GetPHImin response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetPHImin(self, SetPHImin: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetPHImin on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here
        response = None
        logging.debug("Calling SetPHImin:")
        # Input list:
        # SetPHImin = [0,0,0,0,0,0] A setting between 0-90 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetPHImin) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHImin), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHImin': []
            }
            for i, SetPHImin in enumerate(SetPHImin):
                par_dict['SetPHImin'].append(silaFW_pb2.Real(value=SetPHImin))

            try:
                parameter = CalibrationService_pb2.SetPHImin_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationService_pb2.SetPHImin_Parameters(
                                        SetPHImin=[silaFW_pb2.Real(value=SetPHImin)]
                    )

                response = self.CalibrationService_stub.SetPHImin(parameter, metadata)
                logging.debug(f"SetPHImin response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    def GetPHpH0(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetPHpH0 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 

        logging.debug("Calling GetPHpH0:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetPHpH0_Parameters(

                )

            response = self.CalibrationService_stub.GetPHpH0(parameter, metadata)
            logging.debug(f"GetPHpH0 response: {response}")

        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetPHpH0(self, SetPHpH0: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetPHpH0 on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetPHpH0:")
        # Input list:
        # SetPHpH0_List = [0,0,0,0,0,0] A setting between 0-50 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetPHpH0) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHpH0), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHpH0': []
            }
            for i, SetPHpH0 in enumerate(SetPHpH0):
                par_dict['SetPHpH0'].append(silaFW_pb2.Real(value=SetPHpH0))

            try:
                parameter = CalibrationService_pb2.SetPHpH0_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationService_pb2.SetPHpH0_Parameters(
                                        SetPHpH0=[silaFW_pb2.Real(value=SetPHpH0)]
                    )

                response = self.CalibrationService_stub.SetPHpH0(parameter, metadata)
                logging.debug(f"SetPHpH0 response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    def GetPHdpH(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetPHdpH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetPHdpH:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetPHdpH_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetPHdpH(parameter, metadata)
            logging.debug(f"GetPHdpH response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetPHdpH(self, SetPHdpH: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetPHdpH on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetPHdpH:")
        # Input list:
        # SetPHdpH_List = [0,0,0,0,0,0] A setting between 0-50 for each in self.TotalBars
        par_dict: dict = {}
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetPHdpH) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHdpH), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHdpH': []
            }
            for i, SetPHdpH in enumerate(SetPHdpH):
                par_dict['SetPHdpH'].append(silaFW_pb2.Real(value=SetPHdpH))

            try:
                parameter = CalibrationService_pb2.SetPHdpH_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationService_pb2.SetPHdpH_Parameters(
                                        SetPHdpH=[silaFW_pb2.Real(value=SetPHdpH)]
                    )

                response = self.CalibrationService_stub.SetPHdpH(parameter, metadata)
                logging.debug(f"SetPHdpH response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    def GetPHCalTemp(self, EmptyParameter: bytes = b''): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command GetPHCalTemp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetPHCalTemp:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = CalibrationService_pb2.GetPHCalTemp_Parameters(
                                    
                )
    
            response = self.CalibrationService_stub.GetPHCalTemp(parameter, metadata)
            logging.debug(f"GetPHCalTemp response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetPHCalTemp(self, SetPHCalTemp: List[float] = None): # -> (CalibrationService):
        """
        Wrapper to call the unobservable command SetPHCalTemp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        logging.debug("Calling SetPHCalTemp:")
        # Input list:
        # SetPHCalTemp_List = [20,20,20,20,20,20] A setting between -10-60 for each in self.TotalBars
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        if len(SetPHCalTemp) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetPHCalTemp), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetPHCalTemp': []
            }
            for i, SetPHCalTemp in enumerate(SetPHCalTemp):
                par_dict['SetPHCalTemp'].append(silaFW_pb2.Real(value=SetPHCalTemp))

            try:
                parameter = CalibrationService_pb2.SetPHCalTemp_Parameters(**par_dict)
                if parameter is None:
                    parameter = CalibrationService_pb2.SetPHCalTemp_Parameters(
                                        SetPHCalTemp=[silaFW_pb2.Real(value=SetPHCalTemp)]
                    )

                response = self.CalibrationService_stub.SetPHCalTemp(parameter, metadata)
                logging.debug(f"SetPHCalTemp response: {response}")

            except grpc.RpcError as grpc_err:
                self.grpc_error_handling(grpc_err)
                return None
    
        return response

    #   No properties defined

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        logging.error(grpc_error.error_type)
        if hasattr(grpc_error.message, "parameter"):
            logging.error(grpc_error.message.parameter)
        logging.error(grpc_error.message.message)
