"""
________________________________________________________________________

:PROJECT: SiLA2_python

*Calibration Service*

:details: CalibrationService:
    Calibrate the sensor bars by adjusting the temperature compensation and the dynamic averaging value.
    By Lukas Bromig, Institute of Biochemical Engineering, Technical University of Munich, 14.02.2020
           
:file:    CalibrationService_servicer.py
:authors: Lukas Bromig

:date: (creation)          2021-05-17T10:13:20.682324
:date: (last modification) 2021-05-17T10:13:20.682324

.. note:: Code generated by sila2codegenerator 0.3.6

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""

__version__ = "1.0"

# import general packages
import logging
import grpc

# meta packages
from typing import Union

# import SiLA2 library
import sila2lib.framework.SiLAFramework_pb2 as silaFW_pb2
from sila2lib.error_handling.server_err import SiLAError

# import gRPC modules for this feature
from .gRPC import CalibrationService_pb2 as CalibrationService_pb2
from .gRPC import CalibrationService_pb2_grpc as CalibrationService_pb2_grpc

# import simulation and real implementation
from .CalibrationService_simulation import CalibrationServiceSimulation
from .CalibrationService_real import CalibrationServiceReal



class CalibrationService(CalibrationService_pb2_grpc.CalibrationServiceServicer):
    """
    This is a Presens MCR Service
    """
    implementation: Union[CalibrationServiceSimulation, CalibrationServiceReal]
    simulation_mode: bool

    def __init__(self, ser, properties, simulation_mode: bool = True):
        """
        Class initialiser.

        :param simulation_mode: Sets whether at initialisation the simulation mode is active or the real mode.
        :param hardware_interface (optional): access to shared hardware interface, like serial interface. 
        """
        self.ser = ser
        self.properties = properties
        self.lock = properties.lock
        self.simulation_mode = simulation_mode
        if simulation_mode:
            self._inject_implementation(CalibrationServiceSimulation(self.properties))
        else:
            self._inject_implementation(CalibrationServiceReal(self.ser, self.properties))

    def _inject_implementation(self,
                               implementation: Union[CalibrationServiceSimulation,
                                                     CalibrationServiceReal]
                               ) -> bool:
        """
        Dependency injection of the implementation used.
            Allows to set the class used for simulation/real mode.

        :param implementation: A valid implementation of the PresensServiceServicer.
        """

        self.implementation = implementation
        return True

    def switch_to_simulation_mode(self):
        """Method that will automatically be called by the server when the simulation mode is requested."""
        self.simulation_mode = True
        self._inject_implementation(CalibrationServiceSimulation(self.properties))

    def switch_to_real_mode(self):
        """Method that will automatically be called by the server when the real mode is requested."""
        self.simulation_mode = False
        self._inject_implementation(CalibrationServiceReal(self.ser, self.properties))

    def GetO2CalLow(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetO2CalLow_Responses:
        """
        Executes the unobservable command "Get O2 Calibration Low"
            Get the O2 calibration point value at 0% dissolved oxygen.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentO2CalLow (Current O2 Calibration Low): The current value of the lower (0% dissolved oxygen) calibration point. Default = 57.
        """
    
        logging.debug(
            "GetO2CalLow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetO2CalLow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetO2CalLow(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetO2CalLow_Responses:
        """
        Executes the unobservable command "Set O2 Calibration Low"
            Set the O2 calibration point value at 0% dissolved oxygen. Default = 57.
    
        :param request: gRPC request containing the parameters passed:
            request.SetO2CalLow (Setpoint O2 Calibration Low):
            The lower calibration point value setpoint for O2 up to two decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentO2CalLow (Current O2 Calibration Low): The current lower calibration point value for O2.
        """
    
        logging.debug(
            "SetO2CalLow called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetO2CalLow(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetO2CalHigh(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetO2CalHigh_Responses:
        """
        Executes the unobservable command "Get O2 Calibration High"
            Get the O2 calibration point value at 100% dissolved oxygen. Default = 27.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentO2CalHigh (Current O2 Calibration High): The current value of the higher (100% dissolved oxygen) calibration point in %.
        """
    
        logging.debug(
            "GetO2CalHigh called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetO2CalHigh(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetO2CalHigh(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetO2CalHigh_Responses:
        """
        Executes the unobservable command "Set O2 Calibration High"
            Set the O2 calibration point value at 100% dissolved oxygen. Default = 27.
    
        :param request: gRPC request containing the parameters passed:
            request.SetO2CalHigh (Setpoint O2 Calibration High in percent):
            The higher calibration point value setpoint for O2 up to two decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentO2CalHigh (Current O2 Calibration High): The current higher calibration point value for O2 in %.
        """
    
        logging.debug(
            "SetO2CalHigh called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetO2CalHigh(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetO2CalTemp(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetO2CalTemp_Responses:
        """
        Executes the unobservable command "Get O2 Calibration Temperature"
            Get the value of the oxygen sensor calibration temperature in degrees Celsius. Default = 20.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentO2CalTemp (Current O2 Calibration Temperature): The current value of the oxygen calibration temperature in degree Celsius.
        """
    
        logging.debug(
            "GetO2CalTemp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetO2CalTemp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetO2CalTemp(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetO2CalTemp_Responses:
        """
        Executes the unobservable command "Set O2 Calibration Temperature"
            Set the value of the oxygen calibration temperature in degree Celsius. Default = 20.
    
        :param request: gRPC request containing the parameters passed:
            request.SetO2CalTemp (Setpoint O2 Calibration Temperature):
            The oxygen calibration temperature value to be set up to one decimal point in degree Celsius.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentO2CalTemp (Current O2 Calibration Temperature): The current value of the oxygen sensor calibration temperature in degree Celsius.
        """
    
        logging.debug(
            "SetO2CalTemp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetO2CalTemp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetPHImax(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetPHImax_Responses:
        """
        Executes the unobservable command "Get phi max"
            Get the given value of the first calibration point (phi max) of the pH sensor. Default = 0.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHImax (Current phi max): The current value of the first calibration point (phi max) of the pH sensor.
        """
    
        logging.debug(
            "GetPHImax called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetPHImax(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetPHImax(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetPHImax_Responses:
        """
        Executes the unobservable command "Set phi max"
            Set the value of the first calibration point (phi max) of the pH sensor. Default = 0.
    
        :param request: gRPC request containing the parameters passed:
            request.SetPHImax (Setpoint phi max):
            The set value of the first calibration point (phi max) of the pH sensor up to two decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHImax (Current phi max): The current value of the first calibration point (phi max) of the pH sensor.
        """
    
        logging.debug(
            "SetPHImax called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetPHImax(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetPHImin(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetPHImin_Responses:
        """
        Executes the unobservable command "Get phi min"
            Get the given value of the second calibration point (phi min) of the pH sensor. Default = -.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHImin (Current phi min): The current value of the second calibration point (phi min) of the pH sensor.
        """
    
        logging.debug(
            "GetPHImin called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetPHImin(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
                self.lock.release()
    
    def SetPHImin(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetPHImin_Responses:
        """
        Executes the unobservable command "Set phi min"
            Set the value of the second calibration point (phi min) of the pH sensor. Default = -.
    
        :param request: gRPC request containing the parameters passed:
            request.SetPHImin (Setpoint phi min):
            The set value of the second calibration point (phi min) of the pH sensor up to two decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHImin (Current phi min): The current value of the second calibration point (phi min) of the pH sensor.
        """
    
        logging.debug(
            "SetPHImin called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetPHImin(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetPHpH0(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetPHpH0_Responses:
        """
        Executes the unobservable command "Get PH pH0"
            Get the given value of the third calibration point (pH0) of the pH sensor. Default = 0.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHpH0 (Current PH pH0): The current value of the third calibration point (pH0) of the pH sensor.
        """
    
        logging.debug(
            "GetPHpH0 called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetPHpH0(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetPHpH0(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetPHpH0_Responses:
        """
        Executes the unobservable command "Set PH pH0"
            Set the value of the third calibration point (pH0) of the pH sensor. Default = 0.
    
        :param request: gRPC request containing the parameters passed:
            request.SetPHpH0 (Setpoint PH pH0):
            The set value of the third calibration point (pH0) of the pH sensor up to two decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHpH0 (Current PH pH0): The current value of the third calibration point (pH0) of the pH sensor.
        """
    
        logging.debug(
            "SetPHpH0 called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetPHpH0(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetPHdpH(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetPHdpH_Responses:
        """
        Executes the unobservable command "Get PH dpH"
            Get the given value of the fourth calibration point (dpH) of the pH sensor. Default = 0.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHdpH (Current PH dpH): The current value of the fourth calibration point (dpH) of the pH sensor.
        """
    
        logging.debug(
            "GetPHdpH called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetPHdpH(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetPHdpH(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetPHdpH_Responses:
        """
        Executes the unobservable command "Set PH dpH"
            Set the value of the fourth calibration point (dpH) of the pH sensor. Default = 0.
    
        :param request: gRPC request containing the parameters passed:
            request.SetPHdpH (Setpoint PH dpH):
            The set value of the fourth calibration point (dpH) of the pH sensor up to two decimal points.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHdpH (Current PH dpH): The current value of the fourth calibration point (dpH) of the pH sensor.
        """
    
        logging.debug(
            "SetPHdpH called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetPHdpH(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def GetPHCalTemp(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.GetPHCalTemp_Responses:
        """
        Executes the unobservable command "Get PH Calibration Temperature"
            Get the value of the pH sensor calibration temperature in degree Celsius. Default = 20.
    
        :param request: gRPC request containing the parameters passed:
            request.EmptyParameter (Empty Parameter): An empty parameter data type used if no parameter is required.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHCalTemp (Current PH Calibration Temperature): The current value of the pH calibration temperature in degree Celsius.
        """
    
        logging.debug(
            "GetPHCalTemp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.GetPHCalTemp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()

    def SetPHCalTemp(self, request, context: grpc.ServicerContext) \
            -> CalibrationService_pb2.SetPHCalTemp_Responses:
        """
        Executes the unobservable command "Set PH Calibration Temperature"
            Set the value of the pH calibration temperature in degree Celsius. Default = 20.
    
        :param request: gRPC request containing the parameters passed:
            request.SetPHCalTemp (Setpoint PH Calibration Temperature):
            The pH calibration temperature value to be set in degree Celsius up to one decimal point.
        :param context: gRPC :class:`~grpc.ServicerContext` object providing gRPC-specific information
    
        :returns: The return object defined for the command with the following fields:
            request.CurrentPHCalTemp (Current PH Calibration Temperature): The current value of the pH sensor calibration temperature in degree Celsius.
        """
    
        logging.debug(
            "SetPHCalTemp called in {current_mode} mode".format(
                current_mode=('simulation' if self.simulation_mode else 'real')
            )
        )
    
        # parameter validation
        # if request.my_paramameter.value out of scope :
        #        sila_val_err = SiLAValidationError(parameter="myParameter",
        #                                           msg=f"Parameter {request.my_parameter.value} out of scope!")
        #        sila_val_err.raise_rpc_error(context)
    
        try:
            self.lock.acquire()
            return self.implementation.SetPHCalTemp(request, context)
        except SiLAError as err:
            err.raise_rpc_error(context=context)
        finally:
            self.lock.release()
