#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*PresensService client*

:details: PresensService:
    This is a Presens MCR Service

:file:    DeviceService_client.py
:authors: Lukas Bromig

:date: (creation)          2021-05-17T10:13:20.673325
:date: (last modification) 2021-05-17T10:13:20.673325

.. note:: Code generated by sila2codegenerator 0.3.6

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time
import datetime

# import meta packages
from typing import Union, Optional, List

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err
#   Usually not needed, but - feel free to modify
# from sila2lib.framework.std_features import SimulationController_pb2 as SimController_feature_pb2

# import feature gRPC modules
# Import gRPC libraries of features
from sila2lib_implementations.Presens.PresensService.DeviceService.gRPC import DeviceService_pb2
from sila2lib_implementations.Presens.PresensService.DeviceService.gRPC import DeviceService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.DeviceService.DeviceService_default_arguments import default_dict as DeviceService_default_dict
from sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC import CalibrationService_pb2
from sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC import CalibrationService_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.CalibrationService.CalibrationService_default_arguments import default_dict as CalibrationService_default_dict
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2
from sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC import SensorProvider_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.Presens.PresensService.SensorProvider.SensorProvider_default_arguments import default_dict as SensorProvider_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class DeviceServiceClient:
    """
        This is a Presens MCR Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 channel = None):
        """Class initialiser"""

        # Create stub objects used to communicate with the server
        self.DeviceService_stub = \
            DeviceService_pb2_grpc.DeviceServiceStub(channel)
        self.SensorProvider_stub = \
            SensorProvider_pb2_grpc.SensorProviderStub(channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def GetLog(self, parameter: DeviceService_pb2.GetLog_Parameters = None) -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetLog_Parameters(
                    **DeviceService_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceService_stub.GetLog(parameter)
    
            logging.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLog_Info(self, uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceService_stub.GetLog_Info(uuid)
            logging.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetLog_Result(self, uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) -> DeviceService_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        logging.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceService_stub.GetLog_Result(uuid)
            logging.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def GetReport(self, EmptyParameter: bytes = b''): # -> (DeviceService):
        """
        Wrapper to call the unobservable command GetReport on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetReport:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetReport_Parameters(
                                    
                )
    
            response = self.DeviceService_stub.GetReport(parameter, metadata)
            logging.debug(f"GetReport response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GetTComp(self, EmptyParameter: bytes = b''): # -> (DeviceService):
        """
        Wrapper to call the unobservable command GetTComp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetTComp:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetTComp_Parameters(
                                    
                )
    
            response = self.DeviceService_stub.GetTComp(parameter, metadata)
            logging.debug(f"GetTComp response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetTComp(self, SetTComp: List[float] = None): # -> (DeviceService):
        """
        Wrapper to call the unobservable command SetTComp on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        self.TotalChannels = self.SensorProvider_stub.Get_TotalChannels(
            SensorProvider_pb2.Get_TotalChannels_Parameters()
        ).TotalChannels.value
        logging.debug("Calling SetTComp:")
        # input list:
        # SetTComp = [20,20,20,20,20,20,20,20,20,20,20,20,
        # 20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
        # 20,20,20,20,20,20,20,20,20,20,20,20] (48x20 or other)
        par_dict: dict = {}
        if len(SetTComp) != self.TotalChannels:
            logging.error('Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                          '{RequiredLength}'.format(CurrentLength=len(SetTComp),
                                                    RequiredLength=self.TotalChannels))
        else:
            par_dict = {
                'SetTComp': []
            }
            for i, SetTComp in enumerate(SetTComp):
                par_dict['SetTComp'].append(silaFW_pb2.Real(value=SetTComp))
        try:
            parameter = DeviceService_pb2.SetTComp_Parameters(**par_dict)
            if parameter is None:
                parameter = DeviceService_pb2.SetTComp_Parameters(
                                    SetTComp=[silaFW_pb2.Real(value=SetTComp)]
                )
    
            response = self.DeviceService_stub.SetTComp(parameter, metadata)
            logging.debug(f"SetTComp response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def GetDynAveraging(self, EmptyParameter: bytes = b''): # -> (DeviceService):
        """
        Wrapper to call the unobservable command GetDynAveraging on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling GetDynAveraging:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.GetDynAveraging_Parameters(
                                    
                )
    
            response = self.DeviceService_stub.GetDynAveraging(parameter, metadata)
            logging.debug(f"GetDynAveraging response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SetDynAveraging(self, SetDynAverage: List[float] = None): # -> (DeviceService):
        """
        Wrapper to call the unobservable command SetDynAveraging on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
        response = None
        self.TotalBars = self.SensorProvider_stub.Get_TotalBars(
            SensorProvider_pb2.Get_TotalBars_Parameters()
        ).TotalBars.value
        logging.debug("Calling SetDynAveraging:")
        # input list:
        # SetDynAveraging_List = [4,4,4,4,4,4] A setting between 0-9 for each in self.TotalBars
        par_dict: dict = {}
        if len(SetDynAverage) != self.TotalBars:
            logging.error(
                'Length of input list doesn\'t match required length. Length is: {CurrentLength}, required: '
                '{RequiredLength}'.format(CurrentLength=len(SetDynAverage), RequiredLength=self.TotalBars))
        else:
            par_dict = {
                'SetDynAverage': []
            }

            for i, SetDynAverage in enumerate(SetDynAverage):
                par_dict['SetDynAverage'].append(silaFW_pb2.Real(value=SetDynAverage))

        try:
            parameter = DeviceService_pb2.SetDynAveraging_Parameters(**par_dict)
            if parameter is None:
                parameter = DeviceService_pb2.SetDynAveraging_Parameters(
                                    SetDynAverage=[silaFW_pb2.Real(value=SetDynAverage)]
                )
    
            response = self.DeviceService_stub.SetDynAveraging(parameter, metadata)
            logging.debug(f"SetDynAveraging response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def SwitchOffDevice(self,EmptyParameter: bytes = b''): # -> (DeviceService):
        """
        Wrapper to call the unobservable command SwitchOffDevice on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        parameter = None
        metadata = None  # add metadata generator here 
    
        logging.debug("Calling SwitchOffDevice:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceService_pb2.SwitchOffDevice_Parameters(
                                    
                )
    
            response = self.DeviceService_stub.SwitchOffDevice(parameter, metadata)
            logging.debug(f"SwitchOffDevice response: {response}")
    
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Subscribe_CurrentStatus(self) -> DeviceService_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        logging.debug("Reading observable property CurrentStatus:")
        try:
            response = self.DeviceService_stub.Subscribe_CurrentStatus(
                DeviceService_pb2.Subscribe_CurrentStatus_Parameters()
            )
            logging.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error =  client_err.grpc_error_handling(error_object=error_object)

        logging.error(grpc_error.error_type)
        if hasattr(grpc_error.message, "parameter"):
            logging.error(grpc_error.message.parameter)
        logging.error(grpc_error.message.message)
        

